/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.ide.net.URLFactory;
import oracle.javatools.icons.OracleIcons;

public class ApplicationFileFolderNode
extends DefaultContainerCustomNode {
    protected static final Logger LOGGER = Logger.getLogger(ApplicationFileFolderNode.class.getName());
    private ApplicationNode _applicationNode;
    private String _name;
    private String _path;
    static final Icon FOLDER_ICON = OracleIcons.getIcon((String)"folder.png");

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public ApplicationFileFolderNode(ApplicationNode applicationNode, String string) {
        assert (applicationNode != null);
        assert (string != null);
        this._applicationNode = applicationNode;
        this._path = string;
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(MigrationAddin.getRepositoryConnectionName() + "/" + applicationNode.getMdApplication().getKey().toString() + "/" + string)));
    }

    String getPath() {
        return this._path;
    }

    public String getShortLabel() {
        if (null == this._name) {
            int n = this._path.lastIndexOf(47);
            this._name = n > -1 ? this._path.substring(n + 1) : this._path;
            assert (this._name.length() > 0);
        }
        return this._name;
    }

    public URL getDirURL() {
        String string = this._applicationNode.getFQPath(this.getPath());
        return URLFactory.newFileURL((String)string);
    }

    public Icon getIcon() {
        return ApplicationNode.getIcon(this.getDirURL(), FOLDER_ICON);
    }

    @Override
    protected void queueBackgroundLoadChildrenTask() {
        this._applicationNode.loadApplicationFileFolderNode(this);
    }

    @Override
    public String getObjectName() {
        return "MD_APPLICATIONFILES";
    }

    @Override
    public String getObjectType() {
        return "APPLICATION_FILE_FOLDER";
    }

    @Override
    public HashMap<String, Object> getDict() {
        this._dict = this._applicationNode.getDict();
        this._dict.put("URIFILTER", this.getPath());
        return this._dict;
    }
}

