/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class MigrationURLFormatHelper
extends DBURLFormatHelper {
    public MigrationURLFormatHelper() {
        super("sqldev.migration");
    }

    protected String getConnectionNameImpl(URL uRL) {
        return MigrationURLFormatHelper.extractPart(uRL, 0);
    }

    protected Icon getIconImpl(URL uRL) {
        return null;
    }

    protected String getCatalogImpl(URL uRL) {
        String string = MigrationURLFormatHelper.extractPart(uRL, 1);
        return MigrationURLFormatHelper.extractNameFromRef(string);
    }

    public DBObjectId getCatalogId(URL uRL) {
        String string = MigrationURLFormatHelper.extractPart(uRL, 1);
        return MigrationURLFormatHelper.extractIdFromRef(string);
    }

    protected String getSchemaImpl(URL uRL) {
        String string = MigrationURLFormatHelper.extractPart(uRL, 2);
        return MigrationURLFormatHelper.extractNameFromRef(string);
    }

    public static DBObjectId getSchemaId(URL uRL) {
        String string = MigrationURLFormatHelper.extractPart(uRL, 2);
        return MigrationURLFormatHelper.extractIdFromRef(string);
    }

    public static DBObjectId getColumnId(URL uRL) {
        String string = null;
        try {
            string = MigrationURLFormatHelper.extractPart(new URL(uRL.getProtocol() + "://" + uRL.getRef()), 1);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(MigrationURLFormatHelper.class.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
        }
        return MigrationURLFormatHelper.extractIdFromRef(string);
    }

    protected String getBaseTypeImpl(URL uRL) {
        return MigrationURLFormatHelper.extractPart(uRL, 3);
    }

    protected String getNameImpl(URL uRL) {
        String string = MigrationURLFormatHelper.extractPart(uRL, 4);
        return MigrationURLFormatHelper.extractNameFromRef(string);
    }

    public static DBObjectId getObjectId(URL uRL) {
        String string = MigrationURLFormatHelper.extractPart(uRL, 4);
        return MigrationURLFormatHelper.extractIdFromRef(string);
    }

    protected String getChildTypeImpl(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String string = uRL.getRef();
        String[] stringArray = string.split("/");
        if (stringArray == null || stringArray.length < 2) {
            return null;
        }
        return MigrationURLFormatHelper.decode(stringArray[0]);
    }

    protected String getChildNameImpl(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String string = uRL.getRef();
        String[] stringArray = string.split("/");
        if (stringArray == null || stringArray.length < 2) {
            return null;
        }
        return MigrationURLFormatHelper.extractNameFromRef(stringArray[1]);
    }

    public DBObjectId getChildObjectId(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String string = uRL.getRef();
        String[] stringArray = string.split("/");
        if (stringArray == null || stringArray.length < 2) {
            return null;
        }
        return MigrationURLFormatHelper.extractIdFromRef(stringArray[1]);
    }

    private static String extractPart(URL uRL, int n) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String string = URLFileSystem.getPath((URL)uRL);
        String[] stringArray = string.split("/");
        if (stringArray == null || stringArray.length < n + 1) {
            return null;
        }
        return MigrationURLFormatHelper.decode(stringArray[n]);
    }

    private static String extractNameFromRef(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(95);
        if (n == -1 || n == string.length()) {
            return string;
        }
        return MigrationURLFormatHelper.decode(string.substring(n + 1));
    }

    private static DBObjectId extractIdFromRef(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(95);
        String string2 = n == -1 ? string : string.substring(0, n);
        try {
            return new DBObjectId(Long.parseLong(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected static String decode(String string) {
        String string2 = string;
        try {
            string2 = URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    protected URL getURLImpl(String string, String string2, String string3, String string4) {
        String string5 = MigrationURLFormatHelper.encode((String)string) + "/" + MigrationURLFormatHelper.encode((String)(string2 != null ? string2 : "")) + "/" + MigrationURLFormatHelper.encode((String)(string3 != null ? string3 : ""));
        if (string4 != null) {
            string5 = string4.equals("PACKAGE+BODY") ? string5 + "/" + string4 : string5 + "/" + MigrationURLFormatHelper.encode((String)string4);
        }
        return URLFactory.newURL((String)"sqldev.migration", (String)string5);
    }

    protected URL getEnclosingURLImpl(URL uRL) {
        throw new UnsupportedOperationException("getEnclosingURL");
    }

    protected URL getEnclosedTypeURLImpl(URL uRL, String string) {
        throw new UnsupportedOperationException("getEnclosedTypeURL");
    }

    protected URL getTypeURLImpl(URL uRL) {
        String string = this.getBaseTypeImpl(uRL);
        return string != null ? this.getURLImpl(this.getConnectionNameImpl(uRL), this.getCatalogImpl(uRL), this.getSchemaImpl(uRL), this.getBaseTypeImpl(uRL)) : null;
    }
}

