/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.actions.ShowLogAction;
import oracle.dbtools.migration.workbench.core.logging.ILogListener;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.MigrationTreeTableLogPage;
import oracle.ide.Context;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;

public final class MigrationLogHandler
extends Handler {
    private static MigrationTreeTableLogPage s_migrationLogPage;
    private static MigrationLogHandler s_self;
    private List<ILogListener> _listenerList = new ArrayList<ILogListener>();

    public static synchronized MigrationLogHandler getInstance() {
        if (s_self == null) {
            s_self = new MigrationLogHandler();
        }
        return s_self;
    }

    private MigrationLogHandler() {
    }

    public static void activateLogView() {
        if (s_migrationLogPage != null) {
            s_migrationLogPage.getLogPageView().show();
            s_migrationLogPage.getLogPageView().activate();
            s_migrationLogPage.startAsynchronousLogging();
        }
    }

    public static void activateLogView(boolean bl) {
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MigrationLogHandler.getInstance().addMigrationLogPage();
                    MigrationLogHandler.activateLogView();
                }
            });
        } else {
            MigrationLogHandler.activateLogView();
        }
    }

    private synchronized LogPage getLogPage() {
        if (s_migrationLogPage == null) {
            s_migrationLogPage = new MigrationTreeTableLogPage();
        }
        return s_migrationLogPage;
    }

    private synchronized void addMigrationLogPage() {
        LogManager logManager;
        if (s_migrationLogPage == null && (logManager = LogManager.getLogManager()) != null) {
            LogManager.getLogManager().addPage(this.getLogPage());
            MigrationLogHandler.activateLogView();
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        this.addMigrationLogPage();
        if (!this.isLoggable(logRecord)) {
            return;
        }
        s_migrationLogPage.log(logRecord);
    }

    @Override
    public synchronized void flush() {
        while (s_migrationLogPage != null && !s_migrationLogPage.isLogQueueEmpty()) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void close() {
        if (s_migrationLogPage != null) {
            UnifiedBuildSystem.ideLog.unregisterAsynchronousLogPage(this.getLogPage());
        }
    }

    public void notifyListeners(LogRecord logRecord) {
        for (ILogListener iLogListener : this._listenerList) {
            iLogListener.run(logRecord);
        }
    }

    public void registerListener(ILogListener iLogListener) {
        if (!this._listenerList.contains(iLogListener)) {
            this._listenerList.add(iLogListener);
        }
    }

    public void setFilterBy(Object object) {
        if (s_migrationLogPage != null) {
            s_migrationLogPage.setFilterBy(object);
        }
    }

    public void loadLastProjectLog() {
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(MigrationAddin.getPersistenceManager());
        try {
            CloseableIterator closeableIterator = persistenceUtility.getAllCapturedConnections();
            MdConnection mdConnection = this.getLatestConnection(closeableIterator);
            CloseableIterator closeableIterator2 = persistenceUtility.getAllConvertedConnections();
            MdConnection mdConnection2 = this.getLatestConnection(closeableIterator2);
            MdConnection mdConnection3 = null;
            if (mdConnection != null) {
                mdConnection3 = mdConnection;
            }
            if (mdConnection2 != null && (mdConnection3 != null && mdConnection2.getCreatedOn().compareTo(mdConnection3.getCreatedOn()) >= 0 || mdConnection3 == null)) {
                mdConnection3 = mdConnection2;
            }
            if (mdConnection3 != null) {
                Context context = new Context();
                context.setSelection(new Element[]{new CapturedConnectionNode("", "", mdConnection3)});
                ShowLogAction showLogAction = new ShowLogAction();
                showLogAction.setContext(context);
                showLogAction.launch();
                this.setFilterBy(mdConnection3.getKey());
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not load log messages", persistenceException);
        }
    }

    private MdConnection getLatestConnection(CloseableIterator<MdConnection> closeableIterator) {
        MdConnection mdConnection = null;
        Date date = null;
        while (closeableIterator.hasNext()) {
            MdConnection mdConnection2 = (MdConnection)closeableIterator.next();
            DBObjectId dBObjectId = mdConnection2.getProjectId();
            Date date2 = mdConnection2.getCreatedOn();
            if (date != null && date2.compareTo(date) < 0) continue;
            date = date2;
            mdConnection = mdConnection2;
        }
        return mdConnection;
    }

    public void clearAllLogs() {
        if (s_migrationLogPage != null) {
            s_migrationLogPage.clearAll();
        }
    }
}

