/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.NavigatorNodeMap;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.model.Element;

public final class MigrationFilterUtil {
    private static MigrationObjectFilter[] s_schemaChildFilters = new MigrationObjectFilter[CaptureWorker.CAPTURE_ORDER.length - 2];

    private MigrationFilterUtil() {
    }

    public static MigrationObjectFilterList generateFilters(Context context) {
        String[] stringArray;
        Properties properties;
        Element[] elementArray;
        HashMap hashMap = new HashMap();
        MigrationObjectFilterList migrationObjectFilterList = new MigrationObjectFilterList();
        NavigatorNodeMap navigatorNodeMap = new NavigatorNodeMap();
        MigrationObjectFilter migrationObjectFilter = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        boolean bl = false;
        DBObject dBObject = null;
        dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        String string = null;
        if (dBObject != null) {
            string = dBObject.getConnectionType();
        }
        if (string != null && ("JDBC".equals(string) || "ODBCBridge".equals(string))) {
            bl = true;
        }
        if (((elementArray = context.getSelection()) == null || elementArray.length == 0) && context.getNode() instanceof ViewerNode) {
            elementArray = new Element[1];
            properties = (ViewerNode)context.getNode();
            elementArray[0] = properties.getBaseNode();
        }
        properties = navigatorNodeMap.getMap();
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < elementArray.length; ++i) {
            String[] stringArray2;
            MigrationObjectFilter[] migrationObjectFilterArray;
            Object object3;
            if (elementArray[i] instanceof CatalogFolder) {
                CatalogFolder catalogFolder = (CatalogFolder)elementArray[i];
                stringArray = catalogFolder.getURL();
                String string2 = DBURLFormatHelper.getCatalog((URL)stringArray);
                arrayList2.add(string2);
                bl3 = true;
                bl2 = true;
                continue;
            }
            if (elementArray[i] instanceof SchemaFolder) {
                String string3 = (String)((SchemaFolder)elementArray[i]).getProperty("CATALOG");
                if (string3 != null && string3.length() > 0 && !arrayList2.contains(string3)) {
                    arrayList2.add(string3);
                }
                stringArray = ((SchemaFolder)elementArray[i]).getShortLabel();
                if (bl) continue;
                arrayList.add(stringArray);
                bl2 = true;
                continue;
            }
            if (elementArray[i] instanceof ObjectFolder) {
                Object object2;
                ObjectFolder objectFolder = (ObjectFolder)elementArray[i];
                stringArray = MigrationURLFormatHelper.getSchema((URL)objectFolder.getURL());
                String string4 = ((ObjectFolder)elementArray[i]).getObjectType();
                if (!bl) {
                    if (!arrayList.contains(stringArray)) {
                        arrayList.add(stringArray);
                    }
                    object2 = null;
                    try {
                        object2 = MigrationURLFormatHelper.getCatalogSchema((URL)objectFolder.getURL());
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    if (object2 != null && !arrayList.contains(object2)) {
                        arrayList.add(object2);
                    }
                } else {
                    migrationObjectFilter = new MigrationObjectFilter("MD_CATALOGS");
                    migrationObjectFilterList.addFilter(migrationObjectFilter);
                    migrationObjectFilter = new MigrationObjectFilter("MD_SCHEMAS");
                    migrationObjectFilterList.addFilter(migrationObjectFilter);
                }
                object2 = ((ObjectFolder)elementArray[i]).getProperty("CATALOG");
                object3 = null;
                if (object2 != null) {
                    object3 = (String)object2;
                }
                if (object3 == null && ((object3 = DBURLFormatHelper.getCatalog((URL)((ObjectFolder)elementArray[i]).getURL())) == null || ((String)object3).length() == 0)) {
                    object3 = MigrationURLFormatHelper.getCatalog((URL)((ObjectFolder)elementArray[i]).getURL());
                }
                if (object3 != null && !arrayList2.contains(object3) && ((String)object3).length() > 0) {
                    arrayList2.add(object3);
                }
                for (MigrationObjectFilter migrationObjectFilter2 : migrationObjectFilterArray = MigrationFilterUtil.generateFilter(properties.getProperty(string4, string4))) {
                    migrationObjectFilterList.addFilter(migrationObjectFilter2);
                }
                continue;
            }
            if (elementArray[i] instanceof ObjectNode) {
                String string5;
                ObjectNode objectNode = (ObjectNode)elementArray[i];
                stringArray = (String)objectNode.getProperty("TYPE");
                String string6 = (String)objectNode.getProperty("SCHEMA");
                if (!bl) {
                    if (!arrayList.contains(string6)) {
                        arrayList.add(string6);
                    }
                } else {
                    migrationObjectFilter = new MigrationObjectFilter("MD_CATALOGS");
                    migrationObjectFilterList.addFilter(migrationObjectFilter);
                    migrationObjectFilter = new MigrationObjectFilter("MD_SCHEMAS");
                    migrationObjectFilterList.addFilter(migrationObjectFilter);
                }
                if ((string5 = (String)objectNode.getProperty("CATALOG")) != null && string5.length() > 0 && !arrayList2.contains(string5)) {
                    arrayList2.add(string5);
                }
                object3 = (ObjectNode)elementArray[i];
                migrationObjectFilterArray = object3.getShortLabel();
                if (hashMap.get(stringArray) == null) {
                    hashMap.put(stringArray, new ArrayList());
                    ((ArrayList)hashMap.get(stringArray)).add(migrationObjectFilterArray);
                    continue;
                }
                ((ArrayList)hashMap.get(stringArray)).add(migrationObjectFilterArray);
                continue;
            }
            if (elementArray[i] instanceof CapturedNode) {
                String string7;
                CapturedNode capturedNode = (CapturedNode)elementArray[i];
                stringArray = (String)capturedNode.getProperty("TYPE");
                String string8 = (String)capturedNode.getProperty("SCHEMA");
                if (!arrayList.contains(string8)) {
                    arrayList.add(string8);
                }
                if ((string7 = (String)capturedNode.getProperty("CATALOG")) != null && string7.length() > 0 && !arrayList2.contains(string7)) {
                    arrayList2.add(string7);
                }
                object3 = capturedNode.getShortLabel();
                if (hashMap.get(stringArray) == null) {
                    hashMap.put(stringArray, new ArrayList());
                    ((ArrayList)hashMap.get(stringArray)).add(object3);
                    continue;
                }
                ((ArrayList)hashMap.get(stringArray)).add(object3);
                continue;
            }
            if (!(elementArray[i] instanceof MigrationConnectionNode)) continue;
            migrationObjectFilter = new MigrationObjectFilter("MD_CATALOGS");
            migrationObjectFilterList.addFilter(migrationObjectFilter);
            migrationObjectFilter = new MigrationObjectFilter("MD_SCHEMAS");
            migrationObjectFilterList.addFilter(migrationObjectFilter);
            for (Object object3 : stringArray2 = new String[]{"MD_TABLES", "MD_VIEWS", "MD_FUNCTION", "MD_PROCEDURE", "MD_STORED_PROGRAMS", "MD_SEQUENCES", "MD_TRIGGERS", "MD_INDEXES", "MD_USERS"}) {
                for (MigrationObjectFilter migrationObjectFilter2 : migrationObjectFilterArray = MigrationFilterUtil.generateFilter((String)object3)) {
                    migrationObjectFilterList.addFilter(migrationObjectFilter2);
                }
            }
        }
        if (arrayList.size() > 0) {
            String[] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
            migrationObjectFilter = new MigrationObjectFilter("MD_SCHEMAS", stringArray3);
            migrationObjectFilterList.addFilter(migrationObjectFilter);
            if (arrayList2.size() == 0) {
                migrationObjectFilter = new MigrationObjectFilter("MD_CATALOGS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
            }
        }
        if (arrayList2.size() > 0) {
            String[] stringArray4 = arrayList2.toArray(new String[arrayList2.size()]);
            migrationObjectFilter = new MigrationObjectFilter("MD_CATALOGS", stringArray4);
            migrationObjectFilterList.addFilter(migrationObjectFilter);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            stringArray = (String)entry.getKey();
            ArrayList arrayList3 = (ArrayList)entry.getValue();
            String string9 = properties.getProperty((String)stringArray, (String)stringArray);
            migrationObjectFilter = new MigrationObjectFilter(string9, arrayList3.toArray(new String[arrayList3.size()]));
            migrationObjectFilterList.addFilter(migrationObjectFilter);
            if (string9.equals("MD_TABLES")) {
                migrationObjectFilter = new MigrationObjectFilter("MD_COLUMNS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
                migrationObjectFilter = new MigrationObjectFilter("MD_INDEXES");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
                migrationObjectFilter = new MigrationObjectFilter("MD_INDEX_DETAILS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
                migrationObjectFilter = new MigrationObjectFilter("MD_CONSTRAINTS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
                migrationObjectFilter = new MigrationObjectFilter("MD_CONSTRAINT_DETAILS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
                migrationObjectFilter = new MigrationObjectFilter("MD_TRIGGERS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
            }
            if (string9.equals("MD_VIEWS")) {
                migrationObjectFilter = new MigrationObjectFilter("MD_VIEWS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
                migrationObjectFilter = new MigrationObjectFilter("MD_TRIGGERS");
                migrationObjectFilterList.addFilter(migrationObjectFilter);
            }
            if (!string9.equals("MD_STORED_PROGRAMS") && !string9.equals("MD_PROCEDURE") && !string9.equals("MD_FUNCTION")) continue;
            migrationObjectFilter = new MigrationObjectFilter("MD_STORED_PROGRAMS", arrayList3.toArray(new String[arrayList3.size()]));
            migrationObjectFilterList.addFilter(migrationObjectFilter);
        }
        if (bl3) {
            migrationObjectFilter = new MigrationObjectFilter("MD_SCHEMAS");
            migrationObjectFilterList.addFilter(migrationObjectFilter);
        }
        if (bl2) {
            for (MigrationObjectFilter migrationObjectFilter3 : s_schemaChildFilters) {
                migrationObjectFilterList.addFilter(migrationObjectFilter3);
            }
        }
        if (migrationObjectFilterList.size() == 0) {
            return null;
        }
        return migrationObjectFilterList;
    }

    private static MigrationObjectFilter[] generateFilter(String string) {
        ArrayList<MigrationObjectFilter> arrayList = new ArrayList<MigrationObjectFilter>();
        MigrationObjectFilter migrationObjectFilter = string.equals("MD_STORED_PROGRAMS") || string.equals("MD_PROCEDURE") || string.equals("MD_FUNCTION") ? new MigrationObjectFilter(0, "MD_STORED_PROGRAMS") : new MigrationObjectFilter(0, string);
        arrayList.add(migrationObjectFilter);
        if (string.equals("MD_TABLES")) {
            migrationObjectFilter = new MigrationObjectFilter("MD_COLUMNS");
            arrayList.add(migrationObjectFilter);
            migrationObjectFilter = new MigrationObjectFilter("MD_INDEXES");
            arrayList.add(migrationObjectFilter);
            migrationObjectFilter = new MigrationObjectFilter("MD_INDEX_DETAILS");
            arrayList.add(migrationObjectFilter);
            migrationObjectFilter = new MigrationObjectFilter("MD_CONSTRAINTS");
            arrayList.add(migrationObjectFilter);
            migrationObjectFilter = new MigrationObjectFilter("MD_CONSTRAINT_DETAILS");
            arrayList.add(migrationObjectFilter);
            migrationObjectFilter = new MigrationObjectFilter("MD_TRIGGERS");
            arrayList.add(migrationObjectFilter);
        }
        return arrayList.toArray(new MigrationObjectFilter[arrayList.size()]);
    }

    public static MigrationObjectFilterList getFullFilter() {
        String[] stringArray = new String[]{"MD_TABLES", "MD_VIEWS", "MD_FUNCTION", "MD_PROCEDURE", "MD_STORED_PROGRAMS", "MD_SEQUENCES", "MD_TRIGGERS", "MD_INDEXES", "MD_USERS"};
        return MigrationFilterUtil.getFilter(stringArray);
    }

    public static MigrationObjectFilterList getProgramLessFilter() {
        String[] stringArray = new String[]{"MD_TABLES", "MD_SEQUENCES", "MD_INDEXES", "MD_USERS"};
        return MigrationFilterUtil.getFilter(stringArray);
    }

    public static MigrationObjectFilterList getFilter(String[] stringArray) {
        MigrationObjectFilterList migrationObjectFilterList = new MigrationObjectFilterList();
        MigrationObjectFilter migrationObjectFilter = null;
        migrationObjectFilter = new MigrationObjectFilter("MD_CATALOGS");
        migrationObjectFilterList.addFilter(migrationObjectFilter);
        migrationObjectFilter = new MigrationObjectFilter("MD_SCHEMAS");
        migrationObjectFilterList.addFilter(migrationObjectFilter);
        for (String string : stringArray) {
            MigrationObjectFilter[] migrationObjectFilterArray;
            for (MigrationObjectFilter migrationObjectFilter2 : migrationObjectFilterArray = MigrationFilterUtil.generateFilter(string)) {
                migrationObjectFilterList.addFilter(migrationObjectFilter2);
            }
        }
        return migrationObjectFilterList;
    }

    static {
        int n = 0;
        for (String string : CaptureWorker.CAPTURE_ORDER) {
            if (string.equals("MD_CATALOGS") || string.equals("MD_SCHEMAS")) continue;
            MigrationFilterUtil.s_schemaChildFilters[n++] = new MigrationObjectFilter(string);
        }
    }
}

