/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.OnlineCaptureWorker;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.CaptureDialogTaskUI;
import oracle.dbtools.migration.workbench.core.ui.CaptureRunnerTask;
import oracle.dbtools.migration.workbench.core.ui.SingleDropdownDialog;
import oracle.dbtools.migration.workbench.core.util.IncrementalMigrationStorer;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class CaptureInitiator
extends AbstractMenuAction {
    private boolean m_incremental;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void launch() {
        MigrationObjectFilterList migrationObjectFilterList = null;
        DBObject dBObject = this.getDBObject();
        MigrationPlugin migrationPlugin = this.getMigrationPlugin(dBObject);
        if (migrationPlugin == null) {
            return;
        }
        ThirdPartyDbProvider thirdPartyDbProvider = null;
        Context context = this.getContext();
        migrationObjectFilterList = MigrationFilterUtil.generateFilters(context);
        try {
            thirdPartyDbProvider = migrationPlugin.getProvider(dBObject.getConnection());
            PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
            if (persistenceManager == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MSG_CANNOT_CAPTURE"), (String)MigrationAddinArb.getString("TITLE_CANNOT_CAPTURE"), (String)"help_must_connect_before_capture");
                return;
            }
            BasicMigrationStorer basicMigrationStorer = null;
            MdConnection mdConnection = null;
            if (this.m_incremental) {
                mdConnection = this.getTargetConnection(context);
                if (mdConnection == null) return;
                basicMigrationStorer = new IncrementalMigrationStorer(MigrationAddin.getPersistenceManager(), mdConnection);
            } else {
                basicMigrationStorer = new BasicMigrationStorer(MigrationAddin.getPersistenceManager());
            }
            OnlineCaptureWorker onlineCaptureWorker = new OnlineCaptureWorker(thirdPartyDbProvider.getCapturer(basicMigrationStorer), migrationPlugin.getPlatformName(), migrationPlugin.getClass().getName(), migrationObjectFilterList);
            if (mdConnection != null) {
                onlineCaptureWorker.setTargetConnection(mdConnection);
            }
            CaptureRunnerTask captureRunnerTask = new CaptureRunnerTask(onlineCaptureWorker, migrationPlugin.getPlatformMask(), dBObject.getConnectionName());
            final CaptureDialogTaskUI captureDialogTaskUI = new CaptureDialogTaskUI(captureRunnerTask.getDescriptor());
            onlineCaptureWorker.addActionListener(captureDialogTaskUI);
            RaptorTaskManager.getInstance().addTask((RaptorTask)captureRunnerTask, Collections.singletonList(new ITaskViewer(){

                public void addTaskUI(ITaskUI iTaskUI) {
                }

                public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return captureDialogTaskUI;
                }

                public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return this.getTaskUI(raptorTaskDescriptor);
                }

                public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void removeTaskUI(ITaskUI iTaskUI) {
                }
            }));
            return;
        }
        catch (MigrationPluginException migrationPluginException) {
            MigrationLogUtil.logThrowable(migrationPluginException.getMessage(), Messages.getString("CaptureInitiator.1"), (Throwable)migrationPluginException);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, migrationPluginException.getStackTrace()[0].toString(), migrationPluginException);
            return;
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getMessage(), Messages.getString("CaptureInitiator.2"), (Throwable)exception);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private MdConnection getTargetConnection(Context context) {
        Object object;
        Object object2;
        Element element = context.getElement();
        Element[] elementArray = context.getSelection();
        String string = null;
        if (elementArray.length > 0) {
            object2 = elementArray[0];
            if (object2 instanceof CatalogFolder) {
                object = (CatalogFolder)object2;
                string = DBURLFormatHelper.getConnectionName((URL)object.getURL());
            } else if (object2 instanceof SchemaFolder) {
                object = (SchemaFolder)object2;
                string = DBURLFormatHelper.getConnectionName((URL)object.getURL());
            } else if (object2 instanceof ObjectFolder) {
                object = (ObjectFolder)object2;
                string = DBURLFormatHelper.getConnectionName((URL)object.getURL());
            } else if (object2 instanceof ObjectNode) {
                object = (ObjectNode)object2;
                string = DBURLFormatHelper.getConnectionName((URL)object.getURL());
            } else {
                return null;
            }
        }
        try {
            object2 = null;
            try {
                Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
            if (object2 == null) {
                object2 = this.getDBObject().getConnection();
            }
            object = object2.getMetaData().getURL();
            Object[] objectArray = CapturedDatabases.getInstance().findMatchingConnections((String)object);
            if (objectArray.length == 0) {
                return null;
            }
            if (objectArray.length == 1) {
                return objectArray[0].getMdConnection();
            }
            SingleDropdownDialog singleDropdownDialog = new SingleDropdownDialog((Frame)Ide.getMainWindow(), MigrationAddinArb.getString("IncrementalCapture_DIALOGTITLE"), MigrationAddinArb.getString("IncrementalCapture_LABEL"), MigrationAddinArb.getString("IncrementalCapture_BUTTON"), objectArray);
            singleDropdownDialog.setHelpId("f1_choosetargetmodel");
            if (!singleDropdownDialog.runDialog()) {
                return null;
            }
            return ((MigrationConnectionNode)singleDropdownDialog.getSelectedItem()).getMdConnection();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            return null;
        }
    }

    protected MigrationPlugin getMigrationPlugin(DBObject dBObject) {
        return MigrationAddin.getPluginForConnection(dBObject.getConnection());
    }

    public void setArgs(String string) {
        if (string != null && string.equals("INCREMENTAL")) {
            this.m_incremental = true;
        }
    }
}

