/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.identifierMapping;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.CMDUtil;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdHelp;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.identifierMapping.GenerateMappingXML;
import oracle.dbtools.migration.identifierMapping.LoadMappingXML;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.utils.Connections;
import oracle.jdbc.OracleCallableStatement;

public class IdentifierMappingCmd
extends MigrationCmd {
    public static final String CMDNAME = "idmap";
    IdentifierMappingDetails m_idmDetails = null;

    public IdentifierMappingCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
        try {
            this.m_idmDetails = new IdentifierMappingDetails(migrationDetails);
        }
        catch (CMDLineError cMDLineError) {
            this.getCmdout().printError(cMDLineError);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void executeImpl() {
        boolean bl = this.m_idmDetails.isValid();
        try {
            if (bl) {
                Object object;
                Connection connection = null;
                if (this.m_idmDetails.isRepositorySpecified()) {
                    object = this.m_idmDetails.getUserRepository();
                    boolean bl2 = this.m_idmDetails.isValidUserRepository((String)object);
                    if (bl2) {
                        this.m_idmDetails.openRepositoryConnection((String)object);
                        connection = Connections.getInstance().getConnection((String)object);
                    }
                } else {
                    connection = Connections.getInstance().getConnection(CMDUtil.getRepositoryConnectionName());
                }
                if (connection == null) throw new Exception("A Migration Repository is required to perform this task.");
                if (this.m_idmDetails.isOutputSpecified()) {
                    object = new GenerateMappingXML(connection, this.m_idmDetails);
                    ((GenerateMappingXML)object).generateXML();
                } else if (this.m_idmDetails.isInputSpecified()) {
                    object = new LoadMappingXML(connection, this.m_idmDetails);
                    ((LoadMappingXML)object).loadXML();
                } else if (this.m_idmDetails.isDefaultSpecified()) {
                    this.resetMappingIdentifiers(connection);
                }
                if (!this.m_idmDetails.isRepositorySpecified()) return;
                MigrationAddin.disconnectRepository();
                return;
            } else {
                this.m_idmDetails.usage(this.m_idmDetails.m_errorMessage);
            }
            return;
        }
        catch (Exception exception) {
            this.getCmdout().printError(exception.getLocalizedMessage());
        }
    }

    public void resetMappingIdentifiers(Connection connection) throws Exception {
        String string = null;
        Long l = null;
        String string2 = "select distinct CONNNAME, CONNID from MGV_ALL_DETAILS WHERE CAPTUREDORCONVERTED = 'CAPTURED'";
        Statement statement = connection.createStatement();
        String string3 = this.m_idmDetails.getCapturedModel();
        ResultSet resultSet = statement.executeQuery(string2);
        boolean bl = false;
        while (resultSet.next()) {
            string = resultSet.getString(1);
            l = resultSet.getLong(2);
            if (!string.equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new Exception("The Captured Model \"" + string3 + "\" could not be found.");
        }
        statement = (OracleCallableStatement)connection.prepareCall("{call MIGRATION.REVERT_DERIVATIVES_TABLE(?)}");
        ((OracleCallableStatement)statement).setLong(1, l.longValue());
        ((OracleCallableStatement)statement).execute();
    }

    class IdentifierMappingDetails {
        MigrationDetails m_details = null;
        HashMap<Long, String> m_capturedList = new HashMap();
        HashMap<Integer, Long> m_capIdList = new HashMap();
        StringBuffer m_capturedModels = new StringBuffer();
        String m_errorMessage = null;

        IdentifierMappingDetails(MigrationDetails migrationDetails) throws CMDLineError {
            this.m_details = migrationDetails;
            this.populateCapturedModels();
        }

        public boolean isGenerateFileSpecified() {
            return this.m_details.contains("generatefile");
        }

        public boolean isOutputSpecified() {
            return this.m_details.contains("output");
        }

        public boolean isLoadFileSpecified() {
            boolean bl = this.m_details.contains("loadfile");
            return bl;
        }

        public boolean isInputSpecified() {
            return this.m_details.contains("input");
        }

        public boolean isValidFilePath(String string) {
            if (string != null && string.trim().equals("")) {
                return false;
            }
            return new File(string).isAbsolute();
        }

        public boolean isValidDirectory(String string) {
            if (string != null && string.trim().equals("")) {
                return false;
            }
            return new File(string).isDirectory();
        }

        public boolean isDefaultSpecified() {
            boolean bl = this.m_details.contains("default");
            return bl;
        }

        public boolean isCapturedModelSpecified() {
            return this.m_details.contains("capturedmodel");
        }

        public boolean isValidCapturedModel(String string) {
            String string2 = this.m_details.get(string);
            return !string2.equals("");
        }

        public boolean isRepositorySpecified() {
            return this.m_details.contains("repository");
        }

        public boolean isValidUserRepository(String string) {
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            return migrationConfig.isRepository(string);
        }

        public boolean isValid() {
            boolean bl;
            boolean bl2;
            String[] stringArray;
            if (this.m_details.getCapturedModelCount() == 0 && ((stringArray = this.m_details.getAllActionNames())[0].equals(IdentifierMappingCmd.CMDNAME) || !stringArray[0].equals("capture"))) {
                this.m_errorMessage = "There are no Captured Models in the repository. A \"capture\" action should be performed before the \"idmap\" action.";
                return false;
            }
            if (this.isOutputSpecified() && this.isInputSpecified()) {
                this.m_errorMessage = "Either input or output action needs to be specified.";
                return false;
            }
            if (this.isOutputSpecified() && !(bl2 = this.isValidDirectory(this.m_details.get("output")))) {
                this.m_errorMessage = "Not a valid output directory.";
                return false;
            }
            if (this.isInputSpecified() && !(bl = this.isValidFilePath(this.m_details.get("input")))) {
                this.m_errorMessage = "Not a valid input file.";
                return false;
            }
            return true;
        }

        public String getFilePath() {
            String string = null;
            String string2 = null;
            String string3 = null;
            if (this.isOutputSpecified()) {
                string = this.m_details.get("output");
                try {
                    if (string != null && string.trim().length() > 0) {
                        String string4;
                        File file = new File(string);
                        String string5 = file.getCanonicalPath();
                        string5 = string5 + File.separator + IdentifierMappingCmd.CMDNAME;
                        File file2 = new File(string5);
                        boolean bl = true;
                        if (!file2.exists()) {
                            bl = file2.mkdirs();
                        }
                        if (!bl) {
                            throw new IllegalStateException("Unable to create necessary output directory");
                        }
                        String string6 = string3 = this.m_details.get("model") != null ? this.m_details.get("model") : this.m_details.getCurrentCapturedModel();
                        if (string3 != null && string3.trim().equalsIgnoreCase("latest")) {
                            string3 = this.m_details.getLastCapturedModelId().toString();
                        }
                        string2 = string4 = file2.getPath() + File.separator + "idmap-" + string3 + ".xml";
                    }
                }
                catch (Exception exception) {
                    IdentifierMappingCmd.this.getCmdout().printError(exception.getLocalizedMessage());
                }
            } else if (this.isInputSpecified()) {
                string2 = this.m_details.get("input");
            }
            return string2;
        }

        public void usage(String string) {
            System.err.println("Error:\n" + string + "\n");
            MigrationCmdHelp.usage(IdentifierMappingCmd.CMDNAME, IdentifierMappingCmd.this.getCmdout());
        }

        public String getCapturedModel() {
            String string = this.m_details.get("model");
            if (string != null && !string.trim().equals("")) {
                return string.equalsIgnoreCase("latest") ? this.m_details.getLastCapturedModelId().toString() : this.getModelIdFromList(string);
            }
            string = this.m_details.get("capturedModel");
            if (string == null || string.trim().equals("")) {
                this.selectUserChoosenCapturedModel();
            }
            return this.m_details.get("capturedModel");
        }

        public String getUserRepository() {
            String[] stringArray;
            String string = this.m_details.get("repository");
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            for (String string2 : stringArray = migrationConfig.getRepositories()) {
                if (!string2.endsWith(string)) continue;
                return string2;
            }
            return string;
        }

        public void openRepositoryConnection(String string) {
            MigrationAddin.openRepository(string);
        }

        private void populateCapturedModels() throws CMDLineError {
            Statement statement = null;
            String string = CMDUtil.getRepositoryConnectionName();
            try {
                Connection connection = Connections.getInstance().getConnection(string);
                if (connection != null) {
                    String string2 = "select distinct connname, connid from mgv_all_details where capturedorconverted = 'CAPTURED' order by connid";
                    statement = connection.createStatement();
                    ResultSet resultSet = statement.executeQuery(string2);
                    int n = 0;
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(1);
                        Long l = resultSet.getLong(2);
                        this.m_capturedList.put(l, string3);
                        this.m_capIdList.put(++n, l);
                        String string4 = "" + n + ") " + string3 + "\n";
                        this.m_capturedModels.append(string4);
                    }
                    resultSet.close();
                    statement.close();
                }
            }
            catch (Exception exception) {
                IdentifierMappingCmd.this.getCmdout().printError(exception.getMessage());
            }
        }

        private void selectUserChoosenCapturedModel() {
            IdentifierMappingCmd.this.getCmdout().printPrompt("** Please Choose a Captured Model **");
            IdentifierMappingCmd.this.getCmdout().printPrompt(this.m_capturedModels.toString());
            String string = System.console().readLine(" > Choose a Number: ", new Object[]{null});
            int n = Integer.parseInt(string.trim());
            Long l = this.m_capIdList.get(n);
            if (l != null) {
                this.m_details.setCurrentCaptureModel(l.toString());
            }
        }

        private String getModelIdFromList(String string) {
            String string2 = null;
            if (string.matches("\\d+")) {
                int n = Integer.parseInt(string.trim());
                Long l = this.m_capIdList.get(n);
                if (l != null) {
                    string2 = l.toString();
                    this.m_details.setCurrentCaptureModel(l.toString());
                }
            } else {
                string2 = string;
            }
            return string2;
        }

        public void setCapturedModel(String string) {
            this.m_details.setCurrentCaptureModel(string);
        }
    }
}

