/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.online.Messages;

public class TriggerHandler {
    protected static final int ORA_ERR_NO_SUCH_TRIGGER = 4080;
    protected static Logger s_log = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    protected HashSet<TriggerInformation> m_disabledTriggers = new HashSet();
    private static final String GET_TRIGGERS_QUERY = "SELECT TRIGGER_NAME, SCHEMA_NAME FROM MGV_ALL_TABLE_TRIGGERS WHERE CONNECTION_ID = ?";
    protected DBObjectId m_connectionId;
    protected PersistenceManager m_persistenceManager;

    public TriggerHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        this.setConnectionId(dBObjectId);
        this.setPersistenceManager(persistenceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableTriggers(Connection connection, boolean bl) {
        if (connection == null) {
            throw new IllegalArgumentException(Messages.getString("TriggerHandler.1"));
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.m_persistenceManager.getPreparedStatement(GET_TRIGGERS_QUERY);
            preparedStatement.setLong(1, this.m_connectionId.getId());
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            s_log.warning(sQLException.getLocalizedMessage());
            CloseableResultSet.close(null, resultSet);
            return;
        }
        try {
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        TriggerInformation triggerInformation = new TriggerInformation(resultSet);
                        boolean bl2 = false;
                        if (connection != null) {
                            bl2 = this.issueTriggerStmt(connection, triggerInformation.getDisableStatment(bl));
                        }
                        if (!bl2) continue;
                        this.m_disabledTriggers.add(triggerInformation);
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                s_log.warning(sQLException.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(null, resultSet);
            throw throwable;
        }
        CloseableResultSet.close(null, resultSet);
    }

    void enableTriggers(Connection connection, boolean bl) {
        for (TriggerInformation triggerInformation : this.m_disabledTriggers) {
            if (connection == null) continue;
            this.issueTriggerStmt(connection, triggerInformation.getEnableStatement(bl));
        }
    }

    public void enableTriggers(boolean bl) {
        this.enableTriggers(null, bl);
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        this.m_connectionId = dBObjectId;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected boolean issueTriggerStmt(Connection connection, String string) {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(string);
            statement.close();
            return true;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 4080) {
                s_log.warning(sQLException.getLocalizedMessage());
            }
            return false;
        }
    }

    public static class TriggerInformation {
        private String m_triggerName;
        private String m_schemaName;

        public TriggerInformation(ResultSet resultSet) throws SQLException {
            this.m_triggerName = resultSet.getString(1);
            this.m_schemaName = resultSet.getString(2);
        }

        public String getTriggerName() {
            return this.m_triggerName;
        }

        public String getSchemaName() {
            return this.m_schemaName;
        }

        private String getAlterStatement(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer("ALTER TRIGGER ");
            if (bl) {
                stringBuffer.append(this.m_schemaName);
                stringBuffer.append('.');
            }
            stringBuffer.append(this.m_triggerName);
            return stringBuffer.toString();
        }

        public String getDisableStatment(boolean bl) {
            return this.getAlterStatement(bl) + " DISABLE";
        }

        public String getEnableStatement(boolean bl) {
            return this.getAlterStatement(bl) + " ENABLE";
        }
    }
}

