/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline.streams;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.offline.streams.Offline3rdPartyDMSAbstract;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSInterface;
import oracle.dbtools.migration.datamove.offline.streams.ThirdPartyDMStream;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;

public class OfflineDataMoveStream
implements OfflineDMSInterface {
    ArrayList<OfflineDMSAbstract> list = new ArrayList();
    String m_basedir = null;
    boolean m_truncate = false;
    String m_catalog = null;
    String m_schema = null;
    private MigrationPlugin m_plugin;
    private String streamTimestamp;
    private String projectName;

    public String getCatalog() {
        return this.m_catalog;
    }

    public void setCatalogDir(String string) {
        this.m_catalog = string;
        for (OfflineDMSAbstract offlineDMSAbstract : this.list) {
            offlineDMSAbstract.setCatalogDir(string);
        }
    }

    public String getSchema() {
        return this.m_schema;
    }

    public void setSchema(String string) {
        this.m_schema = string;
        for (OfflineDMSAbstract offlineDMSAbstract : this.list) {
            offlineDMSAbstract.setSchemaDir(string);
        }
    }

    public OfflineDataMoveStream(String string, boolean bl, MdConnection mdConnection, DataMoveAudience dataMoveAudience) {
        try {
            this.m_plugin = MigrationUtils.getPluginForConnection(mdConnection);
            this.projectName = MdProject.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), mdConnection.getProjectId()).getProjectName();
            this.setTimeStamp(OfflineDataMoveStream.getTimeStamp());
            this.list.add(this.m_plugin.getSQLLoaderDMStream(OfflineDataMoveStream.getTimeStamp(), string));
            this.list.add(this.m_plugin.getExternalLoaderDMStream(OfflineDataMoveStream.getTimeStamp(), string));
            Offline3rdPartyDMSAbstract offline3rdPartyDMSAbstract = this.m_plugin.getOffline3rdPartyPrintStream(OfflineDataMoveStream.getTimeStamp(), string);
            if (offline3rdPartyDMSAbstract != null) {
                this.list.add(offline3rdPartyDMSAbstract);
            } else {
                this.list.add(new ThirdPartyDMStream(string, this.m_plugin));
            }
            this.setAudience(dataMoveAudience, this.projectName, this.streamTimestamp);
            this.m_basedir = string;
            this.m_truncate = bl;
            this.setWriteDir(this.m_basedir);
        }
        catch (MigrationPluginException migrationPluginException) {
            migrationPluginException.printStackTrace();
        }
        catch (PersistenceException persistenceException) {
            persistenceException.printStackTrace();
        }
        catch (NoSuchObjectException noSuchObjectException) {
            noSuchObjectException.printStackTrace();
        }
    }

    @Override
    public void setAudience(DataMoveAudience dataMoveAudience, String string, String string2) {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.setAudience(dataMoveAudience, string, string2);
        }
    }

    public String getBaseDir() {
        return this.m_basedir;
    }

    private final void setWriteDir(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    @Override
    public void println(PrintWriter printWriter, String string, boolean bl) {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.println(printWriter, string, bl);
        }
    }

    @Override
    public void startTable(String string) {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.startTable(string);
        }
    }

    @Override
    public void endTable() {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.endTable();
        }
    }

    @Override
    public void startDatabase(String string, String string2) {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.startDatabase(string, string2);
        }
    }

    @Override
    public void endDatabase() {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.endDatabase();
        }
    }

    @Override
    public void startSchema(String string, String string2) {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.startSchema(string, string2);
        }
        this.setSchema(string2);
    }

    @Override
    public void endSchema() {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.endSchema();
        }
    }

    @Override
    public void finished() {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.finished();
        }
    }

    @Override
    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        for (OfflineDMSInterface offlineDMSInterface : this.list) {
            offlineDMSInterface.start(mdConnection, persistenceManager);
        }
    }

    public static void main(String[] stringArray) {
        try {
            OfflineDataMoveStream.delete(new File("/tmp/dm1"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        OfflineDataMoveStream offlineDataMoveStream = new OfflineDataMoveStream("/tmp/dm1", true, null, null);
        offlineDataMoveStream.startDatabase("pubs2", "dbo");
        offlineDataMoveStream.startSchema("pubs2", "dbo");
        offlineDataMoveStream.startTable("rebecca");
        offlineDataMoveStream.endTable();
        offlineDataMoveStream.startTable("katieellen");
        offlineDataMoveStream.endTable();
        offlineDataMoveStream.endSchema();
        offlineDataMoveStream.startSchema("pubs2", "sa");
        offlineDataMoveStream.startTable("barry");
        offlineDataMoveStream.endTable();
        offlineDataMoveStream.startTable("lisa");
        offlineDataMoveStream.endTable();
        offlineDataMoveStream.endSchema();
        offlineDataMoveStream.endDatabase();
        offlineDataMoveStream.finished();
    }

    static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                OfflineDataMoveStream.delete(file2);
            }
        }
        if (!file.delete()) {
            System.out.println("Failed to delete file: " + file);
        }
    }

    @Override
    public void setDescriptor(DataMoveDescriptor dataMoveDescriptor) {
        for (OfflineDMSAbstract offlineDMSAbstract : this.list) {
            offlineDMSAbstract.setDescriptor(dataMoveDescriptor);
        }
    }

    public static String getTimeStamp() {
        String string = "";
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        String string2 = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        string = simpleDateFormat.format(calendar.getTime());
        string = string.replaceFirst(" ", "_");
        string = string.replace(":", "-");
        return string;
    }

    public final void setTimeStamp(String string) {
        this.streamTimestamp = string;
    }
}

