/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.online.ConstraintHandler;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class OfflineConstraintHandler
extends ConstraintHandler {
    private static final String QUERY_FIND_CONSTRAINTS_OFF = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.NAME, B.CONSTRAINT_TYPE, DECODE(B.CONSTRAINT_TYPE, 'CHECK', 1, 'FOREIGN KEY',2, 'PK', 3, 'UNIQUE', 4) CONSCODE, B.ID FROM MGV_ALL_TABLES A, MD_CONSTRAINTS B WHERE A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? AND A.CATALOG_NAME = ? AND A.SCHEMA_NAME = ? ORDER BY CONSCODE";
    private static final String QUERY_FIND_CONSTRAINTS_ON = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.NAME, B.CONSTRAINT_TYPE, DECODE(B.CONSTRAINT_TYPE, 'PK', 1, 'UNIQUE', 2, 'FOREIGN KEY' ,3, 'CHECK', 4) CONSCODE, B.ID FROM MGV_ALL_TABLES A, MD_CONSTRAINTS B WHERE A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? AND A.CATALOG_NAME = ? AND A.SCHEMA_NAME = ? ORDER BY CONSCODE";
    public static final String CONSTRAINTS_ON = "CONSTRAINTS_ON";
    public static final String CONSTRAINTS_OFF = "CONSTRAINTS_OFF";

    public OfflineConstraintHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        super(dBObjectId, persistenceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ConstraintHandler.ConstraintDetail> getConstraints(String string, String string2, String string3) {
        ArrayList<ConstraintHandler.ConstraintDetail> arrayList = new ArrayList<ConstraintHandler.ConstraintDetail>();
        CloseableResultSet closeableResultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            if (string3.equals(CONSTRAINTS_ON)) {
                preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_CONSTRAINTS_ON);
            } else if (string3.equals(CONSTRAINTS_OFF)) {
                preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_CONSTRAINTS_OFF);
            }
            preparedStatement.setLong(1, this.m_connectionId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            String string4 = preparedStatement.toString();
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                ConstraintHandler.ConstraintDetail constraintDetail = new ConstraintHandler.ConstraintDetail(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3));
                try {
                    if (MdConstraint.retrieveExistingInstance(this.m_persistenceManager, new DBObjectId(resultSet.getLong(6))).getProperty("DO_NOT_ENABLE_DISABLE") != null) continue;
                    arrayList.add(constraintDetail);
                }
                catch (PersistenceException persistenceException) {
                    MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)persistenceException);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)noSuchObjectException);
                }
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
        return arrayList;
    }
}

