/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.ListCapturedModelsCmd;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class DelCapturedCmd
extends MigrationCmd {
    public static final String CMDNAME = "delcaptured";

    public DelCapturedCmd(MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        super(CMDNAME, migrationDetails, cMDOut, bl);
    }

    @Override
    protected void executeImpl() throws CMDLineError {
        Object object;
        this.verifyRepository();
        ListCapturedModelsCmd listCapturedModelsCmd = null;
        Long l = null;
        MdConnection mdConnection = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        if (persistenceManager == null) {
            String string = MigrationAddin.getDefaultMigrationRepository();
            try {
                object = Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            MigrationAddin.openRepository(string);
            persistenceManager = MigrationAddin.getPersistenceManager();
        }
        int n = -1;
        try {
            listCapturedModelsCmd = (ListCapturedModelsCmd)MigrationCmdRegistry.getMigrationCmd("lscaptured", this.getMigrationDetails(), this.getCmdout(), true);
        }
        catch (Exception exception) {
            throw new CMDLineError(CMDNAME, "Problem listing the captured models", exception);
        }
        listCapturedModelsCmd.execute();
        object = this.getMigrationDetails().get("model");
        if (listCapturedModelsCmd.hasSingleCapturedModel() || object != null && "latest".equalsIgnoreCase(((String)object).trim())) {
            l = listCapturedModelsCmd.getLatestCapturedModel();
        } else if (object != null) {
            n = Integer.parseInt((String)object);
            l = listCapturedModelsCmd.getModelIdForIndex(n);
        } else if (!listCapturedModelsCmd.hasSingleCapturedModel() && object == null) {
            listCapturedModelsCmd.printModelList();
            n = this.getCmdout().promptForModelSelection();
            l = listCapturedModelsCmd.getModelIdForIndex(n);
        } else {
            throw new IllegalStateException("There are no valid captured models in the repository");
        }
        if (l == null) {
            throw new IllegalStateException("Unable to locate captured model corresponding to id: " + n);
        }
        dBObjectId = new DBObjectId(l);
        try {
            mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
        }
        catch (PersistenceException persistenceException) {
            throw new CMDLineError(CMDNAME, "Problem retrieving the connection information", persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new CMDLineError(CMDNAME, "Connection cannot be found", noSuchObjectException);
        }
        try {
            mdConnection.delete(persistenceManager);
        }
        catch (PersistenceException persistenceException) {
            throw new CMDLineError(CMDNAME, "Connection found, but problem encountered deleting", persistenceException);
        }
    }
}

