/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.PlatformDatabaseListProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MySQLDatabaseListProvider
implements PlatformDatabaseListProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getAvailableOfflineDatabaseList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Properties properties = new Properties();
        File file = null;
        String string2 = null;
        LineNumberReader lineNumberReader = null;
        FileInputStream fileInputStream = null;
        String string3 = "";
        String string4 = "";
        try {
            String string5;
            file = new File(string);
            if (file != null && file.canRead()) {
                fileInputStream = new FileInputStream(file);
                string2 = file.getParent();
                properties.load(fileInputStream);
            }
            if ((string5 = properties.getProperty("version_info")) != null) {
                File file2 = new File(string2, string5 = string5.trim());
                if (file2.exists() && file2.canRead()) {
                    FileReader fileReader = new FileReader(file2);
                    lineNumberReader = new LineNumberReader(fileReader);
                }
                while ((string3 = lineNumberReader.readLine()) != null) {
                    if (string3.equalsIgnoreCase("VERSION()")) continue;
                    string4 = string3.substring(0, string3.indexOf("."));
                }
                arrayList = string4.startsWith("3") || string4.startsWith("4") ? this.readFlatFileForDatabaseList(string2, properties) : this.readXMLFileForDatabaseList(string2, properties);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MSG_CANNOT_CONVERT"), (String)MigrationAddinArb.getString("TITLE_CANNOT_CONVERT"), (String)"help_migr_no_plugin_saved");
            }
        }
        catch (IOException iOException) {
            String string6 = MigrationAddinArb.format("READ_OFFLINE_OUTPUT_FAILED", file.getName(), iOException.getMessage());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
        return arrayList;
    }

    private ArrayList<String> readXMLFileForDatabaseList(String string, Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = string.concat(File.separator).concat(properties.getProperty("alldbsfile").trim());
            FileInputStream fileInputStream = new FileInputStream(new File(string2));
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            String string3 = Ide.getEnvironOptions().getEncoding();
            if (string3 == null) {
                dOMParser.parse((InputStream)fileInputStream);
            } else {
                dOMParser.parse((Reader)new BufferedReader(new InputStreamReader((InputStream)fileInputStream, string3)));
            }
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getElementsByTagName("mysqldump").item(0);
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string4;
                Node node2 = nodeList.item(i);
                if (!node2.getNodeName().equals("database") || (string4 = XMLHelper.getAttributeNode((Node)node2, (String)"name")).equalsIgnoreCase("mysql") || string4.equalsIgnoreCase("information_schema")) continue;
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    private ArrayList<String> readFlatFileForDatabaseList(String string, Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = properties.getProperty("table_info").trim();
        try {
            File file;
            if (string2 != null && (file = new File(string, string2)).exists() && file.canRead()) {
                String string3 = Ide.getEnvironOptions().getEncoding();
                InputStreamReader inputStreamReader = null;
                inputStreamReader = string3 == null ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), string3);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string4 = "";
                ArrayList arrayList2 = new ArrayList();
                String string5 = "";
                boolean bl = false;
                while (bl || (string4 = bufferedReader.readLine()) != null) {
                    bl = false;
                    if (!(string4 = string4.trim()).startsWith("`")) continue;
                    string5 = string4.substring(1, string4.length() - 1);
                    arrayList.add(string5);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return arrayList;
    }

    @Override
    public ArrayList<String> getAvailableOnlineDatabaseList(String string) {
        return this.getOnlineDatabaseNames(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> getOnlineDatabaseNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            Connection connection = Connections.getInstance().getConnection(string);
            int n = connection.getMetaData().getDatabaseMajorVersion();
            String string2 = null;
            string2 = n >= 5 ? "select SCHEMA_NAME AS 'DATABASE' from information_schema.schemata where (SCHEMA_NAME NOT IN ('information_schema','mysql'))" : "SHOW DATABASES";
            PreparedStatement preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString("DATABASE");
                if (string3 == null || string3.equals("mysql")) continue;
                arrayList.add(string3);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return arrayList;
    }

    @Override
    public boolean isSystemDatabase(String string) {
        boolean bl = string != null ? string.equals("mysql") || string.equals("information_schema") : false;
        return bl;
    }
}

