/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.dbtools.migration.capture.AbstractCapturer;
import oracle.dbtools.migration.capture.offline.MultiDatabaseOfflineCapturer;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.javatools.db.DBException;

public abstract class AbstractOfflineCapturer
extends AbstractCapturer
implements MultiDatabaseOfflineCapturer {
    private ConcurrentLinkedQueue<String> _dbQueue = new ConcurrentLinkedQueue();
    private ArrayList<String> m_selectedDBList = null;
    private String m_encoding = null;

    public AbstractOfflineCapturer() {
        super(null);
    }

    @Override
    public boolean hasMoreDatabase() {
        return !this._dbQueue.isEmpty();
    }

    @Override
    public String captureInitialize(String string, Properties properties, MigrationStorer migrationStorer, String string2) throws OfflineCaptureException {
        this.setStorer(migrationStorer);
        this.setEncoding(string2);
        return this.captureInitializeImpl(string, properties);
    }

    @Override
    public String captureInitialize(String string, Properties properties, MigrationStorer migrationStorer) throws OfflineCaptureException {
        this.setStorer(migrationStorer);
        return this.captureInitializeImpl(string, properties);
    }

    protected abstract String captureInitializeImpl(String var1, Properties var2) throws OfflineCaptureException;

    @Override
    public void createStagingTables(Connection connection) throws DBException, SQLException, OfflineCaptureException {
    }

    @Override
    public void cleanUp(String string) throws OfflineCaptureException {
    }

    @Override
    public String getEnterpriseCaptureFileName() {
        return null;
    }

    @Override
    public void addDatabaseToCapture(String string) {
        this._dbQueue.add(string);
    }

    @Override
    public Iterator<String> getDatabases() {
        return this._dbQueue.iterator();
    }

    @Override
    public String getNextDatabase() {
        return !this._dbQueue.isEmpty() ? (String)this._dbQueue.remove() : null;
    }

    public void captureStarting() {
    }

    @Override
    public ArrayList<String> getSelectedDatabaseList() {
        return this.m_selectedDBList;
    }

    @Override
    public void setSelectedDatabaseList(ArrayList<String> arrayList) {
        this.m_selectedDBList = arrayList;
    }

    @Override
    public String getEncoding() {
        return this.m_encoding;
    }

    @Override
    public void setEncoding(String string) {
        this.m_encoding = string;
    }
}

