/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.MdAdditionalPropertie;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public abstract class PersistableObject {
    public static final String COLNAME_OBJECTID = "ID";
    private static final String REMOVE_PROPERTIES_QUERY = "DELETE FROM MD_ADDITIONAL_PROPERTIES WHERE REF_ID_FK=?";
    private static final String RETRIEVE_ADDITIONAL_PROPERTIES_QUERY = "SELECT PROP_KEY, VALUE, PROPERTY_ORDER, CONNECTION_ID_FK FROM MD_ADDITIONAL_PROPERTIES WHERE REF_ID_FK=? ORDER BY PROPERTY_ORDER";
    private static final String REMOVE_OBJECT_QUERY = "DELETE FROM {0} WHERE ID = :1";
    private static final String COUNT_OBJECTS_QUERY = "SELECT COUNT (*) FROM {0}";
    private static final String RETRIEVE_OBJECT_QUERY = "SELECT * FROM {0} WHERE ID = :1";
    private DBObjectId m_key;
    private Hashtable<String, Field> m_fields;
    private boolean m_isPersisted;
    private boolean m_isChanged;
    private ArrayList<AdditionalProperty> m_additionalProperties;
    private DBObjectId m_additionalPropertyConnectionId;
    private String m_insertStatement = null;

    protected abstract String getStorageTableName();

    public PersistableObject() {
        this.m_fields = new Hashtable();
        this.m_additionalProperties = new ArrayList();
    }

    public PersistableObject(DBObjectId dBObjectId) {
        this.setKey(dBObjectId);
    }

    public String getContainerFieldName() {
        return null;
    }

    public DBObjectId getContainerId() {
        return null;
    }

    public String getObjectName() {
        return null;
    }

    public String getObjectNameFieldName() {
        return null;
    }

    public boolean isChanged() {
        if (this.m_isChanged) {
            return true;
        }
        for (Field field : this.m_fields.values()) {
            if (!field.isUpdated()) continue;
            this.m_isChanged = true;
            break;
        }
        return this.m_isChanged;
    }

    protected void setChanged(boolean bl) {
        this.m_isChanged = bl;
    }

    protected boolean isPersisted() {
        return this.m_isPersisted;
    }

    private void setPersisted(boolean bl) {
        this.m_isPersisted = bl;
    }

    public DBObjectId getKey() {
        return this.m_key;
    }

    protected void setKey(DBObjectId dBObjectId) {
        this.m_key = dBObjectId;
        this.m_isPersisted = true;
    }

    public void save(PersistenceManager persistenceManager) throws PersistenceException {
        if (!this.m_isPersisted) {
            this.doInsert(persistenceManager);
        } else if (this.m_isChanged) {
            this.doUpdate(persistenceManager);
        }
        try {
            persistenceManager.commit();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    protected String getInsertStatement() {
        if (this.m_insertStatement == null) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer.append("INSERT INTO ");
            stringBuffer2.append(") VALUES (");
            stringBuffer.append(this.getStorageTableName());
            stringBuffer.append("(");
            int n = 0;
            int n2 = 1;
            for (Field field : this.m_fields.values()) {
                stringBuffer.append("\"" + field.getColumnName() + "\"");
                stringBuffer2.append(":" + field.getColumnName());
                ++n2;
                if (++n < this.m_fields.size()) {
                    stringBuffer.append(", ");
                    stringBuffer2.append(", ");
                    continue;
                }
                stringBuffer2.append(")");
                stringBuffer.append(stringBuffer2);
            }
            this.m_insertStatement = stringBuffer.toString();
        }
        return this.m_insertStatement;
    }

    private void doInsert(PersistenceManager persistenceManager) throws PersistenceException {
        String[] stringArray = new String[]{COLNAME_OBJECTID};
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(this.getInsertStatement(), stringArray);
            int n = 1;
            for (Field field : this.m_fields.values()) {
                n = this.setFieldOnPreparedStatement(preparedStatement, n, field);
            }
            preparedStatement.executeUpdate();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            resultSet.next();
            this.setKey(new DBObjectId(resultSet.getLong(1)));
            this.saveAdditionalProperties(persistenceManager);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        this.setChanged(false);
        this.setPersisted(true);
    }

    private void saveAdditionalProperties(PersistenceManager persistenceManager) throws PersistenceException {
        this.removeExistingAdditionalProperties(persistenceManager);
        if (this.m_additionalProperties.size() == 0) {
            return;
        }
        int n = 0;
        for (AdditionalProperty additionalProperty : this.m_additionalProperties) {
            MdAdditionalPropertie mdAdditionalPropertie = new MdAdditionalPropertie(this.getAdditionalPropertyConnectionId(), this.getKey(), this.getStorageTableName(), additionalProperty.getKey());
            mdAdditionalPropertie.setPropertyOrder(n++);
            mdAdditionalPropertie.setValue(additionalProperty.getValue());
            mdAdditionalPropertie.save(persistenceManager);
        }
    }

    protected void retrieveAdditionalProperties(PersistenceManager persistenceManager) throws PersistenceException {
        if (!this.isPersisted()) {
            return;
        }
        if (this.getAdditionalProperties().length != 0) {
            return;
        }
        CloseableResultSet closeableResultSet = null;
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(RETRIEVE_ADDITIONAL_PROPERTIES_QUERY);
            preparedStatement.setLong(1, this.m_key.getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                AdditionalProperty additionalProperty = new AdditionalProperty(resultSet.getString(1), resultSet.getString(2));
                DBObjectId dBObjectId = new DBObjectId(resultSet.getLong(4));
                this.addProperty(additionalProperty, dBObjectId);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    private void removeExistingAdditionalProperties(PersistenceManager persistenceManager) throws PersistenceException {
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(REMOVE_PROPERTIES_QUERY);
            preparedStatement.setLong(1, this.m_key.getId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    private boolean fieldsUpdated() {
        for (Field field : this.m_fields.values()) {
            if (!field.isUpdated()) continue;
            return true;
        }
        return false;
    }

    protected void doUpdate(PersistenceManager persistenceManager) throws PersistenceException {
        if (this.fieldsUpdated()) {
            String string = this.generateUpdateStatement();
            try {
                PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string);
                int n = 1;
                for (Field field : this.m_fields.values()) {
                    if (!field.isUpdated()) continue;
                    n = this.setFieldOnPreparedStatement(preparedStatement, n, field);
                }
                preparedStatement.setLong(n, this.m_key.getId());
                int n2 = preparedStatement.executeUpdate();
                if (n2 != 1) {
                    throw new PersistenceException("Affected rows = " + n2 + ", expecting only 1");
                }
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(sQLException);
            }
        }
        this.saveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
        this.setChanged(false);
        this.setPersisted(true);
    }

    private String generateUpdateStatement() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ");
        stringBuffer.append(this.getStorageTableName());
        stringBuffer.append(" SET ");
        for (Field field : this.m_fields.values()) {
            if (!field.isUpdated()) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("\"" + field.getColumnName() + "\"");
            stringBuffer.append("= ?");
            bl = true;
        }
        stringBuffer.append(" WHERE ID = ?");
        return stringBuffer.toString();
    }

    protected void setField(Field field) {
        if (this.m_fields.contains(field.getColumnName())) {
            this.m_fields.remove(field.getColumnName());
        }
        this.m_fields.put(field.getColumnName(), field);
        this.m_isChanged = true;
    }

    private int setFieldOnPreparedStatement(PreparedStatement preparedStatement, int n, Field field) throws SQLException {
        if (field.getValue() == null) {
            preparedStatement.setNull(n++, field.getSQLType());
            return n;
        }
        if (field.getDatatype().equals("LONG")) {
            preparedStatement.setLong(n++, field.getLong());
        } else if (field.getDatatype().equals("STRING")) {
            preparedStatement.setString(n++, field.getString());
        } else if (field.getDatatype().equals("DBOBJECTID")) {
            preparedStatement.setLong(n++, field.getDBObjectId().getId());
        } else if (field.getDatatype().equals("INTEGER")) {
            preparedStatement.setInt(n++, field.getInteger());
        } else if (field.getDatatype().equals("DATE")) {
            preparedStatement.setDate(n++, field.getDate());
        } else if (field.getDatatype().equals("CLOBHELPER")) {
            ClobHelper clobHelper = field.getClobHelper();
            if (clobHelper.getLength() > Integer.MAX_VALUE) {
                throw new IllegalStateException("Clob value too long");
            }
            preparedStatement.setClob(n++, clobHelper.getReader(), (int)clobHelper.getLength());
        } else if (field.getDatatype().equals("TIMESTAMP")) {
            preparedStatement.setTimestamp(n++, field.getTimestamp());
        } else {
            throw new AssertionError((Object)("Unknown datatype " + field.getDatatype()));
        }
        return n;
    }

    protected void clearUpdatedFields() {
        for (Field field : this.m_fields.values()) {
            field.clearUpdated();
        }
    }

    protected Field getField(String string) {
        if (this.m_fields.containsKey(string)) {
            return this.m_fields.get(string);
        }
        return null;
    }

    public void addProperty(String string, String string2, DBObjectId dBObjectId) {
        AdditionalProperty additionalProperty = new AdditionalProperty(string, string2);
        this.addProperty(additionalProperty, dBObjectId);
    }

    public void addProperty(AdditionalProperty additionalProperty, DBObjectId dBObjectId) {
        this.m_additionalProperties.add(additionalProperty);
        this.setAdditionalPropertyConnectionId(dBObjectId);
        this.setChanged(true);
    }

    public AdditionalProperty[] getAdditionalProperties() {
        return this.m_additionalProperties.toArray(new AdditionalProperty[this.m_additionalProperties.size()]);
    }

    public String getProperty(String string) {
        for (AdditionalProperty additionalProperty : this.m_additionalProperties) {
            if (!additionalProperty.getKey().equalsIgnoreCase(string)) continue;
            return additionalProperty.getValue();
        }
        return null;
    }

    public void delete(PersistenceManager persistenceManager) throws PersistenceException {
        if (!this.isPersisted()) {
            return;
        }
        if (this.getKey() == null) {
            return;
        }
        String string = MessageFormat.format(REMOVE_OBJECT_QUERY, this.getStorageTableName());
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string);
            preparedStatement.setLong(1, this.getKey().getId());
            int n = preparedStatement.executeUpdate();
            persistenceManager.commit();
            if (n > 1) {
                throw new PersistenceException("Delete caused " + n + " to be deleted");
            }
            this.removeExistingAdditionalProperties(persistenceManager);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    public int countObjects(PersistenceManager persistenceManager) throws PersistenceException {
        String string = MessageFormat.format(COUNT_OBJECTS_QUERY, this.getStorageTableName());
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = resultSet.getInt(1);
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    protected CloseableResultSet issueRetrieveQuery(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        if (this.getKey() == null) {
            throw new PersistenceException("Cannot retrieve object if key is not set");
        }
        String string = MessageFormat.format(RETRIEVE_OBJECT_QUERY, this.getStorageTableName());
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string);
            preparedStatement.setLong(1, this.getKey().getId());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new NoSuchObjectException(this, this.getKey());
            }
            return new CloseableResultSet(null, resultSet);
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    protected DBObjectId getAdditionalPropertyConnectionId() {
        return this.m_additionalPropertyConnectionId;
    }

    protected void setAdditionalPropertyConnectionId(DBObjectId dBObjectId) {
        if (this.m_additionalPropertyConnectionId == null) {
            if (dBObjectId == null) {
                throw new IllegalArgumentException("Cannot set the additional property connection id to null");
            }
            this.m_additionalPropertyConnectionId = dBObjectId;
        } else if (!this.m_additionalPropertyConnectionId.equals(dBObjectId)) {
            throw new IllegalStateException("Attempt to change additional property connection id");
        }
    }

    public String getObjectType() {
        return this.getStorageTableName();
    }
}

