/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdMigrParameter
extends PersistableObject {
    public static final String TABLE_NAME = "MD_MIGR_PARAMETER";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_OBJECT_ID = "OBJECT_ID";
    public static final String COLNAME_OBJECT_TYPE = "OBJECT_TYPE";
    public static final String COLNAME_PARAM_EXISTING = "PARAM_EXISTING";
    public static final String COLNAME_PARAM_ORDER = "PARAM_ORDER";
    public static final String COLNAME_PARAM_NAME = "PARAM_NAME";
    public static final String COLNAME_PARAM_TYPE = "PARAM_TYPE";
    public static final String COLNAME_PARAM_DATA_TYPE = "PARAM_DATA_TYPE";
    public static final String COLNAME_PERCISION = "PERCISION";
    public static final String COLNAME_SCALE = "SCALE";
    public static final String COLNAME_NULLABLE = "NULLABLE";
    public static final String COLNAME_DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String DELETE_PARAMS = "DELETE FROM MD_MIGR_PARAMETER WHERE OBJECT_ID=?";

    public MdMigrParameter(DBObjectId dBObjectId, DBObjectId dBObjectId2, String string, Integer n, Integer n2, String string2, String string3, String string4, String string5) {
        this.setConnectionId(dBObjectId);
        this.setObjectId(dBObjectId2);
        this.setObjectType(string);
        this.setParamExisting(n);
        this.setParamOrder(n2);
        this.setParamName(string2);
        this.setParamType(string3);
        this.setParamDataType(string4);
        this.setNullable(string5);
    }

    public static MdMigrParameter getExistingInstance(DBObjectId dBObjectId) {
        MdMigrParameter mdMigrParameter = new MdMigrParameter();
        mdMigrParameter.setKey(dBObjectId);
        return mdMigrParameter;
    }

    private MdMigrParameter() {
    }

    public static MdMigrParameter retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdMigrParameter mdMigrParameter = MdMigrParameter.getExistingInstance(dBObjectId);
        mdMigrParameter.retrieve(persistenceManager);
        return mdMigrParameter;
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setObjectId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_OBJECT_ID, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setObjectType(String string) {
        Field field = new Field(COLNAME_OBJECT_TYPE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setParamExisting(Integer n) {
        Field field = new Field(COLNAME_PARAM_EXISTING, "INTEGER", false);
        field.setValue(n);
        this.setField(field);
    }

    protected void setParamOrder(Integer n) {
        Field field = new Field(COLNAME_PARAM_ORDER, "INTEGER", false);
        field.setValue(n);
        this.setField(field);
    }

    protected void setParamName(String string) {
        Field field = new Field(COLNAME_PARAM_NAME, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setParamType(String string) {
        Field field = new Field(COLNAME_PARAM_TYPE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setParamDataType(String string) {
        Field field = new Field(COLNAME_PARAM_DATA_TYPE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setPercision(Integer n) {
        Field field = new Field(COLNAME_PERCISION, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    public void setScale(Integer n) {
        Field field = new Field(COLNAME_SCALE, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    protected void setNullable(String string) {
        Field field = new Field(COLNAME_NULLABLE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setDefaultValue(String string) {
        Field field = new Field(COLNAME_DEFAULT_VALUE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getConnectionId() {
        Field field = this.getField(COLNAME_CONNECTION_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getObjectId() {
        Field field = this.getField(COLNAME_OBJECT_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    @Override
    public String getObjectType() {
        Field field = this.getField(COLNAME_OBJECT_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getParamExisting() {
        Field field = this.getField(COLNAME_PARAM_EXISTING);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getParamOrder() {
        Field field = this.getField(COLNAME_PARAM_ORDER);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getParamName() {
        Field field = this.getField(COLNAME_PARAM_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getParamType() {
        Field field = this.getField(COLNAME_PARAM_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getParamDataType() {
        Field field = this.getField(COLNAME_PARAM_DATA_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getPercision() {
        Field field = this.getField(COLNAME_PERCISION);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public Integer getScale() {
        Field field = this.getField(COLNAME_SCALE);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public String getNullable() {
        Field field = this.getField(COLNAME_NULLABLE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDefaultValue() {
        Field field = this.getField(COLNAME_DEFAULT_VALUE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setConnectionId(new DBObjectId(resultSet.getLong(COLNAME_CONNECTION_ID_FK)));
            this.setObjectId(new DBObjectId(resultSet.getLong(COLNAME_OBJECT_ID)));
            this.setObjectType(resultSet.getString(COLNAME_OBJECT_TYPE));
            this.setParamExisting(resultSet.getInt(COLNAME_PARAM_EXISTING));
            this.setParamOrder(resultSet.getInt(COLNAME_PARAM_ORDER));
            this.setParamName(resultSet.getString(COLNAME_PARAM_NAME));
            this.setParamType(resultSet.getString(COLNAME_PARAM_TYPE));
            this.setParamDataType(resultSet.getString(COLNAME_PARAM_DATA_TYPE));
            Object object = resultSet.getInt(COLNAME_PERCISION);
            if (resultSet.wasNull()) {
                this.setPercision(null);
            } else {
                this.setPercision((Integer)object);
            }
            object = resultSet.getInt(COLNAME_SCALE);
            if (resultSet.wasNull()) {
                this.setScale(null);
            } else {
                this.setScale((Integer)object);
            }
            this.setNullable(resultSet.getString(COLNAME_NULLABLE));
            object = resultSet.getString(COLNAME_DEFAULT_VALUE);
            if (resultSet.wasNull()) {
                this.setDefaultValue(null);
            } else {
                this.setDefaultValue((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_CONNECTION_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getConnectionId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteParamInfo(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = persistenceManager.getPreparedStatement(DELETE_PARAMS);
            preparedStatement.setLong(1, dBObjectId.getId());
            int n = preparedStatement.executeUpdate();
            System.out.println("rowsUpdated:" + n);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        finally {
            if (preparedStatement != null) {
                try {
                    persistenceManager.commit();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

