/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdDerivative
extends PersistableObject {
    public static final String TABLE_NAME = "MD_DERIVATIVES";
    public static final String COLNAME_SRC_ID = "SRC_ID";
    public static final String COLNAME_SRC_TYPE = "SRC_TYPE";
    public static final String COLNAME_DERIVED_ID = "DERIVED_ID";
    public static final String COLNAME_DERIVED_TYPE = "DERIVED_TYPE";
    public static final String COLNAME_DERIVED_CONNECTION_ID_FK = "DERIVED_CONNECTION_ID_FK";
    public static final String COLNAME_TRANSFORMED = "TRANSFORMED";
    public static final String COLNAME_ORIGINAL_IDENTIFIER = "ORIGINAL_IDENTIFIER";
    public static final String COLNAME_NEW_IDENTIFIER = "NEW_IDENTIFIER";
    public static final String COLNAME_DERIVED_OBJECT_NAMESPACE = "DERIVED_OBJECT_NAMESPACE";
    public static final String COLNAME_DERIVATIVE_REASON = "DERIVATIVE_REASON";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdDerivative(DBObjectId dBObjectId, DBObjectId dBObjectId2, DBObjectId dBObjectId3) {
        this.setSrcId(dBObjectId);
        this.setDerivedId(dBObjectId2);
        this.setDerivedConnectionId(dBObjectId3);
    }

    public static MdDerivative getExistingInstance(DBObjectId dBObjectId) {
        MdDerivative mdDerivative = new MdDerivative();
        mdDerivative.setKey(dBObjectId);
        return mdDerivative;
    }

    private MdDerivative() {
    }

    public static MdDerivative retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdDerivative mdDerivative = MdDerivative.getExistingInstance(dBObjectId);
        mdDerivative.retrieve(persistenceManager);
        return mdDerivative;
    }

    protected void setSrcId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SRC_ID, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setSrcType(String string) {
        Field field = new Field(COLNAME_SRC_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    protected void setDerivedId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_DERIVED_ID, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setDerivedType(String string) {
        Field field = new Field(COLNAME_DERIVED_TYPE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    protected void setDerivedConnectionId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_DERIVED_CONNECTION_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setTransformed(String string) {
        Field field = new Field(COLNAME_TRANSFORMED, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setOriginalIdentifier(String string) {
        Field field = new Field(COLNAME_ORIGINAL_IDENTIFIER, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setNewIdentifier(String string) {
        Field field = new Field(COLNAME_NEW_IDENTIFIER, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setDerivedObjectNamespace(String string) {
        Field field = new Field(COLNAME_DERIVED_OBJECT_NAMESPACE, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setDerivativeReason(String string) {
        Field field = new Field(COLNAME_DERIVATIVE_REASON, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getSrcId() {
        Field field = this.getField(COLNAME_SRC_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getSrcType() {
        Field field = this.getField(COLNAME_SRC_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getDerivedId() {
        Field field = this.getField(COLNAME_DERIVED_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getDerivedType() {
        Field field = this.getField(COLNAME_DERIVED_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getDerivedConnectionId() {
        Field field = this.getField(COLNAME_DERIVED_CONNECTION_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getTransformed() {
        Field field = this.getField(COLNAME_TRANSFORMED);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getOriginalIdentifier() {
        Field field = this.getField(COLNAME_ORIGINAL_IDENTIFIER);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getNewIdentifier() {
        Field field = this.getField(COLNAME_NEW_IDENTIFIER);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDerivedObjectNamespace() {
        Field field = this.getField(COLNAME_DERIVED_OBJECT_NAMESPACE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDerivativeReason() {
        Field field = this.getField(COLNAME_DERIVATIVE_REASON);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setSrcId(new DBObjectId(resultSet.getLong(COLNAME_SRC_ID)));
            Object object = resultSet.getString(COLNAME_SRC_TYPE);
            if (resultSet.wasNull()) {
                this.setSrcType(null);
            } else {
                this.setSrcType((String)object);
            }
            this.setDerivedId(new DBObjectId(resultSet.getLong(COLNAME_DERIVED_ID)));
            object = resultSet.getString(COLNAME_DERIVED_TYPE);
            if (resultSet.wasNull()) {
                this.setDerivedType(null);
            } else {
                this.setDerivedType((String)object);
            }
            this.setDerivedConnectionId(new DBObjectId(resultSet.getLong(COLNAME_DERIVED_CONNECTION_ID_FK)));
            object = resultSet.getString(COLNAME_TRANSFORMED);
            if (resultSet.wasNull()) {
                this.setTransformed(null);
            } else {
                this.setTransformed((String)object);
            }
            object = resultSet.getString(COLNAME_ORIGINAL_IDENTIFIER);
            if (resultSet.wasNull()) {
                this.setOriginalIdentifier(null);
            } else {
                this.setOriginalIdentifier((String)object);
            }
            object = resultSet.getString(COLNAME_NEW_IDENTIFIER);
            if (resultSet.wasNull()) {
                this.setNewIdentifier(null);
            } else {
                this.setNewIdentifier((String)object);
            }
            object = resultSet.getString(COLNAME_DERIVED_OBJECT_NAMESPACE);
            if (resultSet.wasNull()) {
                this.setDerivedObjectNamespace(null);
            } else {
                this.setDerivedObjectNamespace((String)object);
            }
            object = resultSet.getString(COLNAME_DERIVATIVE_REASON);
            if (resultSet.wasNull()) {
                this.setDerivativeReason(null);
            } else {
                this.setDerivativeReason((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

