/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.PersistableObjectIterator;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class ConstraintsIterator
extends PersistableObjectIterator {
    private static final String GET_CHECK_CONSTRAINTS_FOR_CONNECTIONID_QUERY = "SELECT ID FROM MD_CONSTRAINTS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?) AND CONSTRAINT_TYPE = ?";
    private static final String GET_ALL_CONSTAINTS_QUERY = "SELECT ID FROM MD_CONSTRAINTS WHERE TABLE_ID_FK IN (SELECT TABLE_ID FROM MGV_ALL_TABLES WHERE CONNECTION_ID = ?)";
    private PreparedStatement m_myStatement;

    public ConstraintsIterator(PersistenceManager persistenceManager, DBObjectId dBObjectId, String string, MigrationObjectFilterList migrationObjectFilterList) throws PersistenceException {
        super(MdConstraint.class, persistenceManager);
        String string2 = "";
        try {
            Object object;
            if (migrationObjectFilterList != null && (object = migrationObjectFilterList.getFilterForType(string)) != null) {
                string2 = ((MigrationObjectFilter)object).toWhereConditionForMigrationRepository();
                if (string2 == null) {
                    throw new IllegalStateException("Error creating where condition");
                }
                if (string2.length() > 0) {
                    string2 = string2 + " AND " + string2;
                }
            }
            if (string != null) {
                object = GET_CHECK_CONSTRAINTS_FOR_CONNECTIONID_QUERY + string2;
                this.m_myStatement = persistenceManager.getPreparedStatement((String)object);
                this.m_myStatement.setLong(1, dBObjectId.getId());
                this.m_myStatement.setString(2, string);
            } else {
                object = GET_ALL_CONSTAINTS_QUERY + string2;
                this.m_myStatement = persistenceManager.getPreparedStatement((String)object);
                this.m_myStatement.setLong(1, dBObjectId.getId());
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
    }

    @Override
    protected PreparedStatement getPreparedStatement() {
        return this.m_myStatement;
    }
}

