/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.jdeveloper.java.locator.PackageEntry;

class ModularizedPackageEntry
extends PackageEntry {
    ModularizedPackageEntry(String packageName, Collection<String> classNames, Collection<String> subPackageNames) {
        super(packageName, classNames, subPackageNames);
    }

    List<String> getTopLevelClassNamesAsList() {
        ArrayList<String> classNames = new ArrayList<String>();
        int idx = 0;
        int i = 0;
        while (i < this._classCnt) {
            byte dataByte;
            int start = idx;
            boolean found = true;
            while ((dataByte = this._data[idx]) != 0) {
                if (dataByte == 47) {
                    start = idx + 1;
                } else if (dataByte == 36) {
                    found = false;
                }
                ++idx;
            }
            if (found) {
                classNames.add(new String(this._data, start, idx - start));
            }
            ++i;
            ++idx;
        }
        return classNames;
    }

    List<String[]> getClassNamesAndModuleIndices() {
        ArrayList<String[]> classNames = new ArrayList<String[]>();
        int idx = 0;
        int i = 0;
        while (i < this._classCnt) {
            byte dataByte;
            int moduleIndexStart = idx;
            int moduleIndexEnd = 0;
            int nameStart = 0;
            while ((dataByte = this._data[idx]) != 0) {
                if (dataByte == 47) {
                    moduleIndexEnd = idx;
                    nameStart = idx + 1;
                }
                ++idx;
            }
            classNames.add(new String[]{new String(this._data, nameStart, idx - nameStart), new String(this._data, moduleIndexStart, moduleIndexEnd - moduleIndexStart)});
            ++i;
            ++idx;
        }
        return classNames;
    }

    String getModuleIndexForClass(String className) {
        byte[] nameBytes = className.getBytes();
        int nameLen = nameBytes.length;
        int idx = 0;
        for (int i = 0; i < this._classCnt; ++i) {
            byte dataByte;
            int nameCounter = 0;
            boolean found = true;
            int moduleStart = idx;
            int moduleEnd = -1;
            while ((dataByte = this._data[idx++]) != 0) {
                if (!found) continue;
                if (dataByte == 47) {
                    moduleEnd = idx - 1;
                    continue;
                }
                if (moduleEnd == -1) continue;
                if (nameCounter >= nameLen) {
                    found = false;
                    continue;
                }
                if (dataByte == nameBytes[nameCounter++]) continue;
                found = false;
            }
            if (!found || nameCounter != nameLen) continue;
            return moduleEnd != -1 ? new String(this._data, moduleStart, moduleEnd - moduleStart) : "0";
        }
        return null;
    }
}

