/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import oracle.ide.util.Assert;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public class DebugClassLocator
extends BaseClassLocator {
    private BaseClassLocator _locator;

    protected DebugClassLocator(BaseClassLocator locator) {
        this._locator = locator;
    }

    @Override
    public void buildIndex() {
        this._locator.buildIndex();
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        this._locator.buildIndexInterruptibly();
    }

    protected void dumpCollection(Collection collection) {
        for (Object object : collection) {
            Assert.println((String)object.toString());
        }
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        ArraySortedSet packageSet = new ArraySortedSet();
        this._locator.getPackages(packagePrefix, (Collection<String>)packageSet);
        out.addAll((Collection<String>)packageSet);
        Assert.println((String)"----- getPackages() -----");
        Assert.println((String)("prefix = " + packagePrefix));
        this.dumpCollection((Collection)packageSet);
    }

    @Override
    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        ArraySortedSet packageSet = new ArraySortedSet();
        this._locator.getPackagesInterruptibly(packagePrefix, (Collection<String>)packageSet);
        out.addAll((Collection<String>)packageSet);
        Assert.println((String)"----- getPackages() -----");
        Assert.println((String)("prefix = " + packagePrefix));
        this.dumpCollection((Collection)packageSet);
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        ArraySortedSet classSet = new ArraySortedSet();
        this._locator.getClassesInPackage(packagePrefix, (Collection<String>)classSet);
        out.addAll((Collection<String>)classSet);
        Assert.println((String)"----- getClassesInPackage() -----");
        Assert.println((String)("prefix = " + packagePrefix));
        this.dumpCollection((Collection)classSet);
    }

    @Override
    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        ArraySortedSet classSet = new ArraySortedSet();
        this._locator.getClassesInPackageInterruptibly(packagePrefix, (Collection<String>)classSet);
        out.addAll((Collection<String>)classSet);
        Assert.println((String)"----- getClassesInPackage() -----");
        Assert.println((String)("prefix = " + packagePrefix));
        this.dumpCollection((Collection)classSet);
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        ArraySortedSet classSet = new ArraySortedSet();
        this._locator.getAllClasses((Collection<String>)classSet, filter);
        out.addAll((Collection<String>)classSet);
        Assert.println((String)"----- getAllClasses() -----");
        this.dumpCollection((Collection)classSet);
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        ArraySortedSet classSet = new ArraySortedSet();
        this._locator.getAllClassesInterruptibly((Collection<String>)classSet, filter);
        out.addAll((Collection<String>)classSet);
        Assert.println((String)"----- getAllClasses() -----");
        this.dumpCollection((Collection)classSet);
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        ArraySortedSet packageSet = new ArraySortedSet();
        this._locator.getAllPackages((Collection<String>)packageSet, filter);
        out.addAll((Collection<String>)packageSet);
        Assert.println((String)"----- getAllPackages() -----");
        this.dumpCollection((Collection)packageSet);
    }

    @Override
    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        ArraySortedSet packageSet = new ArraySortedSet();
        this._locator.getAllPackagesInterruptibly((Collection<String>)packageSet, filter);
        out.addAll((Collection<String>)packageSet);
        Assert.println((String)"----- getAllPackages() -----");
        this.dumpCollection((Collection)packageSet);
    }

    @Override
    public URL getURL(String fqClassName) {
        URL url = this._locator.getURL(fqClassName);
        Assert.println((String)"----- getURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("url = " + url));
        return url;
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        URL url = this._locator.getURLInterruptibly(fqClassName);
        Assert.println((String)"----- getURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("url = " + url));
        return url;
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        URL url = this._locator.getSourceURL(fqClassName);
        Assert.println((String)"----- getSourceURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("source url = " + url));
        return url;
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        URL url = this._locator.getSourceURLInterruptibly(fqClassName);
        Assert.println((String)"----- getSourceURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("source url = " + url));
        return url;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        URL url = this._locator.getClassURL(fqClassName);
        Assert.println((String)"----- getClassesURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("class url = " + url));
        return url;
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        URL url = this._locator.getClassURLInterruptibly(fqClassName);
        Assert.println((String)"----- getClassesURL() -----");
        Assert.println((String)("fqClassName = " + fqClassName));
        Assert.println((String)("class url = " + url));
        return url;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        URL url = this._locator.getResourceURL(resourceName);
        Assert.println((String)"----- getResourceURL() -----");
        Assert.println((String)("resourceName = " + resourceName));
        Assert.println((String)("resource url = " + url));
        return url;
    }
}

