/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class CachedDirURLClassLocator
extends URLClassLocator {
    private Map _packageMap = new HashMap(512);
    private boolean _built = false;
    private static final boolean VERBOSE_CACHE = Boolean.getBoolean("VFS.VERBOSE_CACHE");

    protected CachedDirURLClassLocator(URL dirURL, int classType) {
        super(dirURL, classType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndex() {
        if (!this._built) {
            CachedDirURLClassLocator cachedDirURLClassLocator = this;
            synchronized (cachedDirURLClassLocator) {
                if (!this._built) {
                    try {
                        this.buildIndexImpl(false);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this._built = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        if (!this._built) {
            CachedDirURLClassLocator cachedDirURLClassLocator = this;
            synchronized (cachedDirURLClassLocator) {
                if (!this._built) {
                    this.buildIndexImpl(true);
                    this._built = true;
                }
            }
        }
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(Arrays.asList(entry._subPackageNames));
        }
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            if (this.isSourceTypeLocator()) {
                out.addAll(Arrays.asList(entry._classNames));
            } else {
                for (String className : entry._classNames) {
                    if (className.indexOf(36) != -1) continue;
                    out.add(className);
                }
            }
        }
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        try {
            this.getClassesRecursively("", out, filter, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.getClassesRecursively("", out, filter, true);
    }

    @Override
    protected Collection<String> getClassesDirectly() {
        return this.getAllClasses();
    }

    @Override
    protected Collection<URL> getResourcesDirectly(String name) {
        return this.getResourceURLs(name);
    }

    private void getClassesRecursively(String packagePrefix, Collection<String> out, ClassNameFilter filter, boolean checkInterrupt) throws InterruptedException {
        PackageEntry entry;
        if (checkInterrupt) {
            CachedDirURLClassLocator.checkInterrupt();
        }
        if ((entry = this.findExactPackage(packagePrefix)) != null) {
            String[] classList = entry._classNames;
            int classCount = classList.length;
            for (int i = 0; i < classCount; ++i) {
                String className;
                if (checkInterrupt) {
                    CachedDirURLClassLocator.checkInterrupt();
                }
                if ((className = classList[i]).indexOf(36) != -1) continue;
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptClassName(className, packagePrefix);
                }
                if (!acceptName) continue;
                String fqName = CachedDirURLClassLocator.buildFQName(packagePrefix, className);
                out.add(fqName);
            }
            if (checkInterrupt) {
                CachedDirURLClassLocator.checkInterrupt();
            }
            for (String subName : entry._subPackageNames) {
                String fullSubName = CachedDirURLClassLocator.buildFQName(packagePrefix, subName);
                this.getClassesRecursively(fullSubName, out, filter, checkInterrupt);
            }
        }
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        LinkedList<String> queue = new LinkedList<String>();
        queue.add("");
        while (!queue.isEmpty()) {
            PackageEntry entry;
            String current = (String)queue.removeFirst();
            if (!current.isEmpty() && (filter == null || filter.acceptPackageName(current))) {
                out.add(current);
            }
            if ((entry = this.findPackage(current)) == null) continue;
            for (String subpackage : entry._subPackageNames) {
                queue.add(CachedDirURLClassLocator.buildFQName(current, subpackage));
            }
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        String[] nameCascades = CachedDirURLClassLocator.getNameCascades(fqClassName);
        String[] nameParts = CachedDirURLClassLocator.getNameParts(fqClassName);
        if (nameParts.length == 0) {
            return null;
        }
        int countCascades = nameCascades.length;
        String packagePrefix = countCascades > 1 ? nameCascades[countCascades - 2] : "";
        PackageEntry foundEntry = this.findPackage(packagePrefix);
        if (foundEntry == null) {
            return null;
        }
        String className = nameParts[nameParts.length - 1];
        if (!Arrays.asList(foundEntry._classNames).contains(className)) {
            return null;
        }
        for (String suffix : this.isSourceTypeLocator() ? SOURCE_SUFFIXES : CLASS_SUFFIXES) {
            String entryPath = fqClassName.replace('.', '/') + suffix;
            URL rootURL = this.getRootURL();
            URL fileURL = URLFactory.newURL((URL)rootURL, (String)entryPath);
            if (!URLFileSystem.exists((URL)fileURL)) continue;
            return fileURL;
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        URL rootURL;
        URL fileURL;
        if (this.isClassTypeLocator() && URLFileSystem.exists((URL)(fileURL = URLFactory.newURL((URL)(rootURL = this.getRootURL()), (String)resourceName)))) {
            return fileURL;
        }
        return null;
    }

    private void buildIndexImpl(boolean checkInterrupt) throws InterruptedException {
        this.buildPackage("", checkInterrupt);
    }

    private void buildPackage(String packagePrefix, boolean checkInterrupt) throws InterruptedException {
        if (checkInterrupt) {
            CachedDirURLClassLocator.checkInterrupt();
        }
        Thread.yield();
        PackageEntry entry = this.findExactPackage(packagePrefix);
        if (entry != null) {
            String[] subs = entry._subPackageNames;
            int numSubs = subs.length;
            for (int i = 0; i < numSubs; ++i) {
                String subName = packagePrefix.length() > 0 ? packagePrefix + "." + subs[i] : subs[i];
                this.buildPackage(subName, checkInterrupt);
            }
        }
    }

    private boolean containsSubPackage(PackageEntry packageEntry, String subName) {
        if (packageEntry == null) {
            return false;
        }
        if (packageEntry._subPackageNames.length == 0) {
            return false;
        }
        List<String> subList = Arrays.asList(packageEntry._subPackageNames);
        return subList.contains(subName);
    }

    private PackageEntry findPackage(String packageName) {
        PackageEntry rootEntry = this.findExactPackage("");
        if (packageName.length() == 0) {
            return rootEntry;
        }
        String[] nameCascades = CachedDirURLClassLocator.getNameCascades(packageName);
        String[] nameParts = CachedDirURLClassLocator.getNameParts(packageName);
        PackageEntry parentEntry = rootEntry;
        int countCascades = nameCascades.length;
        PackageEntry foundEntry = null;
        for (int i = 0; i < countCascades; ++i) {
            String checkPackage = nameParts[i];
            if (!this.containsSubPackage(parentEntry, checkPackage)) {
                return null;
            }
            parentEntry = foundEntry = this.findExactPackage(nameCascades[i]);
        }
        return foundEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageEntry findExactPackage(String packageName) {
        int numInfos;
        URL dirURL;
        PackageEntry foundEntry;
        Map map = this._packageMap;
        synchronized (map) {
            foundEntry = (PackageEntry)this._packageMap.get(packageName);
        }
        URL rootURL = this.getRootURL();
        if (foundEntry != null) {
            dirURL = foundEntry._packageURL;
        } else if (packageName.length() == 0) {
            dirURL = rootURL;
        } else {
            String dirName = packageName.replace('.', '/');
            dirURL = URLFactory.newDirURL((URL)rootURL, (String)dirName);
        }
        URLFileSystem.FileInfo[] infos = URLFileSystem.ls((URL)dirURL);
        int n = numInfos = infos == null ? 0 : infos.length;
        if (foundEntry != null && CachedDirURLClassLocator.equals(foundEntry._fileInfos, infos)) {
            return foundEntry;
        }
        ArrayList<String> classList = new ArrayList<String>(numInfos);
        ArrayList<String> subList = new ArrayList<String>(numInfos);
        for (int i = 0; i < numInfos; ++i) {
            URLFileSystem.FileInfo info = infos[i];
            URL childURL = info.getURL();
            boolean isDirectory = info.isDirectory();
            String filename = URLFileSystem.getFileName((URL)childURL);
            if (isDirectory) {
                if (filename.indexOf(46) != -1 || filename.indexOf(45) != -1 || filename.equals("CVS")) continue;
                subList.add(new String(filename));
                continue;
            }
            if (!this.isMatchingFileType(filename)) continue;
            int lastDot = filename.lastIndexOf(46);
            classList.add(new String(filename.substring(0, lastDot)));
        }
        String[] classes = CachedDirURLClassLocator.getStringArray(classList);
        String[] subs = CachedDirURLClassLocator.getStringArray(subList);
        foundEntry = new PackageEntry(dirURL, infos, classes, subs);
        Map map2 = this._packageMap;
        synchronized (map2) {
            this._packageMap.put(packageName, foundEntry);
        }
        return foundEntry;
    }

    protected static boolean supportsCache(URL rootURL) {
        URLFileSystem.FileInfo[] info1 = URLFileSystem.ls((URL)rootURL);
        URLFileSystem.FileInfo[] info2 = URLFileSystem.ls((URL)rootURL);
        boolean supported = CachedDirURLClassLocator.equals(info1, info2);
        if (VERBOSE_CACHE) {
            Assert.println((String)("Class database VFS caching " + (supported ? "supported" : "not supported") + " for: " + rootURL.toString()));
        }
        return supported;
    }

    private static boolean equals(URLFileSystem.FileInfo[] infos1, URLFileSystem.FileInfo[] infos2) {
        int count2;
        int count1 = infos1 == null ? 0 : infos1.length;
        int n = count2 = infos2 == null ? 0 : infos2.length;
        if (count1 != count2) {
            return false;
        }
        for (int i = 0; i < count1; ++i) {
            if (infos1[i] == infos2[i]) continue;
            return false;
        }
        return true;
    }

    private static final class PackageEntry {
        private URL _packageURL;
        private URLFileSystem.FileInfo[] _fileInfos;
        private String[] _classNames;
        private String[] _subPackageNames;

        private PackageEntry(URL packageURL, URLFileSystem.FileInfo[] fileInfos, String[] classNames, String[] subPackageNames) {
            this._packageURL = packageURL;
            this._fileInfos = fileInfos;
            this._classNames = classNames;
            this._subPackageNames = subPackageNames;
        }
    }
}

