/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class Streams {
    public static void copy(InputStream is, OutputStream os) throws IOException {
        Streams.copy(is, os, new byte[4096]);
    }

    public static void copy(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int size;
        while ((size = is.read(buffer)) >= 0) {
            os.write(buffer, 0, size);
        }
    }

    public static void copy(InputStream is, OutputStream os, long size, byte[] buffer) throws IOException {
        int actualSize;
        int requestedSize = buffer.length;
        for (long remainder = size; remainder > 0L; remainder -= (long)actualSize) {
            if ((long)requestedSize > remainder) {
                requestedSize = (int)remainder;
            }
            if ((actualSize = is.read(buffer, 0, requestedSize)) < 0) {
                throw new IOException("actual size short " + remainder + " of " + size + " expected");
            }
            os.write(buffer, 0, actualSize);
        }
    }

    public static void copy(InputStream is, byte[] buffer) throws IOException {
        Streams.copy(is, buffer, 0, buffer.length);
    }

    private static void copy(InputStream is, byte[] buffer, int offset, int size) throws IOException {
        int actualSize;
        int count = offset;
        for (int remainder = size; remainder > 0; remainder -= actualSize) {
            actualSize = is.read(buffer, count, remainder);
            if (actualSize < 0) {
                throw new IOException("actual size short " + remainder + " of " + size + " expected");
            }
            count += actualSize;
        }
    }

    public static void copy(Reader is, Writer os) throws IOException {
        Streams.copy(is, os, new char[4096]);
    }

    public static void copy(Reader is, Writer os, char[] buffer) throws IOException {
        int size;
        while ((size = is.read(buffer)) >= 0) {
            os.write(buffer, 0, size);
        }
    }

    public static void copy(Reader is, char[] buffer) throws IOException {
        Streams.copy(is, buffer, 0, buffer.length);
    }

    private static void copy(Reader is, char[] buffer, int offset, int size) throws IOException {
        int actualSize;
        int count = offset;
        for (int remainder = size; remainder > 0; remainder -= actualSize) {
            actualSize = is.read(buffer, count, remainder);
            if (actualSize < 0) {
                throw new IOException("actual size short " + remainder + " of " + size + " expected");
            }
            count += actualSize;
        }
    }
}

