/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class WhitespaceDecoratorIcon
implements Icon {
    private Icon icon;
    private int x;
    private int y;
    private int width;
    private int height;

    public WhitespaceDecoratorIcon(Icon icon, int width, int height) {
        this.icon = icon;
        this.x = (width - this.getIconWidth()) / 2;
        this.y = (height - this.getIconHeight()) / 2;
        this.width = width;
        this.height = height;
    }

    public WhitespaceDecoratorIcon(Icon icon, int top, int left, int bottom, int right) {
        this.icon = icon;
        this.x = left;
        this.y = top;
        this.width = left + icon.getIconWidth() + right;
        this.height = top + icon.getIconHeight() + bottom;
    }

    public WhitespaceDecoratorIcon(Icon icon, Insets insets) {
        this(icon, insets.top, insets.left, insets.bottom, insets.right);
    }

    public void setIcon(Icon icon, int width, int height) {
        this.icon = icon;
        this.x = (width - this.getIconWidth()) / 2;
        this.y = (height - this.getIconHeight()) / 2;
        this.width = width;
        this.height = height;
    }

    public void setIcon(Icon icon, int top, int left, int bottom, int right) {
        this.icon = icon;
        this.x = left;
        this.y = top;
        this.width = left + icon.getIconWidth() + right;
        this.height = top + icon.getIconHeight() + bottom;
    }

    public void setIcon(Icon icon, Insets insets) {
        this.setIcon(icon, insets.top, insets.left, insets.bottom, insets.right);
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.translate(this.x, this.y);
        this.icon.paintIcon(c, g, x, y);
        g.translate(-this.x, -this.y);
    }
}

