/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import oracle.jdevimpl.audit.swing.TableTransferable;

public class TableTransferHandler
extends TransferHandler {
    @Override
    protected Transferable createTransferable(JComponent component) {
        if (component instanceof JTable) {
            int[] columns;
            int[] rows;
            JTable table = (JTable)component;
            if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                return null;
            }
            if (!table.getRowSelectionAllowed()) {
                rows = new int[table.getRowCount()];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = i;
                }
            } else {
                rows = table.getSelectedRows();
            }
            if (rows == null || rows.length == 0) {
                return null;
            }
            if (!table.getColumnSelectionAllowed()) {
                columns = new int[table.getColumnCount()];
                for (int i = 0; i < columns.length; ++i) {
                    columns[i] = i;
                }
            } else {
                columns = table.getSelectedColumns();
            }
            if (columns == null || columns.length == 0) {
                return null;
            }
            int[] modelColumns = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                modelColumns[i] = table.convertColumnIndexToModel(columns[i]);
            }
            StringBuilder plainBuffer = new StringBuilder();
            StringBuilder htmlBuffer = new StringBuilder();
            htmlBuffer.append("<html>\n<body>\n<table>\n");
            for (int row : rows) {
                htmlBuffer.append("<tr>\n");
                for (int i = 0; i < columns.length; ++i) {
                    Object value = this.getValue(table, row, columns[i], modelColumns[i]);
                    String text = value != null ? value.toString() : "";
                    plainBuffer.append(text).append("\t");
                    htmlBuffer.append("  <td>").append(text).append("</td>\n");
                }
                plainBuffer.deleteCharAt(plainBuffer.length() - 1).append("\n");
                htmlBuffer.append("</tr>\n");
            }
            plainBuffer.deleteCharAt(plainBuffer.length() - 1);
            htmlBuffer.append("</table>\n</body>\n</html>");
            return new TableTransferable(plainBuffer.toString(), htmlBuffer.toString());
        }
        return null;
    }

    protected Object getValue(JTable table, int row, int column, int modelColumn) {
        return table.getValueAt(row, column);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

