/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.log;

import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.treetable.AbstractTreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModel;
import oracle.javatools.ui.treetable.TreeTableModelAdapter;
import oracle.javatools.util.ArraySortedSet;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.analyzer.Metric;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.AuditModel;
import oracle.jdeveloper.audit.service.AuditModelListener;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.DefaultAuditModel;
import oracle.jdevimpl.audit.log.AuditTreeTable;

public class AuditTreeTableModel
extends AbstractTreeTableModel
implements AuditModelListener {
    private static final Log LOG = new Log("treetablemodel");
    private static final Log EVENT_LOG = new Log(new String[]{"treetablemodel", "treetablemodel-event"});
    private AuditModel model;
    private TreeTableModelAdapter tableModel;
    private AuditTreeTable table;
    private JTree tree;
    private int restructureCount = 0;
    private TreeState restructureState;
    private List<Object> expansionState;
    private List<Object> selectionState;
    private Object leadSelectionState;
    private final String EOL = System.getProperty("line.separator");

    public AuditTreeTableModel(AuditModel model) {
        super(null);
        assert (model != null);
        this.setModel(model);
    }

    public void setTableModel(TreeTableModelAdapter model) {
        LOG.trace("**** setting table model");
        this.tableModel = model;
    }

    public void setComponents(AuditTreeTable table, JTree tree) {
        LOG.trace("**** setting components");
        this.table = table;
        this.tree = tree;
    }

    public void setModel(AuditModel model) {
        if (model == this.model) {
            return;
        }
        this.model = model;
        LOG.trace("**** setting components");
        this.root = model.getRoot();
        this.fireTreeStructureChanged(this, null);
        model.addAuditModelListener(this);
    }

    public AuditModel getModel() {
        return this.model;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer, "", this.getRoot());
        return buffer.toString();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : this.model.getColumn(column).getType();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public String getColumnName(int column) {
        return column == 0 ? "construct" : this.model.getColumn(column).id();
    }

    public Object getValueAt(Object node, int column) {
        return column == 0 ? node : this.model.getValue(node, column);
    }

    public Object getChild(Object parent, int index) {
        List<?> children = this.model.getVisibleChildren(parent);
        if (index < children.size()) {
            return children.get(index);
        }
        if (this.model instanceof DefaultAuditModel) {
            return ((DefaultAuditModel)this.model).createDummyRow(this.model, parent);
        }
        return this.model.getRoot();
    }

    public boolean isLeaf(Object parent) {
        return this.model.isLeaf(parent);
    }

    public int getChildCount(Object parent) {
        return this.model.getVisibleChildren(parent).size();
    }

    @Override
    public void auditStarted(AuditModel model, List<Metric> columns, List<Location> locations, Object root, Class type) {
        this.setRoot(root);
    }

    @Override
    public void auditStopped(AuditModel model, boolean cancelled) {
    }

    @Override
    public void rowsInserted(AuditModel model, List<?> rows, Object parent, int index) {
    }

    @Override
    public void rowsRemoved(AuditModel model, List<?> rows, Object parent, int index) {
    }

    @Override
    public void rowsShown(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
        EVENT_LOG.trace("handling rows shown in {0} at {1}: {2}", visibleParent, (Object)visibleIndex, rows);
        Object[] path = this.getPath(visibleParent);
        int[] shownIndexes = new int[rows.size()];
        for (int i = 0; i < shownIndexes.length; ++i) {
            shownIndexes[i] = visibleIndex + i;
        }
        this.fireTreeNodesInserted(this, path, shownIndexes, rows.toArray());
    }

    @Override
    public void rowsHidden(AuditModel model, List<?> rows, Object visibleParent, int visibleIndex) {
        EVENT_LOG.trace("handling rows hidden in {0} at {1}: {2}", visibleParent, (Object)visibleIndex, rows);
        Object[] path = this.getPath(visibleParent);
        TreePath parentPath = new TreePath(path);
        if (this.restructureState != null && this.restructureState.visible != null && this.restructureState.map.get(parentPath) == Boolean.TRUE) {
            this.restructureState.visible.addAll(rows);
        }
        int[] hiddenIndexes = new int[rows.size()];
        for (int i = 0; i < hiddenIndexes.length; ++i) {
            hiddenIndexes[i] = visibleIndex + i;
        }
        this.fireTreeNodesRemoved(this, path, hiddenIndexes, rows.toArray());
    }

    @Override
    public void rowsRestructureBegin(AuditModel model, Object parent, Object visibleParent) {
        if (this.restructureCount++ == 0) {
            this.restructureState = this.saveState(new TreePath(this.getPath(visibleParent)), false);
        }
    }

    @Override
    public void rowsRestructureEnd(AuditModel model, Object parent, Object visibleParent) {
        if (--this.restructureCount == 0) {
            this.restoreState(this.restructureState);
        }
    }

    @Override
    public void countChanged(AuditModel model, Object row, AuditModel.Count count, int oldValue, int newValue) {
    }

    @Override
    public void valueChanged(AuditModel model, Object row, int column, Object oldValue, Object newValue) {
        EVENT_LOG.trace("handling column {0} of {1} changed to {2}", column, row, newValue);
        if (!model.isVisible(row)) {
            return;
        }
        if (column != 0) {
            int rowIndex = this.tree.getRowForPath(new TreePath(this.getPath(row)));
            EVENT_LOG.trace("handling changed {2} at row {0}, column {1}", rowIndex, column, row);
            this.tableModel.fireTableCellUpdated(rowIndex, column);
        } else if (model.getRoot() != row) {
            Object parent = model.getVisibleParent(row);
            this.fireTreeNodesChanged(this, this.getPath(parent), new int[]{model.getVisibleIndexOf(row)}, new Object[]{row});
        } else {
            this.fireTreeNodesChanged(this, new Object[]{row}, null, null);
        }
        EVENT_LOG.trace("completed handling changed {1} at column {0}", column, row);
    }

    @Override
    public void modelResorted(AuditModel model) {
        TreePath rootPath = new TreePath(this.root);
        this.restructureState = this.saveState(rootPath, true);
        this.fireTreeStructureChanged(this, rootPath);
        this.restoreState(this.restructureState);
    }

    @Override
    public void appliedTransformsChanged(AuditModel model, Object row, List<Transform> appliedTransforms) {
        EVENT_LOG.trace("handling transformd changed at row {0}: {1}", row, appliedTransforms);
        if (model.getRoot() != row) {
            Object parent = model.getVisibleParent(row);
            this.fireTreeNodesChanged(this, this.getPath(parent), new int[]{model.getVisibleIndexOf(row)}, new Object[]{row});
        } else {
            this.fireTreeNodesChanged(this, new Object[]{row}, null, null);
        }
    }

    private Object[] getPath(Object row) {
        return this.getPath(row, 0);
    }

    private Object[] getParentPath(Object row) {
        Object parent = this.model.getVisibleParent(row);
        if (parent == null) {
            return null;
        }
        return this.getPath(parent, 0);
    }

    private Object[] getPath(Object row, int count) {
        Object parent = this.model.getVisibleParent(row);
        Object[] path = parent == null ? new Object[count] : this.getPath(parent, ++count);
        path[path.length - count] = row;
        return path;
    }

    private void setRoot(Object newRoot) {
        Object oldRoot = this.root;
        if (oldRoot == newRoot) {
            return;
        }
        EVENT_LOG.trace("changing root from {0} to {1}", oldRoot, newRoot);
        this.root = newRoot;
        if (newRoot == null) {
            this.fireTreeStructureChanged(this, null);
        } else {
            this.fireTreeStructureChanged(this, new Object[]{newRoot}, null, null);
        }
    }

    protected void fireTreeStructureChanged(Object source, TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    private TreeState saveState(TreePath rootPath, boolean resort) {
        if (!this.tree.isExpanded(rootPath)) {
            return null;
        }
        TreeState state = new TreeState();
        state.rootPath = rootPath;
        if (!resort) {
            state.visible = new ArrayList();
        }
        try {
            Field field = JTree.class.getDeclaredField("expandedState");
            field.setAccessible(true);
            state.map = (Map)field.get(this.tree);
            this.accumulateRows(rootPath, state.map, state.expanded, state.visible, state.selected);
        }
        catch (NoSuchFieldException e) {
            Log.error((String)"unexpected exception accessing tree state: {0}", (Object)e);
        }
        catch (IllegalAccessException e) {
            Log.error((String)"unexpected exception accessing tree state: {0}", (Object)e);
        }
        TreePath leadPath = this.tree.getLeadSelectionPath();
        if (leadPath != null) {
            state.selectionLead = leadPath.getLastPathComponent();
        }
        return state;
    }

    private void accumulateRows(TreePath parentPath, Map<TreePath, Boolean> state, List<Object> expanded, List<Object> visible, List<Object> selected) {
        for (Object child : this.model.getChildren(parentPath.getLastPathComponent())) {
            TreePath childPath = parentPath.pathByAddingChild(child);
            if (this.tree.isPathSelected(childPath)) {
                selected.add(child);
            }
            if (Boolean.TRUE == state.get(childPath)) {
                expanded.add(child);
                this.accumulateRows(childPath, state, expanded, visible, selected);
                continue;
            }
            if (visible == null) continue;
            visible.add(child);
        }
    }

    private void restoreState(TreeState state) {
        int i;
        TreePath rowPath;
        if (state == null) {
            return;
        }
        this.tree.expandPath(state.rootPath);
        Object root = state.rootPath.getLastPathComponent();
        ArrayList stack = new ArrayList();
        block0: for (Object row : state.expanded) {
            while (!this.model.isVisible(row)) {
                if ((row = this.model.getParent(row)) != root) continue;
                continue block0;
            }
            stack.clear();
            stack.add(row);
            row = this.model.getParent(row);
            while (row != root) {
                if (this.model.isVisible(row)) {
                    stack.add(row);
                }
                row = this.model.getParent(row);
            }
            rowPath = state.rootPath;
            i = stack.size();
            while (i-- > 0) {
                rowPath = rowPath.pathByAddingChild(stack.get(i));
                this.tree.expandPath(rowPath);
            }
        }
        if (state.visible != null) {
            block4: for (Object row : state.visible) {
                while ((row = this.model.getParent(row)) != root) {
                    if (!this.model.isVisible(row)) continue;
                    stack.clear();
                    stack.add(row);
                    row = this.model.getParent(row);
                    while (row != null && row != root) {
                        if (this.model.isVisible(row)) {
                            stack.add(row);
                        }
                        row = this.model.getParent(row);
                    }
                    rowPath = state.rootPath;
                    i = stack.size();
                    while (i-- > 0) {
                        rowPath = rowPath.pathByAddingChild(stack.get(i));
                        this.tree.expandPath(rowPath);
                    }
                    continue block4;
                }
            }
        }
        TreePath leadPath = null;
        ArrayList<TreePath> paths = new ArrayList<TreePath>(state.selected.size());
        for (Object row : state.selected) {
            if (!this.model.isVisible(row)) continue;
            boolean isLead = row == state.selectionLead;
            stack.clear();
            stack.add(row);
            row = this.model.getParent(row);
            while (row != root) {
                if (this.model.isVisible(row)) {
                    stack.add(row);
                }
                row = this.model.getParent(row);
            }
            TreePath path = state.rootPath;
            int i2 = stack.size();
            while (i2-- > 0) {
                path = path.pathByAddingChild(stack.get(i2));
            }
            paths.add(path);
            if (!isLead) continue;
            leadPath = path;
        }
        this.tree.addSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        if (leadPath != null) {
            this.tree.setLeadSelectionPath(leadPath);
        }
    }

    public void saveState(boolean expansion) {
        if (this.tree == null) {
            return;
        }
        if (expansion) {
            int count = this.tree.getRowCount();
            this.expansionState = new ArrayList<Object>(count);
            this.selectionState = new ArrayList<Object>();
            for (int i = 0; i < count; ++i) {
                Object object = this.tree.getPathForRow(i).getLastPathComponent();
                this.expansionState.add(object);
                if (!this.tree.isRowSelected(i)) continue;
                this.selectionState.add(object);
            }
        } else {
            this.expansionState = null;
            this.selectionState = null;
            TreePath[] paths = this.tree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            this.selectionState = new ArrayList<Object>(paths.length);
            for (int i = 0; i < paths.length; ++i) {
                this.selectionState.add(paths[i].getLastPathComponent());
            }
            this.leadSelectionState = this.tree.getLeadSelectionPath().getLastPathComponent();
        }
    }

    public void restoreState() {
        ArraySortedSet paths;
        EVENT_LOG.trace("restoring state");
        if (this.tree == null) {
            return;
        }
        if (this.expansionState != null) {
            paths = new ArraySortedSet((Comparator)new PathComparator(this.model.getChildComparator()));
            for (int i = 0; i < this.expansionState.size(); ++i) {
                Object child = this.expansionState.get(i);
                Object[] parentPath = this.getParentPath(child);
                if (parentPath == null) continue;
                paths.add(parentPath);
            }
            this.expansionState = null;
            Iterator i = paths.iterator();
            while (i.hasNext()) {
                this.tree.expandPath(new TreePath((Object[])i.next()));
            }
            EVENT_LOG.trace("expanded paths {0}", paths.size());
        }
        if (this.selectionState != null) {
            paths = new ArrayList();
            TreePath lead = null;
            for (int i = 0; i < this.selectionState.size(); ++i) {
                Object[] path;
                Object child = this.selectionState.get(i);
                Object[] objectArray = path = this.model.isVisible(child) ? this.getPath(child) : this.getParentPath(child);
                if (path == null) continue;
                TreePath treePath = new TreePath(path);
                paths.add(treePath);
                if (child != this.leadSelectionState) continue;
                lead = treePath;
            }
            this.selectionState = null;
            this.leadSelectionState = null;
            TreePath leadPath = lead;
            EVENT_LOG.trace("selected paths {0}", (Object)paths);
            SwingUtilities.invokeLater(new Runnable((List)paths, leadPath){
                final /* synthetic */ List val$paths;
                final /* synthetic */ TreePath val$leadPath;
                {
                    this.val$paths = list;
                    this.val$leadPath = treePath;
                }

                @Override
                public void run() {
                    AuditTreeTableModel.this.tree.setSelectionPaths(this.val$paths.toArray(new TreePath[this.val$paths.size()]));
                    if (this.val$leadPath != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Rectangle bounds = AuditTreeTableModel.this.tree.getPathBounds(val$leadPath);
                                if (bounds != null) {
                                    AuditTreeTableModel.this.table.scrollRectToVisible(bounds);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private void append(StringBuffer buffer, String indent, Object parent) {
        assert (parent != null);
        int rowCount = this.getChildCount(parent);
        buffer.append(indent);
        int columnCount = 1;
        Object value = this.getValueAt(parent, 0);
        if (value != null) {
            buffer.append(this.model.getLabel(value));
            Location location = this.model.getLocation(value);
            buffer.append(" (");
            buffer.append(location.getOffset());
            buffer.append('+');
            buffer.append(location.getLength());
            buffer.append(')');
        }
        for (int j = 1; j < columnCount; ++j) {
            buffer.append(", ");
            buffer.append(this.getValueAt(parent, j));
        }
        buffer.append(this.EOL);
        for (int i = 0; i < rowCount; ++i) {
            Object child = this.getChild(parent, i);
            assert (child != null) : "parent " + parent;
            this.append(buffer, indent + "  ", child);
        }
    }

    private static class PathComparator
    implements Comparator<Object[]> {
        private Comparator<Object> sorter;

        public PathComparator(Comparator<Object> sorter) {
            this.sorter = sorter;
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int length = Math.min(o1.length, o2.length);
            for (int i = 0; i < length; ++i) {
                int comparison = this.sorter.compare(o1[i], o2[i]);
                if (comparison == 0) continue;
                return comparison;
            }
            return o1.length - o2.length;
        }
    }

    private static class TreeState {
        private TreePath rootPath;
        private Map<TreePath, Boolean> map;
        private List<Object> expanded = new ArrayList<Object>();
        private List<Object> visible;
        private List<Object> selected = new ArrayList<Object>();
        private Object selectionLead;

        private TreeState() {
        }
    }
}

