/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.net.URL;
import java.util.concurrent.CancellationException;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.audit.analyzer.IssueReport;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.DefaultIssue;

class DefaultIssueReport
implements IssueReport {
    private ModelAdapter contextModel;
    private Object construct;
    private DefaultIssue issue;
    private int lastSerialNumber;

    DefaultIssueReport() {
    }

    boolean isClosed() {
        return this.issue == null;
    }

    void open(ModelAdapter contextModel, Rule rule, Location location, Object construct) {
        assert (this.issue == null);
        this.contextModel = contextModel;
        this.construct = construct;
        this.issue = new DefaultIssue(rule, location, ++this.lastSerialNumber);
    }

    DefaultIssue close() {
        this.issue.suspend(this.construct);
        DefaultIssue issue = this.issue;
        this.clear();
        return issue;
    }

    void cancel() {
        if (this.issue == null) {
            return;
        }
        this.clear();
    }

    void clear() {
        this.construct = null;
        this.contextModel = null;
        this.construct = null;
        this.issue = null;
    }

    @Override
    public void addParameter(String name, Object value) {
        Location location;
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        if (value instanceof URL) {
            value = URLFactory.intern((URL)((URL)value));
        } else if (!(value instanceof Location) && (location = this.getConstructLocation(this.issue.getModel(), value)) != null) {
            value = location;
        }
        this.issue.addParameter(name, value);
    }

    @Override
    public void addConstructParameter(String name, Object construct) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        this.addConstructParameter(name, this.issue.getModel(), construct);
    }

    @Override
    public void addConstructParameter(String name, ModelAdapter model, Object construct) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        Location location = this.getConstructLocation(model, construct);
        if (location == null) {
            throw new IllegalArgumentException("construct " + construct + " not in model " + model);
        }
        this.addParameter(name, location);
    }

    @Override
    public void setFocusLocation(Object construct) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        if (construct == null) {
            return;
        }
        Location location = this.getConstructLocation(this.issue.getModel(), construct);
        if (location != null) {
            this.setFocusLocation(location);
        }
    }

    @Override
    public void setFocusLocation(Location location) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        this.issue.setFocusLocation(location);
    }

    @Override
    public void setVariation(String name) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        this.issue.setVariation(name);
    }

    @Override
    public void hideAllTransforms() {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        this.issue.hideAllTransforms();
    }

    @Override
    public void showTransform(Transform transform) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        this.issue.showTransform(transform);
    }

    @Override
    public void hideTransform(Transform transform) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        this.issue.hideTransform(transform);
    }

    @Override
    public void setDefaultTransform(Transform transform) {
        if (this.issue == null) {
            throw new IllegalStateException("report closed");
        }
        this.issue.setDefaultTransform(transform);
    }

    public String toString() {
        return this.issue != null ? this.issue.toString() : "Issue{}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location getConstructLocation(ModelAdapter model, Object construct) {
        if (model == this.contextModel) {
            return model.getLocation(construct);
        }
        try {
            model.beginRead();
        }
        catch (InterruptedException e) {
            CancellationException exception = new CancellationException("audit interrupted");
            exception.initCause(e);
            throw exception;
        }
        try {
            Location location = model.getLocation(construct);
            return location;
        }
        finally {
            model.endRead();
        }
    }
}

