/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.transform;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.TextTransformAdapter;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;

public class TextTransformContext
extends TransformContext {
    private List<UndoableEdit> edits = new ArrayList<UndoableEdit>();

    protected TextTransformContext(TransformAdapter adapter, TransformContext.Shape shape, Transform transform, Violation violation, Location location, URL pendingLocation, Project pendingProject, Workspace pendingWorkspace) {
        super(adapter, shape, transform, violation, location, pendingLocation, pendingProject, pendingWorkspace);
    }

    public TextTransformContext(TextTransformAdapter adapter, Transform transform, Violation violation, Location location) {
        super(adapter, TransformContext.Shape.WRITE, transform, violation, location, null, null, null);
    }

    @Override
    public Collection<Class<? extends ModelAdapter>> getModelAdapterTypes() {
        return Collections.singletonList(TextFileModelAdapter.class);
    }

    @Override
    public TextTransformAdapter getAdapter() {
        return (TextTransformAdapter)super.getAdapter();
    }

    @Override
    public TextFileModelAdapter getModel() {
        return (TextFileModelAdapter)super.getModel();
    }

    public TextNode getTextNode() {
        return (TextNode)this.getNode();
    }

    public TextBuffer getBuffer() {
        return this.getModel().getTextBuffer();
    }

    public void addEdit(UndoableEdit edit) {
        this.edits.add(edit);
    }

    public void setSelection(int offset) {
        this.setSelection(offset, offset);
    }

    public void setSelection(int offset, int endOffset) {
        this.setSelection(this.getModel().getLocation(offset, endOffset - offset));
    }

    public void setSelection(Location location) {
        this.getAdapter().setSelection(location, 0, 0);
    }

    List<UndoableEdit> getEdits() {
        return this.edits;
    }
}

