/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.TypeMap;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.ConverterDefinition;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Converter;
import oracle.jdevimpl.audit.util.Beans;
import oracle.jdevimpl.audit.util.PropertyDescriptor;

public class ValueHandle
implements Comparable<ValueHandle> {
    private final String name;
    private Object representation;
    private Object value;
    private static TypeMap<Object, Converter> typeConverters;
    private static Collection<ConverterDefinition> unloadedConverterDefinitions;

    public ValueHandle(String name, Object representation, Object value) {
        if (name == null) {
            throw new NullArgumentException("name == null");
        }
        this.name = name;
        this.representation = value instanceof Boolean ? value.toString() : representation;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getRepresentation() {
        if (this.representation != null) {
            return this.representation;
        }
        if (this.value != null) {
            this.representation = this.createRepresentation(this.value);
        }
        return this.representation;
    }

    public boolean isTrue() {
        if (this.value != null) {
            return this.value instanceof Boolean && (Boolean)this.value != false;
        }
        if (this.representation != null) {
            return "true".equalsIgnoreCase((String)this.representation);
        }
        return false;
    }

    public Object getValueForProperty(Object bean) throws Exception {
        PropertyDescriptor property = Beans.getPropertyDescriptor(bean, this.name);
        if (property == null) {
            throw new IllegalArgumentException("property " + this.name + " not found");
        }
        return this.getValue(property.getPropertyType());
    }

    public Object getValue(Class<?> type) throws Exception {
        block12: {
            if (this.value != null || this.representation == null) break block12;
            if (this.representation instanceof String) {
                Converter converter = ValueHandle.getConverter(type);
                if (converter != null) {
                    this.value = converter.toValue((String)this.representation, type);
                } else {
                    AuditLogger.error("Converter for {0} not found", type);
                    this.value = null;
                }
            } else {
                Collection handles = (Collection)this.representation;
                if (type.isArray()) {
                    Class<?> componentType = type.getComponentType();
                    this.value = Array.newInstance(componentType, handles.size());
                    int index = 0;
                    for (ValueHandle handle : handles) {
                        try {
                            Array.set(this.value, index++, handle.getValue(componentType));
                        }
                        catch (Exception e) {
                            AuditLogger.error("Unmarshalling element \"{0}\" of {1} (name \"{2}\") failed: {3}", index - 1, this.value, this.getName(), e);
                        }
                    }
                } else {
                    this.value = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                    for (ValueHandle handle : handles) {
                        String name = handle.getName();
                        try {
                            PropertyDescriptor property = Beans.getPropertyDescriptor(this.value, name);
                            property.getWriteMethod().invoke(this.value, handle.getValue(property.getPropertyType()));
                        }
                        catch (Exception e) {
                            AuditLogger.error("Unmarshalling property \"{0}\" of {1} (name \"{2}\") failed: {3}", name, this.value, this.getName(), e);
                        }
                    }
                }
            }
        }
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof ValueHandle && this.getName().equals(((ValueHandle)object).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(ValueHandle that) {
        return this.name.compareTo(that.getName());
    }

    public static boolean valueEquals(ValueHandle left, ValueHandle right) {
        if (left == null || right == null) {
            return left == right;
        }
        if (left.value != null && right.value != null) {
            return left.value.equals(right.value);
        }
        if (left.value == null && right.value == null) {
            return left.representation == null ? right.representation == null : left.representation.equals(right.representation);
        }
        if (left.value != null) {
            try {
                return left.value.equals(right.getValue(left.value.getClass()));
            }
            catch (Exception exception) {
                return left.getRepresentation().equals(right.representation);
            }
        }
        assert (right.value != null);
        try {
            return right.value.equals(left.getValue(right.value.getClass()));
        }
        catch (Exception exception) {
            return right.getRepresentation().equals(left.representation);
        }
    }

    private Object createRepresentation(Object value) {
        if (value != null) {
            ArrayList<ValueHandle> handles;
            Class<?> type = value.getClass();
            Converter converter = ValueHandle.getConverter(type);
            if (converter != null) {
                return converter.toString(value);
            }
            if (type.isArray()) {
                Object[] array = (Object[])value;
                handles = new ArrayList(array.length);
                for (Object element : array) {
                    try {
                        handles.add(new ValueHandle("item", this.createRepresentation(element), element));
                    }
                    catch (Exception e) {
                        AuditLogger.error("marshaling element {0} (name \"{1}\") failed: {2}", element, this.getName(), e);
                    }
                }
            } else {
                Collection<PropertyDescriptor> properties = Beans.getPropertyDescriptors(value);
                handles = new ArrayList<ValueHandle>(properties.size());
                for (PropertyDescriptor propertyDescriptor : properties) {
                    try {
                        Object PropertyValue = propertyDescriptor.getReadMethod().invoke(value, new Object[0]);
                        handles.add(new ValueHandle(propertyDescriptor.getName(), this.createRepresentation(PropertyValue), PropertyValue));
                    }
                    catch (Exception e) {
                        AuditLogger.error("marshaling property {0} of class {1} (name {2}) failed: {3}", propertyDescriptor.getName(), value.getClass(), this.getName(), e);
                    }
                }
            }
            return handles;
        }
        return null;
    }

    private static synchronized Converter getConverter(Class<?> type) {
        ValueHandle.loadConverters();
        return (Converter)typeConverters.get(type);
    }

    private static void loadConverters() {
        if (typeConverters == null) {
            typeConverters = new TypeMap();
            unloadedConverterDefinitions = AuditHook.getAuditHook().getConverters();
        }
        if (!unloadedConverterDefinitions.isEmpty()) {
            Collection<ConverterDefinition> converterDefinitions = unloadedConverterDefinitions;
            unloadedConverterDefinitions = new ArrayList<ConverterDefinition>();
            for (ConverterDefinition definition : converterDefinitions) {
                if (definition.isExtensionLoaded()) {
                    Converter converter = definition.getConverter();
                    Class<?> valueType = definition.getValueType();
                    typeConverters.put(valueType, (Object)converter);
                    Class<?> primitiveType = definition.getPrimitiveValueType();
                    if (primitiveType == null) continue;
                    typeConverters.put(primitiveType, (Object)converter);
                    continue;
                }
                unloadedConverterDefinitions.add(definition);
            }
        }
    }

    public String toString() {
        return this.name + "{\"" + this.representation + "\"}{" + this.value + "}";
    }
}

