/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.bean;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.bean.PropertyFieldListener;
import oracle.jdeveloper.audit.bean.PropertyItem;
import oracle.jdevimpl.audit.util.PropertyDescriptor;

public abstract class PropertyField
extends PropertyItem
implements FocusListener {
    private PropertyDescriptor descriptor;
    private Class type;
    private Object initialValue;
    private boolean applied = false;
    private CopyOnWriteArrayList<PropertyFieldListener> listeners = new CopyOnWriteArrayList();
    private static final Log LOG = new Log("field");

    public void addFieldListener(PropertyFieldListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeFieldListener(PropertyFieldListener listener) {
        this.listeners.remove(listener);
    }

    public void fireFieldEntered() {
        LOG.trace("firing field {0} entered", (Object)this);
        for (PropertyFieldListener listener : this.listeners) {
            listener.fieldEntered(this);
        }
    }

    public void fireFieldChanged() {
        LOG.trace("firing field {0} changed", (Object)this);
        this.applied = false;
        for (PropertyFieldListener listener : this.listeners) {
            listener.fieldChanged(this);
        }
    }

    public void fireFieldCommitted() {
        LOG.trace("firing field {0} changed", (Object)this);
        this.applied = false;
        for (PropertyFieldListener listener : this.listeners) {
            listener.fieldCommitted(this);
        }
    }

    public void fireFieldExited() {
        LOG.trace("firing field {0} exited", (Object)this);
        for (PropertyFieldListener listener : this.listeners) {
            listener.fieldExited(this);
        }
    }

    public void setDescriptor(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getType() {
        return this.type != null ? this.type : this.descriptor.getPropertyType();
    }

    public void load(Object bean) throws Exception {
        Object value = this.descriptor.getReadMethod().invoke(bean, new Object[0]);
        LOG.trace("loading field {0} with {1} from {2}", (Object)this, value, bean);
        this.initialValue = value;
        this.setValue(value);
    }

    public void apply(Object bean) throws Exception {
        LOG.trace("applying {1}, initial value {2}, applied {0}", (Object)this.applied, (Object)this, this.initialValue);
        if (this.applied) {
            return;
        }
        this.applied = true;
        Object value = this.getValue();
        LOG.trace("new value {0}", value);
        if (!this.equals(this.initialValue, value)) {
            Object newValue;
            this.descriptor.getWriteMethod().invoke(bean, value);
            this.initialValue = newValue = this.descriptor.getReadMethod().invoke(bean, new Object[0]);
            if (!this.equals(newValue, value)) {
                this.setValue(newValue);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (!e.isTemporary()) {
            this.fireFieldEntered();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            this.fireFieldExited();
        }
    }

    public abstract Object getValue() throws Exception;

    public abstract void setValue(Object var1);

    public void handleException(Throwable e) {
        LOG.trace("handling exception in field {0}: {1}", (Object)this, (Object)e);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getLabelText() + (this.applied ? " (applied)" : "");
    }

    public boolean equals(Object left, Object right) {
        return left == null ? right == null : left.equals(right);
    }
}

