/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.bean;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.jdeveloper.audit.bean.PropertyField;

public abstract class AbstractTextField
extends PropertyField
implements ActionListener,
DocumentListener {
    private JTextField textField;

    protected AbstractTextField() {
        this(16);
    }

    protected AbstractTextField(int columns) {
        this.textField = new JTextField(columns);
        this.textField.getDocument().addDocumentListener(this);
        this.textField.addFocusListener(this);
        this.textField.setMinimumSize(this.textField.getPreferredSize());
    }

    public void setColumns(int columns) {
        this.textField.setColumns(columns);
        this.textField.setMinimumSize(this.textField.getPreferredSize());
    }

    public int getColumns() {
        return this.textField.getColumns();
    }

    @Override
    public void setValue(Object value) {
        this.textField.setText((String)value);
    }

    @Override
    public Object getValue() {
        String text = this.textField.getText();
        if (text != null) {
            text = text.trim();
        }
        return text;
    }

    @Override
    public JComponent getComponent() {
        return this.textField;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireFieldChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireFieldChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireFieldChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireFieldCommitted();
    }
}

