/*
 * Decompiled with CFR 0.152.
 */
package oracle.sdovis;

public class CoordArray {
    int dim = 2;
    int count = 0;
    int capacity = 0;
    double[] coords = null;
    boolean sorted = false;

    public CoordArray(int n) {
        this.ensure(n);
    }

    public CoordArray(int n, int n2) {
        this.dim = n;
        this.ensure(n2);
    }

    public CoordArray(int n, int n2, boolean bl) {
        this.dim = n;
        this.ensure(n2);
        this.sorted = bl;
    }

    public void reset() {
        this.count = 0;
        this.sorted = false;
    }

    public int getNumCoords() {
        return this.count;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void close() {
        if (this.count == 0) {
            return;
        }
        this.add(this.coords[0], this.coords[1]);
    }

    public void remove(int n) {
        System.arraycopy(this.coords, (n + 1) * this.dim, this.coords, n * this.dim, (this.count - 1 - n) * this.dim);
        --this.count;
    }

    public int find(double d, double d2) {
        for (int i = 0; i < this.count; ++i) {
            double d3 = this.coords[i * this.dim];
            double d4 = this.coords[i * this.dim + 1];
            if (d != d3 || d2 != d4) continue;
            return i;
        }
        return -1;
    }

    public boolean getSorted() {
        return this.sorted;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
    }

    public void add(double d, double d2) {
        if (this.capacity <= this.count) {
            this.ensure((int)((double)this.capacity * 1.2));
        }
        this.coords[this.dim * this.count] = d;
        this.coords[this.dim * this.count + 1] = d2;
        ++this.count;
    }

    public void addSortY(double d, double d2) {
        double d3;
        int n = -1;
        while (++n < this.count && !((d3 = this.coords[n * this.dim + 1]) > d2)) {
        }
        this.addAt(d, d2, n);
    }

    public void addAt(double d, double d2, int n) {
        if (this.capacity <= this.count) {
            this.ensure(this.capacity * 2);
        }
        int n2 = this.dim * n;
        double d3 = this.coords[n2];
        double d4 = this.coords[n2 + 1];
        this.coords[n2] = d;
        this.coords[n2 + 1] = d2;
        System.arraycopy(this.coords, (n + 1) * this.dim, this.coords, (n + 2) * this.dim, (this.count - n) * this.dim);
        this.coords[(n + 1) * this.dim] = d3;
        this.coords[(n + 1) * this.dim + 1] = d4;
        ++this.count;
    }

    public void replaceAt(double d, double d2, int n) {
        this.coords[this.dim * n] = d;
        this.coords[this.dim * n + 1] = d2;
    }

    public double getX(int n) {
        return this.coords[n * this.dim];
    }

    public double getY(int n) {
        return this.coords[n * this.dim + 1];
    }

    public double getLastX() {
        return this.coords[(this.count - 1) * this.dim];
    }

    public double getLastY() {
        return this.coords[(this.count - 1) * this.dim + 1];
    }

    public double[] getAll() {
        double[] dArray = new double[this.count * this.dim];
        System.arraycopy(this.coords, 0, dArray, 0, this.count * this.dim);
        return dArray;
    }

    public float[] getAllFloat() {
        float[] fArray = new float[this.count * this.dim];
        for (int i = 0; i < this.count * this.dim; ++i) {
            fArray[i] = (float)this.coords[i];
        }
        return fArray;
    }

    private void ensure(int n) {
        if (this.capacity >= n) {
            return;
        }
        double[] dArray = new double[n * this.dim];
        if (this.coords != null && this.count > 0) {
            System.arraycopy(this.coords, 0, dArray, 0, this.count * this.dim);
        }
        this.coords = dArray;
        this.capacity = n;
    }
}

