/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.stylex;

import java.util.ArrayList;
import java.util.Collection;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.stylex.Bucket;
import oracle.sdovis.util.Util;

public class CollectionBucket
extends Bucket {
    static final long serialVersionUID = -1138763220227156473L;
    Collection members = null;
    String delimiter = ",";
    String type = "string";
    boolean keepWhiteSpace = false;

    public CollectionBucket(String string) {
        super(string);
    }

    public CollectionBucket(String string, Collection collection) {
        super(string);
        this.members = collection;
        if (collection.contains(new Field("#DEFAULT#")) || collection.contains(new Field("#default#"))) {
            this.setDefaultBucket(true);
        }
    }

    @Override
    public Object clone() {
        CollectionBucket collectionBucket = (CollectionBucket)super.clone();
        if (this.members != null && this.members.size() > 0) {
            collectionBucket.members = new ArrayList(this.members);
        }
        return collectionBucket;
    }

    public void setMembers(Collection collection) {
        this.members = collection;
    }

    public void setMembers(Field[] fieldArray) {
        this.members = new ArrayList(fieldArray.length);
        for (int i = 0; i < fieldArray.length; ++i) {
            this.members.add(fieldArray[i]);
        }
    }

    public Collection getMembers() {
        return this.members;
    }

    public Field[] getMembersAsArray() {
        if (this.members == null) {
            return null;
        }
        return this.members.toArray(new Field[this.members.size()]);
    }

    public String getMembersAsString() {
        if (this.members == null || this.members.size() == 0) {
            return null;
        }
        Field[] fieldArray = this.members.toArray(new Field[this.members.size()]);
        String string = fieldArray[0].toString();
        for (int i = 1; i < this.members.size(); ++i) {
            string = string + this.delimiter + fieldArray[i].toString();
        }
        return string;
    }

    public void setMembersAsString(String string) {
        this.setMembers(string);
    }

    public void setMembers(String string) {
        if (string == null || string.length() == 0) {
            this.members = null;
        } else {
            ArrayList arrayList = Util.splitBy((String)string, (String)this.delimiter);
            if (arrayList == null || arrayList.size() == 0) {
                this.members = null;
            } else {
                this.members = new ArrayList(arrayList.size());
                for (int i = 0; i < arrayList.size(); ++i) {
                    Field field = null;
                    field = this.type != null && this.type.equalsIgnoreCase("integer") ? new Field().setInt(Integer.parseInt(arrayList.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("double") ? new Field().setDouble(Double.parseDouble(arrayList.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("float") ? new Field().setFloat(Float.parseFloat(arrayList.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("long") ? new Field().setLong(Long.parseLong(arrayList.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("short") ? new Field().setShort(Short.parseShort(arrayList.get(i).toString())) : (this.type != null && this.type.equalsIgnoreCase("char") ? new Field(arrayList.get(i).toString()) : (this.type != null && this.type.equalsIgnoreCase("date") ? Field.createField(arrayList.get(i).toString(), "date") : new Field(arrayList.get(i).toString())))))));
                    if (field == null) continue;
                    this.members.add(field);
                }
            }
        }
    }

    @Override
    public boolean contains(Field field) {
        try {
            for (Field field2 : this.members) {
                if (field2.compareTo(field) != 0) continue;
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            field = Field.createField(field.getString(), "string");
            for (Field field3 : this.members) {
                if (field3.compareTo(field) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string == null ? "," : string;
    }

    public void setKeepWhiteSpace(boolean bl) {
        this.keepWhiteSpace = bl;
    }

    public boolean getKeepWhiteSpace() {
        return this.keepWhiteSpace;
    }

    public void print() {
        if (this.members.size() > 0) {
            Object[] objectArray = this.members.toArray();
            System.out.println("Collection Bucket members");
            for (int i = 0; i < this.members.size(); ++i) {
                if (objectArray[i].toString() != null) {
                    System.out.println("Element: " + i + "= " + objectArray[i].toString());
                    continue;
                }
                System.out.println("Element: " + i + "= null");
            }
        }
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }
}

