/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.util.SharedUtils;

public class StyleUtils {
    public static int getTypeCodeFromName(String string) {
        if ("COLOR".equals(string = string.toUpperCase())) {
            return 1;
        }
        if ("AREA".equals(string)) {
            return 4;
        }
        if ("LINE".equals(string)) {
            return 3;
        }
        if ("MARKER".equals(string)) {
            return 2;
        }
        if ("TEXT".equals(string)) {
            return 5;
        }
        if ("ADVANCED".equals(string)) {
            return 9;
        }
        if ("CUSTOM".equals(string)) {
            return 100;
        }
        if ("TTF".equals(string)) {
            return 99;
        }
        return 0;
    }

    public static String getTypeNameFromCode(int n) {
        switch (n) {
            case 9: {
                return "ADVANCED";
            }
            case 4: {
                return "AREA";
            }
            case 1: {
                return "COLOR";
            }
            case 100: {
                return "CUSTOM";
            }
            case 3: {
                return "LINE";
            }
            case 2: {
                return "MARKER";
            }
            case 5: {
                return "TEXT";
            }
            case 99: {
                return "TTF";
            }
        }
        return null;
    }

    public static String getHexidecimalString(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        String string = "#";
        int n4 = (n >> 4) % 16;
        char c = n4 < 10 ? (char)(48 + n4) : (char)(65 + (n4 - 10));
        string = string + c;
        n4 = n % 16;
        c = n4 < 10 ? (char)(48 + n4) : (char)(65 + (n4 - 10));
        string = string + c;
        n4 = (n2 >> 4) % 16;
        c = n4 < 10 ? (char)(48 + n4) : (char)(65 + (n4 - 10));
        string = string + c;
        n4 = n2 % 16;
        c = n4 < 10 ? (char)(48 + n4) : (char)(65 + (n4 - 10));
        string = string + c;
        n4 = (n3 >> 4) % 16;
        c = n4 < 10 ? (char)(48 + n4) : (char)(65 + (n4 - 10));
        string = string + c;
        n4 = n3 % 16;
        c = n4 < 10 ? (char)(48 + n4) : (char)(65 + (n4 - 10));
        string = string + c;
        return string;
    }

    public static int getStyleTypeFromXML(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.indexOf("class=");
        int n2 = 0;
        if (n < 0) {
            int n3 = string.indexOf("AdvancedStyle");
            if (n3 < 0) {
                return 0;
            }
            return 9;
        }
        n2 = n += 7;
        try {
            while (string.charAt(n2++) != '\"') {
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return 0;
        }
        String string2 = string.substring(n, n2 - 1);
        if (string2 == null || string2.length() < 4) {
            return 0;
        }
        string2 = string2.toUpperCase();
        try {
            if (string2.equals("COLOR")) {
                return 1;
            }
            if (string2.equals("LINE")) {
                return 3;
            }
            if (string2.equals("TEXT")) {
                return 5;
            }
            if (string2.equals("MARKER")) {
                return 2;
            }
            if (string2.equals("AREA")) {
                return 4;
            }
            return 0;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return 0;
        }
    }

    public static Color getColor(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        Color color = null;
        if (string.indexOf("#") != -1 || string.indexOf("0x") != -1) {
            try {
                color = Color.decode(string);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (string.toUpperCase().equals("BLACK")) {
            color = Color.black;
        } else if (string.toUpperCase().equals("RED")) {
            color = Color.red;
        } else if (string.toUpperCase().equals("GREEN")) {
            color = Color.green;
        } else if (string.toUpperCase().equals("BLUE")) {
            color = Color.blue;
        } else if (string.toUpperCase().equals("YELLOW")) {
            color = Color.yellow;
        } else if (string.toUpperCase().equals("WHITE")) {
            color = Color.white;
        } else if (string.toUpperCase().equals("PINK")) {
            color = Color.pink;
        } else if (string.toUpperCase().equals("MAGENTA")) {
            color = Color.magenta;
        } else if (string.toUpperCase().equals("ORANGE")) {
            color = Color.orange;
        } else if (string.toUpperCase().equals("GRAY")) {
            color = Color.gray;
        } else if (string.toUpperCase().equals("LIGHTGRAY")) {
            color = Color.lightGray;
        } else if (string.toUpperCase().equals("CYAN")) {
            color = Color.cyan;
        } else if (string.toUpperCase().equals("US MAP YELLOW")) {
            color = new Color(0xFFFFA5);
        } else {
            if (string.toUpperCase().equals("NONE")) {
                return null;
            }
            return null;
        }
        return color;
    }

    public static Color getColor(String string, String string2) {
        String string3 = StyleUtils.getNamedString(string2, string);
        if (string3 == null || string3.length() <= 0) {
            return null;
        }
        String string4 = string + "-opacity";
        int n = StyleUtils.getColorOpacity(string4, string2);
        Color color = StyleUtils.getColor(string3);
        if (color == null) {
            return null;
        }
        if (n >= 0 && n <= 255) {
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
        }
        return color;
    }

    public static int getColorOpacity(String string, String string2) {
        String string3 = StyleUtils.getNamedString(string2, string);
        if (string3 == null || string3.length() <= 0) {
            return 255;
        }
        if ((string3 = string3.trim()).indexOf("#") != -1) {
            Integer n = Integer.decode(string3);
            return n;
        }
        if ("1".equals(string3)) {
            return 255;
        }
        if ("0".equals(string3)) {
            return 0;
        }
        if (string3.indexOf(".") >= 0) {
            double d = Double.parseDouble(string3);
            if (d < 1.0 && d > 0.0) {
                return (int)(255.0 * d);
            }
            return 255;
        }
        return Integer.parseInt(string3);
    }

    public static float getStrokeWidth(String string) {
        String string2 = StyleUtils.getNamedString(string, "stroke-width");
        if (string2 == null || string2.length() <= 0) {
            return 1.0f;
        }
        return Float.valueOf(string2.trim()).floatValue();
    }

    public static SizeDefinition getStrokeWidthSize(String string) {
        String string2 = StyleUtils.getNamedString(string, "stroke-width");
        if (string2 == null || string2.length() <= 0) {
            return null;
        }
        return SizeDefinition.parse(string2.trim());
    }

    public static String getNamedString(String string, String string2) {
        String string3;
        char c;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n < 0) {
            return null;
        }
        while (n > 0 && (c = string.charAt(n - 1)) != ';' && !Character.isWhitespace(c)) {
            if ((n = string.indexOf(string2, n + 1)) >= 0) continue;
            return null;
        }
        String string4 = string.substring(n += string2.length() + 1, string.length());
        int n2 = string4.indexOf(";");
        if ((string3 = n2 < 0 ? string.substring(n, string.length()) : string.substring(n, n + n2)) == null || string3.length() <= 0) {
            return null;
        }
        return string3;
    }

    public static Color getColorFromRGB(String string) {
        if (string == null) {
            return null;
        }
        int n = string.toLowerCase().indexOf("rgb(");
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(")");
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + 4, n2);
        List list = SharedUtils.splitBy(string2, ",");
        if (list == null || list.size() != 3) {
            return null;
        }
        try {
            int n3 = Integer.parseInt(list.get(0).toString());
            int n4 = Integer.parseInt(list.get(1).toString());
            int n5 = Integer.parseInt(list.get(2).toString());
            return new Color(n3, n4, n5);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String cleanDecimalZeros(String string, int n) {
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = "0.";
        String string3 = string;
        int n3 = string3.indexOf(".");
        if (n3 == -1) {
            return string3;
        }
        int n4 = string3.length();
        int n5 = 0;
        for (n2 = n3 + 1; n2 < n4; ++n2) {
            string2 = string2 + "0";
            ++n5;
        }
        n2 = 1;
        if (n > 0) {
            n2 += n + 1;
        }
        while (n2 <= n5 + 1) {
            if (string3.endsWith(string2.substring(n2))) {
                return string3.substring(0, n3 + n2 - 1);
            }
            ++n2;
        }
        return string3;
    }

    public static String getUSLocaleFormat(double d) {
        if (Double.isNaN(d)) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).applyPattern("0.000");
            String string = numberFormat.format(d);
            return string;
        }
        return String.valueOf(d);
    }

    public static Color[] createTwoStopGradient(Color color, Color color2, int n, int n2) {
        if (n2 < 0 || n2 > 255) {
            n2 = 255;
        }
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        int n6 = color2.getRed();
        int n7 = color2.getGreen();
        int n8 = color2.getBlue();
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)i / (double)n;
            n9 = (int)((double)n3 + d * (double)(n6 - n3));
            n10 = (int)((double)n4 + d * (double)(n7 - n4));
            n11 = (int)((double)n5 + d * (double)(n8 - n5));
            colorArray[i] = new Color(n9, n10, n11, n2);
        }
        return colorArray;
    }

    public static Color[] createMultiStopGradient(Color[] colorArray, int n, int n2) {
        if (n2 < 0 || n2 > 255) {
            n2 = 255;
        }
        int n3 = colorArray.length - 1;
        int n4 = 0;
        Color[] colorArray2 = new Color[n];
        if (n3 <= 0) {
            throw new IllegalArgumentException("You must pass in at least 2 colors in the array!");
        }
        for (int i = 0; i < n3; ++i) {
            Color[] colorArray3 = StyleUtils.createTwoStopGradient(colorArray[i], colorArray[i + 1], n / n3, n2);
            for (int j = 0; j < colorArray3.length; ++j) {
                colorArray2[n4++] = colorArray3[j];
            }
        }
        if (n4 < n) {
            while (n4 < n) {
                colorArray2[n4] = colorArray[colorArray.length - 1];
                ++n4;
            }
        }
        return colorArray2;
    }
}

