/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share.style;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import oracle.mapviewer.share.SizeDefinition;
import oracle.mapviewer.share.SizeDefinition2D;
import oracle.mapviewer.share.XMLUtil;
import oracle.mapviewer.share.style.AbstractStyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TruetypeFont;
import oracle.sdovis.util.Util;

public class MarkerStyleModel
extends AbstractStyleModel {
    static final long serialVersionUID = 6465985930521778440L;
    public static final int MARKER_POLYGON = 1;
    public static final int MARKER_POLYLINE = 2;
    public static final int MARKER_CIRCLE = 3;
    public static final int MARKER_RECT = 4;
    public static final int MARKER_IMAGE = 5;
    public static final int MARKER_TTF = 6;
    public static final int MARKER_SVG = 7;
    public static final double NO_ROTATION = 0.0;
    public static final int OTHER = -1;
    public static final int GIF = 0;
    public static final int JPG = 1;
    public static final int PNG = 2;
    public static final int DEFAULT_WIDTH = 16;
    public static final int DEFAULT_HEIGHT = 16;
    int markerType = 0;
    byte[] markerImageBinary = null;
    int markerImageType = 0;
    Font labelFont = null;
    SizeDefinition labelFontSize = new SizeDefinition(12.0, null);
    Color labelFontColor = Color.white;
    SizeDefinition2D labelOffset = new SizeDefinition2D();
    double[] vector = null;
    Color vectorFillColor = Color.gray;
    Color vectorStrokeColor = Color.black;
    Color backgroundColor = null;
    float vectorStrokeWidth = 1.0f;
    TruetypeFont ttf = null;
    int glyphCharCode = 0;
    SizeDefinition2D markerSize = new SizeDefinition2D();
    double ox = 1.0;
    double oy = 0.0;
    double oz = 0.0;
    double rotation = 0.0;
    String url = null;
    String urlFormat = "gif";
    String urlColumn = null;
    double[] anchorPoint = new double[]{0.5, 0.5};
    double[] svgNaturalSize = null;
    String rawSVGString = null;

    public MarkerStyleModel() {
        this.type = 2;
    }

    @Override
    public Object clone() {
        MarkerStyleModel markerStyleModel = (MarkerStyleModel)super.clone();
        if (this.vector != null) {
            markerStyleModel.vector = (double[])this.vector.clone();
        }
        if (this.markerImageBinary != null) {
            markerStyleModel.markerImageBinary = (byte[])this.markerImageBinary.clone();
        }
        markerStyleModel.setLabelFontSize(this.labelFontSize);
        markerStyleModel.setLabelOffsetSize(this.labelOffset);
        markerStyleModel.setMarkerSize(this.markerSize);
        markerStyleModel.setAnchorPoint(this.getAnchorX(), this.getAnchorY());
        return markerStyleModel;
    }

    @Override
    public String getTypeName() {
        return "MARKER";
    }

    @Override
    public String toXMLString() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = "";
        if (this.labelFont != null) {
            int n;
            string5 = this.labelFont.getFamily();
            float f = (float)this.labelFontSize.getValue();
            string4 = String.valueOf(f);
            if (this.labelFontSize.isPixelUnit()) {
                string4 = String.valueOf((int)f);
            }
            string3 = "";
            if (this.labelFontSize.getUnit() != null && !this.labelFontSize.getUnit().equalsIgnoreCase("px")) {
                string3 = this.labelFontSize.getUnit();
            }
            boolean bl = ((n = this.labelFont.getStyle()) & 1) > 0;
            boolean bl2 = (n & 2) > 0;
            string2 = bl ? ";font-weight:bold" : "";
            string = bl2 ? ";font-style:italic" : "";
            String string7 = this.labelFontColor == null ? ";font-fill:#ffffff" : ";font-fill:" + StyleUtils.getHexidecimalString(this.labelFontColor);
            string6 = string6 + ";font-family:" + string5 + ";font-size:" + string4 + string3 + string2 + string + string7;
            double d = this.labelOffset.getWidth();
            double d2 = this.labelOffset.getHeight();
            String string8 = "";
            if (this.labelOffset.getUnit() != null && !this.labelOffset.getUnit().equalsIgnoreCase("px")) {
                string8 = this.labelOffset.getUnit();
            }
            if (this.labelOffset.isPixelUnit()) {
                if (d != 0.0) {
                    string6 = string6 + ";text-offset-x:" + String.valueOf((int)d) + string8;
                }
                if (d2 != 0.0) {
                    string6 = string6 + ";text-offset-y:" + String.valueOf((int)d2) + string8;
                }
            } else {
                String string9;
                if (d != 0.0) {
                    string9 = StyleUtils.getUSLocaleFormat(d);
                    string9 = StyleUtils.cleanDecimalZeros(string9, 1);
                    string6 = string6 + ";text-offset-x:" + string9 + string8;
                }
                if (d2 != 0.0) {
                    string9 = StyleUtils.getUSLocaleFormat(d2);
                    string9 = StyleUtils.cleanDecimalZeros(string9, 1);
                    string6 = string6 + ";text-offset-y:" + string9 + string8;
                }
            }
        }
        string5 = "";
        if (this.markerSize.getUnit() != null && !this.markerSize.getUnit().equalsIgnoreCase("px")) {
            string5 = this.markerSize.getUnit();
        }
        String string10 = String.valueOf(this.markerSize.getWidth());
        string4 = String.valueOf(this.markerSize.getHeight());
        if (this.markerSize.isPixelUnit()) {
            string10 = String.valueOf((int)this.markerSize.getWidth());
            string4 = String.valueOf((int)this.markerSize.getHeight());
        }
        string3 = "";
        if (this.anchorPoint[0] != 0.5 || this.anchorPoint[1] != 0.5) {
            string3 = "      <anchor x=\"" + this.anchorPoint[0] + "\" y=\"" + this.anchorPoint[1] + "\" />\n";
        }
        String string11 = "";
        if (this.backgroundColor != null) {
            string11 = ";background:" + StyleUtils.getHexidecimalString(this.backgroundColor);
            if (this.backgroundColor.getAlpha() < 255) {
                string11 = string11 + ";background-opacity:" + this.backgroundColor.getAlpha();
            }
        }
        if (this.markerType == 5) {
            String string12 = "dummy.gif";
            if (this.url != null) {
                string12 = this.url;
            }
            String string13 = "gif";
            if (this.urlFormat != null) {
                string13 = this.urlFormat;
            }
            string2 = "";
            string2 = this.urlColumn == null || !string12.equals("dummy.gif") ? "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\" style=\"width:" + string10 + string5 + ";height:" + string4 + string5 + string6 + string11 + "\">\n" + "    <image x=\"0\" y=\"0\" width=\"1\" height=\"1\" markerType=\"" + string13 + "\" href=\"" + string12 + "\"/>\n" + string3 + "  </g>\n" + "</svg>" : "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\" style=\"width:" + string10 + string5 + ";height:" + string4 + string5 + string6 + string11 + "\">\n" + "    <image x=\"0\" y=\"0\" width=\"1\" height=\"1\" markerType=\"" + string13 + "\" hrefColumn=\"" + this.urlColumn + "\"/>\n" + string3 + "  </g>\n" + "</svg>";
            return string2;
        }
        if (this.markerType == 7) {
            String string14 = "dummy.svg";
            String string15 = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\" style=\"width:" + string10 + string5 + ";height:" + string4 + string5 + string6 + string11 + "\">\n" + "    <svgSymbol href=\"" + string14 + "\">\n" + "      <![CDATA[" + this.rawSVGString + "]]>\n" + "    </svgSymbol>\n" + string3 + "  </g>\n" + "</svg>";
            return string15;
        }
        if (this.markerType == 1 || this.markerType == 2 || this.markerType == 4 || this.markerType == 3 || this.markerType == 6) {
            String string16 = "<?xml version=\"1.0\" standalone=\"yes\"?>\n<svg width=\"1in\" height=\"1in\">\n  <desc></desc>\n  <g class=\"marker\"";
            string16 = string16 + " style=\"";
            String string17 = "";
            int n = 255;
            if (this.vectorStrokeColor != null) {
                string17 = string17 + "stroke:" + StyleUtils.getHexidecimalString(this.vectorStrokeColor);
                n = this.vectorStrokeColor.getAlpha();
                if (n < 255) {
                    string17 = string17 + ";stroke-opacity:" + n;
                }
                if (this.vectorStrokeWidth != 1.0f) {
                    string17 = string17 + ";stroke-width:" + this.vectorStrokeWidth;
                }
                if (this.vectorFillColor != null) {
                    string17 = string17 + ";fill:" + StyleUtils.getHexidecimalString(this.vectorFillColor);
                    n = this.vectorFillColor.getAlpha();
                    if (n < 255) {
                        string17 = string17 + ";fill-opacity:" + n;
                    }
                }
            } else if (this.vectorFillColor != null) {
                string17 = string17 + "fill:" + StyleUtils.getHexidecimalString(this.vectorFillColor);
                n = this.vectorFillColor.getAlpha();
                if (n < 255) {
                    string17 = string17 + ";fill-opacity:" + n;
                }
            }
            if (this.backgroundColor != null) {
                string17 = string17.length() == 0 ? string17 + "background:" + StyleUtils.getHexidecimalString(this.backgroundColor) : string17 + ";background:" + StyleUtils.getHexidecimalString(this.backgroundColor);
                n = this.backgroundColor.getAlpha();
                if (n < 255) {
                    string17 = string17 + ";background-opacity:" + n;
                }
            }
            if (string17.length() > 1) {
                string16 = string16 + string17;
            }
            if (this.markerSize.getWidth() > 0.0 && this.markerSize.getHeight() > 0.0) {
                string16 = string16 + ";width:" + string10 + string5 + ";height:" + string4 + string5;
            }
            string16 = string16 + string6;
            string16 = string16 + "\">\n";
            switch (this.markerType) {
                case 6: {
                    string16 = string16 + "    <ttfSymbol fontName=\"" + XMLUtil.replaceXMLEntities(this.ttf.getName().toUpperCase()) + "\" charCode=\"" + this.glyphCharCode + "\" />\n";
                    break;
                }
                case 3: {
                    if (this.vector == null) break;
                    string16 = string16 + "    <circle cx=\"0\" cy=\"0\" r=\"0\" />\n";
                    break;
                }
                case 1: {
                    if (this.vector == null || this.vector.length % 2 != 0) break;
                    string = "";
                    string = string + this.vector[0] + "," + this.vector[1];
                    for (int i = 2; i < this.vector.length; i += 2) {
                        string = string + "," + this.vector[i] + "," + this.vector[i + 1];
                    }
                    string16 = string16 + "    <polygon points=\"" + string + "\" />\n";
                    break;
                }
                case 2: {
                    if (this.vector == null || this.vector.length % 2 != 0) break;
                    string = "";
                    string = string + this.vector[0] + "," + this.vector[1];
                    for (int i = 2; i < this.vector.length; i += 2) {
                        string = string + "," + this.vector[i] + "," + this.vector[i + 1];
                    }
                    string16 = string16 + "    <polyline points=\"" + string + "\" />\n";
                    break;
                }
                case 4: {
                    if (this.vector == null || this.vector.length != 4) break;
                    string = "";
                    string = string + this.vector[0] + "," + this.vector[1];
                    for (int i = 2; i < this.vector.length; i += 2) {
                        string = string + "," + this.vector[i] + "," + this.vector[i + 1];
                    }
                    string16 = string16 + "    <rect points=\"" + string + "\" />\n";
                }
            }
            string16 = string16 + string3;
            string16 = string16 + "  </g>\n</svg>";
            return string16;
        }
        return null;
    }

    public void setMarkerType(int n) {
        this.markerType = n;
    }

    public int getMarkerType() {
        return this.markerType;
    }

    public void setMarkerImageBinary(byte[] byArray) {
        this.markerImageBinary = byArray;
    }

    public byte[] getMarkerImageBinary() {
        return this.markerImageBinary;
    }

    public void setMarkerImageType(int n) {
        this.markerImageType = n;
    }

    public int getMarkerImageType() {
        return this.markerImageType;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFontColor(Color color) {
        this.labelFontColor = color;
    }

    public Color getLabelFontColor() {
        return this.labelFontColor;
    }

    public void setMarkerSize(SizeDefinition2D sizeDefinition2D) {
        this.markerSize = new SizeDefinition2D();
        if (sizeDefinition2D == null) {
            return;
        }
        this.markerSize.setSize(sizeDefinition2D);
        this.markerSize.setUnit(sizeDefinition2D.getUnit());
    }

    public SizeDefinition2D getMarkerSize() {
        return this.markerSize;
    }

    public double getMarkerWidth() {
        return this.markerSize.getWidth();
    }

    public void setMarkerWidth(double d) {
        this.markerSize.setWidth(d);
    }

    public double getMarkerHeight() {
        return this.markerSize.getHeight();
    }

    public void setMarkerHeight(double d) {
        this.markerSize.setHeight(d);
    }

    public String getMarkerSizeUnit() {
        return this.markerSize.getUnit();
    }

    public void setMarkerSizeUnit(String string) {
        this.markerSize.setUnit(string);
    }

    public void setForcedWidth(int n) {
        this.markerSize.setWidth(n);
    }

    public int getForcedWidth() {
        return (int)this.markerSize.getWidth();
    }

    public void setForcedHeight(int n) {
        this.markerSize.setHeight(n);
    }

    public int getForcedHeight() {
        return (int)this.markerSize.getHeight();
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setVector(double[] dArray) {
        this.vector = dArray;
    }

    public double[] getVector() {
        return this.vector;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public String getCoordinatesAsString() {
        if (this.vector == null || this.vector.length == 0) {
            if (this.markerType != 3) {
                return "";
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("" + this.vector[0]);
        if (this.markerType != 3) {
            for (int i = 1; i < this.vector.length; ++i) {
                stringBuffer.append("," + this.vector[i]);
            }
        }
        return stringBuffer.toString();
    }

    public void setCoordinatesAsString(String string) {
        if (string == null || string.trim().length() == 0) {
            this.vector = null;
            return;
        }
        ArrayList arrayList = Util.splitBy((String)string.trim(), (String)",");
        if (arrayList == null || arrayList.size() == 0) {
            this.vector = null;
            return;
        }
        if (this.markerType == 3) {
            this.vector = new double[1];
            this.vector[0] = Double.parseDouble((String)arrayList.get(0));
        }
        this.vector = Util.convert((String)string.trim());
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setVectorFillColor(Color color) {
        this.vectorFillColor = color;
    }

    public Color getVectorFillColor() {
        return this.vectorFillColor;
    }

    public void setVectorStrokeColor(Color color) {
        this.vectorStrokeColor = color;
    }

    public Color getVectorStrokeColor() {
        return this.vectorStrokeColor;
    }

    public void setVectorStrokeWidth(float f) {
        this.vectorStrokeWidth = f;
    }

    public float getVectorStrokeWidth() {
        return this.vectorStrokeWidth;
    }

    public double setOrientation(double d, double d2, double d3) {
        this.ox = d;
        this.oy = d2;
        this.oz = d3;
        this.rotation = Math.atan2(-d2, d);
        return this.rotation;
    }

    public double[] getOrientation() {
        return new double[]{this.ox, this.oy, this.oz};
    }

    public void resetOrientation() {
        this.ox = 1.0;
        this.oy = 0.0;
        this.oz = 0.0;
        this.rotation = 0.0;
    }

    public void setGlyphCharCode(int n) {
        this.glyphCharCode = n;
    }

    public int getGlyphCharCode() {
        return this.glyphCharCode;
    }

    public void setTruetypeFontName(String string) {
        if (this.ttf == null) {
            this.ttf = new TruetypeFont();
        }
        this.ttf.setName(string);
    }

    public String getTruetypeFontName() {
        return this.ttf == null ? null : this.ttf.getName();
    }

    public void setTruetypeFont(TruetypeFont truetypeFont) {
        this.ttf = truetypeFont;
    }

    public TruetypeFont getTruetypeFont() {
        return this.ttf;
    }

    public void setTruetypeFont(Font font) {
        if (this.ttf == null) {
            this.ttf = new TruetypeFont();
        }
        this.ttf.setFont(font);
        if (this.ttf.getName() == null) {
            this.ttf.setName(font.getFamily().toUpperCase());
        }
    }

    public void setLabelOffsetSize(SizeDefinition2D sizeDefinition2D) {
        this.labelOffset = new SizeDefinition2D();
        if (sizeDefinition2D == null) {
            return;
        }
        this.labelOffset.setSize(sizeDefinition2D);
        this.labelOffset.setUnit(sizeDefinition2D.getUnit());
    }

    public SizeDefinition2D getLabelOffsetSize() {
        return this.labelOffset;
    }

    public double getLabelOffsetSizeX() {
        return this.labelOffset.getWidth();
    }

    public void setLabelOffsetSizeX(double d) {
        this.labelOffset.setWidth(d);
    }

    public double getLabelOffsetSizeY() {
        return this.labelOffset.getHeight();
    }

    public void setLabelOffsetSizeY(double d) {
        this.labelOffset.setHeight(d);
    }

    public String getLabelOffsetUnit() {
        return this.labelOffset.getUnit();
    }

    public void setLabelOffsetUnit(String string) {
        this.labelOffset.setUnit(string);
    }

    public void setLabelOffsetX(int n) {
        this.labelOffset.setWidth(n);
    }

    public int getLabelOffsetX() {
        return (int)this.labelOffset.getWidth();
    }

    public void setLabelOffsetY(int n) {
        this.labelOffset.setHeight(n);
    }

    public int getLabelOffsetY() {
        return (int)this.labelOffset.getHeight();
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrlColumn(String string) {
        this.urlColumn = string;
    }

    public String getUrlColumn() {
        return this.urlColumn;
    }

    public String getUrlMarkerImageFormat() {
        return this.urlFormat;
    }

    public void setUrlMarkerImageFormat(String string) {
        this.urlFormat = string;
    }

    public String getLabelFontSizeUnit() {
        return this.labelFontSize.getUnit();
    }

    public void setLabelFontSizeUnit(String string) {
        this.labelFontSize.setUnit(string);
    }

    public float getLabelFontSizeValue() {
        return (float)this.labelFontSize.getValue();
    }

    public void setLabelFontSizeValue(float f) {
        this.labelFontSize.setValue(f);
    }

    public void setLabelFontSize(SizeDefinition sizeDefinition) {
        this.labelFontSize = new SizeDefinition(12.0, null);
        if (sizeDefinition == null) {
            return;
        }
        this.labelFontSize.setValue(sizeDefinition.getValue());
        this.labelFontSize.setUnit(sizeDefinition.getUnit());
    }

    public void setLabelFontSize(float f, String string) {
        this.labelFontSize.setValue(f);
        this.labelFontSize.setUnit(string);
    }

    public void setAnchorPoint(double d, double d2) {
        if (d < 0.0 || d > 1.0 || d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Invalid anchor point x or y.");
        }
        this.anchorPoint[0] = d;
        this.anchorPoint[1] = d2;
    }

    public double[] getAnchorPoint() {
        return this.anchorPoint;
    }

    public void setAnchorX(double d) {
        this.anchorPoint[0] = d;
    }

    public double getAnchorX() {
        return this.anchorPoint[0];
    }

    public void setAnchorY(double d) {
        this.anchorPoint[1] = d;
    }

    public double getAnchorY() {
        return this.anchorPoint[1];
    }

    public double[] getSVGNaturalSize() {
        return this.svgNaturalSize;
    }

    public void setSVGNaturalSize(double[] dArray) {
        if (dArray != null && dArray.length >= 2) {
            this.svgNaturalSize = new double[]{dArray[0], dArray[1]};
        }
    }

    public void setRawSVGString(String string) {
        if (string != null) {
            this.rawSVGString = string.trim();
        }
    }

    public String getRawSVGString() {
        return this.rawSVGString;
    }

    @Override
    public String[] getStyleDependency() {
        String[] stringArray = null;
        if (this.ttf != null) {
            stringArray = new String[]{this.ttf.getName()};
        }
        return stringArray;
    }

    public SizeDefinition getLabelFontSize() {
        return this.labelFontSize;
    }
}

