/*
 * Decompiled with CFR 0.152.
 */
package oracle.mapviewer.share;

import java.util.Hashtable;

public class ArrayParameter {
    private String typeName = null;
    private Object value = null;
    private String dataSource = null;
    private static Hashtable descriptorTable = new Hashtable(10);

    public ArrayParameter(String string, Object object) {
        this.typeName = string;
        this.value = object;
    }

    public ArrayParameter(String string, Object object, String string2) {
        if (string != null) {
            this.typeName = string.toUpperCase();
        }
        this.value = object;
        if (string2 != null) {
            this.dataSource = string2.toUpperCase();
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        int n;
        Object[] objectArray;
        String string = "";
        if (this.value instanceof double[]) {
            objectArray = (double[])this.value;
            for (n = 0; n < objectArray.length; ++n) {
                if (n > 0) {
                    string = string + ":";
                }
                string = string + objectArray[n];
            }
        } else if (this.value instanceof int[]) {
            objectArray = (int[])this.value;
            for (n = 0; n < objectArray.length; ++n) {
                if (n > 0) {
                    string = string + ":";
                }
                string = string + (int)objectArray[n];
            }
        }
        if (this.value instanceof String[]) {
            objectArray = (String[])this.value;
            for (n = 0; n < objectArray.length; ++n) {
                if (n > 0) {
                    string = string + ":";
                }
                string = string + '\"' + objectArray[n].replace("\\", "\\\\").replace("\"", "\\\"") + '\"';
            }
        }
        return this.typeName + ";" + this.dataSource + ";" + string;
    }

    public static Hashtable getDescriptorTable() {
        return descriptorTable;
    }

    public void setDataSource(String string) {
        this.dataSource = string;
    }

    public String getDataSource() {
        return this.dataSource;
    }
}

