/*
 * Decompiled with CFR 0.152.
 */
package oracle.lbs.mapclient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleDriver;
import oracle.lbs.mapclient.MapViewer;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class SQLMapClient {
    private static MapViewer mv = null;
    private static Connection conn = null;
    private static ArrayDescriptor stringArrayDesc = null;
    private static ArrayDescriptor numberArrayDesc = null;
    private static ArrayDescriptor stringArrayDesc2D = null;
    private static ArrayDescriptor stringArrayDesc3D = null;

    public static ARRAY arrayTest(ARRAY aRRAY) throws SQLException {
        conn = new OracleDriver().defaultConnection();
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_1D_STRING_ARRAY", (Connection)conn);
        ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_2D_STRING_ARRAY", (Connection)conn);
        ArrayDescriptor arrayDescriptor3 = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_3D_STRING_ARRAY", (Connection)conn);
        Object object = aRRAY.getArray();
        Object[] objectArray = new Object[2];
        String[] stringArray = new String[]{"test1", "test2"};
        String[] stringArray2 = new String[]{"test3", "test4"};
        objectArray[0] = new ARRAY(arrayDescriptor, conn, (Object)stringArray);
        objectArray[1] = new ARRAY(arrayDescriptor, conn, (Object)stringArray2);
        return new ARRAY(arrayDescriptor2, conn, (Object)objectArray);
    }

    public static void createMapViewerClient(String string) throws SQLException {
        mv = new MapViewer(string);
        conn = new OracleDriver().defaultConnection();
        stringArrayDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_1D_STRING_ARRAY", (Connection)conn);
        stringArrayDesc2D = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_2D_STRING_ARRAY", (Connection)conn);
        stringArrayDesc3D = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_2D_STRING_ARRAY", (Connection)conn);
        numberArrayDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_NUMBER_ARRAY", (Connection)conn);
    }

    public static void setWebProxy(String string, String string2) {
        mv.setWebProxy(string, string2);
    }

    public static void init() {
        mv.init();
    }

    public static String getGeneratedMapImageURL() {
        return mv.getGeneratedMapImageURL();
    }

    public static String getServiceURL() {
        return mv.getServiceURL();
    }

    public static void setServiceURL(String string) {
        mv.setServiceURL(string);
    }

    public static String getDataSourceName() {
        return mv.getDataSourceName();
    }

    public static void setDataSourceName(String string) {
        mv.setDataSourceName(string);
    }

    public static String getBaseMapName() {
        return mv.getBaseMapName();
    }

    public static String dataSourceExists(String string) throws Exception {
        return SQLMapClient.booleanToString(mv.dataSourceExists(string));
    }

    public static ARRAY getDataSources() throws Exception {
        String[] stringArray = mv.getDataSources();
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static String styleExists(String string) throws Exception {
        return SQLMapClient.booleanToString(mv.styleExists(string));
    }

    public static void addDataSource(String string, String string2, int n, String string3, String string4, String string5, String string6, int n2) throws Exception {
        mv.addDataSource(string, string2, n, string3, string4, string5, string6, n2);
    }

    public static void setBaseMapName(String string) {
        mv.setBaseMapName(string);
    }

    public static void addThemesFromBaseMap(String string) throws Exception {
        mv.addThemesFromBaseMap(string);
    }

    public static void setBox(double d, double d2, double d3, double d4) {
        mv.setBox(d, d2, d3, d4);
    }

    public static ARRAY getRequestBox() throws SQLException {
        double[] dArray = mv.getRequestBox();
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static void setCenterAndSize(double d, double d2, double d3) {
        mv.setCenterAndSize(d, d2, d3);
    }

    public static void setCenter(double d, double d2) {
        mv.setCenter(d, d2);
    }

    public static void setSize(double d) {
        mv.setSize(d);
    }

    public static ARRAY getRequestCenter() throws SQLException {
        Point2D point2D = mv.getRequestCenter();
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static void setFullExtent() {
        mv.setFullExtent();
    }

    public static double getRequestSize() {
        return mv.getRequestSize();
    }

    public static String getMapTitle() {
        return mv.getMapTitle();
    }

    public static void setMapTitle(String string) {
        mv.setMapTitle(string);
    }

    public static void setBoundingThemes(ARRAY aRRAY, double d, String string) throws SQLException {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        mv.setBoundingThemes(stringArray, d, SQLMapClient.stringToBoolean(string));
    }

    public static ARRAY getBoundingThemes() throws SQLException {
        String[] stringArray = mv.getBoundingThemes();
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static double getBorderMarginForBoundingThemes() {
        return mv.getBorderMarginForBoundingThemes();
    }

    public static String boundingThemesRespectAspectRatio() {
        return SQLMapClient.booleanToString(mv.boundingThemesRespectAspectRatio());
    }

    public static void setMapResultFileName(String string) {
        mv.setMapResultFileName(string);
    }

    public static String getMapResultFileName() {
        return mv.getMapResultFileName();
    }

    public static void setDeviceSize(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        mv.setDeviceSize(dimension);
    }

    public static int getDeviceWidth() {
        return (int)mv.getDeviceSize().getWidth();
    }

    public static int getDeviceHeight() {
        return (int)mv.getDeviceSize().getHeight();
    }

    public static void setBackgroundColor(String string) {
        int n = 0;
        if (string == null) {
            return;
        }
        n = string.trim().startsWith("0x") || string.trim().startsWith("0X") ? Integer.parseInt(string.trim().substring(2), 16) : (string.trim().startsWith("#") ? Integer.parseInt(string.trim().substring(1), 16) : Integer.parseInt(string));
        mv.setBackgroundColor(new Color(n));
    }

    public static String getBackgroundColor() {
        return "0x" + Integer.toHexString(mv.getBackgroundColor().getRGB()).substring(2);
    }

    public static void setBackgroundImageURL(String string) {
        mv.setBackgroundImageURL(string);
    }

    public static String getBackgroundImageURL() {
        return mv.getBackgroundImageURL();
    }

    public static String isBackgroundTransparent() {
        return SQLMapClient.booleanToString(mv.isBackgroundTransparent());
    }

    public static void setBackgroundTransparent(String string) {
        mv.setBackgroundTransparent(SQLMapClient.stringToBoolean(string));
    }

    public static void setMapLegend(String string) {
        mv.setMapLegend(string);
    }

    public static String getMapLegend() {
        return mv.getMapLegend();
    }

    public static double getMapScale() {
        return mv.getMapScale();
    }

    public static void setAntiAliasing(String string) {
        mv.setAntiAliasing(SQLMapClient.stringToBoolean(string));
    }

    public static String getAntiAliasing() {
        return SQLMapClient.booleanToString(mv.getAntiAliasing());
    }

    public static void setImageScaling(String string) {
        mv.setImageScaling(SQLMapClient.stringToBoolean(string));
    }

    public static String getImageScaling() {
        return SQLMapClient.booleanToString(mv.getImageScaling());
    }

    public static ARRAY getEnabledThemes() throws SQLException {
        String[] stringArray = mv.getEnabledThemes();
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static void setImageFormat(String string) {
        int n = 3;
        if (string != null) {
            if (string.equalsIgnoreCase("PNG_URL")) {
                n = 13;
            }
            if (string.equalsIgnoreCase("PNG8_URL")) {
                n = 25;
            }
            if (string.equalsIgnoreCase("GIF_URL")) {
                n = 3;
            }
            if (string.equalsIgnoreCase("JPEG_URL")) {
                n = 21;
            }
        }
        mv.setImageFormat(n);
    }

    public static int getImageFormat() {
        return mv.getImageFormat();
    }

    public static int getNumGeoFeatures() {
        return mv.getNumGeoFeatures();
    }

    public static void setDefaultStyleForCenter(String string, String string2, String string3, ARRAY aRRAY) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.setDefaultStyleForCenter(string, string2, string3, dArray);
    }

    public static String getDefaultCenterRenderStyleName() {
        return mv.getDefaultCenterRenderStyleName();
    }

    public static String getDefaultCenterLabelStyleName() {
        return mv.getDefaultCenterLabelStyleName();
    }

    public static String getDefaultCenterLabel() {
        return mv.getDefaultCenterLabel();
    }

    public static ARRAY getDefaultCenterRadii() throws SQLException {
        double[] dArray = mv.getDefaultCenterRadii();
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static void addPointFeature(double d, double d2, int n, String string, String string2, String string3, ARRAY aRRAY, String string4) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.addPointFeature(d, d2, n, string, string2, string3, dArray, null, SQLMapClient.stringToBoolean(string4));
    }

    public static void addPointFeature(double d, double d2, int n, String string, String string2, String string3, ARRAY aRRAY) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.addPointFeature(d, d2, n, string, string2, string3, dArray, false);
    }

    public static void addPointFeature(double d, double d2, String string, String string2, String string3, ARRAY aRRAY) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.addPointFeature(d, d2, 0, string, string2, string3, dArray);
    }

    public static void addPointFeature(double d, double d2, int n, String string, String string2, String string3, ARRAY aRRAY, ARRAY aRRAY2, String string4) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        Object[] objectArray = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        mv.addPointFeature(d, d2, n, string, string2, string3, dArray, objectArray, 0.0, 0.0, 0.0, SQLMapClient.stringToBoolean(string4));
    }

    public static void addPointFeature(double d, double d2, int n, String string, String string2, String string3, ARRAY aRRAY, ARRAY aRRAY2, double d3, double d4, double d5, String string4) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        Object[] objectArray = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        mv.addPointFeature(d, d2, n, string, string2, string3, dArray, objectArray, d3, d4, d5, SQLMapClient.stringToBoolean(string4), null, false, null, null);
    }

    public static void addPointFeature(double d, double d2, int n, String string, String string2, String string3, ARRAY aRRAY, ARRAY aRRAY2, double d3, double d4, double d5, String string4, String string5, String string6, String string7, String string8) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        Object[] objectArray = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        mv.addPointFeature(d, d2, n, string, string2, string3, dArray, objectArray, d3, d4, d5, SQLMapClient.stringToBoolean(string4), string5, SQLMapClient.stringToBoolean(string6), string7, string8);
    }

    public static void addLinearFeature(ARRAY aRRAY, int n, String string, String string2, String string3, String string4) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.addLinearFeature(dArray, n, string, string2, string3, SQLMapClient.stringToBoolean(string4));
    }

    public static void addLinearFeature(ARRAY aRRAY, int n, String string, String string2, String string3) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.addLinearFeature(dArray, n, string, string2, string3, false);
    }

    public static void addLinearFeature(ARRAY aRRAY, String string, String string2, String string3) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.addLinearFeature(dArray, 0, string, string2, string3);
    }

    public static void removeAllPointFeatures() {
        mv.removeAllPointFeatures();
    }

    public static void removeAllLinearFeatures() {
        mv.removeAllLinearFeatures();
    }

    public static void enableThemes(ARRAY aRRAY) throws SQLException {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        mv.enableThemes(stringArray);
    }

    public static void setAllThemesEnabled(String string) {
        mv.setAllThemesEnabled(SQLMapClient.stringToBoolean(string));
    }

    public static int numPointFeatures() {
        return mv.numPointFeatures();
    }

    public static String hasThemes() {
        return SQLMapClient.booleanToString(mv.hasThemes());
    }

    public static int getThemePosition(String string) {
        return mv.getThemePosition(string);
    }

    public static String getThemeEnabled(String string) {
        return SQLMapClient.booleanToString(mv.getThemeEnabled(string));
    }

    public static String getThemeVisibleInSVG(String string) {
        return SQLMapClient.booleanToString(mv.getThemeVisibleInSVG(string));
    }

    public static ARRAY getMapMBR() throws SQLException {
        double[] dArray = mv.getMapMBR();
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static int addPredefinedTheme(int n, String string) {
        return mv.addPredefinedTheme(n, string);
    }

    public static int addPredefinedTheme(String string, String string2) {
        return mv.addPredefinedTheme(string, string2);
    }

    public static int addPredefinedTheme(int n, String string, String string2) {
        return mv.addPredefinedTheme(n, string, string2);
    }

    public static int addImageTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
        return mv.addImageTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, SQLMapClient.stringToBoolean(string13));
    }

    public static int addImageTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
        return mv.addImageTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, SQLMapClient.stringToBoolean(string13));
    }

    public static int addImageTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return mv.addImageTheme(string, string2, string3, string4, string5, string6, string7, SQLMapClient.stringToBoolean(string8));
    }

    public static int addImageTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return mv.addImageTheme(n, string, string2, string3, string4, string5, string6, string7, SQLMapClient.stringToBoolean(string8));
    }

    public static int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        return mv.addGeoRasterTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, SQLMapClient.stringToBoolean(string15));
    }

    public static int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        return mv.addGeoRasterTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, SQLMapClient.stringToBoolean(string15));
    }

    public static int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return mv.addGeoRasterTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, SQLMapClient.stringToBoolean(string10));
    }

    public static int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        return mv.addGeoRasterTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, SQLMapClient.stringToBoolean(string10));
    }

    public static int addGeoRasterTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        return mv.addGeoRasterTheme(string, string2, string3, string4, string5, string6, string7, string8, SQLMapClient.stringToBoolean(string9));
    }

    public static int addGeoRasterTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        return mv.addGeoRasterTheme(n, string, string2, string3, string4, string5, string6, string7, string8, SQLMapClient.stringToBoolean(string9));
    }

    public static int addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) {
        return mv.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, SQLMapClient.stringToBoolean(string14));
    }

    public static int addJDBCTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        return mv.addJDBCTheme(string, string2, string3, string4, string5, string6, string7, string8, SQLMapClient.stringToBoolean(string9));
    }

    public static int addJDBCTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14) {
        return mv.addJDBCTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, SQLMapClient.stringToBoolean(string14));
    }

    public static int addJDBCTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        return mv.addJDBCTheme(n, string, string2, string3, string4, string5, string6, string7, string8, SQLMapClient.stringToBoolean(string9));
    }

    public static int addTopologyTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        return mv.addTopologyTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, SQLMapClient.stringToBoolean(string11));
    }

    public static int addTopologyTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        return mv.addTopologyTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, SQLMapClient.stringToBoolean(string11));
    }

    public static int addTopologyDebugTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2, String string7, String string8, String string9, String string10, String string11, String string12) {
        return mv.addTopologyDebugTheme(n, string, string2, string3, string4, string5, string6, n2, string7, string8, string9, string10, string11, SQLMapClient.stringToBoolean(string12));
    }

    public static int addTopologyDebugTheme(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7, String string8, String string9, String string10, String string11, String string12) {
        return mv.addTopologyDebugTheme(string, string2, string3, string4, string5, string6, n, string7, string8, string9, string10, string11, SQLMapClient.stringToBoolean(string12));
    }

    public static int addNetworkTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, double d, int n2, String string7, int n3, String string8, String string9, int n4, String string10) {
        return mv.addNetworkTheme(n, string, string2, string3, string4, string5, string6, d, n2, string7, n3, string8, string9, n4, SQLMapClient.stringToBoolean(string10));
    }

    public static int addNetworkTheme(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, double d, int n2, String string12, int n3, String string13, String string14, int n4, String string15) {
        return mv.addNetworkTheme(n, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, d, n2, string12, n3, string13, string14, n4, SQLMapClient.stringToBoolean(string15));
    }

    public static int addNetworkTheme(String string, String string2, String string3, String string4, String string5, String string6, double d, int n, String string7, int n2, String string8, String string9, int n3, String string10) {
        return mv.addNetworkTheme(string, string2, string3, string4, string5, string6, d, n, string7, n2, string8, string9, n3, SQLMapClient.stringToBoolean(string10));
    }

    public static int addNetworkTheme(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, double d, int n, String string12, int n2, String string13, String string14, int n3, String string15) {
        return mv.addNetworkTheme(string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, d, n, string12, n2, string13, string14, n3, SQLMapClient.stringToBoolean(string15));
    }

    public static int addPredefinedTheme(String string) {
        return mv.addPredefinedTheme(string);
    }

    public static int addShortestPath(int n, String string, String string2, String string3, String string4, int n2, int n3, String string5, String string6, String string7, String string8, int n4, String string9) {
        return mv.addShortestPath(n, string, string2, string3, string4, n2, n3, string5, string6, string7, string8, n4, SQLMapClient.stringToBoolean(string9));
    }

    public static int addShortestPath(String string, String string2, String string3, String string4, int n, int n2, String string5, String string6, String string7, String string8, int n3, String string9) {
        return mv.addShortestPath(string, string2, string3, string4, n, n2, string5, string6, string7, string8, n3, SQLMapClient.stringToBoolean(string9));
    }

    public static int addNetworkLinks(String string, String string2, String string3, String string4, String string5, String string6, double d, int n, int n2, String string7) {
        return mv.addNetworkTheme(string, string2, string3, string4, string5, string6, d, n, null, 3, null, null, n2, SQLMapClient.stringToBoolean(string7));
    }

    public static int addNetworkNodes(String string, String string2, String string3, String string4, String string5, int n, int n2, String string6) {
        return mv.addNetworkTheme(string, string2, string3, string4, null, null, 0.75, 3, string5, n, null, null, n2, SQLMapClient.stringToBoolean(string6));
    }

    public static int addNetworkPaths(String string, String string2, String string3, String string4, String string5, String string6, int n, String string7) {
        return mv.addNetworkTheme(string, string2, string3, string4, null, null, 0.75, 3, null, 3, string5, string6, n, SQLMapClient.stringToBoolean(string7));
    }

    public static int addLinksWithinCost(String string, String string2, String string3, int n, String string4, String string5, double d, String string6, int n2, String string7) {
        return mv.addLinksWithinCost(string, string2, string3, n, string4, string5, d, string6, n2, SQLMapClient.stringToBoolean(string7));
    }

    public static int addWMSMapTheme(String string, String string2, ARRAY aRRAY, ARRAY aRRAY2, ARRAY aRRAY3) throws SQLException {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        Object[] objectArray = aRRAY3 == null ? null : (Object[])aRRAY3.getArray();
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] == null ? null : (String[])((ARRAY)objectArray[i]).getArray();
            }
        }
        return mv.addWMSMapTheme(string, string2, "false", "1.1.1", stringArray, stringArray2, "EPSG:4326", "image/png", "true", "0xffffff", "application/vnd.ogc.se_inimage", objectArray2);
    }

    public static int addWMSMapTheme(String string, String string2, ARRAY aRRAY, ARRAY aRRAY2, String string3, String string4, String string5, ARRAY aRRAY3) throws SQLException {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        Object[] objectArray = aRRAY3 == null ? null : (Object[])aRRAY3.getArray();
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] == null ? null : (String[])((ARRAY)objectArray[i]).getArray();
            }
        }
        return mv.addWMSMapTheme(string, string2, "false", "1.1.1", stringArray, stringArray2, string3, string4, "true", string5, "application/vnd.ogc.se_inimage", objectArray2);
    }

    public static int addWMSMapTheme(String string, String string2, String string3, String string4, ARRAY aRRAY, ARRAY aRRAY2, String string5, String string6, String string7, String string8, String string9, ARRAY aRRAY3) throws SQLException {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        Object[] objectArray = aRRAY3 == null ? null : (Object[])aRRAY3.getArray();
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] == null ? null : (String[])((ARRAY)objectArray[i]).getArray();
            }
        }
        return mv.addWMSMapTheme(string, string2, string3, string4, stringArray, stringArray2, string5, string6, string7, string8, string9, objectArray2);
    }

    public static int addMapCacheTheme(String string, String string2, String string3, String string4) throws SQLException {
        return mv.addMapCacheTheme(string, string2, string3, SQLMapClient.stringToBoolean(string4));
    }

    public static void deleteTheme(String string) {
        mv.deleteTheme(string);
    }

    public static void deleteAllThemes() {
        mv.deleteAllThemes();
    }

    public static void setThemeEnabled(String string, String string2) {
        mv.setThemeEnabled(SQLMapClient.stringToBoolean(string), string2);
    }

    public static void setLabelAlwaysOn(String string, String string2) {
        mv.setLabelAlwaysOn(SQLMapClient.stringToBoolean(string), string2);
    }

    public static void setClickable(String string, String string2) {
        mv.setClickable(SQLMapClient.stringToBoolean(string), string2);
    }

    public static String isClickable(String string) {
        return SQLMapClient.booleanToString(mv.isClickable(string));
    }

    public static void moveThemeUp(int n) {
        mv.moveThemeUp(n);
    }

    public static void moveThemeDown(int n) {
        mv.moveThemeDown(n);
    }

    public static String getActiveTheme(double d) {
        return mv.getActiveTheme(d);
    }

    public static void setThemeScale(String string, double d, double d2) {
        mv.setThemeScale(string, d, d2);
    }

    public static void setThemeRequestTimeout(String string, long l) {
        mv.setThemeRequestTimeout(string, l);
    }

    public static void setThemeVisibleInSVG(String string, String string2) {
        mv.setThemeVisibleInSVG(string, SQLMapClient.stringToBoolean(string2));
    }

    public static void setThemePartOfBaseMapInSVG(String string, String string2) {
        mv.setThemePartOfBaseMapInSVG(string, SQLMapClient.stringToBoolean(string2));
    }

    public static void setThemeSelectableInSVG(String string, String string2) {
        mv.setThemeSelectableInSVG(string, SQLMapClient.stringToBoolean(string2));
    }

    public static void setThemeOnClickInSVG(String string, String string2) {
        mv.setThemeOnClickInSVG(string, string2);
    }

    public static void setThemeOnMouseMoveInSVG(String string, String string2) {
        mv.setThemeOnMouseMoveInSVG(string, string2);
    }

    public static void setThemeOnMouseOverInSVG(String string, String string2) {
        mv.setThemeOnMouseOverInSVG(string, string2);
    }

    public static void setThemeOnMouseOutInSVG(String string, String string2) {
        mv.setThemeOnMouseOutInSVG(string, string2);
    }

    public static void setThemeMinDistForSVG(String string, int n) {
        mv.setThemeMinDistForSVG(string, n);
    }

    public static void setJDBCThemeKeyColumn(String string, String string2) {
        mv.setJDBCThemeKeyColumn(string, string2);
    }

    public static void setJDBCThemeHiddenInfoDef(String string, String string2) {
        mv.setJDBCThemeHiddenInfoDef(string, string2);
    }

    public static void setSVGShowInfo(String string) {
        mv.setSVGShowInfo(SQLMapClient.stringToBoolean(string));
    }

    public static void setThemeFastUnpickle(String string, String string2) {
        mv.setThemeFastUnpickle(string, SQLMapClient.stringToBoolean(string2));
    }

    public static void setThemeReorientLines(String string, String string2) {
        mv.setThemeReorientLines(string, SQLMapClient.stringToBoolean(string2));
    }

    public static void setGeoRasterThemePolygonMask(String string, ARRAY aRRAY) throws SQLException {
        BigDecimal[] bigDecimalArray = aRRAY == null ? null : (BigDecimal[])aRRAY.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        mv.setGeoRasterThemePolygonMask(string, dArray);
    }

    public static void setNetworkThemeLabels(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        mv.setNetworkThemeLabels(string, string2, string3, string4, string5, string6, string7);
    }

    public static void setThemeUnitAndResolution(String string, String string2, double d) {
        mv.setThemeUnitAndResolution(string, string2, d);
    }

    public static void setThemeAlpha(String string, float f) {
        mv.setThemeAlpha(string, f);
    }

    public static void setThemeWorkspace(String string, String string2) {
        mv.setThemeWorkspace(string, string2);
    }

    public static void setThemeWorkspaceSavedPoint(String string, String string2) {
        mv.setThemeWorkspaceSavedPoint(string, string2);
    }

    public static void setThemeWorkspaceDate(String string, String string2) {
        mv.setThemeWorkspaceDate(string, string2);
    }

    public static void setThemeWorkspaceDateFormat(String string, String string2, String string3, String string4) {
        mv.setThemeWorkspaceDateFormat(string, string2, string3, SQLMapClient.stringToBoolean(string4));
    }

    public static void setThemePixelsForGeneralizedView(String string, int n) {
        mv.setThemePixelsForGeneralizedView(string, n);
    }

    public static ARRAY getThemeNames() throws SQLException {
        String[] stringArray = mv.getThemeNames();
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static String run() throws Exception {
        return SQLMapClient.booleanToString(mv.run());
    }

    public static ARRAY getPredefinedThemes(String string) throws Exception {
        String[] stringArray = mv.getPredefinedThemes(string);
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static ARRAY getPredefinedThemes(String string, String string2) throws Exception {
        String[] stringArray = mv.getPredefinedThemes(string, string2);
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static ARRAY getBaseMapNames(String string) throws Exception {
        String[] stringArray = mv.getBaseMapNames(string);
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static ARRAY getPermanentStyles(String string, String string2) throws Exception {
        String[] stringArray = mv.getPermanentStyles(string, string2);
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static String zoomIn(double d) throws Exception {
        return SQLMapClient.booleanToString(mv.zoomIn(d));
    }

    public static String zoomOut(double d) throws Exception {
        return SQLMapClient.booleanToString(mv.zoomOut(d));
    }

    public static String zoomOut(int n, int n2, double d) throws Exception {
        return SQLMapClient.booleanToString(mv.zoomOut(n, n2, d));
    }

    public static String zoomIn(int n, int n2, int n3, int n4) throws Exception {
        return SQLMapClient.booleanToString(mv.zoomIn(n, n2, n3, n4));
    }

    public static String zoomIn(int n, int n2, double d) throws Exception {
        return SQLMapClient.booleanToString(mv.zoomIn(n, n2, d));
    }

    public static String pan(int n, int n2) throws Exception {
        return SQLMapClient.booleanToString(mv.pan(n, n2));
    }

    public static ARRAY getUserPoint(int n, int n2) throws SQLException {
        Point2D point2D = mv.getUserPoint(n, n2);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static ARRAY getUserPoint(int n, int n2, String string, int n3) throws SQLException {
        Point2D point2D = mv.getUserPoint(n, n2, string, n3);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static ARRAY getUserPoint(int n, int n2, String string, String string2, String string3, String string4, String string5, String string6, int n3) throws SQLException {
        Point2D point2D = mv.getUserPoint(n, n2, string, string2, string3, string4, string5, string6, n3);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static ARRAY getUserPoint(int n, int n2, String string, String string2) throws SQLException {
        Point2D point2D = mv.getUserPoint(n, n2, string, string2);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return new ARRAY(numberArrayDesc, conn, (Object)dArray);
    }

    public static ARRAY doQuery(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        String[][] stringArray = mv.doQuery(string, string2, string3, string4, string5, string6, string7);
        ARRAY[] aRRAYArray = null;
        if (stringArray != null && stringArray.length > 0) {
            aRRAYArray = new ARRAY[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY doQuery(String string, String string2) throws Exception {
        String[][] stringArray = mv.doQuery(string, string2);
        Object[] objectArray = null;
        if (stringArray != null && stringArray.length > 0) {
            objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                objectArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, objectArray);
    }

    public static ARRAY doQueryInMapWindow(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n, String string9) throws Exception {
        String[][] stringArray = mv.doQueryInMapWindow(string, string2, string3, string4, string5, string6, string7, string8, n, SQLMapClient.stringToBoolean(string9));
        ARRAY[] aRRAYArray = null;
        if (stringArray != null && stringArray.length > 0) {
            aRRAYArray = new ARRAY[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY doQueryInMapWindow(String string, String string2, String string3, int n, String string4) throws Exception {
        String[][] stringArray = mv.doQueryInMapWindow(string, string2, string3, n, SQLMapClient.stringToBoolean(string4));
        ARRAY[] aRRAYArray = null;
        if (stringArray != null && stringArray.length > 0) {
            aRRAYArray = new ARRAY[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static String getSpatialFilter(String string, int n, String string2) {
        return mv.getSpatialFilter(string, n, SQLMapClient.stringToBoolean(string2));
    }

    public static String getSpatialFilter(String string, int n, double d, double d2, double d3, double d4, String string2) {
        return mv.getSpatialFilter(string, n, d, d2, d3, d4, SQLMapClient.stringToBoolean(string2));
    }

    public static String getWhereClauseForAnyInteract(String string, int n, double d, double d2, double d3, double d4, String string2) {
        return mv.getWhereClauseForAnyInteract(string, n, d, d2, d3, d4, SQLMapClient.stringToBoolean(string2));
    }

    public static String getWhereClauseForAnyInteract(String string, int n, double d, double d2) {
        return mv.getWhereClauseForAnyInteract(string, n, d, d2);
    }

    public static String getWhereClauseForNN(String string, int n, double d, double d2) {
        return mv.getWhereClauseForNN(string, n, d, d2);
    }

    public static ARRAY queryWithinRadius(String string, String string2, ARRAY aRRAY, String string3, double d, double d2, double d3, String string4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.queryWithinRadius(string, string2, stringArray, string3, d, d2, d3, SQLMapClient.stringToBoolean(string4));
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY queryAtPoint(String string, String string2, ARRAY aRRAY, double d, double d2, String string3, String string4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.queryAtPoint(string, string2, stringArray, d, d2, string3, SQLMapClient.stringToBoolean(string4));
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY queryWithinRectangle(String string, String string2, ARRAY aRRAY, double d, double d2, double d3, double d4, String string3, String string4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.queryWithinRectangle(string, string2, stringArray, d, d2, d3, d4, string3, SQLMapClient.stringToBoolean(string4));
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY queryWithinArea(String string, String string2, ARRAY aRRAY, ARRAY aRRAY2, String string3, String string4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        BigDecimal[] bigDecimalArray = aRRAY2 == null ? null : (BigDecimal[])aRRAY2.getArray();
        double[] dArray = null;
        if (bigDecimalArray != null && bigDecimalArray.length > 0) {
            dArray = new double[bigDecimalArray.length];
            for (int i = 0; i < bigDecimalArray.length; ++i) {
                dArray[i] = bigDecimalArray[i].doubleValue();
            }
        }
        String[][] stringArray2 = mv.queryWithinArea(string, string2, stringArray, dArray, string3, SQLMapClient.stringToBoolean(string4));
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY queryNN(String string, String string2, ARRAY aRRAY, int n, double d, double d2, String string3, String string4, String string5) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.queryNN(string, string2, stringArray, n, d, d2, string3, SQLMapClient.stringToBoolean(string4), string5);
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY identify(String string, String string2, String string3, String string4, String string5, String string6, String string7, ARRAY aRRAY, String string8, int n, int n2, int n3, int n4, int n5, String string9) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.identify(string, string2, string3, string4, string5, string6, string7, stringArray, string8, n, n2, n3, n4, n5, SQLMapClient.stringToBoolean(string9));
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY identify(String string, String string2, ARRAY aRRAY, String string3, int n, int n2, int n3, int n4, int n5, String string4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.identify(string, string2, stringArray, string3, n, n2, n3, n4, n5, SQLMapClient.stringToBoolean(string4));
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY identify(String string, String string2, String string3, String string4, String string5, String string6, String string7, ARRAY aRRAY, String string8, int n, int n2, int n3) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.identify(string, string2, string3, string4, string5, string6, string7, stringArray, string8, n, n2, n3);
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static ARRAY identify(String string, String string2, ARRAY aRRAY, String string3, int n, int n2, int n3) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[][] stringArray2 = mv.identify(string, string2, stringArray, string3, n, n2, n3);
        ARRAY[] aRRAYArray = null;
        if (stringArray2 != null && stringArray2.length > 0) {
            aRRAYArray = new ARRAY[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                aRRAYArray[i] = new ARRAY(stringArrayDesc, conn, (Object)stringArray2[i]);
            }
        }
        return new ARRAY(stringArrayDesc2D, conn, aRRAYArray);
    }

    public static String getMapRequestString() {
        return mv.getMapRequestString();
    }

    public static String getMapResponseString() {
        return mv.getMapResponseString();
    }

    public static ARRAY getMapResponseThemeNames() throws Exception {
        String[] stringArray = mv.getMapResponseThemeNames();
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static void sendXMLRequest(String string) throws Exception {
        mv.sendXMLRequest(string);
    }

    public static String getXMLResponse() throws Exception {
        return mv.getXMLResponse();
    }

    public static ARRAY listAllDynamicStyles() throws SQLException {
        String[] stringArray = mv.listAllDynamicStyles();
        return new ARRAY(stringArrayDesc, conn, (Object)stringArray);
    }

    public static void removeAllDynamicStyles() throws Exception {
        mv.removeAllDynamicStyles();
    }

    public static void deleteStyle(String string) throws Exception {
        mv.deleteStyle(string);
    }

    public static void addImageMarkerFromURL(String string, String string2) throws Exception {
        mv.addImageMarkerFromURL(string2, string);
    }

    public static void addImageMarkerStyleFromURL(String string, String string2) throws Exception {
        mv.addImageMarkerStyleFromURL(string, string2);
    }

    public static void addImageMarkerStyleFromURL(String string, String string2, int n, int n2, String string3, int n3, String string4, String string5, String string6) throws Exception {
        mv.addImageMarkerStyleFromURL(string, string2, n, n2, string3, n3, string4, string5, string6);
    }

    public static void addImageAreaFromURL(String string, String string2) throws Exception {
        SQLMapClient.addImageAreaStyleFromURL(string2, string);
    }

    public static void addImageAreaStyleFromURL(String string, String string2) throws Exception {
        mv.addImageAreaStyleFromURL(string, string2);
    }

    public static void addImageAreaStyleFromURL(String string, String string2, String string3, float f, int n) throws Exception {
        mv.addImageAreaStyleFromURL(string, string2, string3, f, n);
    }

    public static void addImageAreaStyleFromURL(String string, String string2, String string3) throws Exception {
        mv.addImageAreaStyleFromURL(string, string2, string3);
    }

    public static void addColorStyle(String string, String string2, String string3, int n, int n2) throws Exception {
        mv.addColorStyle(string, string2, string3, n, n2);
    }

    public static void addMarkerStyle(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        mv.addMarkerStyle(string, n, string2, string3, string4, string5, string6, string7);
    }

    public static void addCollectionBucketStyle(String string, ARRAY aRRAY, ARRAY aRRAY2, ARRAY aRRAY3) throws Exception {
        Object[] objectArray = aRRAY3 == null ? null : (Object[])aRRAY3.getArray();
        String[][] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length][];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = objectArray[i] == null ? null : (String[])((ARRAY)objectArray[i]).getArray();
            }
        }
        String[] stringArray2 = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray3 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        mv.addCollectionBucketStyle(string, stringArray2, stringArray3, stringArray);
    }

    public static void addRangedBucketStyle(String string, ARRAY aRRAY, ARRAY aRRAY2, ARRAY aRRAY3, ARRAY aRRAY4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        String[] stringArray3 = aRRAY3 == null ? null : (String[])aRRAY3.getArray();
        String[] stringArray4 = aRRAY4 == null ? null : (String[])aRRAY4.getArray();
        mv.addRangedBucketStyle(string, stringArray, stringArray2, stringArray3, stringArray4);
    }

    public static void addRangedBucketStyle(String string, ARRAY aRRAY, ARRAY aRRAY2, ARRAY aRRAY3, ARRAY aRRAY4, String string2) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        String[] stringArray3 = aRRAY3 == null ? null : (String[])aRRAY3.getArray();
        String[] stringArray4 = aRRAY4 == null ? null : (String[])aRRAY4.getArray();
        mv.addRangedBucketStyle(string, stringArray, stringArray2, stringArray3, stringArray4, string2);
    }

    public static void addBucketStyle(String string, String string2, String string3, int n, ARRAY aRRAY) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        mv.addBucketStyle(string, string2, string3, n, stringArray);
    }

    public static void addBucketStyle(String string, String string2, String string3, int n, ARRAY aRRAY, String string4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        mv.addBucketStyle(string, string2, string3, n, stringArray, string4);
    }

    public static void addColorSchemeStyle(String string, String string2, String string3, ARRAY aRRAY, ARRAY aRRAY2, ARRAY aRRAY3) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        String[] stringArray3 = aRRAY3 == null ? null : (String[])aRRAY3.getArray();
        mv.addColorSchemeStyle(string, string2, string3, stringArray, stringArray2, stringArray3);
    }

    public static void addColorSchemeStyle(String string, String string2, String string3, ARRAY aRRAY, ARRAY aRRAY2, ARRAY aRRAY3, String string4) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        String[] stringArray3 = aRRAY3 == null ? null : (String[])aRRAY3.getArray();
        mv.addColorSchemeStyle(string, string2, string3, stringArray, stringArray2, stringArray3, string4);
    }

    public static void addColorSchemeStyle(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        mv.addColorSchemeStyle(string, string2, string3, string4, string5, n);
    }

    public static void addColorSchemeStyle(String string, String string2, String string3, String string4, String string5, int n, String string6) throws Exception {
        mv.addColorSchemeStyle(string, string2, string3, string4, string5, n, string6);
    }

    public static void addVariableMarkerStyle(String string, ARRAY aRRAY, String string2, int n, int n2, ARRAY aRRAY2, ARRAY aRRAY3) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        String[] stringArray3 = aRRAY3 == null ? null : (String[])aRRAY3.getArray();
        mv.addVariableMarkerStyle(string, stringArray, string2, n, n2, stringArray2, stringArray3);
    }

    public static void addVariableMarkerStyle(String string, ARRAY aRRAY, String string2, int n, int n2, ARRAY aRRAY2, ARRAY aRRAY3, String string3) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        String[] stringArray3 = aRRAY3 == null ? null : (String[])aRRAY3.getArray();
        mv.addVariableMarkerStyle(string, stringArray, string2, n, n2, stringArray2, stringArray3, string3);
    }

    public static void addPieChartStyle(String string, String string2, ARRAY aRRAY, ARRAY aRRAY2) throws Exception {
        String[] stringArray = aRRAY == null ? null : (String[])aRRAY.getArray();
        String[] stringArray2 = aRRAY2 == null ? null : (String[])aRRAY2.getArray();
        mv.addPieChartStyle(string, string2, stringArray, stringArray2);
    }

    public static void addTextStyle(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        mv.addTextStyle(string, string2, string3, string4, string5, string6);
    }

    public static void addTextStyleWithHalo(String string, String string2, String string3, String string4, String string5, String string6, double d) {
        mv.addTextStyleWithHalo(string, string2, string3, string4, string5, string6, d);
    }

    public static void addLineStyle(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) throws Exception {
        mv.addLineStyle(string, string2, string3, SQLMapClient.stringToBoolean(string4), string5, string6, string7, SQLMapClient.stringToBoolean(string8), string9, string10, SQLMapClient.stringToBoolean(string11), string12, string13, null, 0.0, 8);
    }

    public static void addLineStyle(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, double d, int n) throws Exception {
        mv.addLineStyle(string, string2, string3, SQLMapClient.stringToBoolean(string4), string5, string6, string7, SQLMapClient.stringToBoolean(string8), string9, string10, SQLMapClient.stringToBoolean(string11), string12, string13, string14, d, n);
    }

    public static void setMapLegend(String string, String string2, String string3, String string4, String string5, ARRAY aRRAY) throws SQLException {
        Object[] objectArray = aRRAY == null ? null : (Object[])aRRAY.getArray();
        String[][][] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length][][];
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2;
                Object[] objectArray3 = objectArray2 = objectArray[i] == null ? null : (Object[])((ARRAY)objectArray[i]).getArray();
                if (objectArray2 == null) continue;
                stringArray[i] = new String[objectArray2.length][];
                for (int j = 0; j < objectArray2.length; ++j) {
                    stringArray[i][j] = objectArray2[i] == null ? null : (String[])((ARRAY)objectArray2[j]).getArray();
                }
            }
        }
        mv.setMapLegend(string, string2, string3, string4, string5, stringArray);
    }

    public static void setMapLegend(String string, String string2, String string3, String string4, String string5, String string6, ARRAY aRRAY) throws SQLException {
        Object[] objectArray = aRRAY == null ? null : (Object[])aRRAY.getArray();
        String[][][] stringArray = null;
        if (objectArray != null) {
            stringArray = new String[objectArray.length][][];
            for (int i = 0; i < objectArray.length; ++i) {
                Object[] objectArray2;
                Object[] objectArray3 = objectArray2 = objectArray[i] == null ? null : (Object[])((ARRAY)objectArray[i]).getArray();
                if (objectArray2 == null) continue;
                stringArray[i] = new String[objectArray2.length][];
                for (int j = 0; j < objectArray2.length; ++j) {
                    stringArray[i][j] = objectArray2[i] == null ? null : (String[])((ARRAY)objectArray2[j]).getArray();
                }
            }
        }
        mv.setMapLegend(string, string2, string3, string4, string5, string6, stringArray);
    }

    public static void deleteMapLegend() {
        mv.deleteMapLegend();
    }

    public static void setMapRequestSRID(int n) {
        mv.setMapRequestSRID(n);
    }

    public static int getMapRequestSRID() {
        return mv.getMapRequestSRID();
    }

    public static String doXMLEscape(String string) {
        return MapViewer.doXMLEscape(string);
    }

    public static void setSVGZoomRatio(double d) {
        mv.setSVGZoomRatio(d);
    }

    public static void setShowSVGNavBar(String string) {
        mv.setShowSVGNavBar(SQLMapClient.stringToBoolean(string));
    }

    public static void setSVGZoomLevels(int n) {
        mv.setSVGZoomLevels(n);
    }

    public static void setSVGZoomFactor(double d) {
        mv.setSVGZoomFactor(d);
    }

    public static void setSVGOnClick(String string) {
        mv.setSVGOnClick(string);
    }

    public static void setSVGOnMouseMove(String string) {
        mv.setSVGOnMouseMove(string);
    }

    public static void setSVGOnRectangleSelect(String string) {
        mv.setSVGOnRectangleSelect(string);
    }

    public static void setSVGOnPolygonSelect(String string) {
        mv.setSVGOnPolygonSelect(string);
    }

    public static void setRenderRasterBaseMapInSVG(String string) {
        mv.setRenderRasterBaseMapInSVG(SQLMapClient.stringToBoolean(string));
    }

    public static void setSVGFragmentType(int n) {
        mv.setSVGFragmentType(n);
    }

    public static void setSVGFragmentInDeviceCoord(String string) {
        mv.setSVGFragmentInDeviceCoord(SQLMapClient.stringToBoolean(string));
    }

    public static String getSVGStreamAsString() {
        return mv.getSVGStreamAsString();
    }

    public static String getThemeAsHTMLAreas(String string, String string2) {
        return mv.getThemeAsHTMLAreas(string, SQLMapClient.stringToBoolean(string2));
    }

    public static void setWorkspaceNameForInfoRequest(String string) {
        mv.setWorkspaceNameForInfoRequest(string);
    }

    public static void setWorkspaceSavedPointForInfoRequest(String string) {
        mv.setWorkspaceSavedPointForInfoRequest(string);
    }

    public static void setWorkspaceDateForInfoRequest(String string) {
        mv.setWorkspaceDateForInfoRequest(string);
    }

    public static void setWorkspaceDateFormatForInfoRequest(String string, String string2, String string3) {
        mv.setWorkspaceDateFormatForInfoRequest(string, string2, SQLMapClient.stringToBoolean(string3));
    }

    public static void resetWorkspaceAttributesForInfoRequest() {
        mv.resetWorkspaceAttributesForInfoRequest();
    }

    public static String putCustomProperty(String string, String string2) {
        Object object = mv.putCustomProperty(string, string2);
        return object == null ? null : object.toString();
    }

    public static String getCustomProperty(String string) {
        Object object = mv.getCustomProperty(string);
        return object == null ? null : object.toString();
    }

    public static String removeCustomProperty(String string) {
        Object object = mv.removeCustomProperty(string);
        return object == null ? null : object.toString();
    }

    public static void clearCustomProperties() {
        mv.clearCustomProperties();
    }

    private static String booleanToString(boolean bl) {
        if (bl) {
            return "TRUE";
        }
        return "FALSE";
    }

    private static boolean stringToBoolean(String string) {
        return "TRUE".equalsIgnoreCase(string);
    }
}

