/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy.stmtlogging;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.proxy.stmtlogging.IStmtLoggingPage;
import oracle.dbtools.raptor.proxy.stmtlogging.StmtLogRecord;

public class StmtLogPaneHandler {
    private static StmtLogPaneHandler INSTANCE;
    private static final Object INSTANCE_LOCK;
    private static final Logger BASE_LOGGER;
    private Queue<StmtLogRecord> m_records = new ConcurrentLinkedQueue<StmtLogRecord>();
    private volatile Class<IStmtLoggingPage> _logPageClass;
    private transient Runnable _logRunner;
    private volatile IStmtLoggingPage _logPage;

    private StmtLogPaneHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StmtLogPaneHandler getInstance() {
        if (INSTANCE == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new StmtLogPaneHandler();
                }
            }
        }
        return INSTANCE;
    }

    public void close() throws SecurityException {
    }

    public void flush() {
        this.logMessages(true);
    }

    public void publish(StmtLogRecord stmtLogRecord) {
        assert (stmtLogRecord != null);
        if (this.isLoggable(stmtLogRecord)) {
            this.m_records.add(stmtLogRecord);
            this.logMessages(false);
        }
    }

    private boolean isLoggable(StmtLogRecord stmtLogRecord) {
        return true;
    }

    public void setLogPageClass(Class clazz) {
        assert (clazz != null);
        this._logPageClass = clazz;
    }

    private void logMessages(boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.logMessages();
        } else if (bl || null == this._logRunner) {
            this._logRunner = new Runnable(){

                @Override
                public void run() {
                    StmtLogPaneHandler.this._logRunner = null;
                    StmtLogPaneHandler.this.logMessages();
                }
            };
            SwingUtilities.invokeLater(this._logRunner);
        }
    }

    private void logMessages() {
        StmtLogRecord stmtLogRecord;
        assert (SwingUtilities.isEventDispatchThread());
        IStmtLoggingPage iStmtLoggingPage = this.getLogPage();
        while ((stmtLogRecord = this.m_records.poll()) != null) {
            if (iStmtLoggingPage == null) continue;
            iStmtLoggingPage.log(stmtLogRecord);
        }
    }

    private void setLogPage(IStmtLoggingPage iStmtLoggingPage) {
        this._logPage = iStmtLoggingPage;
    }

    private IStmtLoggingPage getLogPage() {
        if (this._logPageClass != null) {
            try {
                IStmtLoggingPage iStmtLoggingPage = this._logPageClass.newInstance();
                this._logPageClass = null;
                this.setLogPage(iStmtLoggingPage);
            }
            catch (InstantiationException instantiationException) {
                BASE_LOGGER.log(Level.SEVERE, instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                BASE_LOGGER.log(Level.SEVERE, illegalAccessException.getMessage());
            }
        }
        return this._logPage;
    }

    static {
        INSTANCE_LOCK = new Object();
        BASE_LOGGER = Logger.getLogger("oracle.dbtools");
    }
}

