/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy.stmtlogging;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

abstract class RowTableModel<T>
extends AbstractTableModel {
    protected List<T> modelData;
    protected List<String> columnNames;
    protected Class[] columnClasses;
    protected Boolean[] isColumnEditable;
    private Class rowClass = Object.class;
    private boolean isModelEditable = true;

    protected RowTableModel(Class clazz) {
        this.setRowClass(clazz);
    }

    protected RowTableModel(List<String> list) {
        this(new ArrayList(), list);
    }

    protected RowTableModel(List<T> list, List<String> list2) {
        this.setDataAndColumnNames(list, list2);
    }

    protected RowTableModel(List<T> list, List<String> list2, Class clazz) {
        this.setDataAndColumnNames(list, list2);
        this.setRowClass(clazz);
    }

    protected RowTableModel(List<String> list, Class clazz) {
        this.setDataAndColumnNames(new ArrayList(), list);
        this.setRowClass(clazz);
    }

    protected void setDataAndColumnNames(List<T> list, List<String> list2) {
        this.modelData = list;
        this.columnNames = list2;
        this.columnClasses = new Class[this.getColumnCount()];
        this.isColumnEditable = new Boolean[this.getColumnCount()];
        this.fireTableStructureChanged();
    }

    protected void setRowClass(Class clazz) {
        this.rowClass = clazz;
    }

    public Class getColumnClass(int n) {
        Class<?> clazz = null;
        if (n < this.columnClasses.length) {
            clazz = this.columnClasses[n];
        }
        if (clazz == null) {
            clazz = super.getColumnClass(n);
        }
        return clazz;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public String getColumnName(int n) {
        Object object = null;
        if (n < this.columnNames.size()) {
            object = this.columnNames.get(n);
        }
        return object == null ? super.getColumnName(n) : object.toString();
    }

    @Override
    public int getRowCount() {
        return this.modelData.size();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Boolean bl = null;
        if (n2 < this.isColumnEditable.length) {
            bl = this.isColumnEditable[n2];
        }
        return bl == null ? this.isModelEditable : bl;
    }

    public void addRow(T t) {
        this.insertRow(this.getRowCount(), t);
    }

    public T getRow(int n) {
        return this.modelData.get(n);
    }

    public T[] getRowsAsArray(int ... nArray) {
        List<Object> list = this.getRowsAsList(nArray);
        Object[] objectArray = (Object[])Array.newInstance(this.rowClass, list.size());
        return list.toArray(objectArray);
    }

    public List<T> getRowsAsList(int ... nArray) {
        ArrayList<T> arrayList = new ArrayList<T>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getRow(nArray[i]));
        }
        return arrayList;
    }

    public void insertRow(int n, T t) {
        this.modelData.add(n, t);
        this.fireTableRowsInserted(n, n);
    }

    public void insertRows(int n, List<T> list) {
        this.modelData.addAll(n, list);
        this.fireTableRowsInserted(n, n + list.size() - 1);
    }

    public void insertRows(int n, T[] TArray) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            arrayList.add(TArray[i]);
        }
        this.insertRows(n, arrayList);
    }

    public void moveRow(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n < 0) {
            String string = "Start index must be positive: " + n;
            throw new IllegalArgumentException(string);
        }
        if (n2 > this.getRowCount() - 1) {
            String string = "End index must be less than total rows: " + n2;
            throw new IllegalArgumentException(string);
        }
        if (n > n2) {
            String string = "Start index cannot be greater than end index";
            throw new IllegalArgumentException(string);
        }
        int n6 = n2 - n + 1;
        if (n3 < 0 || n3 > this.getRowCount() - n6) {
            String string = "New destination row (" + n3 + ") is invalid";
            throw new IllegalArgumentException(string);
        }
        ArrayList<T> arrayList = new ArrayList<T>(n6);
        for (n5 = n; n5 < n2 + 1; ++n5) {
            arrayList.add(this.modelData.get(n5));
        }
        this.modelData.subList(n, n2 + 1).clear();
        this.modelData.addAll(n3, arrayList);
        if (n3 < n) {
            n5 = n3;
            n4 = n2;
        } else {
            n5 = n;
            n4 = n3 + n2 - n;
        }
        this.fireTableRowsUpdated(n5, n4);
    }

    public void removeRow(int n) {
        this.removeRowRange(n, n);
    }

    public void removeRowRange(int n, int n2) {
        this.modelData.subList(n, n2 + 1).clear();
        this.fireTableRowsDeleted(n, n2);
    }

    public void removeRows(int ... nArray) {
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            this.modelData.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void replaceRow(int n, T t) {
        this.modelData.set(n, t);
        this.fireTableRowsUpdated(n, n);
    }

    public void setColumnClass(int n, Class clazz) {
        this.columnClasses[n] = clazz;
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    public void setColumnEditable(int n, boolean bl) {
        this.isColumnEditable[n] = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setModelEditable(boolean bl) {
        this.isModelEditable = bl;
    }

    public static String formatColumnName(String string) {
        if (string.length() < 3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        for (int i = 1; i < stringBuffer.length(); ++i) {
            boolean bl2 = Character.isUpperCase(stringBuffer.charAt(i));
            if (bl2 && bl) {
                stringBuffer.insert(i, " ");
                ++i;
            }
            bl = !bl2;
        }
        return stringBuffer.toString().replaceAll("_", " ");
    }
}

