/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.proxy.AbstractProxy;
import oracle.dbtools.raptor.proxy.Messages;
import oracle.dbtools.raptor.proxy.MethodTracker;
import oracle.dbtools.raptor.proxy.ProxyContext;
import oracle.dbtools.raptor.proxy.ProxyRegistry;
import oracle.dbtools.raptor.proxy.ProxyUtils;

public class ProxyLogger
implements ChangeListener {
    protected static final Logger LOGGER = Logger.getLogger(ProxyLogger.class.getName());
    protected static final Level DEFAULT_LOG_LEVEL = Level.FINER;
    protected static final long MIN_LOGGED_ELAPSE = 1L;
    protected long minElapsed = 1L;
    protected boolean logging = true;

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object instanceof MethodTracker.CallMetrics) {
            MethodTracker.CallMetrics callMetrics = (MethodTracker.CallMetrics)object;
            switch (callMetrics.getState()) {
                case CALLED: {
                    this.logPreForAll(callMetrics);
                    break;
                }
                case RETURNED: {
                    this.logPostForAll(callMetrics);
                    this.logSummaryForAll(callMetrics);
                }
            }
        } else if (object instanceof ProxyContext) {
            this.logProxyCleanup((ProxyContext)object);
        }
    }

    public void setMinLoggedElapsed(long l) {
        this.minElapsed = l;
    }

    public long getMinLoggedElapsed() {
        return this.minElapsed;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public boolean getLogging() {
        return this.logging;
    }

    protected final void log(Level level, String string) {
        if (this.logging) {
            LOGGER.log(level, string);
        }
    }

    protected void logException(Throwable throwable) {
        this.logException(Level.SEVERE, throwable);
    }

    protected void logException(Level level, Throwable throwable) {
        this.log(level, Messages.formatExceptionMsg(throwable.getLocalizedMessage()));
    }

    protected void logConnectionWrap(Connection connection, Properties properties) {
        if (connection instanceof AbstractProxy && properties != null) {
            String string;
            String string2 = string = properties != null ? properties.getProperty("ConnName") : null;
            if (string != null) {
                String string3 = "d?";
                String string4 = Messages.formatReturningCall(ProxyUtils.formatArg(connection), Messages.formatNewConnection(string));
                this.log(DEFAULT_LOG_LEVEL, Messages.formatQualifiedMsg(string3, string4));
            }
        }
    }

    private void logPreForAll(MethodTracker.CallMetrics callMetrics) {
        boolean bl = callMetrics.getAtomic();
        if (!bl) {
            Method method = callMetrics.getMethod();
            Object object = callMetrics.getReceiver();
            if (method != null && object instanceof AbstractProxy) {
                Object[] objectArray = callMetrics.getArgs();
                Level level = callMetrics.getLogLevel();
                AbstractProxy abstractProxy = (AbstractProxy)object;
                String string = Messages.formatInwardCall(ProxyUtils.formatMethodCall(method, objectArray, false));
                string = this.tagWithCaller(callMetrics, string);
                try {
                    ProxyContext proxyContext = abstractProxy.getProxyContext();
                    String string2 = proxyContext.getPath();
                    this.log(level, Messages.formatQualifiedMsg(string2, string));
                }
                catch (Exception exception) {
                    this.logException(exception);
                }
            }
        }
    }

    private void logPostForAll(MethodTracker.CallMetrics callMetrics) {
        Method method = callMetrics.getMethod();
        Object object = callMetrics.getReceiver();
        if (method != null && object instanceof AbstractProxy) {
            Object[] objectArray = callMetrics.getArgs();
            Object object2 = callMetrics.getResult();
            Level level = callMetrics.getLogLevel();
            Throwable throwable = callMetrics.getException();
            boolean bl = callMetrics.getAtomic();
            long l = callMetrics.getElapsed();
            AbstractProxy abstractProxy = (AbstractProxy)object;
            try {
                ProxyContext proxyContext = abstractProxy.getProxyContext();
                String string = proxyContext.getPath();
                String string2 = ProxyUtils.formatMethodCall(method, objectArray, !bl);
                if (!bl) {
                    string2 = Messages.formatOutwardCall(string2);
                }
                String string3 = throwable != null ? (this.isVoid(method) ? Messages.formatFailedVoidCall(string2) : Messages.formatFailedReturningCall(string2)) : (this.isVoid(method) ? Messages.formatVoidCall(string2) : Messages.formatReturningCall(ProxyUtils.formatArg(object2), string2));
                if (l >= this.getMinLoggedElapsed()) {
                    string3 = Messages.formatElapsedTimeAsSuffix(string3, l);
                }
                if (bl) {
                    string3 = this.tagWithCaller(callMetrics, string3);
                }
                this.log(level, Messages.formatQualifiedMsg(string, string3));
                if (throwable != null) {
                    String string4 = Messages.formatExceptionMsg(throwable.getLocalizedMessage());
                    string4 = this.tagWithCaller(callMetrics, string4);
                    this.log(level, Messages.formatQualifiedMsg(string, string4));
                }
            }
            catch (Exception exception) {
                this.logException(exception);
            }
        }
    }

    private void logSummaryForAll(MethodTracker.CallMetrics callMetrics) {
        Method method = callMetrics.getMethod();
        Object object = callMetrics.getReceiver();
        if (method != null && object instanceof AbstractProxy) {
            Level level = ProxyUtils.getLowerLogLevel(callMetrics.getLogLevel());
            String string = "";
            if (SwingUtilities.isEventDispatchThread()) {
                string = Messages.onSwingThread();
                string = this.tagWithCaller(callMetrics, string);
            }
            if (string.length() > 0) {
                AbstractProxy abstractProxy = (AbstractProxy)object;
                try {
                    ProxyContext proxyContext = abstractProxy.getProxyContext();
                    String string2 = proxyContext.getPath();
                    this.log(level, Messages.formatQualifiedMsg(string2, string));
                }
                catch (Exception exception) {
                    this.logException(exception);
                }
            }
        }
    }

    private String tagWithCaller(MethodTracker.CallMetrics callMetrics, String string) {
        StackTraceElement stackTraceElement;
        if (string != null && ProxyRegistry.DEBUG_BUILD && (stackTraceElement = callMetrics.getSignificantCaller()) != null) {
            string = Messages.formatCallWithCaller(string, stackTraceElement);
        }
        return string;
    }

    private void logProxyCleanup(ProxyContext proxyContext) {
        String string = proxyContext.getPath();
        if (!proxyContext.wasExplicitlyClosed()) {
            this.log(DEFAULT_LOG_LEVEL, Messages.formatQualifiedMsg(string, Messages.notExplicitelyClosed()));
        }
    }

    private boolean isVoid(Method method) {
        return method.getReturnType() == null || "void".equals(method.getReturnType().getName());
    }
}

