/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.dmt.dataminer.core.dal.sql.queries.cd.AttributeDependenciesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.cd.AttributeImportanceQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.AssociationItemSetAggregatesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.AssociationItemSetQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.AssociationRulesAggregatesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.AssociationRulesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ClusterAttributeHistogramQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ClusterCentroidQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ClusterCentroidScoringQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ClusterFullTreeQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ClusterRuleQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.DTFullTreeQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.DTFullTreeXMLQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.DTLeafProfileQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.EMBernoulliDetailsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.EMComponentClustersQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.EMComponentPriorsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.EMComponentsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.EMGaussianDetailsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.EMProjectionsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.FeatureCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.FeatureProjectionsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.GLMCCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.GLMCRowDiagnosticsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.GLMRCoefficientsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.GLMRRowDiagnosticsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.GlobalDetailsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelDetailsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.ModelSignatureQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.NBProbabilitiesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.PCAScreeQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.RModelDetailsQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.SVDSingularValuesQuery;
import oracle.dmt.dataminer.core.dal.sql.queries.md.SVMCCoefficientsQuery;
import oracle.dmt.dataminer.core.model.common.build.RowDiagnosticTableDetails;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.FilterDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.javatools.util.Version;

public class ExtractQueryFactory {
    public static ModelDetailsQuery createModelQuery(ModelDetailsDataNode modelDetailsDataNode, ModelDetailType modelDetailType, List<RefModelType> list, Map<String, RowDiagnosticTableDetails> map, boolean bl, Version version) {
        ModelDetailsQuery modelDetailsQuery = null;
        switch (modelDetailType) {
            case AR_RULES_STRING_VERSION: {
                return new AssociationRulesQuery(version, modelDetailType, list, map, modelDetailsDataNode.getARNodeSettings(), bl);
            }
            case AR_RULES_AGGREGATES_STRING_VERSION: {
                return new AssociationRulesAggregatesQuery(version, modelDetailType, list, map, modelDetailsDataNode.getARNodeSettings(), bl);
            }
            case AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION: {
                return new AssociationItemSetQuery(version, modelDetailType, list, map, modelDetailsDataNode.getARNodeSettings(), bl);
            }
            case AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION: {
                return new AssociationItemSetAggregatesQuery(version, modelDetailType, list, map, modelDetailsDataNode.getARNodeSettings(), bl);
            }
            case CLUSTER_DETAILS: {
                return new ClusterFullTreeQuery(version, modelDetailType, list, map, bl);
            }
            case CLUSTER_RULES: {
                return new ClusterRuleQuery(version, modelDetailType, list, map, bl);
            }
            case CENTROIDS: {
                return new ClusterCentroidQuery(version, modelDetailType, list, map, bl);
            }
            case CENTROID_SCORING: {
                return new ClusterCentroidScoringQuery(version, modelDetailType, list, map, bl);
            }
            case CLUSTER_ATTRIBUTE_HISTOGRAMS: {
                return new ClusterAttributeHistogramQuery(version, modelDetailType, list, map, bl);
            }
            case DT_FULL_TREE: 
            case DT_LEAF_NODES_ONLY: {
                return new DTFullTreeQuery(version, modelDetailType, list, map, bl);
            }
            case DT_LEAF_NODES_ONLY_PROFILE_VERSION: {
                return new DTLeafProfileQuery(version, modelDetailType, list, map, bl);
            }
            case DT_FULL_TREE_XML_VERSION: {
                return new DTFullTreeXMLQuery(version, modelDetailType, list, map, bl);
            }
            case EM_COMPONENTS: {
                return new EMComponentsQuery(version, modelDetailType, list, map, bl);
            }
            case EM_CLUSTERS: {
                return new EMComponentClustersQuery(version, modelDetailType, list, map, bl);
            }
            case EM_PRIORS: {
                return new EMComponentPriorsQuery(version, modelDetailType, list, map, bl);
            }
            case EM_GAUSSIAN_DETAILS: {
                return new EMGaussianDetailsQuery(version, modelDetailType, list, map, bl);
            }
            case EM_BERNOULLI_DETAILS: {
                return new EMBernoulliDetailsQuery(version, modelDetailType, list, map, bl);
            }
            case EM_PROJECTIONS: {
                return new EMProjectionsQuery(version, modelDetailType, list, map, bl);
            }
            case GLMC_COEFFICIENTS_AND_STATISTICS: {
                return new GLMCCoefficientsQuery(version, modelDetailType, list, map, bl);
            }
            case GLMR_COEFFICIENTS_AND_STATISTICS: {
                return new GLMRCoefficientsQuery(version, modelDetailType, list, map, bl);
            }
            case GLMC_ROW_DIAGNOSTICS: {
                return new GLMCRowDiagnosticsQuery(version, modelDetailType, list, map, bl);
            }
            case GLMR_ROW_DIAGNOSTICS: {
                return new GLMRRowDiagnosticsQuery(version, modelDetailType, list, map, bl);
            }
            case GLOBAL_DETAILS: {
                return new GlobalDetailsQuery(version, modelDetailType, list, map, bl);
            }
            case FEATURE_PROJECTIONS: {
                return new FeatureProjectionsQuery(version, modelDetailType, list, map, bl);
            }
            case MODEL_SIGNATURE: {
                return new ModelSignatureQuery(version, modelDetailType, list, map, bl);
            }
            case NB_PAIR_PROBABILITIES: {
                return new NBProbabilitiesQuery(version, modelDetailType, list, map, bl);
            }
            case NMF_DETAILS_TRANSACTIONAL_VERSION: {
                return new FeatureCoefficientsQuery(version, modelDetailType, list, map, bl);
            }
            case PCA_EIGENVALUES: {
                return new PCAScreeQuery(version, modelDetailType, list, map, bl);
            }
            case SVD_SINGULAR_VALUES: {
                return new SVDSingularValuesQuery(version, modelDetailType, list, map, bl);
            }
            case SVMC_COEFFICIENTS: 
            case SVMR_COEFFICIENTS: 
            case AD_COEFFICIENTS: {
                return new SVMCCoefficientsQuery(version, modelDetailType, list, map, bl);
            }
            case R_MODEL_DETAILS: {
                return new RModelDetailsQuery(version, modelDetailType, list, map, modelDetailsDataNode.getRModelOutputDefinition(), bl);
            }
        }
        assert (false) : "Invalid Query Type";
        return modelDetailsQuery;
    }

    public static String createColumnQuery(FilterDetailType filterDetailType, List<AttributeType> list, String string, Version version) {
        assert (filterDetailType != null && (filterDetailType == FilterDetailType.ATTRIBUTE_DEPENDENCIES || filterDetailType == FilterDetailType.ATTRIBUTE_IMPORTANCE)) : "Invalid Output Type value.";
        AttributeImportanceQuery attributeImportanceQuery = null;
        switch (filterDetailType) {
            case ATTRIBUTE_IMPORTANCE: {
                attributeImportanceQuery = new AttributeImportanceQuery(filterDetailType, list, string, version);
                break;
            }
            case ATTRIBUTE_DEPENDENCIES: {
                attributeImportanceQuery = new AttributeDependenciesQuery(filterDetailType, list, string, version);
                break;
            }
        }
        return attributeImportanceQuery.getSQLCommand();
    }

    public static List<OutputAttributeType> getModelColumnList(ModelDetailsDataNode modelDetailsDataNode, ModelDetailType modelDetailType, Version version) {
        if (modelDetailType == null) {
            return Collections.emptyList();
        }
        ClusterFullTreeQuery clusterFullTreeQuery = null;
        switch (modelDetailType) {
            case AR_RULES_STRING_VERSION: {
                clusterFullTreeQuery = new AssociationRulesQuery(version, modelDetailType, modelDetailsDataNode.getARNodeSettings());
                break;
            }
            case AR_RULES_AGGREGATES_STRING_VERSION: {
                clusterFullTreeQuery = new AssociationRulesAggregatesQuery(version, modelDetailType, modelDetailsDataNode.getARNodeSettings());
                break;
            }
            case AR_FREQUENT_ITEM_SETS_TRANSACTIONAL_VERSION: {
                clusterFullTreeQuery = new AssociationItemSetQuery(version, modelDetailType, modelDetailsDataNode.getARNodeSettings());
                break;
            }
            case AR_FREQUENT_ITEM_SETS_AGGREGATES_TRANSACTIONAL_VERSION: {
                clusterFullTreeQuery = new AssociationItemSetAggregatesQuery(version, modelDetailType, modelDetailsDataNode.getARNodeSettings());
                break;
            }
            case CLUSTER_DETAILS: {
                clusterFullTreeQuery = new ClusterFullTreeQuery(version, modelDetailType);
                break;
            }
            case CLUSTER_RULES: {
                clusterFullTreeQuery = new ClusterRuleQuery(version, modelDetailType);
                break;
            }
            case CENTROIDS: {
                clusterFullTreeQuery = new ClusterCentroidQuery(version, modelDetailType);
                break;
            }
            case CENTROID_SCORING: {
                clusterFullTreeQuery = new ClusterCentroidScoringQuery(version, modelDetailType);
                break;
            }
            case CLUSTER_ATTRIBUTE_HISTOGRAMS: {
                clusterFullTreeQuery = new ClusterAttributeHistogramQuery(version, modelDetailType);
                break;
            }
            case DT_FULL_TREE: 
            case DT_LEAF_NODES_ONLY: {
                clusterFullTreeQuery = new DTFullTreeQuery(version, modelDetailType);
                break;
            }
            case DT_LEAF_NODES_ONLY_PROFILE_VERSION: {
                clusterFullTreeQuery = new DTLeafProfileQuery(version, modelDetailType);
                break;
            }
            case DT_FULL_TREE_XML_VERSION: {
                clusterFullTreeQuery = new DTFullTreeXMLQuery(version, modelDetailType);
                break;
            }
            case EM_COMPONENTS: {
                clusterFullTreeQuery = new EMComponentsQuery(version, modelDetailType);
                break;
            }
            case EM_CLUSTERS: {
                clusterFullTreeQuery = new EMComponentClustersQuery(version, modelDetailType);
                break;
            }
            case EM_PRIORS: {
                clusterFullTreeQuery = new EMComponentPriorsQuery(version, modelDetailType);
                break;
            }
            case EM_GAUSSIAN_DETAILS: {
                clusterFullTreeQuery = new EMGaussianDetailsQuery(version, modelDetailType);
                break;
            }
            case EM_BERNOULLI_DETAILS: {
                clusterFullTreeQuery = new EMBernoulliDetailsQuery(version, modelDetailType);
                break;
            }
            case EM_PROJECTIONS: {
                clusterFullTreeQuery = new EMProjectionsQuery(version, modelDetailType);
                break;
            }
            case FEATURE_PROJECTIONS: {
                clusterFullTreeQuery = new FeatureProjectionsQuery(version, modelDetailType);
                break;
            }
            case GLMC_COEFFICIENTS_AND_STATISTICS: {
                clusterFullTreeQuery = new GLMCCoefficientsQuery(version, modelDetailType);
                break;
            }
            case GLMR_COEFFICIENTS_AND_STATISTICS: {
                clusterFullTreeQuery = new GLMRCoefficientsQuery(version, modelDetailType);
                break;
            }
            case GLMC_ROW_DIAGNOSTICS: {
                clusterFullTreeQuery = new GLMCRowDiagnosticsQuery(version, modelDetailType);
                break;
            }
            case GLMR_ROW_DIAGNOSTICS: {
                clusterFullTreeQuery = new GLMRRowDiagnosticsQuery(version, modelDetailType);
                break;
            }
            case GLOBAL_DETAILS: {
                clusterFullTreeQuery = new GlobalDetailsQuery(version, modelDetailType);
                break;
            }
            case MODEL_SIGNATURE: {
                clusterFullTreeQuery = new ModelSignatureQuery(version, modelDetailType);
                break;
            }
            case NB_PAIR_PROBABILITIES: {
                clusterFullTreeQuery = new NBProbabilitiesQuery(version, modelDetailType);
                break;
            }
            case NMF_DETAILS_TRANSACTIONAL_VERSION: {
                clusterFullTreeQuery = new FeatureCoefficientsQuery(version, modelDetailType);
                break;
            }
            case PCA_EIGENVALUES: {
                clusterFullTreeQuery = new PCAScreeQuery(version, modelDetailType);
                break;
            }
            case SVMC_COEFFICIENTS: 
            case SVMR_COEFFICIENTS: 
            case AD_COEFFICIENTS: {
                clusterFullTreeQuery = new SVMCCoefficientsQuery(version, modelDetailType);
                break;
            }
            case SVD_SINGULAR_VALUES: {
                clusterFullTreeQuery = new SVDSingularValuesQuery(version, modelDetailType);
                break;
            }
            case R_MODEL_DETAILS: {
                clusterFullTreeQuery = new RModelDetailsQuery(version, modelDetailType, modelDetailsDataNode.getRModelOutputDefinition());
                break;
            }
            default: {
                assert (false) : "Invalid Query Type";
                break;
            }
        }
        return clusterFullTreeQuery.getOutputColumnList();
    }

    public static List<OutputAttributeType> getFilterColumnList(FilterDetailType filterDetailType, List<AttributeType> list, String string, Version version) {
        if (filterDetailType == null) {
            return Collections.emptyList();
        }
        AttributeImportanceQuery attributeImportanceQuery = null;
        switch (filterDetailType) {
            case ATTRIBUTE_IMPORTANCE: {
                attributeImportanceQuery = new AttributeImportanceQuery(filterDetailType, list, string, version);
                break;
            }
            case ATTRIBUTE_DEPENDENCIES: {
                attributeImportanceQuery = new AttributeDependenciesQuery(filterDetailType, list, string, version);
                break;
            }
        }
        return attributeImportanceQuery.getOutputColumnList();
    }
}

