/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.dialog.dynamic.DynamicApplyHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.PredictionFunctionsHelper;
import oracle.dmt.dataminer.workflow.dialog.dynamic.feature.ColumnGeneratorHelper;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.DynamicHelper;
import oracle.dmt.dataminer.workflow.model.DynamicNode;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.CaseAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicApplyOutputColumnType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicFeatureNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DynamicNodeBaseSettingsType;
import oracle.dmt.dataminer.workflow.xmlschema.FeatureIdType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningAttributes;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PartitionExpressions;
import oracle.dmt.dataminer.workflow.xmlschema.SupplementalAttributesType;
import oracle.ide.Context;

public class DynamicFeatureNode
extends DynamicNode {
    private String FEATURE_TEMPLATE = null;
    public static final String FEATURE_NODE_INPUT_COLUMNS = "FEATURE_NODE_INPUT_COLUMNS";
    public static final String NUMBER_OF_FEATURES = "NUMBER_OF_FEATURES";
    public static final int INITIAL_FEATURES = 10;

    public DynamicFeatureNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
        this.FEATURE_TEMPLATE = "SELECT " + (SQLHelper.generateSQLInlineHint(context) ? "/*+ inline */" : "") + "<SUPPLEMENTAL_DATA>" + "\n<DYNAMIC_FEATURE_CODE>FROM {INPUT_SOURCE}\n";
    }

    @Override
    public DynamicNodeBaseSettingsType getDynamicNodeBaseSettingsType() {
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)this.getData();
        return dynamicFeatureNodeType.getDynamicNodeBaseSettings();
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_DYNAMIC_FEATURE_NODE_NAME");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_DYNAMIC_FEATURE_NODE_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_DYNAMIC_FEATURE_NODE_ICON"));
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.initDynamicNodeBaseSettingsType();
        dynamicFeatureNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
        dynamicNodeBaseSettingsType.getDynamicApplyOutputColumns().getDynamicApplyOutputColumn().addAll(this.generateDefaultPredictionOutputs());
        FeatureIdType featureIdType = new FeatureIdType();
        FeatureIdType.Column column = new FeatureIdType.Column();
        column.setName(String.valueOf(10));
        featureIdType.setColumn(column);
        dynamicFeatureNodeType.setFeatureId(featureIdType);
        dynamicFeatureNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        dynamicFeatureNodeType.setStatus(NodeStatusType.INVALID);
    }

    private List<DynamicApplyOutputColumnType> generateDefaultPredictionOutputs() {
        ArrayList<DynamicApplyOutputColumnType> arrayList = new ArrayList<DynamicApplyOutputColumnType>();
        arrayList.add(ColumnGeneratorHelper.generateDefaultFeatureSetOutput(this.getNameGenerator(), true));
        return arrayList;
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        if (!(node instanceof DataProvider)) {
            return;
        }
        super.handleNewConnectionFrom(node);
        Attributes attributes = ((DataProvider)((Object)node)).getAttributes();
        List list = attributes.getAttribute();
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        MiningAttributes miningAttributes = dynamicNodeBaseSettingsType.getMiningAttributes();
        List list2 = miningAttributes.getMiningAttribute();
        SupplementalAttributesType supplementalAttributesType = dynamicNodeBaseSettingsType.getSupplementalAttributes();
        supplementalAttributesType.getAttribute();
        CaseAttributes caseAttributes = dynamicNodeBaseSettingsType.getCaseAttributes();
        caseAttributes.getAttribute();
        PartitionExpressions partitionExpressions = dynamicNodeBaseSettingsType.getPartitionExpressions();
        partitionExpressions.getPartitionExpression();
        if (list2.isEmpty()) {
            miningAttributes.setAutoSpec(AutoSpecType.YES);
            this.copyAttributes(list2, list);
            DynamicFeatureHelper dynamicFeatureHelper = new DynamicFeatureHelper(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions, dynamicFeatureNodeType.getFeatureId());
            this.updateAllColumnsTxn(dynamicFeatureHelper, new DynamicFeatureHelper());
            this.validate(true);
        } else {
            DynamicFeatureHelper dynamicFeatureHelper = new DynamicFeatureHelper(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions, dynamicFeatureNodeType.getFeatureId());
            DynamicFeatureHelper dynamicFeatureHelper2 = this.copyPreviousState(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions, dynamicFeatureNodeType.getFeatureId());
            this.updateStatusFromDataProvider();
            this.updateAllColumnsTxn(dynamicFeatureHelper, dynamicFeatureHelper2);
            this.validateSimple(true);
        }
    }

    private DynamicFeatureHelper copyPreviousState(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions, FeatureIdType featureIdType) {
        DynamicHelper dynamicHelper = this.copyPreviousStateCommon(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
        return new DynamicFeatureHelper(dynamicHelper.newInputAttributes, dynamicHelper.newSupplAttributes, dynamicHelper.newCaseAttributes, dynamicHelper.newPartExpressions, featureIdType);
    }

    @Override
    public boolean validate(boolean bl) {
        boolean bl2 = super.validate(bl);
        boolean bl3 = SQLHelper.isExtendedTypeEnabled(this.getContext());
        this.convertNestedVarcharTypes(bl3);
        bl2 = this.performValidation();
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        DynamicFeatureHelper dynamicFeatureHelper = new DynamicFeatureHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions(), dynamicFeatureNodeType.getFeatureId());
        this.updateStatusFromDataProvider();
        DynamicFeatureHelper dynamicFeatureHelper2 = new DynamicFeatureHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions(), dynamicFeatureNodeType.getFeatureId());
        this.updateAllColumnsTxn(dynamicFeatureHelper2, dynamicFeatureHelper);
        bl2 = this.performValidation();
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        return bl2;
    }

    @Override
    public void setSQLPredictionExpression(String string) {
        ((DynamicFeatureNodeType)this.getData()).getDynamicNodeBaseSettings().setSQLPredictionExpression(string);
    }

    @Override
    public String getHelpTopic() {
        return "dynamic_feature_node";
    }

    @Override
    public Attributes getAttributes() {
        if (this._isEnableLegacyApplyOutputTypes == null) {
            this.detectDBVersion();
        }
        Attributes attributes = new Attributes();
        if (null != this.getDynamicNodeBaseSettingsType().getSupplementalAttributes() && !this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute().isEmpty()) {
            attributes.getAttribute().addAll(this.getDynamicNodeBaseSettingsType().getSupplementalAttributes().getAttribute());
        }
        if (null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns() && null != this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
            for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn()) {
                String string = null;
                String string2 = null;
                if (null != dynamicApplyOutputColumnType.getFeatureId()) {
                    string2 = dynamicApplyOutputColumnType.getFeatureId().getColumn().getName();
                    string = "NUMBER";
                } else if (null != dynamicApplyOutputColumnType.getFeatureSet()) {
                    string2 = dynamicApplyOutputColumnType.getFeatureSet().getColumn().getName();
                    string = this._isEnableLegacyApplyOutputTypes != false ? "ODMR_FEATURE_SET_NUM" : "ODMR_FEATURE_SET_NUMVD";
                } else if (null != dynamicApplyOutputColumnType.getFeatureValue()) {
                    string2 = dynamicApplyOutputColumnType.getFeatureValue().getColumn().getName();
                    string = this._isEnableLegacyApplyOutputTypes != false ? "NUMBER" : "BINARY_DOUBLE";
                } else if (null != dynamicApplyOutputColumnType.getFeatureDetails()) {
                    string2 = dynamicApplyOutputColumnType.getFeatureDetails().getColumn().getName();
                    string = "XMLTYPE";
                }
                AttributeType attributeType = new AttributeType();
                attributeType.setName(string2);
                attributeType.setDataType(string != null ? string : "UNKNOWN");
                attributeType.setStatus(AttributeStatus.VALID);
                attributes.getAttribute().add(attributeType);
            }
        }
        return attributes;
    }

    @Override
    public String generateSQLExpression() {
        Map<String, String> map = this.generateSQLExpressions();
        return map.get("CLIENT_SQL_EXPRESSION");
    }

    @Override
    public Map<String, String> generateSQLExpressions() {
        Object object2;
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)this.getData();
        DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = this.getDynamicNodeBaseSettingsType();
        StringBuilder stringBuilder = new StringBuilder();
        List list = dynamicNodeBaseSettingsType.getMiningAttributes().getMiningAttribute();
        List list2 = dynamicNodeBaseSettingsType.getCaseAttributes().getAttribute();
        List list3 = dynamicNodeBaseSettingsType.getPartitionExpressions().getPartitionExpression();
        boolean bl = false;
        int n = 1;
        for (Object object2 : list) {
            bl = this.isCaseIdAttribute((AttributeType)object2, list2) ? false : (this.isPartitionAttribute((MiningAttributeType)object2, list3) ? false : "Yes".equals(object2.getInput()));
            if (!bl) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"");
            stringBuilder.append(object2.getName());
            stringBuilder.append("\"");
            if (stringBuilder.length() <= n * 500) continue;
            stringBuilder.append("\n");
            ++n;
        }
        stringBuilder.append("\n");
        Object object3 = this.generateSupplementalCode(this.FEATURE_TEMPLATE);
        object2 = object3;
        Map<String, StringBuilder> map = this.generateFeatureSQL(dynamicFeatureNodeType.getFeatureId());
        object3 = StringUtils.getReplacedString((String)object3, "<DYNAMIC_FEATURE_CODE>", map.get("CLIENT_SQL_EXPRESSION").toString());
        object3 = StringUtils.getReplacedString((String)object3, "<INPUT_LIST>", stringBuilder.toString());
        object2 = StringUtils.getReplacedString((String)object2, "<DYNAMIC_FEATURE_CODE>", map.get("SERVER_SQL_EXPRESSION").toString());
        object2 = StringUtils.getReplacedString((String)object2, "<INPUT_LIST>", stringBuilder.toString());
        String string = this.wrapExpressionInWithClause((String)object3);
        String string2 = this.wrapExpressionInWithClause((String)object2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CLIENT_SQL_EXPRESSION", string);
        hashMap.put("SERVER_SQL_EXPRESSION", string2);
        return hashMap;
    }

    private Map<String, StringBuilder> generateFeatureSQL(FeatureIdType featureIdType) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        List list = this.getDynamicNodeBaseSettingsType().getDynamicApplyOutputColumns().getDynamicApplyOutputColumn();
        for (DynamicApplyOutputColumnType dynamicApplyOutputColumnType : list) {
            String string;
            String string2;
            PredictionFunctionsHelper.Parameters parameters = DynamicApplyHelper.getPredictionFunctionParameters(dynamicApplyOutputColumnType, null, null, null);
            String string3 = string2 = parameters.generateCode(this);
            if (parameters instanceof PredictionFunctionsHelper.FeatureId && featureIdType != null) {
                string2 = StringUtils.getReplacedString(string2, "<FEATURES_NUMBER>", featureIdType.getColumn().getName());
                string3 = StringUtils.getReplacedString(string3, "<FEATURES_NUMBER>", featureIdType.getColumn().getName());
            } else if (parameters instanceof PredictionFunctionsHelper.FeatureValue) {
                string = this.generateFeatureValue((PredictionFunctionsHelper.FeatureValue)parameters, featureIdType);
                string2 = StringUtils.getReplacedString(string2, "<FEATURE_VALUE>", string);
                string3 = StringUtils.getReplacedString(string3, "<FEATURE_VALUE>", string);
            } else if (parameters instanceof PredictionFunctionsHelper.FeatureSet) {
                string = this.generateFeatureSet((PredictionFunctionsHelper.FeatureSet)parameters, featureIdType);
                string2 = StringUtils.getReplacedString(string2, "<FEATURE_SET>", string);
                string3 = StringUtils.getReplacedString(string3, "<FEATURE_SET>", string);
            } else if (parameters instanceof PredictionFunctionsHelper.FeatureDetails) {
                string = this.generateFeatureDetails((PredictionFunctionsHelper.FeatureDetails)parameters, featureIdType);
                string2 = StringUtils.getReplacedString(string2, "<FEATURE_DETAILS>", string);
                string3 = StringUtils.getReplacedString(string3, "<FEATURE_DETAILS>", string);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append(",");
            }
            stringBuilder.append(string2);
            stringBuilder2.append(string3);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("CLIENT_SQL_EXPRESSION", stringBuilder);
        hashMap.put("SERVER_SQL_EXPRESSION", stringBuilder2);
        return hashMap;
    }

    private String generateFeatureDetails(PredictionFunctionsHelper.FeatureDetails featureDetails, FeatureIdType featureIdType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(featureIdType.getColumn().getName());
        if (featureDetails != null) {
            Object object = featureDetails.getSelectedTarget();
            if (null != object) {
                Integer n;
                if (object instanceof Number && (n = (Integer)object) <= Integer.parseInt(featureIdType.getColumn().getName())) {
                    stringBuilder.append(", " + object.toString());
                }
                if (featureDetails.isUseTopN()) {
                    stringBuilder.append(", " + featureDetails.getTopN().toString());
                }
            } else if (featureDetails.isUseTopN()) {
                stringBuilder.append(", NULL, " + featureDetails.getTopN().toString());
            }
        }
        if (null != featureDetails.getSort()) {
            stringBuilder.append(" " + ServerConstants.ApplyPredictionDetailsSort.toAlgorithm((String)featureDetails.getSort()));
        }
        return stringBuilder.toString();
    }

    private String generateFeatureSet(PredictionFunctionsHelper.FeatureSet featureSet, FeatureIdType featureIdType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(featureIdType.getColumn().getName());
        if (featureSet != null) {
            if (featureSet.isUseTopN()) {
                BigInteger bigInteger = featureSet.getTopN();
                if (!bigInteger.equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                    stringBuilder.append(", " + bigInteger.toString());
                }
                if (featureSet.isUseCutOff()) {
                    if (bigInteger.equals(PredictionFunctionsHelper.TOPN_VALUE)) {
                        stringBuilder.append(", null");
                    }
                    Double d = featureSet.getCutOff();
                    stringBuilder.append(", " + d.toString());
                }
            } else if (featureSet.isUseCutOff()) {
                Double d = featureSet.getCutOff();
                stringBuilder.append(", null, " + d.toString());
            }
        }
        return stringBuilder.toString();
    }

    private String generateFeatureValue(PredictionFunctionsHelper.FeatureValue featureValue, FeatureIdType featureIdType) {
        Integer n;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(featureIdType.getColumn().getName());
        if (featureValue != null && null != (object = featureValue.getFeatureId()) && object instanceof Number && (n = (Integer)object) <= Integer.parseInt(featureIdType.getColumn().getName())) {
            stringBuilder.append(", " + n.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void refactorForApply() {
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(FEATURE_NODE_INPUT_COLUMNS) || complexProperty.getPropertyName().equals(ALL_COLUMNS)) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)this.getData();
        if (string.equals(FEATURE_NODE_INPUT_COLUMNS)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("DynamicNodeBaseSettingsType", dynamicFeatureNodeType.getDynamicNodeBaseSettings());
            hashMap.put("ClusterIdType", dynamicFeatureNodeType.getFeatureId());
            object = hashMap;
        } else {
            if (string.equals(NUMBER_OF_FEATURES)) {
                return dynamicFeatureNodeType.getFeatureId();
            }
            if (string.equals(ALL_COLUMNS)) {
                DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicFeatureNodeType.getDynamicNodeBaseSettings();
                object = new DynamicFeatureHelper(dynamicNodeBaseSettingsType.getMiningAttributes(), dynamicNodeBaseSettingsType.getSupplementalAttributes(), dynamicNodeBaseSettingsType.getCaseAttributes(), dynamicNodeBaseSettingsType.getPartitionExpressions(), dynamicFeatureNodeType.getFeatureId());
            } else {
                return super.getProperty(string);
            }
        }
        return object;
    }

    @Override
    public void setProperty(String string, Object object) {
        DynamicFeatureNodeType dynamicFeatureNodeType = (DynamicFeatureNodeType)this.getData();
        if (string.equals(FEATURE_NODE_INPUT_COLUMNS)) {
            Map map = (Map)object;
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = (DynamicNodeBaseSettingsType)map.get("DynamicNodeBaseSettingsType");
            FeatureIdType featureIdType = (FeatureIdType)map.get("FeatureIdType");
            dynamicFeatureNodeType.setDynamicNodeBaseSettings(dynamicNodeBaseSettingsType);
            dynamicFeatureNodeType.setFeatureId(featureIdType);
        } else if (string.equals(ALL_COLUMNS)) {
            DynamicNodeBaseSettingsType dynamicNodeBaseSettingsType = dynamicFeatureNodeType.getDynamicNodeBaseSettings();
            DynamicFeatureHelper dynamicFeatureHelper = (DynamicFeatureHelper)object;
            dynamicNodeBaseSettingsType.setMiningAttributes(dynamicFeatureHelper.newInputAttributes);
            dynamicNodeBaseSettingsType.setSupplementalAttributes(dynamicFeatureHelper.newSupplAttributes);
            dynamicNodeBaseSettingsType.setCaseAttributes(dynamicFeatureHelper.newCaseAttributes);
            dynamicNodeBaseSettingsType.setPartitionExpressions(dynamicFeatureHelper.newPartExpressions);
            dynamicFeatureNodeType.setFeatureId(dynamicFeatureHelper.featureId);
        } else if (string.equals(NUMBER_OF_FEATURES)) {
            FeatureIdType featureIdType = (FeatureIdType)object;
            dynamicFeatureNodeType.setFeatureId(featureIdType);
        } else {
            super.setProperty(string, object);
        }
    }

    private static class DynamicFeatureHelper
    extends DynamicHelper {
        FeatureIdType featureId;

        DynamicFeatureHelper() {
            this.featureId = new FeatureIdType();
        }

        DynamicFeatureHelper(MiningAttributes miningAttributes, SupplementalAttributesType supplementalAttributesType, CaseAttributes caseAttributes, PartitionExpressions partitionExpressions, FeatureIdType featureIdType) {
            super(miningAttributes, supplementalAttributesType, caseAttributes, partitionExpressions);
            this.featureId = featureIdType;
        }
    }
}

