/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.model;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dmt.dataminer.core.utils.db.DbMetadataUtils;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.utils.UIResourceHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.codegen.CodeGenLrb;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.AbstractTransformNode;
import oracle.dmt.dataminer.workflow.model.ApplyChainNode;
import oracle.dmt.dataminer.workflow.model.DataConsumer;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementType;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElements;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.GroupingElementType;
import oracle.dmt.dataminer.workflow.xmlschema.MessageEnumType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public final class AggregationNode
extends AbstractTransformNode
implements ApplyChainNode,
DataConsumer {
    public static final String AUTO_SPEC = "autoSpec";
    public static final String SOURCE_COLUMNS = "sourceColumns";
    public static final String SUB_GROUP_BY = "subGroupBy";
    public static final String ALL_AGGREGATE_NODE_PROPERTIES = "allAggregateNodeProperies";
    public static final String MAIN_GROUP_BY = "mainGroupBy";
    public static final String REFACTOR_AGGREGATED_COLUMNS = "refactorAggregatedColumns";

    public AggregationNode(String string, NodeType nodeType, Context context) {
        super(string, nodeType, context);
    }

    @Override
    public String getDefaultName() {
        return WorkflowEditorLrb.get("DEFAULT_AGGREGATION_NODE_NAME");
    }

    public static boolean isAutoSpec(AggregationNodeType aggregationNodeType) {
        AutoSpecType autoSpecType = aggregationNodeType.getAutoSpec();
        if (autoSpecType == null) {
            return false;
        }
        return 0 == autoSpecType.value().compareTo("Yes");
    }

    @Override
    public URL getNodeIcon() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        return classLoader.getResource(WorkflowEditorLrb.get("WORKFLOW_AGGREGATION_ICON"));
    }

    @Override
    public Icon getExplorerIcon() {
        return UIResourceHelper.getImageIcon(this.getClass(), WorkflowEditorLrb.get("PALETTE_AGGREGATION_ICON"));
    }

    @Override
    public Attributes getAttributes() {
        String string;
        AbstractNode abstractNode;
        Object object;
        Attributes attributes = new Attributes();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        if (null != groupingElementType.getExpression()) {
            object = new AttributeType();
            Object object2 = AttributeTypeHelper.mainGroupBytoString(groupingElementType);
            String string2 = AttributeTypeHelper.createNonQuotedAlias((String)object2);
            object.setName(string2);
            try {
                abstractNode = this.findParentNode();
                string = AttributeTypeHelper.getMainGroupByElementValidationSQL(groupingElementType, ((DataProvider)((Object)abstractNode)).getInputSQL());
                String string3 = DatabaseMetadataUtils.getColumnType(this.getContext(), string);
                object.setDataType(string3);
            }
            catch (Exception exception) {
                object.setDataType("VARCHAR2");
            }
            object.setStatus(AttributeStatus.VALID);
            attributes.getAttribute().add(object);
        } else if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute() && !groupingElementType.getAttributes().getAttribute().isEmpty()) {
            for (Object object2 : groupingElementType.getAttributes().getAttribute()) {
                attributes.getAttribute().add(object2);
            }
        }
        object = aggregationNodeType.getAggregationElements();
        for (String string2 : object.getAggregationElement()) {
            abstractNode = string2.getOutput();
            string = new AttributeType();
            string.setName(abstractNode.getName());
            string.setAlias(abstractNode.getAlias());
            string.setDataType(abstractNode.getDataType());
            string.setStatus(abstractNode.getStatus());
            attributes.getAttribute().add(string);
        }
        return attributes;
    }

    @Override
    public void initNewInstance(Context context) {
        super.initNewInstance(context);
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        AggregationElements aggregationElements = new AggregationElements();
        aggregationElements.getAggregationElement();
        aggregationNodeType.setAggregationElements(aggregationElements);
        GroupingElementType groupingElementType = new GroupingElementType();
        Attributes attributes = new Attributes();
        attributes.getAttribute();
        groupingElementType.setAttributes(attributes);
        aggregationNodeType.setGroupingElement(groupingElementType);
        aggregationNodeType.setAutoSpec(AutoSpecType.YES);
        aggregationNodeType.getCacheSettings().setUseFullData(Boolean.valueOf(false));
        aggregationNodeType.setStatus(NodeStatusType.INVALID);
    }

    @Override
    public boolean validate(boolean bl) {
        AbstractNode abstractNode;
        boolean bl2 = super.validate(bl);
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        GroupingElementType groupingElementType = null;
        boolean bl3 = false;
        if (bl2) {
            groupingElementType = aggregationNodeType.getGroupingElement();
            if (groupingElementType == null) {
                bl2 = false;
            }
            boolean bl4 = bl3 = null == groupingElementType.getExpression() && (null == groupingElementType.getAttributes() || null == groupingElementType.getAttributes().getAttribute() || groupingElementType.getAttributes().getAttribute().isEmpty());
        }
        if (null == aggregationNodeType.getAggregationElements() || null == aggregationNodeType.getAggregationElements().getAggregationElement()) {
            bl2 = false;
            this.addMessage("AGGREGATION_INCOMPLETE_ATTRIBUTES", MessageEnumType.INCOMPLETE, new String[0]);
        } else if (aggregationNodeType.getAggregationElements().getAggregationElement().isEmpty() && bl3) {
            bl2 = false;
            this.addMessage("AGGREGATION_INCOMPLETE_ATTRIBUTES", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (bl2 && (abstractNode = this.findParentNode()) == null) {
            bl2 = false;
            this.addMessage("AGGREGATION_INCOMPLETE_SRC_DATA", MessageEnumType.INCOMPLETE, new String[0]);
        }
        if (bl2) {
            bl2 = this.validateInputAttributes();
        }
        this.convertNestedVarcharTypes();
        this.setState(bl2);
        if (bl) {
            this.validateChildren();
        }
        if (bl2) {
            this.excecuteInputColumnsTxn();
        }
        return bl2;
    }

    private void convertNestedVarcharTypes() {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        if (null == aggregationNodeType.getAggregationElements() || null == aggregationNodeType.getAggregationElements().getAggregationElement()) {
            return;
        }
        boolean bl = SQLHelper.isExtendedTypeEnabled(this.getContext());
        boolean bl2 = false;
        for (AggregationElementType aggregationElementType : aggregationNodeType.getAggregationElements().getAggregationElement()) {
            String string;
            int n;
            if (null != aggregationElementType.getAggregationFunction()) {
                n = aggregationElementType.getAggregationFunction().equals(DatabaseMetadataUtils.AggregateFunctions.CAST_COLLECT.toString());
                if (n != 0) {
                    bl2 = true;
                }
            } else if (aggregationElementType.getOutput() != null && (aggregationElementType.getOutput().getDataType().equals("ODMR_NESTED_VARCHAR2") || aggregationElementType.getOutput().getDataType().equals("ODMR_NESTED_VARCHAR2_EX"))) {
                bl2 = true;
            }
            if (!bl2) continue;
            aggregationElementType.getOutput().setDataType(bl ? "ODMR_NESTED_VARCHAR2_EX" : "ODMR_NESTED_VARCHAR2");
            if (null == aggregationElementType.getSource().getExpression()) continue;
            if (bl) {
                n = aggregationElementType.getSource().getExpression().indexOf("ODMR_NESTED_VARCHAR2");
                if (-1 == n) continue;
                string = StringUtils.getReplacedString(aggregationElementType.getSource().getExpression(), "ODMR_NESTED_VARCHAR2", "ODMR_NESTED_VARCHAR2_EX");
                string = StringUtils.removeLineSeparator(string);
                aggregationElementType.getSource().setExpression(string);
                continue;
            }
            n = aggregationElementType.getSource().getExpression().indexOf("ODMR_NESTED_VARCHAR2_EX");
            if (-1 == n) continue;
            string = StringUtils.getReplacedString(aggregationElementType.getSource().getExpression(), "ODMR_NESTED_VARCHAR2_EX", "ODMR_NESTED_VARCHAR2");
            string = StringUtils.removeLineSeparator(string);
            aggregationElementType.getSource().setExpression(string);
        }
    }

    @Override
    public Object getProperty(String string) {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        Object object = null;
        if (string.equals(SOURCE_COLUMNS)) {
            object = aggregationNodeType.getAggregationElements();
        } else if (string.equals(AUTO_SPEC)) {
            object = aggregationNodeType;
        } else if (string.equals(MAIN_GROUP_BY)) {
            object = aggregationNodeType.getGroupingElement();
        } else if (string.equals(REFACTOR_AGGREGATED_COLUMNS)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("GroupingElementType", aggregationNodeType.getGroupingElement());
            hashMap.put("AggregationElements", aggregationNodeType.getAggregationElements());
            object = hashMap;
        } else if (string.equals(ALL_AGGREGATE_NODE_PROPERTIES)) {
            AggregationNodeType aggregationNodeType2 = new AggregationNodeType();
            AggregationElements aggregationElements = new AggregationElements();
            aggregationElements.getAggregationElement();
            aggregationNodeType2.setAggregationElements(aggregationElements);
            GroupingElementType groupingElementType = new GroupingElementType();
            Attributes attributes = new Attributes();
            attributes.getAttribute();
            groupingElementType.setAttributes(attributes);
            aggregationNodeType2.setGroupingElement(groupingElementType);
            if (aggregationNodeType.getAggregationElements() != null && aggregationNodeType.getAggregationElements().getAggregationElement() != null) {
                AttributeTypeHelper.copyAttributes(aggregationNodeType2.getAggregationElements().getAggregationElement(), aggregationNodeType.getAggregationElements().getAggregationElement());
            }
            if (aggregationNodeType.getGroupingElement() != null) {
                AttributeTypeHelper.copyGroupingElementType(aggregationNodeType2.getGroupingElement(), aggregationNodeType.getGroupingElement());
            }
            aggregationNodeType2.setAutoSpec(aggregationNodeType.getAutoSpec());
            object = aggregationNodeType2;
        } else if (string.equals("SQL_EXPRESSION")) {
            object = this.getSQLExpression();
        } else {
            return super.getProperty(string);
        }
        return object;
    }

    @Override
    public Object getProperty(ComplexProperty complexProperty) {
        if (complexProperty.getPropertyName().equals(SOURCE_COLUMNS) || complexProperty.getPropertyName().equals(AUTO_SPEC) || complexProperty.getPropertyName().equals(MAIN_GROUP_BY) || complexProperty.getPropertyName().equals(REFACTOR_AGGREGATED_COLUMNS) || complexProperty.getPropertyName().equals("SQL_EXPRESSION")) {
            return complexProperty.getOldData();
        }
        return super.getProperty(complexProperty);
    }

    @Override
    public void setProperty(String string, Object object) {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        if (string.equals(SOURCE_COLUMNS)) {
            assert (object instanceof AggregationElements);
            aggregationNodeType.setAggregationElements((AggregationElements)object);
        } else if (string.equals(AUTO_SPEC)) {
            AggregationNodeType aggregationNodeType2 = (AggregationNodeType)object;
            aggregationNodeType.setAutoSpec(aggregationNodeType2.getAutoSpec());
            aggregationNodeType.setGroupingElement(aggregationNodeType2.getGroupingElement());
            aggregationNodeType.setAggregationElements(aggregationNodeType2.getAggregationElements());
        } else if (string.equals(MAIN_GROUP_BY)) {
            aggregationNodeType.setGroupingElement((GroupingElementType)object);
        } else if (string.equals(ALL_AGGREGATE_NODE_PROPERTIES)) {
            AggregationNodeType aggregationNodeType3 = (AggregationNodeType)object;
            aggregationNodeType.setAggregationElements(aggregationNodeType3.getAggregationElements());
            aggregationNodeType.setAutoSpec(aggregationNodeType3.getAutoSpec());
            aggregationNodeType.setGroupingElement(aggregationNodeType3.getGroupingElement());
        } else if (string.equals(REFACTOR_AGGREGATED_COLUMNS)) {
            Map map = (Map)object;
            GroupingElementType groupingElementType = (GroupingElementType)map.get("GroupingElementType");
            AggregationElements aggregationElements = (AggregationElements)map.get("AggregationElements");
            aggregationNodeType.setGroupingElement(groupingElementType);
            aggregationNodeType.setAggregationElements(aggregationElements);
        } else if (string.equals("SQL_EXPRESSION")) {
            if (object != null && object.equals("SQL_EXPRESSION_GENERATE")) {
                this.setSQLExpression(this.generateSQLExpression());
            } else {
                this.setSQLExpression((String)object);
            }
        } else {
            super.setProperty(string, object);
        }
    }

    @Override
    public String generateSQLExpression() {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        return this.wrapExpressionInWithClause(AttributeTypeHelper.generateSQLExpression(this.getContext(), aggregationNodeType.getAggregationElements(), aggregationNodeType.getGroupingElement(), null, false));
    }

    @Override
    public boolean isVersionSupported(Context context, StringBuffer stringBuffer) {
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        Version version = (Version)context.getProperty("TARGET_DATABASE_VERSION");
        stringBuffer.setLength(0);
        if (!DbVersionHelper.isDB121Up((Version)version)) {
            List list = aggregationNodeType.getAggregationElements().getAggregationElement();
            for (AggregationElementType aggregationElementType : list) {
                GroupingElementType groupingElementType = aggregationElementType.getSubGroupBy();
                if (groupingElementType == null || groupingElementType.getAttributes() == null || groupingElementType.getAttributes().getAttribute().size() <= 0) continue;
                String string = ((AttributeType)groupingElementType.getAttributes().getAttribute().get(0)).getName();
                String string2 = ((AttributeType)groupingElementType.getAttributes().getAttribute().get(0)).getDataType();
                if (DbMetadataUtils.isTargetCategoricalDataTypeSupported((Version)version, (String)string2)) continue;
                Object[] objectArray = new Object[]{string, string2};
                stringBuffer.append(MessageFormat.format(CodeGenLrb.get("VALIDATE_ATTR_DATA_TYPE_NOT_SUPPORTED"), objectArray));
                return false;
            }
        }
        return true;
    }

    @Override
    public void handleRemoveConnectionFrom(Node node) {
        super.handleRemoveConnectionFrom(node);
        this.validate(false);
    }

    @Override
    public void handleNewConnectionFrom(Node node) {
        super.handleNewConnectionFrom(node);
        this.validate(false);
    }

    private void excecuteInputColumnsTxn() {
        OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
        ArrayList<ComplexProperty> arrayList = new ArrayList<ComplexProperty>();
        ComplexProperty complexProperty = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty.setOldData(this.getSQLExpression());
        arrayList.add(complexProperty);
        odmrSDMUndoFilter.prepareUndoComplexPropertyList(this, this.getContext(), arrayList);
    }

    private boolean validateInputAttributes() {
        String string;
        boolean bl = true;
        AbstractNode abstractNode = this.findParentNode();
        assert (abstractNode instanceof DataProvider);
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        DataProvider dataProvider = (DataProvider)((Object)abstractNode);
        Attributes attributes = dataProvider.getAttributes();
        List list2 = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (Object object : list2) {
            String string2 = object.getAlias();
            string = string2 != null && string2.trim().length() > 0 ? string2 : object.getName();
            hashMap.put(string, (AttributeType)object);
        }
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        bl = AggregationNode.validateGroupingElementType(hashMap, groupingElementType);
        if (bl) {
            for (String string2 : list) {
                string = string2.getSource();
                bl = AggregationNode.validateGroupingElementType(hashMap, (GroupingElementType)string);
                if (!bl) {
                    this.addMessage("AGGREGATION_MISSING_COLUMN", MessageEnumType.INCOMPLETE, new String[0]);
                } else {
                    GroupingElementType groupingElementType2 = string2.getSubGroupBy();
                    bl = AggregationNode.validateGroupingElementType(hashMap, groupingElementType2);
                    if (bl) continue;
                    this.addMessage("AGGREGATION_MISSING_COLUMN", MessageEnumType.INCOMPLETE, new String[0]);
                }
                break;
            }
        } else {
            this.addMessage("AGGREGATION_INCOMPLETE_SRC_DATA", MessageEnumType.INCOMPLETE, new String[0]);
        }
        return bl;
    }

    private static boolean validateGroupingElementType(Map<String, AttributeType> map, GroupingElementType groupingElementType) {
        List list;
        boolean bl = true;
        if (null != groupingElementType.getAttributes() && null == groupingElementType.getExpression() && null != (list = groupingElementType.getAttributes().getAttribute()) && !list.isEmpty()) {
            for (AttributeType attributeType : list) {
                AttributeType attributeType2 = map.get(attributeType.getName());
                if (null == attributeType2) {
                    attributeType.setStatus(AttributeStatus.MISSING);
                    bl = false;
                    continue;
                }
                attributeType.setStatus(attributeType2.getStatus());
                attributeType.setStatus(attributeType2.getStatus().equals((Object)AttributeStatus.VALID) ? AttributeStatus.VALID : AttributeStatus.INVALID);
            }
        }
        return bl;
    }

    private static boolean isGroupingElementInvalid(Map<String, AttributeType> map, GroupingElementType groupingElementType) {
        boolean bl = false;
        if (null != groupingElementType.getAttributes() && null != groupingElementType.getAttributes().getAttribute()) {
            for (AttributeType attributeType : groupingElementType.getAttributes().getAttribute()) {
                AttributeType attributeType2 = map.get(attributeType.getName());
                if (null == attributeType2) {
                    bl = true;
                    break;
                }
                if (attributeType2.getStatus().equals((Object)AttributeStatus.VALID)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static Map<String, AggregationElementType> getInvalidAggregationElements(DataProvider dataProvider, AggregationNodeType aggregationNodeType) {
        String string;
        HashMap<String, AggregationElementType> hashMap = new HashMap<String, AggregationElementType>();
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        if (list.isEmpty()) {
            return hashMap;
        }
        Attributes attributes = dataProvider.getAttributes();
        List list2 = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap2 = new HashMap<String, AttributeType>();
        for (Object object : list2) {
            String string2 = object.getAlias();
            string = string2 != null && string2.trim().length() > 0 ? string2 : object.getName();
            hashMap2.put(string, (AttributeType)object);
        }
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        if (AggregationNode.isGroupingElementInvalid(hashMap2, groupingElementType)) {
            for (String string2 : list) {
                hashMap.put(string2.getOutput().getName(), (AggregationElementType)string2);
            }
            return hashMap;
        }
        for (String string2 : list) {
            GroupingElementType groupingElementType2;
            string = string2.getSource();
            if (AggregationNode.isGroupingElementInvalid(hashMap2, (GroupingElementType)string)) {
                hashMap.put(string2.getOutput().getName(), (AggregationElementType)string2);
            }
            if (!AggregationNode.isGroupingElementInvalid(hashMap2, groupingElementType2 = string2.getSubGroupBy())) continue;
            hashMap.put(string2.getOutput().getName(), (AggregationElementType)string2);
        }
        return hashMap;
    }

    @Override
    public String getHelpTopic() {
        return "aggregation_node";
    }

    public static void autoRemoveAttributes(DataProvider dataProvider, AggregationNodeType aggregationNodeType) {
        String string2;
        Object object;
        AttributeType attributeType2;
        List list = aggregationNodeType.getAggregationElements().getAggregationElement();
        if (list.isEmpty()) {
            return;
        }
        Attributes attributes = dataProvider.getAttributes();
        List list2 = attributes.getAttribute();
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        for (AttributeType attributeType2 : list2) {
            object = attributeType2.getAlias();
            string2 = object != null && ((String)object).trim().length() > 0 ? object : attributeType2.getName();
            hashMap.put(string2, attributeType2);
        }
        ArrayList arrayList = new ArrayList();
        attributeType2 = aggregationNodeType.getGroupingElement();
        if (AggregationNode.isGroupingElementInvalid(hashMap, (GroupingElementType)attributeType2)) {
            for (String string2 : list) {
                arrayList.add(string2);
            }
        } else {
            for (String string2 : list) {
                GroupingElementType groupingElementType;
                GroupingElementType groupingElementType2 = string2.getSource();
                if (AggregationNode.isGroupingElementInvalid(hashMap, groupingElementType2)) {
                    arrayList.add(string2);
                }
                if (!AggregationNode.isGroupingElementInvalid(hashMap, groupingElementType = string2.getSource())) continue;
                arrayList.add(string2);
            }
        }
        object = arrayList.iterator();
        block3: while (object.hasNext()) {
            string2 = (AggregationElementType)object.next();
            for (GroupingElementType groupingElementType : list) {
                if (!groupingElementType.getOutput().getName().equals(string2.getOutput().getName())) continue;
                list.remove(groupingElementType);
                continue block3;
            }
        }
    }

    private boolean updateGroupingElement(GroupingElementType groupingElementType, Map<String, AttributeType> map) {
        boolean bl = false;
        for (AttributeType attributeType : groupingElementType.getAttributes().getAttribute()) {
            AttributeType attributeType2 = map.get(attributeType.getName());
            if (attributeType2 == null || attributeType.getName().equals(attributeType2.getName()) && attributeType.getDataType().equals(attributeType2.getDataType())) continue;
            attributeType.setName(attributeType2.getName());
            attributeType.setDataType(attributeType2.getDataType());
            bl = true;
        }
        return bl;
    }

    @Override
    public void refactorAttributes(Node node, Map<String, AttributeType> map) {
        HashMap<String, AttributeType> hashMap = new HashMap<String, AttributeType>();
        AggregationNodeType aggregationNodeType = (AggregationNodeType)this.getData();
        GroupingElementType groupingElementType = aggregationNodeType.getGroupingElement();
        GroupingElementType groupingElementType2 = (GroupingElementType)MetaDataHelper.copyMetadataObject(groupingElementType);
        boolean bl = this.updateGroupingElement(groupingElementType2, map);
        AggregationElements aggregationElements = new AggregationElements();
        List list = aggregationElements.getAggregationElement();
        AggregationElements aggregationElements2 = aggregationNodeType.getAggregationElements();
        List list2 = aggregationElements2.getAggregationElement();
        for (Object object : list2) {
            AggregationElementType aggregationElementType = (AggregationElementType)MetaDataHelper.copyMetadataObject(object);
            GroupingElementType groupingElementType3 = aggregationElementType.getSource();
            bl |= this.updateGroupingElement(groupingElementType3, map);
            GroupingElementType groupingElementType4 = aggregationElementType.getSubGroupBy();
            bl |= this.updateGroupingElement(groupingElementType4, map);
            list.add(aggregationElementType);
        }
        if (bl) {
            Object object;
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this.getUndoFilter();
            object = new HashMap();
            object.put("GroupingElementType", groupingElementType2);
            object.put("AggregationElements", aggregationElements);
            odmrSDMUndoFilter.prepareUndo(this, this.getContext(), REFACTOR_AGGREGATED_COLUMNS, object);
            this.refactorChildrenAttributes(this, hashMap);
        }
    }

    @Override
    public void refactorForApply() {
    }
}

