/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.r;

import java.util.ArrayList;
import java.util.List;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.workflow.inspect.AbstractNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.NodeProperty;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyGroupImpl;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.xmlschema.ExtensibleBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;

public class RBuildNodePropertyModel
extends AbstractNodePropertyModel {
    private static int ACCURACY_METRIC_SIZE = 1;
    protected static List<NodeProperty> properties = new ArrayList<NodeProperty>();
    public static final NodeProperty MODEL_ADDED_REMOVED;
    public static final NodeProperty ALGORITHM_SETTINGS;
    public static final NodeProperty CASE_IDS;
    public static final NodeProperty MODELS_RERUN;
    public static final NodeProperty MODEL_ANNOTATION;
    public static final NodeProperty MODEL_NAME;
    public static final NodeProperty MODEL_USEFOROUTPUT;
    public static final NodeProperty MINING_ATTRIBUTE_SETTINGS;
    public static final NodeProperty MINING_FUNCTION;
    public static final NodeProperty TARGET;
    public static final NodeProperty SPLIT_VALUE;
    public static final NodeProperty SPLIT_DATA_FORMAT;
    public static final NodeProperty GEN_ACCURACY_METRICS_REG;
    public static final NodeProperty GEN_ACCURACY_METRICS_CLAS;
    public static final NodeProperty GEN_RESIDUALS;
    public static final NodeProperty GEN_CONFUSION_MATRIX;
    public static final NodeProperty GEN_ROC_CURVE;
    public static final NodeProperty GEN_LIFT_AND_PROFIT;
    public static final NodeProperty TEST_OPTIONS_CHANGED;
    public static final NodeProperty TEST_SETTINGS_CHANGED;
    public static final NodeProperty TESTS_RERUN;
    public static final NodeProperty TESTS_ADDED_REMOVED;

    public RBuildNodePropertyModel(Context context) {
        super(context);
        NodeType nodeType = this.workflowElement.getNode().getData();
        ExtensibleBuildNodeType extensibleBuildNodeType = (ExtensibleBuildNodeType)nodeType;
        MiningFunctionType miningFunctionType = extensibleBuildNodeType.getMiningFunction();
        if (miningFunctionType != null) {
            switch (miningFunctionType) {
                case CLASSIFICATION: 
                case REGRESSION: {
                    NodeProperty nodeProperty = MiningFunctionType.REGRESSION.equals((Object)miningFunctionType) ? GEN_ACCURACY_METRICS_REG : GEN_ACCURACY_METRICS_CLAS;
                    Property property = new Property(nodeProperty.id, nodeProperty.displayName, nodeType.getName(), nodeProperty.description, nodeProperty.group);
                    this.rows.add(property);
                    break;
                }
            }
        }
    }

    @Override
    public String getHelpTopic() {
        return "r_node_pi";
    }

    @Override
    protected int getPropertyEndIndex() {
        return super.getPropertyEndIndex() + ACCURACY_METRIC_SIZE;
    }

    @Override
    protected List<NodeProperty> getNodeProperties() {
        return properties;
    }

    static {
        properties.addAll(AbstractNodePropertyModel.properties);
        int n = properties.size();
        MODEL_ADDED_REMOVED = new NodeProperty("modelAddedorRemoved", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_VIEW_PROPERTY_MODEL_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_ADDED_REMOVED);
        ALGORITHM_SETTINGS = new NodeProperty("algTreeSettings", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_ALGORITHM_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(ALGORITHM_SETTINGS);
        CASE_IDS = new NodeProperty("caseAttributes", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_CASE_ID_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(CASE_IDS);
        MODELS_RERUN = new NodeProperty("modelsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_BUILD"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODELS_RERUN);
        MODEL_ANNOTATION = new NodeProperty("modelAnnotation", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_ANNOTATION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_ANNOTATION);
        MODEL_NAME = new NodeProperty("modelName", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_NAME_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_NAME);
        MODEL_USEFOROUTPUT = new NodeProperty("modelUseForOutput", PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_MODEL_USEFOR_OUTPUT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MODEL_USEFOROUTPUT);
        MINING_ATTRIBUTE_SETTINGS = new NodeProperty("miningAttributeSettings", PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE"), PropertyLrb.get("PI_BUILD_GROUP_BUILD_ATTRIBUTE_USAGE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MINING_ATTRIBUTE_SETTINGS);
        MINING_FUNCTION = new NodeProperty("miningFunction", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_MINING_FUNCTION"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_MINING_FUNCTION_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(MINING_FUNCTION);
        TARGET = new NodeProperty("targetAttribute", PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_TARGET_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TARGET);
        SPLIT_VALUE = new NodeProperty("splitValueChanged", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(SPLIT_VALUE);
        SPLIT_DATA_FORMAT = new NodeProperty("splitDataFormat", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_SETTINGS_TABLE_BUILD_MODEL_TEST_SPLIT_FORMAT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(SPLIT_DATA_FORMAT);
        GEN_RESIDUALS = new NodeProperty("genResiduals", PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS"), PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_RESIDUALS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_RESIDUALS);
        GEN_CONFUSION_MATRIX = new NodeProperty("genConfusionMatrix", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_CONFUSION_MATRIX"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_CONFUSION_MATRIX_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_CONFUSION_MATRIX);
        GEN_ROC_CURVE = new NodeProperty("genROC", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ROC_CURVE"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ROC_CURVE_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_ROC_CURVE);
        GEN_LIFT_AND_PROFIT = new NodeProperty("genLiftProfit", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_LIFT_AND_PROFIT"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_LIFT_AND_PROFIT_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(GEN_LIFT_AND_PROFIT);
        TEST_OPTIONS_CHANGED = new NodeProperty("testOptionsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_OPTIONS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TEST_OPTIONS_CHANGED);
        TEST_SETTINGS_CHANGED = new NodeProperty("testSettingsChanged", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_SETTINGS_CHANGED_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
        properties.add(TEST_SETTINGS_CHANGED);
        TESTS_RERUN = new NodeProperty("testsRerun", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(TESTS_RERUN);
        TESTS_ADDED_REMOVED = new NodeProperty("testsRemoved", PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_MODEL_BUTTON_MARK_FOR_RERUN_TEST"), Groups.CUSTOM_BUILD, n++);
        properties.add(TESTS_ADDED_REMOVED);
        GEN_ACCURACY_METRICS_REG = new NodeProperty("genAccuracyMetrics", PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_PERFORMANCE_METRICS"), PropertyLrb.get("PI_REGRESS_BUILD_GROUP_TEST_PERFORMANCE_METRICS_DESCRIPTION"), Groups.CUSTOM_BUILD, n);
        GEN_ACCURACY_METRICS_CLAS = new NodeProperty("genAccuracyMetrics", PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS"), PropertyLrb.get("PI_CLASS_BUILD_GROUP_TEST_GEN_ACCURACY_METRICS_DESCRIPTION"), Groups.CUSTOM_BUILD, n++);
    }

    private static class Groups {
        private static final PropertyGroupImpl CUSTOM_BUILD = new PropertyGroupImpl(PreferencesLrb.get("PI_BUILD_NODE_GROUP_BUILD_TITLE"));

        private Groups() {
        }
    }
}

