/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect.profile;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.controls.DataMinerCombBox;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.ToolTipComboBoxRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.renderers.AttributeTypeCellRenderer;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.DataProfileAttributesDialog;
import oracle.dmt.dataminer.workflow.inspect.profile.DataProfileNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.profile.ProfileGroupPIPropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.profile.WorkflowDataProfileNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.table.TablePIPropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractDataNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.DataProfileNode;
import oracle.dmt.dataminer.workflow.model.DataProvider;
import oracle.dmt.dataminer.workflow.model.Node;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileInputType;
import oracle.dmt.dataminer.workflow.xmlschema.DataProfileNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DataProfileNodeProfileGroupPIComponentPanel
extends PIComponentPanel {
    private static final String DEFAULT_GROUP_BY_VALUE = ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_GROUP_GROUP_BY_DEFAULT");
    private static final String GROUP_VALUE_NONE = ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_GROUP_GROUP_BY_NONE");
    private static Icon _editIcon;
    private List<AttributeType> _profiledAttributes = new Vector<AttributeType>();
    private List<AttributeType> _allAttributes = new Vector<AttributeType>();
    private Map<String, AttributeType> _allAttributesMap = new HashMap<String, AttributeType>();
    private List<String> _allowedAttributes = new ArrayList<String>();
    private JButton _editBtn;
    private JButton _removeBtn;
    private AttrTableModel<AttributeType> tableModel;
    private AbstractDataNode _targetNode;
    private JCheckBox jChkBoxAuto;
    private JComboBox jComboBoxGroupby;
    private JLabel jLabelGroupby;
    private DataMinerTablePanel tablePanel;

    public DataProfileNodeProfileGroupPIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelGroupby = new JLabel();
        this.jComboBoxGroupby = new DataMinerCombBox();
        this.jChkBoxAuto = new JCheckBox();
        this.tablePanel = new DataMinerTablePanel();
        this.jLabelGroupby.setText("Group  By:");
        this.jComboBoxGroupby.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jChkBoxAuto.setText("Auto Input Columns Selection");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jChkBoxAuto, -2, 289, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelGroupby, -2, 117, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxGroupby, -2, 230, -2))).addGap(0, 56, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelGroupby).addComponent(this.jComboBoxGroupby, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jChkBoxAuto).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 333, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelGroupby, (Component)this.jComboBoxGroupby, (String)ProfileGroupPIPropertyLrb.get("PI_PROFILE_NODE_PROFILE_GROUP_GROUP_BY"));
        ResourceUtils.resButton((AbstractButton)this.jChkBoxAuto, (String)TablePIPropertyLrb.get("PI_CREATE_TABLE_NODE_GROUP_COLUMNS_AUTO"));
        this.jChkBoxAuto.setOpaque(false);
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
        }
    }

    public void initUI(PropertyModel propertyModel) {
        Object object;
        Object object2;
        DataProfileInputType dataProfileInputType;
        Object object3;
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        if (!(nodeType instanceof DataProfileNodeType)) {
            return;
        }
        List<AttributeType> list = this.getDatasourceAttributes();
        if (list != null) {
            this._allAttributes.addAll(list);
            object3 = list.iterator();
            while (object3.hasNext()) {
                dataProfileInputType = (AttributeType)object3.next();
                this._allAttributesMap.put(dataProfileInputType.getName(), (AttributeType)dataProfileInputType);
                try {
                    if (DatabaseMetadataUtils.isACustomDataType(this.getContext((PropertyModel)this._model), dataProfileInputType.getDataType())) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception, (String)"Unexpected Exception");
                    return;
                }
                object2 = DatabaseMetadataUtils.getDefaultMiningType(dataProfileInputType.getDataType());
                if (!((String)object2).equals("Numerical") && !((String)object2).equals("Categorical")) continue;
                this._allowedAttributes.add(dataProfileInputType.getName());
            }
        }
        if ((object2 = (dataProfileInputType = (object3 = (DataProfileNodeType)nodeType).getDataProfileInput()).getAttributes()) != null && (object = object2.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = Collator.getInstance();
        Collections.sort(this._allowedAttributes, object);
        Vector<String> vector = new Vector<String>(this._allowedAttributes);
        vector.add(0, DEFAULT_GROUP_BY_VALUE);
        final DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(vector);
        String string = DEFAULT_GROUP_BY_VALUE;
        AttributeType attributeType = dataProfileInputType.getGroupByAttribute();
        if (null != attributeType) {
            string = attributeType.getName();
            if (string != null && -1 == this._allowedAttributes.indexOf(string)) {
                defaultComboBoxModel.addElement(string);
            }
            defaultComboBoxModel.removeElementAt(0);
            defaultComboBoxModel.insertElementAt(GROUP_VALUE_NONE, 0);
        }
        this.jComboBoxGroupby.setModel(defaultComboBoxModel);
        this.jComboBoxGroupby.setSelectedItem(string);
        if (attributeType != null) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jLabelGroupby.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                this.jLabelGroupby.setIcon(null);
            }
        } else {
            this.jLabelGroupby.setIcon(null);
        }
        this.jComboBoxGroupby.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                String string = (String)object;
                if (GROUP_VALUE_NONE.equals(string)) {
                    defaultComboBoxModel.removeElementAt(0);
                    defaultComboBoxModel.insertElementAt(DEFAULT_GROUP_BY_VALUE, 0);
                    DataProfileNodeProfileGroupPIComponentPanel.this.jComboBoxGroupby.setModel(defaultComboBoxModel);
                }
                NodeType nodeType = DataProfileNodeProfileGroupPIComponentPanel.this._targetNode.getData();
                DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)nodeType;
                DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
                DataProfileInputType dataProfileInputType2 = new DataProfileInputType();
                dataProfileInputType2.setGroupByAttribute((AttributeType)DataProfileNodeProfileGroupPIComponentPanel.this._allAttributesMap.get(string));
                Attributes attributes = new Attributes();
                attributes.getAttribute().addAll(dataProfileInputType.getAttributes().getAttribute());
                dataProfileInputType2.setAttributes(attributes);
                DataProfileNodeProfileGroupPIComponentPanel.this.updateProfile(dataProfileInputType2, dataProfileInputType, DataProfileNode.DATAPROFILE_INPUT);
            }
        });
        this.jComboBoxGroupby.setRenderer(new ToolTipComboBoxRenderer());
        this.tableModel = new AttrTableModel<AttributeType>(this._profiledAttributes);
        this.setupItemsTable(this.tableModel);
        this.installItemFilterActions();
        boolean bl = "Yes".equals(object3.getAutoSpec().value());
        this.jChkBoxAuto.setSelected(bl);
        this._editBtn.setEnabled(!bl);
        this._removeBtn.setEnabled(!bl);
        this.jChkBoxAuto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = DataProfileNodeProfileGroupPIComponentPanel.this.jChkBoxAuto.isSelected();
                if (bl && !MessageDialog.confirm((Component)DataProfileNodeProfileGroupPIComponentPanel.this, (Object)DataDialogsLrb.get("DATA_PROFILE_ALL_COLUMNS_SELECTED"), (String)DataDialogsLrb.get("DATA_PROFILE_ALL_COLUMNS_SELECTED_CONFIRM"), null)) {
                    DataProfileNodeProfileGroupPIComponentPanel.this.jChkBoxAuto.setSelected(false);
                    return;
                }
                DataProfileNodeProfileGroupPIComponentPanel.this._editBtn.setEnabled(!bl);
                DataProfileNodeProfileGroupPIComponentPanel.this._removeBtn.setEnabled(!bl);
                DataProfileNodeProfileGroupPIComponentPanel.this.updateAutoSpec("autoSpec", bl);
            }
        });
        this.tablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !DataProfileNodeProfileGroupPIComponentPanel.this.jChkBoxAuto.isSelected()) {
                    DataProfileNodeProfileGroupPIComponentPanel.this.launchEdit();
                }
            }
        });
        this.setWritableControls();
    }

    private void launchEdit() {
        Context context;
        DataProfileAttributesDialog dataProfileAttributesDialog;
        DialogHelper dialogHelper;
        AbstractNode abstractNode = this._targetNode.findParentNode();
        if (abstractNode instanceof AbstractDataNode && (dialogHelper = new DialogHelper(dataProfileAttributesDialog = new DataProfileAttributesDialog(context = this.getContext((PropertyModel)this._model), (DataProfileNode)this._targetNode, (AbstractDataNode)abstractNode))).showAsDialog(this)) {
            this.updateWorkFlow();
        }
    }

    public void updateUI(PropertyModel propertyModel) {
        Object object;
        Object exception;
        if (!(propertyModel instanceof WorkflowDataProfileNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDataProfileNodePropertyProxyModel)propertyModel;
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (nArray != null && nArray.length > 0) {
            for (int attributeType : nArray) {
                exception = (AttributeType)this.tableModel.getSrcData().get(attributeType);
                arrayList.add(exception.getName());
            }
        }
        this._targetNode = (AbstractDataNode)this.getTargetNode((PropertyModel)this._model);
        NodeType nodeType = this._targetNode.getData();
        this._allAttributes.clear();
        this._allAttributesMap.clear();
        this._allowedAttributes.clear();
        List<AttributeType> list = this.getDatasourceAttributes();
        if (list != null) {
            this._allAttributes.addAll(list);
            for (AttributeType dataProfileInputType : list) {
                this._allAttributesMap.put(dataProfileInputType.getName(), dataProfileInputType);
                try {
                    if (DatabaseMetadataUtils.isACustomDataType(this.getContext((PropertyModel)this._model), dataProfileInputType.getDataType())) {
                        continue;
                    }
                }
                catch (Exception exception2) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception2, (String)"Unexpected Exception");
                    return;
                }
                exception = DatabaseMetadataUtils.getDefaultMiningType(dataProfileInputType.getDataType());
                if (!((String)exception).equals("Numerical") && !((String)exception).equals("Categorical")) continue;
                this._allowedAttributes.add(dataProfileInputType.getName());
            }
        }
        this._profiledAttributes.clear();
        DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)nodeType;
        DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
        exception = dataProfileInputType.getAttributes();
        if (exception != null && (object = exception.getAttribute()) != null && !object.isEmpty()) {
            this._profiledAttributes.addAll((Collection<AttributeType>)object);
        }
        object = Collator.getInstance();
        Collections.sort(this._allowedAttributes, object);
        Vector<String> vector = new Vector<String>(this._allowedAttributes);
        vector.add(0, DEFAULT_GROUP_BY_VALUE);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(vector);
        String string = DEFAULT_GROUP_BY_VALUE;
        AttributeType attributeType = dataProfileInputType.getGroupByAttribute();
        if (null != dataProfileInputType && null != attributeType) {
            string = attributeType.getName();
            if (string != null && -1 == this._allowedAttributes.indexOf(string)) {
                defaultComboBoxModel.addElement(string);
            }
            defaultComboBoxModel.removeElementAt(0);
            defaultComboBoxModel.insertElementAt(GROUP_VALUE_NONE, 0);
        }
        this.jComboBoxGroupby.setModel(defaultComboBoxModel);
        this.jComboBoxGroupby.setSelectedItem(string);
        if (attributeType != null) {
            if (!attributeType.getStatus().equals((Object)AttributeStatus.VALID)) {
                this.jLabelGroupby.setIcon(OracleIcons.getIcon((String)"warning.png"));
            } else {
                this.jLabelGroupby.setIcon(null);
            }
        } else {
            this.jLabelGroupby.setIcon(null);
        }
        this.tableModel.setSrcData(this._profiledAttributes);
        boolean bl = "Yes".equals(dataProfileNodeType.getAutoSpec().value());
        this.jChkBoxAuto.setSelected(bl);
        this._editBtn.setEnabled(!bl);
        this._removeBtn.setEnabled(!bl);
        if (!arrayList.isEmpty()) {
            nArray = new int[arrayList.size()];
            int n = 0;
            int n2 = -1;
            for (AttributeType attributeType2 : this.tableModel.getSrcData()) {
                ++n2;
                int n3 = arrayList.indexOf(attributeType2.getName());
                if (-1 == n3) continue;
                nArray[n++] = n2;
            }
            this.tablePanel.getTable().setSelectedRowsInModel(nArray);
        }
        this.setWritableControls();
    }

    private void setWritableControls() {
        boolean bl = this.isWritable();
        this.jChkBoxAuto.setEnabled(bl);
        this.jComboBoxGroupby.setEnabled(bl);
        if (!bl) {
            this._removeBtn.setEnabled(false);
            this._editBtn.setEnabled(false);
        }
    }

    private void setupItemsTable(AttrTableModel<AttributeType> attrTableModel) {
        this.tablePanel.setup((TableModel)((Object)attrTableModel), PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE"), 0, true);
        this.tablePanel.getTable().setAutoResizeMode(4);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        AttributeTypeCellRenderer attributeTypeCellRenderer = new AttributeTypeCellRenderer();
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(attributeTypeCellRenderer);
    }

    private void installItemFilterActions() {
        this._editBtn = new JButton(_editIcon);
        String string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataProfileNodeProfileGroupPIComponentPanel.this.launchEdit();
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeType nodeType = DataProfileNodeProfileGroupPIComponentPanel.this._targetNode.getData();
                DataProfileNodeType dataProfileNodeType = (DataProfileNodeType)nodeType;
                DataProfileInputType dataProfileInputType = dataProfileNodeType.getDataProfileInput();
                int[] nArray = DataProfileNodeProfileGroupPIComponentPanel.this.tablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length > 0) {
                    Attributes attributes;
                    HashMap<String, Attributes> hashMap = new HashMap<String, Attributes>();
                    for (int i = 0; i < nArray.length; ++i) {
                        attributes = (AttributeType)DataProfileNodeProfileGroupPIComponentPanel.this.tableModel.getSrcData().get(nArray[i]);
                        hashMap.put(attributes.getName(), attributes);
                    }
                    DataProfileInputType dataProfileInputType2 = new DataProfileInputType();
                    attributes = new Attributes();
                    List list = attributes.getAttribute();
                    for (AttributeType attributeType : DataProfileNodeProfileGroupPIComponentPanel.this._profiledAttributes) {
                        if (null != hashMap.get(attributeType.getName())) continue;
                        list.add(attributeType);
                    }
                    dataProfileInputType2.setAttributes(attributes);
                    dataProfileInputType2.setGroupByAttribute(dataProfileInputType.getGroupByAttribute());
                    DataProfileNodeProfileGroupPIComponentPanel.this.updateProfile(dataProfileInputType2, dataProfileInputType, DataProfileNode.DATAPROFILE_INPUT);
                }
            }
        });
        ListSelectionModel listSelectionModel = this.tablePanel.getTable().getSelectionModel();
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && !this.jChkBoxAuto.isSelected());
        this._removeBtn.setToolTipText(ProfileGroupPIPropertyLrb.get("PI_PROFILE_COLUMNS_REMOVE_TOOLTIP"));
        this.tablePanel.addControlBarComponents(this._editBtn, this._removeBtn);
    }

    private void updateProfile(Object object, Object object2, String string) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty(string, object);
        complexProperty.setOldData(object2);
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.DATAPROFILE_INPUT.index), null, complexProperty, null, null));
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this._targetNode.getSQLExpression());
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
        if (this._model instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
            workflowNodePropertyProxyModel.setValueAt(string, this._targetNode, arrayList);
        }
    }

    private void updateAutoSpec(String string, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ComplexProperty complexProperty = new ComplexProperty("autoSpec", bl ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.AUTO_SPEC.index), null, complexProperty, null, null));
        ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
        complexProperty2.setOldData(this._targetNode.getSQLExpression());
        arrayList.add(new Property(String.valueOf(DataProfileNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
        if (this._model instanceof WorkflowNodePropertyProxyModel) {
            WorkflowNodePropertyProxyModel workflowNodePropertyProxyModel = this._model;
            workflowNodePropertyProxyModel.setValueAt(string, this._targetNode, arrayList);
        }
    }

    protected List<AttributeType> getDatasourceAttributes() {
        List list = null;
        Attributes attributes = null;
        AbstractDataNode abstractDataNode = this.getNode((PropertyModel)this._model);
        if (abstractDataNode != null) {
            if (abstractDataNode instanceof DataProfileNode) {
                attributes = ((DataProfileNode)abstractDataNode).getSourceAttributes();
            } else {
                AbstractNode abstractNode = abstractDataNode.findParentNode();
                if (abstractNode instanceof DataProvider) {
                    attributes = ((DataProvider)((Object)abstractNode)).getAttributes();
                }
            }
        }
        if (attributes != null) {
            list = attributes.getAttribute();
        }
        return list;
    }

    private AbstractDataNode getNode(PropertyModel propertyModel) {
        Node node = this.getTargetNode(propertyModel);
        if (node == null || !(node instanceof AbstractDataNode)) {
            return null;
        }
        AbstractDataNode abstractDataNode = (AbstractDataNode)node;
        return abstractDataNode;
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            DataProfileNodeProfileGroupPIComponentPanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && !DataProfileNodeProfileGroupPIComponentPanel.this.jChkBoxAuto.isSelected());
        }
    }
}

