/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.controls.CustomPIPopupListener;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AttributeTableModel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowModelDetailsNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.ExtractQueryFactory;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.inspector.PropertyLabel;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class ModelDetailsPIComponentOutputPanel
extends PIComponentPanel {
    private PropertyModel _model;
    private ModelDetailsDataNode _data;
    private ModelDetailType _modelDetailType;
    private MiningDetailsOutputType _currentOutputType;
    private MiningFunctions _currentFunction;
    private MiningAlgorithmOptions _currentAlgorithm;
    private List<OutputAttributeType> _currentOutputColumns;
    private AttributeTableModel _outputColumnsTableModel;
    private GenericTable _jOutputColumnsTable = new DataMinerTable();
    private Version dbVersion = null;
    private static final Logger theLogger = Logger.getLogger(ModelDetailsPIComponentOutputPanel.class.getName());
    private final String UNDEFINED = ModelDetailsLrb.get("UNDEFINED_SELECTION");
    private ModelDetailsOutputType _modelOutputType;
    private ComponentWithTitlebar<JComponent> _jOutputComponentWithTitlebar1;
    private JComboBox _jOutputTypeCombo;
    private PropertyLabel _jOutputTypeLabel;

    public ModelDetailsPIComponentOutputPanel(PropertyModel propertyModel) {
        super(propertyModel);
        assert (propertyModel != null) : "PropertyModel for  node is null.";
        this._data = this.getTargetNode(propertyModel);
        assert (this._data != null) : "Model details node is null.";
        if (this._data == null) {
            return;
        }
        Context context = this.getContext(propertyModel);
        this.dbVersion = ConnectionFolder.getConnectionFolder(context).getDbVersion();
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this._jOutputComponentWithTitlebar1 = new ComponentWithTitlebar();
        this._jOutputTypeCombo = new JComboBox();
        this._jOutputTypeLabel = new PropertyLabel();
        this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Full Tree", "Item 1", "Item 2", "Item 3", "Item 4"}));
        this._jOutputTypeLabel.setText("Output:");
        this._jOutputTypeLabel.setPreferredSize(new Dimension(45, 14));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._jOutputComponentWithTitlebar1, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent((Component)this._jOutputTypeLabel, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jOutputTypeCombo, -2, 142, -2).addGap(0, 300, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this._jOutputTypeLabel, -2, -1, -2).addComponent(this._jOutputTypeCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this._jOutputComponentWithTitlebar1, -1, 270, Short.MAX_VALUE)));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jOutputTypeLabel, (Component)this._jOutputTypeCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this._jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this._jOutputTypeCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
    }

    public void initUI(PropertyModel propertyModel) {
        this._model = propertyModel;
        ModelDetailsDataNode modelDetailsDataNode = this.getTargetNode(propertyModel);
        if (modelDetailsDataNode == null) {
            return;
        }
        boolean bl = this.isWritable();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)modelDetailsDataNode.getData();
        this.loadData(modelDetailsDataNodeType);
        this.initCombo();
        this._outputColumnsTableModel = new AttributeTableModel(this.getContext(this._model), this._currentOutputColumns, modelDetailsDataNode, "dummy", true, true);
        this._outputColumnsTableModel.setWritable(bl);
        this.setupModelsTable(this._outputColumnsTableModel);
        this._jOutputTypeCombo.addPopupMenuListener(new CustomPIPopupListener(){

            @Override
            public void updatePropertyModel(Object object) {
                ModelDetailsPIComponentOutputPanel.this.processOutputTypeComboAction();
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)this._jOutputColumnsTable);
        this._jOutputComponentWithTitlebar1.setComponent((JComponent)jScrollPane);
        this._jOutputComponentWithTitlebar1.setLabel(new JLabel(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_COLUMNS")));
    }

    private void processOutputTypeComboAction() {
        MiningDetailsOutputType miningDetailsOutputType = (MiningDetailsOutputType)((Object)this._jOutputTypeCombo.getSelectedItem());
        if (this._currentOutputType != miningDetailsOutputType) {
            this._currentOutputType = miningDetailsOutputType;
            this._jOutputTypeCombo.setSelectedItem((Object)this._currentOutputType);
            this.initOutputColumns();
            this._outputColumnsTableModel.reload(this._currentOutputColumns);
            this.updateOutputColumns();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOutputColumns() {
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)this.getTargetNode(this._model).getData();
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Context context = this.getContext(this._model);
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        ModelDetailsOutputType modelDetailsOutputType2 = modelDetailsDataNodeType.getModelDetailsOutput();
        modelDetailsOutputType.setAttributes(this._outputColumnsTableModel.generateAttributes());
        modelDetailsOutputType.setMiningAlgorithm(modelDetailsOutputType2.getMiningAlgorithm());
        modelDetailsOutputType.setMiningFunction(modelDetailsOutputType2.getMiningFunction());
        modelDetailsOutputType.setModels(modelDetailsOutputType2.getModels());
        modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(this._currentOutputType, this._currentAlgorithm, this._currentFunction));
        modelDetailsOutputType.setAutoSpec(modelDetailsDataNodeType.getModelDetailsOutput().getAutoSpec());
        CommandProcessor.getInstance().beginTrans(ModelDetailsLrb.get("TRANSACTION_NAME_OUTPUT_TYPE"));
        try {
            OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)this._data.getUndoFilter();
            odmrSDMUndoFilter.prepareUndo(this._data, context, "modelDetailsOutputColumns", modelDetailsOutputType);
            this._data.validate(true);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_MODEL_UPDATE_UNEXPECTED"), null);
        }
        finally {
            CommandProcessor.getInstance().endTrans();
        }
    }

    private void initOutputColumns() {
        this._currentOutputColumns = ExtractQueryFactory.getModelColumnList(this._data, MiningDetailsOutputType.getMiningDetailType(this._currentOutputType, this._currentAlgorithm, this._currentFunction), this.dbVersion);
    }

    public void initCombo() {
        if (this._currentOutputType == null) {
            this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{this.UNDEFINED}));
        } else {
            this._jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this.dbVersion, this._currentFunction, this._currentAlgorithm)));
            this._jOutputTypeCombo.setSelectedItem((Object)this._currentOutputType);
        }
    }

    private void setupModelsTable(AttributeTableModel attributeTableModel) {
        this._jOutputColumnsTable.setModel((TableModel)attributeTableModel);
        this._jOutputColumnsTable.getTableHeader().setReorderingAllowed(false);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                GenericTable genericTable = (GenericTable)jTable;
                int n3 = genericTable.convertRowIndexToModel(n);
                AttributeTableModel attributeTableModel = (AttributeTableModel)ModelDetailsPIComponentOutputPanel.this._jOutputColumnsTable.getModel();
                OutputAttributeType outputAttributeType = attributeTableModel.getDataVector().get(n3);
                if (outputAttributeType.getStatus() == AttributeStatus.VALID) {
                    return OracleIcons.getIcon((String)"attribute.png");
                }
                if (outputAttributeType.getStatus() == AttributeStatus.MISSING || outputAttributeType.getStatus() == AttributeStatus.INVALID) {
                    return DataMinerIcons.get(Icons.ERROR_STATUS);
                }
                return null;
            }
        });
        TableColumn tableColumn = this._jOutputColumnsTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(attributeTableModel.getContext());
        TableColumn tableColumn2 = this._jOutputColumnsTable.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(dBObjectNameEditor);
    }

    public void loadData(ModelDetailsDataNodeType modelDetailsDataNodeType) {
        this._modelOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        if (this._modelOutputType != null) {
            this._modelDetailType = this._modelOutputType.getType();
            this._currentOutputType = MiningDetailsOutputType.getMiningDetailsOutputType(this._modelDetailType);
            this._currentFunction = MiningFunctions.getMiningFunctionsFromType(this._modelOutputType.getMiningFunction());
            this._currentAlgorithm = MiningAlgorithmOptions.getMiningAlgorithmOption(this._modelOutputType.getMiningAlgorithm());
            this._currentOutputColumns = OutputAttributeType.convertAttributes((Attributes)this._modelOutputType.getAttributes());
            String string = this._modelOutputType.getAutoSpec().value();
            if (string != null) {
                if (this._modelOutputType.getAutoSpec().value().compareTo("Yes") == 0) {
                    this._jOutputTypeCombo.setEnabled(false);
                } else {
                    this._jOutputTypeCombo.setEnabled(this.isWritable());
                }
            }
        } else {
            this._currentOutputType = null;
            this._currentOutputColumns = new ArrayList<OutputAttributeType>();
            this._currentFunction = null;
            this._currentAlgorithm = null;
            this._jOutputTypeCombo.setEnabled(false);
        }
    }

    public void updatePI(PropertyModel propertyModel) {
        ModelDetailsDataNode modelDetailsDataNode = this.getTargetNode(propertyModel);
        if (modelDetailsDataNode == null) {
            return;
        }
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)modelDetailsDataNode.getData();
        this.loadData(modelDetailsDataNodeType);
        this.initCombo();
        this._outputColumnsTableModel.reload(this._currentOutputColumns);
    }

    @Override
    protected ModelDetailsDataNode getTargetNode(PropertyModel propertyModel) {
        if (propertyModel == null) {
            return null;
        }
        if (!(propertyModel instanceof WorkflowModelDetailsNodePropertyProxyModel)) {
            return null;
        }
        WorkflowModelDetailsNodePropertyProxyModel workflowModelDetailsNodePropertyProxyModel = (WorkflowModelDetailsNodePropertyProxyModel)propertyModel;
        Context context = workflowModelDetailsNodePropertyProxyModel.getSelectionContext();
        Element[] elementArray = context.getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof ModelDetailsDataNodeType) {
            return (ModelDetailsDataNode)workflowNodeInspectorElement.getNode();
        }
        return null;
    }
}

