/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inspect;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.inspector.PropertyModel;
import oracle.dmt.dataminer.PreferencesLrb;
import oracle.dmt.dataminer.common.model.AttrTableModel;
import oracle.dmt.dataminer.controls.DBObjectNameEditor;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.JSONDataTypeCellEditor;
import oracle.dmt.dataminer.controls.JSONJComboBox;
import oracle.dmt.dataminer.controls.JSONTableCellRenderer;
import oracle.dmt.dataminer.controls.dialog.DialogHelper;
import oracle.dmt.dataminer.controls.models.ODMrTableModel;
import oracle.dmt.dataminer.controls.renderers.AttributeTypeCellRenderer;
import oracle.dmt.dataminer.core.model.ds.Table;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.DatabaseMetadataUtils;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.runner.RunManagerLrb;
import oracle.dmt.dataminer.utils.AttributeNameValidator;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.workflow.ComplexProperty;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceAttributesDialog;
import oracle.dmt.dataminer.workflow.dialog.data.DataSourceWizard;
import oracle.dmt.dataminer.workflow.inspect.DataSourceNodePropertyModel;
import oracle.dmt.dataminer.workflow.inspect.PIComponentPanel;
import oracle.dmt.dataminer.workflow.inspect.Property;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.inspect.WorkflowDataSourceNodePropertyProxyModel;
import oracle.dmt.dataminer.workflow.inspect.WorkflowNodeInspectorElement;
import oracle.dmt.dataminer.workflow.model.DataSourceNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeStatus;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.TableType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.inspector.InspectorArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.Version;

public class DataSourcePIComponentPanel
extends PIComponentPanel
implements ActionListener {
    private static final Logger theLogger = Logger.getLogger(DataSourcePIComponentPanel.class.getName());
    private static final String[] COLUMN_NAMES = new String[]{PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_NAME_COLUMN"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_ALIAS_COLUMN"), PropertyLrb.get("PI_ATTRIBUTES_GROUP_ATTRIBUTE_DATA_TYPE_COLUMN")};
    private List<AttributeType> _data = new ArrayList<AttributeType>();
    private JButton _refreshBtn;
    private JButton _editBtn;
    private JButton _removeBtn;
    private static Icon _refreshIcon;
    private static Icon _editIcon;
    private WorkflowDataSourceNodePropertyProxyModel _model;
    private boolean _isDatabaseVersion12andUp = false;
    private DataSourceNodeType ddsNodeData;
    private JButton jButtonEditor;
    private JLabel jLabelTable;
    private JTextField jTextFieldTable;
    private JLabel lblIncludeAllAvailableColumns;
    private DataMinerTablePanel tablePanel;

    public DataSourcePIComponentPanel(PropertyModel propertyModel) {
        super(propertyModel);
        DataSourceNode dataSourceNode = (DataSourceNode)this.getTargetNode(propertyModel, DataSourceNodeType.class);
        if (dataSourceNode == null) {
            return;
        }
        this.ddsNodeData = (DataSourceNodeType)dataSourceNode.getData();
        List list = this.ddsNodeData.getAttributes().getAttribute();
        Version version = ConnectionFolder.getConnectionFolder(this.getContext(propertyModel)).getDbVersion();
        this._isDatabaseVersion12andUp = DbVersionHelper.isDB12102Up((Version)version);
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (AttributeType attributeType : list) {
            AttributeType attributeType2 = new AttributeType();
            AttributeTypeHelper.copyAttribute(attributeType2, attributeType);
            arrayList.add(attributeType2);
        }
        this._data.addAll(arrayList);
        this.initComponents();
        this.initRes();
        this.initUI(propertyModel);
    }

    private void initComponents() {
        this.jLabelTable = new JLabel();
        this.jTextFieldTable = new JTextField();
        this.jButtonEditor = new JButton();
        this.tablePanel = new DataMinerTablePanel();
        this.lblIncludeAllAvailableColumns = new JLabel();
        this.setPreferredSize(new Dimension(520, 200));
        this.jLabelTable.setText("Source Table:");
        this.jTextFieldTable.setEditable(false);
        this.jButtonEditor.setText("...");
        this.lblIncludeAllAvailableColumns.setText("Datasource includes all available columns");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabelTable, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblIncludeAllAvailableColumns, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldTable, -1, 386, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEditor, -2, 27, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTable).addComponent(this.jButtonEditor).addComponent(this.jTextFieldTable, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblIncludeAllAvailableColumns).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tablePanel, -1, 129, Short.MAX_VALUE).addContainerGap()));
    }

    public void initRes() {
        ResourceUtils.resLabel((JLabel)this.jLabelTable, (Component)this.jTextFieldTable, (String)PropertyLrb.get("PI_ATTRIBUTES_GROUP_SOURCE_TABLE"));
        if (_editIcon == null) {
            _editIcon = InspectorArb.getIcon((int)24);
            _refreshIcon = OracleIcons.getIcon((String)"refresh.png");
        }
        this.lblIncludeAllAvailableColumns.setVisible(false);
        if (this.ddsNodeData.isIncludeAllAvailableAttributes() != null && this.ddsNodeData.isIncludeAllAvailableAttributes().booleanValue()) {
            this.lblIncludeAllAvailableColumns.setText(PropertyLrb.get("PI_DATA_SOURCE_NODE_INCLUDE_ALL_AVAILABLE_COLUMNS"));
            this.lblIncludeAllAvailableColumns.setVisible(true);
        }
    }

    public void initUI(final PropertyModel propertyModel) {
        Object object;
        this._model = (WorkflowDataSourceNodePropertyProxyModel)propertyModel;
        Element[] elementArray = this.getContext(propertyModel).getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)nodeType;
            object = new Table(dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName());
            this.jTextFieldTable.setText(object.toString());
            this.jTextFieldTable.setToolTipText(object.toString());
            this.jTextFieldTable.setCaretPosition(0);
        }
        boolean bl = this.isWritable();
        this.jButtonEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Context context = DataSourcePIComponentPanel.this.getContext(propertyModel);
                    DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode(propertyModel, DataSourceNodeType.class);
                    DataSourceWizard dataSourceWizard = new DataSourceWizard();
                    dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
                }
                catch (Exception exception) {
                    theLogger.log(Level.FINEST, exception.getMessage());
                }
            }
        });
        object = new AttributesTableModel(this._data);
        ((AttributesTableModel)((Object)object)).setWritable(bl);
        this.setupItemsTable((AttributesTableModel)((Object)object));
        this.installItemFilterActions();
        this.jButtonEditor.setEnabled(bl);
        this._editBtn.setEnabled(bl);
        this._removeBtn.setEnabled(bl);
        this._refreshBtn.setEnabled(bl);
        if (this.ddsNodeData.isIncludeAllAvailableAttributes() != null && this.ddsNodeData.isIncludeAllAvailableAttributes().booleanValue()) {
            this._editBtn.setEnabled(false);
            this._removeBtn.setEnabled(false);
        }
        this.tablePanel.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DataSourcePIComponentPanel.this.launchEdit();
                }
            }
        });
        this.setataTypeRenderer();
    }

    private void launchEdit() {
        Context context = this.getContext((PropertyModel)this._model);
        DataSourceNode dataSourceNode = (DataSourceNode)this.getTargetNode((PropertyModel)this._model, DataSourceNodeType.class);
        DataSourceAttributesDialog dataSourceAttributesDialog = new DataSourceAttributesDialog(context, dataSourceNode);
        DialogHelper dialogHelper = new DialogHelper(dataSourceAttributesDialog);
        dataSourceAttributesDialog.setCheckForUnderlyingTable(true);
        if (!dialogHelper.showAsDialog(this) && null != dataSourceAttributesDialog.getErrorMessage()) {
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)dataSourceAttributesDialog.getErrorMessage(), (String)DataDialogsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null)) {
                DataSourceWizard dataSourceWizard = new DataSourceWizard();
                dataSourceWizard.setTableExists(false);
                dataSourceWizard.runWizard((Component)Ide.getMainWindow(), context, dataSourceNode);
            } else {
                dataSourceAttributesDialog = new DataSourceAttributesDialog(context, dataSourceNode);
                dataSourceAttributesDialog.setCheckForUnderlyingTable(false);
                DialogHelper dialogHelper2 = new DialogHelper(dataSourceAttributesDialog);
                dialogHelper2.showAsDialog(this);
            }
        }
    }

    public void updateUI(PropertyModel propertyModel) {
        if (!(propertyModel instanceof WorkflowDataSourceNodePropertyProxyModel)) {
            return;
        }
        this._model = (WorkflowDataSourceNodePropertyProxyModel)propertyModel;
        DataSourceNode dataSourceNode = (DataSourceNode)this.getTargetNode(propertyModel, DataSourceNodeType.class);
        if (dataSourceNode == null) {
            return;
        }
        this.ddsNodeData = (DataSourceNodeType)dataSourceNode.getData();
        Element[] elementArray = this.getContext(propertyModel).getSelection();
        WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
        NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
        if (nodeType instanceof DataSourceNodeType) {
            DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)nodeType;
            Table table = new Table(dataSourceNodeType.getSourceTable().getSchema(), dataSourceNodeType.getSourceTable().getName());
            this.jTextFieldTable.setText(table.toString());
        }
        this.updateTable(dataSourceNode);
        boolean bl = this.isWritable();
        this._editBtn.setEnabled(bl);
        this._refreshBtn.setEnabled(bl);
        this._removeBtn.setEnabled(bl);
        this.lblIncludeAllAvailableColumns.setVisible(false);
        if (this.ddsNodeData.isIncludeAllAvailableAttributes() != null && this.ddsNodeData.isIncludeAllAvailableAttributes().booleanValue()) {
            this.lblIncludeAllAvailableColumns.setText(PropertyLrb.get("PI_DATA_SOURCE_NODE_INCLUDE_ALL_AVAILABLE_COLUMNS"));
            this.lblIncludeAllAvailableColumns.setVisible(true);
            this._removeBtn.setEnabled(false);
            this._editBtn.setEnabled(false);
        }
    }

    private void updateTable(DataSourceNode dataSourceNode) {
        int n;
        Object object;
        TableColumnModel tableColumnModel;
        Object object2;
        int[] nArray = this.tablePanel.getTable().getSelectedRowsInModel();
        HashMap<String, TableColumnModel> hashMap = null;
        if (nArray != null && nArray.length > 0) {
            object2 = (AttributesTableModel)((Object)this.tablePanel.getTable().getModel());
            hashMap = new HashMap<String, TableColumnModel>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                tableColumnModel = (AttributeType)((ODMrTableModel)((Object)object2)).getSrcData().get(nArray[i]);
                hashMap.put(tableColumnModel.getName(), tableColumnModel);
            }
        }
        object2 = this.tablePanel.getTable().getVisibleRect();
        TableColumn tableColumn = null;
        tableColumnModel = this.tablePanel.getTable().getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            tableColumn = tableColumnModel.getColumn(i);
            nArray2[i] = tableColumn.getPreferredWidth();
        }
        DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
        List list = dataSourceNodeType.getAttributes().getAttribute();
        this._data.clear();
        ArrayList<AttributeType> arrayList = new ArrayList<AttributeType>();
        for (Object object3 : list) {
            object = new AttributeType();
            AttributeTypeHelper.copyAttribute((AttributeType)object, (AttributeType)object3);
            arrayList.add((AttributeType)object);
        }
        this._data.addAll(arrayList);
        AttributesTableModel attributesTableModel = new AttributesTableModel(this._data);
        this.setupItemsTable(attributesTableModel);
        if (hashMap != null) {
            Object object4;
            Object object3;
            object3 = new ArrayList();
            object = attributesTableModel.getSrcData();
            for (int i = 0; i < object.size(); ++i) {
                object4 = (AttributeType)object.get(i);
                if (null == hashMap.get(object4.getName())) continue;
                object3.add(i);
            }
            if (!object3.isEmpty()) {
                Integer[] integerArray = object3.toArray(new Integer[object3.size()]);
                object4 = new int[integerArray.length];
                for (int i = 0; i < integerArray.length; ++i) {
                    object4[i] = (AttributeType)integerArray[i];
                }
                this.tablePanel.getTable().setSelectedRowsInModel((int[])object4);
            }
        }
        if (!this._data.isEmpty()) {
            this.tablePanel.getTable().scrollRectToVisible((Rectangle)object2);
        }
        if (n2 == (n = (tableColumnModel = this.tablePanel.getTable().getColumnModel()).getColumnCount())) {
            for (int i = 0; i < n; ++i) {
                tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setPreferredWidth(nArray2[i]);
            }
        }
        this.setataTypeRenderer();
    }

    private void setataTypeRenderer() {
        if (this._isDatabaseVersion12andUp) {
            TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(2);
            tableColumn.setCellRenderer(new JSONTableCellRenderer());
            JSONJComboBox jSONJComboBox = new JSONJComboBox();
            jSONJComboBox.addActionListener(this);
            tableColumn.setCellEditor(new JSONDataTypeCellEditor((JComboBox)jSONJComboBox));
        }
    }

    private void setupItemsTable(AttributesTableModel attributesTableModel) {
        this.tablePanel.setup((TableModel)((Object)attributesTableModel), PreferencesLrb.get("PI_ATTRUBUTES_GROUP_TITLE"), 0, true);
        this.tablePanel.getTable().setAutoResizeMode(4);
        this.tablePanel.getTable().getSelectionModel().addListSelectionListener(new SelectedItemSelectionHandler());
        if (attributesTableModel.getRowCount() == 0) {
            return;
        }
        TableColumn tableColumn = this.tablePanel.getTable().getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new AttributeTypeCellRenderer());
        DBObjectNameEditor dBObjectNameEditor = new DBObjectNameEditor(this.getContext((PropertyModel)this._model));
        TableColumn tableColumn2 = this.tablePanel.getTable().getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(dBObjectNameEditor);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void installItemFilterActions() {
        this._refreshBtn = new JButton(_refreshIcon);
        String string = RunManagerLrb.get("REFRESH_TIP");
        this._refreshBtn.setToolTipText(string);
        this._refreshBtn.getAccessibleContext().setAccessibleName(string);
        this._refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Element[] elementArray = DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model).getSelection();
                WorkflowNodeInspectorElement workflowNodeInspectorElement = (WorkflowNodeInspectorElement)((Object)elementArray[0].getData());
                NodeType nodeType = workflowNodeInspectorElement.getNode().getData();
                if (nodeType instanceof DataSourceNodeType) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object42;
                    Object object5;
                    Object object6;
                    AttributeType attributeType2;
                    Attributes attributes = new Attributes();
                    List list = attributes.getAttribute();
                    for (AttributeType attributeType2 : DataSourcePIComponentPanel.this._data) {
                        object6 = new AttributeType();
                        AttributeTypeHelper.copyAttribute((AttributeType)object6, attributeType2);
                        list.add(object6);
                    }
                    DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
                    attributeType2 = (DataSourceNodeType)nodeType;
                    object6 = DataSourcePIComponentPanel.this.getAvailableAttributes((DataSourceNodeType)attributeType2);
                    if (object6 == null || object6.isEmpty()) {
                        object5 = attributeType2.getSourceTable();
                        object42 = object5.getSchema();
                        object3 = object5.getName();
                        object2 = MessageFormat.format(DataDialogsLrb.get("TABLE_VALIDATION_ERROR_MISSING"), (String)object42 + "." + (String)object3);
                        if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)object2, (String)DataDialogsLrb.get("TABLE_CHOOSER_FAILURE_TITLE"), null)) {
                            object = new DataSourceWizard();
                            ((DataSourceWizard)object).setTableExists(false);
                            if (((DataSourceWizard)object).runWizard((Component)Ide.getMainWindow(), DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model), dataSourceNode)) {
                                return;
                            }
                        }
                        for (AttributeType attributeType3 : DataSourcePIComponentPanel.this._data) {
                            attributeType3.setStatus(AttributeStatus.MISSING);
                        }
                    } else {
                        for (Object object42 : DataSourcePIComponentPanel.this._data) {
                            object3 = (AttributeType)object6.get(object42.getName());
                            if (null == object3) {
                                object42.setStatus(AttributeStatus.MISSING);
                                continue;
                            }
                            object42.setStatus(object3.getStatus());
                        }
                    }
                    object5 = new Attributes();
                    object42 = object5.getAttribute();
                    object42.addAll(DataSourcePIComponentPanel.this._data);
                    object3 = new ArrayList();
                    object2 = new ComplexProperty("dataSourceAttributes", object5);
                    ((ComplexProperty)object2).setOldData(attributes);
                    object3.add(new Property(String.valueOf(DataSourceNodePropertyModel.DATA_SOURCE_TABLE_CONTENTS.index), null, object2, null, null));
                    object = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    ((ComplexProperty)object).setOldData(dataSourceNode.getSQLExpression());
                    object3.add(new Property(String.valueOf(DataSourceNodePropertyModel.SQL_EXPRESSION.index), null, object, null, null));
                    DataSourcePIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_DATA_SOURCE_NODE_ATTRIBUTES_REFRESHED"), dataSourceNode, (List<Property>)object3);
                }
            }
        });
        this._editBtn = new JButton(_editIcon);
        string = InspectorArb.getString((int)25);
        this._editBtn.setToolTipText(string);
        this._editBtn.getAccessibleContext().setAccessibleName(InspectorArb.getString((int)23));
        this._editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DataSourcePIComponentPanel.this.launchEdit();
            }
        });
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = DataSourcePIComponentPanel.this.tablePanel.getTable().getSelectedRowsInModel();
                if (nArray.length > 0) {
                    AttributesTableModel attributesTableModel = (AttributesTableModel)((Object)DataSourcePIComponentPanel.this.tablePanel.getTable().getModel());
                    ArrayList arrayList = new ArrayList();
                    for (int i = 0; i < nArray.length; ++i) {
                        arrayList.add(attributesTableModel.getSrcData().get(nArray[i]));
                    }
                    DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
                    ArrayList<Property> arrayList2 = new ArrayList<Property>();
                    ComplexProperty complexProperty = new ComplexProperty("dataSourceTableContentRemoved", "dataSourceTableContentAdded", arrayList);
                    arrayList2.add(new Property(String.valueOf(DataSourceNodePropertyModel.DATA_SOURCE_TABLE_CONTENTS.index), null, complexProperty, null, null));
                    ComplexProperty complexProperty2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                    complexProperty2.setOldData(dataSourceNode.getSQLExpression());
                    arrayList2.add(new Property(String.valueOf(DataSourceNodePropertyModel.SQL_EXPRESSION.index), null, complexProperty2, null, null));
                    DataSourcePIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_DATA_SOURCE_NODE_ATTRIBUTES_REMOVED"), dataSourceNode, arrayList2);
                }
            }
        });
        ListSelectionModel listSelectionModel = this.tablePanel.getTable().getSelectionModel();
        this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && this.isWritable());
        this.tablePanel.addControlBarComponents(this._refreshBtn, this._editBtn, this._removeBtn);
    }

    protected Map<String, AttributeType> getAvailableAttributes(DataSourceNodeType dataSourceNodeType) {
        TableType tableType = dataSourceNodeType.getSourceTable();
        Table table = new Table(tableType);
        return this.getAvailableAttributes(table);
    }

    class AttributesTableModel
    extends AttrTableModel<AttributeType> {
        private static final int NAME = 0;
        private static final int ALIAS = 1;
        private static final int DATA_TYPE = 2;
        private boolean writable;

        private AttributesTableModel(List<AttributeType> list) {
            super(COLUMN_NAMES, null);
            this.srcData = new ArrayList(list.size());
            for (AttributeType attributeType : list) {
                AttributeType attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType);
                this.srcData.add(attributeType2);
            }
            this.writable = true;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2;
            Object object3;
            Object object4;
            if (n2 != 1 && DataSourcePIComponentPanel.this._isDatabaseVersion12andUp && n2 != 2) {
                return;
            }
            DataSourceNode dataSourceNode = (DataSourceNode)DataSourcePIComponentPanel.this.getTargetNode((PropertyModel)DataSourcePIComponentPanel.this._model, DataSourceNodeType.class);
            if (dataSourceNode == null) {
                return;
            }
            if (this.srcData.isEmpty()) {
                return;
            }
            AttributeType attributeType = (AttributeType)this.srcData.get(n);
            Vector vector = new Vector();
            vector.addAll(this.srcData);
            vector.remove(attributeType);
            AttributeType attributeType2 = null;
            AttributeType attributeType3 = null;
            if (n2 == 2) {
                object4 = ((String)object).trim();
                object3 = null;
                if (DatabaseMetadataUtils.isJSONTypeSupported((String)object4)) {
                    object4 = DatabaseMetadataUtils.getDataTypeCorresponsingToJSONType((String)object4);
                    object3 = "JSON";
                }
                object2 = (DataSourceNodeType)dataSourceNode.getData();
                List list = object2.getAttributes().getAttribute();
                for (AttributeType attributeType4 : list) {
                    if (!attributeType4.getName().equals(attributeType.getName())) continue;
                    attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType4);
                    attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType4);
                    attributeType2.setDataType((String)object4);
                    attributeType2.setDataTypeQualifier((String)object3);
                    break;
                }
            } else if (n2 == 1) {
                object4 = attributeType.getName();
                object3 = null;
                object2 = attributeType.getAlias();
                if (object != null) {
                    object3 = ((String)object).trim();
                }
                if (object2 != null && StringUtils.isDoubleQuotedString((String)object3)) {
                    object2 = StringUtils.addDoubleQuotes((String)object2);
                }
                if (((String)object3).length() != 0) {
                    if (!StringUtils.isDoubleQuotedString((String)object3)) {
                        object3 = ((String)object3).toUpperCase();
                    }
                    if (object2 != null && ((String)object2).compareTo((String)object3) == 0) {
                        return;
                    }
                    if (!AttributeNameValidator.validateAttributeName((String)object3, vector, DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model), true)) {
                        return;
                    }
                } else if (object2 != null && ((String)object2).length() != 0 && !AttributeNameValidator.validateAttributeName((String)object4, vector, DataSourcePIComponentPanel.this.getContext((PropertyModel)DataSourcePIComponentPanel.this._model), true)) {
                    return;
                }
                if (object2 != null && ((String)object2).compareTo((String)object3) == 0) {
                    return;
                }
                object3 = StringUtils.trimDoubleQuotes((String)object3);
                attributeType.setAlias((String)object3);
                DataSourceNodeType dataSourceNodeType = (DataSourceNodeType)dataSourceNode.getData();
                List list = dataSourceNodeType.getAttributes().getAttribute();
                attributeType3 = null;
                for (AttributeType attributeType5 : list) {
                    if (!attributeType5.getName().equals(attributeType.getName()) || !attributeType5.getDataType().equals(attributeType.getDataType())) continue;
                    attributeType2 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType5);
                    attributeType3 = (AttributeType)MetaDataHelper.copyMetadataObject(attributeType5);
                    attributeType2.setAlias((String)object3);
                    break;
                }
            }
            if (attributeType2 != null) {
                object4 = new ArrayList();
                object3 = new ComplexProperty("dataSourceTableAliasChange", attributeType2);
                ((ComplexProperty)object3).setOldData(attributeType3);
                object4.add(new Property(String.valueOf(DataSourceNodePropertyModel.DATA_SOURCE_TABLE_ALIAS_CHANGED.index), null, object3, null, null));
                object2 = new ComplexProperty("SQL_EXPRESSION", "SQL_EXPRESSION_GENERATE");
                ((ComplexProperty)object2).setOldData(dataSourceNode.getSQLExpression());
                object4.add(new Property(String.valueOf(DataSourceNodePropertyModel.SQL_EXPRESSION.index), null, object2, null, null));
                DataSourcePIComponentPanel.this._model.setValueAt(PropertyLrb.get("PI_CLASS_BUILD_GROUP_BUILD_DS_CONTENT_ALIAS"), dataSourceNode, (List<Property>)object4);
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 < this.getColumnCount()) : "column out of bounds!";
            assert (n >= 0 && n < this.getRowCount()) : "row out of bounds!";
            AttributeType attributeType = (AttributeType)this.srcData.get(n);
            Object object = null;
            switch (n2) {
                case 0: {
                    object = attributeType;
                    break;
                }
                case 1: {
                    object = attributeType.getAlias();
                    break;
                }
                case 2: {
                    object = this.getDataType(attributeType);
                    break;
                }
                default: {
                    assert (false) : "Out of bounds column when accessing items";
                    break;
                }
            }
            return object != null ? object : "";
        }

        public void removeSelectedRows(int[] nArray) {
            Vector<AttributeType> vector = new Vector<AttributeType>();
            AttributeType attributeType = null;
            for (int i = 0; i < nArray.length; ++i) {
                attributeType = (AttributeType)this.srcData.get(nArray[i]);
                vector.add(attributeType);
            }
            this.srcData.removeAll(vector);
            this.setRowCount(this.srcData.size());
            this.fireTableDataChanged();
        }

        public void setWritable(boolean bl) {
            this.writable = bl;
        }

        public boolean isCellEditable(int n, int n2) {
            Object object;
            Object object2;
            if (n2 == 1) {
                return this.writable;
            }
            return n2 == 2 && (object2 = this.getValueAt(n, n2)) instanceof String && (DatabaseMetadataUtils.isACharacterOracleDataType((object = object2).toString()) || DatabaseMetadataUtils.isJSONTypeSupported(object.toString()));
        }
    }

    class SelectedItemSelectionHandler
    implements ListSelectionListener {
        SelectedItemSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            boolean bl = DataSourcePIComponentPanel.this.isWritable();
            DataSourcePIComponentPanel.this._removeBtn.setEnabled(!listSelectionModel.isSelectionEmpty() && bl);
            DataSourcePIComponentPanel.this._editBtn.setEnabled(bl);
            DataSourcePIComponentPanel.this._refreshBtn.setEnabled(bl);
        }
    }
}

