/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.inmemoryparallelquery;

import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.navigator.WorkflowNode;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.workflow.WorkflowEditorLrb;
import oracle.dmt.dataminer.workflow.inmemoryparallelquery.InMemoryParallelTablePanel;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.WorkflowModel;
import oracle.ide.Context;
import oracle.javatools.icons.OracleIcons;

public class WorkflowInMemoryParallelQueryEditor
extends DialogDisplayer {
    private WorkflowModel model;
    private List<AbstractNode> selectedNodes;
    private boolean isPreferencePanel = false;
    private boolean parallelOn;
    private boolean parallelOff;
    private boolean inMemoryEnabled;
    private JLabel descriptionAreaTxt;
    private JLabel jLabel1;
    private InMemoryParallelTablePanel parallelTablePanel1;

    public WorkflowInMemoryParallelQueryEditor(Context context, List<AbstractNode> list) {
        super(context, null);
        this.selectedNodes = list;
        this.model = ((WorkflowNode)context.getNode()).getWorkflowModel();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        this.parallelOn = ConfigUtils.isPARALLEL_QUERY_ON_ALLOWED(connectionFolder);
        this.parallelOff = ConfigUtils.isPARALLEL_QUERY_OFF_ALLOWED(connectionFolder);
        this.inMemoryEnabled = ConfigUtils.isInMemoryAllowed(connectionFolder);
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.parallelTablePanel1 = new InMemoryParallelTablePanel(this.getContext(), this.selectedNodes);
        this.descriptionAreaTxt = new JLabel();
        this.jLabel1 = new JLabel();
        this.descriptionAreaTxt.setText(" Description Area");
        this.descriptionAreaTxt.setVerticalAlignment(1);
        this.descriptionAreaTxt.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText(" Status");
        this.jLabel1.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)((Object)this.parallelTablePanel1), -1, 751, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionAreaTxt, -1, -1, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.jLabel1, -2, 24, -2).addGap(4, 4, 4).addComponent(this.descriptionAreaTxt, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)((Object)this.parallelTablePanel1), -1, 330, Short.MAX_VALUE)));
    }

    @Override
    public void initRes() {
        CharSequence charSequence;
        this.descriptionAreaTxt.setText(WorkflowEditorLrb.get("WORKFLOW_PERFORMANCE_EXPLAINIG_MSG"));
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (!this.parallelOn) {
            stringBuilder2.append(WorkflowEditorLrb.get("PARALLEL_QUERY_ON_DISABLED"));
        }
        if (!this.parallelOff) {
            if (stringBuilder2.length() > 0) {
                stringBuilder2.append("/");
            }
            stringBuilder2.append(WorkflowEditorLrb.get("PARALLEL_QUERY_OFF_DISABLED"));
        }
        if (stringBuilder2.length() > 0) {
            charSequence = WorkflowEditorLrb.get("PARALLEL_QUERY_DISABLED_TEMPLATE");
            charSequence = StringUtils.getReplacedString((String)charSequence, "<ON_OFF>", stringBuilder2.toString());
            stringBuilder.append((String)charSequence);
        }
        if (!this.inMemoryEnabled) {
            stringBuilder.append(WorkflowEditorLrb.get("INMEMORY_OPTION_DISABLED"));
        }
        if (stringBuilder.length() > 0) {
            charSequence = new StringBuilder("<html><p>");
            stringBuilder.append(" ");
            stringBuilder.append(WorkflowEditorLrb.get("PERFORMAVE_CONTACT_DBA"));
            ((StringBuilder)charSequence).append((CharSequence)stringBuilder);
            ((StringBuilder)charSequence).append("</p></html>");
            this.jLabel1.setIcon(OracleIcons.getIcon((String)"warning.png"));
            this.jLabel1.setText(((StringBuilder)charSequence).toString());
            return;
        }
        this.jLabel1.setVisible(false);
    }

    @Override
    public void initUI() {
    }

    @Override
    public boolean doWork() {
        return this.parallelTablePanel1.doWork();
    }

    @Override
    protected String getDialogTitle() {
        return WorkflowEditorLrb.get("WORKFLOW_PARALLEL_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "performance_settings";
    }
}

