/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.controls.BaseCostMatrixDataProvider;
import oracle.dmt.dataminer.controls.BaseCostMatrixTable;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.DefaultGraphDataModel;
import oracle.dmt.dataminer.controls.GraphPanel;
import oracle.dmt.dataminer.controls.renderers.ColorCellRenderer;
import oracle.dmt.dataminer.controls.renderers.FormatTableCellRenderer;
import oracle.dmt.dataminer.core.model.clas.common.CostMatrixInfo;
import oracle.dmt.dataminer.core.model.clas.common.ProfitInfo;
import oracle.dmt.dataminer.core.model.common.build.partition.CompareMode;
import oracle.dmt.dataminer.tviewer.TestViewerLrb;
import oracle.dmt.dataminer.tviewer.profit.ProfitDetailPanel;
import oracle.dmt.dataminer.tviewer.profit.ProfitInputPanel;
import oracle.dmt.dataminer.tviewer.profit.ProfitTabState;
import oracle.dmt.dataminer.utils.Formats;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogPanel;
import oracle.dmt.dataminer.workflow.dialog.test.CostBenefitDetailPanel;
import oracle.dmt.dataminer.workflow.dialog.test.CostMatrixDetailPanel;
import oracle.dmt.dataminer.workflow.dialog.test.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.test.TuneState;
import oracle.dmt.dataminer.workflow.xmlschema.CostMatrixType;
import oracle.dmt.dataminer.workflow.xmlschema.ROCAccuracyType;
import oracle.dmt.dataminer.workflow.xmlschema.TuningType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericTable;

public class ProfitTabPanel
extends AbstractPropertiesDialogPanel {
    private static final String UPDATE_ALL = "UPDATE_ALL";
    private static final String UPDATE_GRAPH = "UPDATE_GRAPH";
    private static final String UPDATE_THRESHOLD = "UPDATE_THRESHOLD";
    private GraphPanel _graphPanel;
    private boolean _loading;
    private Context _context;
    private NumberFormat _percentageFormat;
    private DataMinerTablePanel dataMinerTablePanel;
    private JButton jClearButton;
    private JButton jCostMatrixBtn;
    private JPanel jCostMatrixPanel;
    private JPanel jGraphControl;
    private JPanel jGraphPanel;
    private JPanel jGraphSelection;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jMatrixLbl;
    private JLabel jMatrixLbl1;
    private GenericTable jMatrixTable;
    private JPanel jPanel1;
    private JSlider jQuantileSlider;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JButton jSettingsBtn;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JComboBox<String> jTargetComb;
    private JLabel jTargetLbl;
    private JButton jTuneBtn;
    private JLabel jTuneCriteriaLabel;
    private JLabel jTuneCriteriaValue;
    private GenericTable jTuneMatrixTable;
    private JLabel jTuneMethodLabel;
    private JLabel jTuneMethodValue;
    private JLabel jTuneSettingsLabel;
    private JLabel jTuneTargetLabel;
    private JLabel jTuneTargetValue;
    private JLabel jTuneThresholdLabel;
    private JLabel jTuneThresholdValue;
    private JButton jDetailBtn;

    public ProfitTabPanel(Context context, TraversableContext traversableContext) {
        super(traversableContext);
        this._context = context;
        this._loading = true;
        this._percentageFormat = Formats.ModelViewer.getPercentage();
        this.initComponents();
        this.initGraph();
        this.initRes();
        this.initUI();
    }

    private void initGraph() {
        this._graphPanel = new GraphPanel(new DefaultGraphDataModel(null, null, null, null, null));
        this.jGraphPanel.add((Component)new JTextArea(CommonLrb.get("LOADING")), "Center");
        this.jGraphPanel.updateUI();
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.jTargetLbl, this.jTargetComb, (String)TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleName(TestViewerLrb.get("TARGET_VALUE"));
        this.jTargetLbl.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("TARGET_VALUE_ADA"));
        ResourceUtils.resButton((AbstractButton)this.jSettingsBtn, (String)TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleName(TestViewerLrb.get("PROFIT_SETTINGS_BTN"));
        this.jSettingsBtn.getAccessibleContext().setAccessibleDescription(TestViewerLrb.get("PROFIT_SETTINGS_BTN_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl, (Component)this.jMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX"));
        this.jMatrixLbl.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX")));
        this.jMatrixLbl.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_PERFORMANCE_MATRIX_ADA"));
        this.jLabel1.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        this.jLabel1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PERF_MATRIX_HINT")));
        ResourceUtils.resButton((AbstractButton)this.jTuneBtn, (String)DialogsLrb.get("TUNE_COMMON_TUNE"));
        this.jTuneBtn.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE")));
        this.jTuneBtn.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TUNE_ADA"));
        this.jTuneSettingsLabel.setText(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        this.jTuneSettingsLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TUNE_SETTINGS")));
        ResourceUtils.resButton((AbstractButton)this.jClearButton, (String)DialogsLrb.get("TUNE_COMMON_CLEAR"));
        this.jClearButton.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CLEAR")));
        this.jClearButton.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CLEAR_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneMethodLabel, (Component)this.jTuneMethodValue, (String)DialogsLrb.get("TUNE_COMMON_METHOD"));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_METHOD")));
        this.jTuneMethodLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_METHOD_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneTargetLabel, (Component)this.jTuneTargetValue, (String)DialogsLrb.get("TUNE_COMMON_TARGET"));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_TARGET")));
        this.jTuneTargetLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_TARGET_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneCriteriaLabel, (Component)this.jTuneCriteriaValue, (String)DialogsLrb.get("TUNE_COMMON_CRITERIA"));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_CRITERIA")));
        this.jTuneCriteriaLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_CRITERIA_ADA"));
        ResourceUtils.resLabel((JLabel)this.jTuneThresholdLabel, (Component)this.jTuneThresholdValue, (String)DialogsLrb.get("TUNE_COMMON_PROFIT"));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_PROFIT")));
        this.jTuneThresholdLabel.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_PROFIT_ADA"));
        ResourceUtils.resLabel((JLabel)this.jMatrixLbl1, (Component)this.jTuneMatrixTable, (String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX"));
        this.jMatrixLbl1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX")));
        this.jMatrixLbl1.getAccessibleContext().setAccessibleDescription(DialogsLrb.get("TUNE_COMMON_DERIVED_COST_MATRIX_ADA"));
    }

    private void initUI() {
        this._loading = true;
        this.installProfitResultsActions();
        this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        this.initializeControls();
        LoadUI loadUI = new LoadUI(UPDATE_ALL);
        loadUI.execute();
    }

    private void enableControls(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = this.dataMinerTablePanel.getTable().getSelectedRowCount() > 0;
        this.jTargetComb.setEnabled(bl);
        this.jSettingsBtn.setEnabled(bl);
        this.jDetailBtn.setEnabled(bl && bl5);
        if (bl5) {
            String string = this.getDialogState().getShareState().getSelectTestResult();
            bl2 = this.getDialogState().isTuningCustom(string);
            bl4 = this.getDialogState().isTuningBenefit(string);
            bl3 = this.getDialogState().isTuningCost(string);
        }
        this.jClearButton.setEnabled(bl && bl5 && (bl2 || bl3 || bl4));
        this.jTuneBtn.setEnabled(bl && bl5);
        this.jTuneTargetLabel.setVisible(bl && bl2);
        this.jTuneTargetValue.setVisible(bl && bl2);
        this.jTuneThresholdLabel.setVisible(bl && bl2);
        this.jTuneThresholdValue.setVisible(bl && bl2);
        this.jTuneCriteriaLabel.setVisible(bl && bl2);
        this.jTuneCriteriaValue.setVisible(bl && bl2);
        this.jMatrixLbl1.setVisible(bl && (bl2 || bl3 || bl4));
        this.jCostMatrixBtn.setVisible(bl && (bl3 || bl4));
        this.jScrollPane2.setVisible(bl && bl2);
        this.jTuneMatrixTable.setVisible(bl && bl2);
        this.jLabel7.setVisible(bl && bl2);
    }

    private void initializeControls() {
        this.dataMinerTablePanel.getTable().setSelectionMode(0);
        this.jTargetComb.setModel(new DefaultComboBoxModel<String>(new String[]{"Loading..."}));
        ListSelectionModel listSelectionModel = this.dataMinerTablePanel.getTable().getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProfitTabPanel.this.jResultTableValueChanged(listSelectionEvent);
            }
        });
        this.enableControls(false);
    }

    public void jResultTableValueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (!listSelectionModel.isSelectionEmpty()) {
            int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
            String string = (String)this.getDialogState().getProfitState().getProfitTableModel().getValueAt(nArray[0], this.getDialogState().getProfitState().getRESULT_NAME());
            this.getDialogState().getShareState().setSelectTestResult(string);
            this.loadConfusionMatrix();
            this.loadTuneMatrix();
            this.enableControls(true);
        }
    }

    @Override
    protected final TuneState getDialogState() {
        return (TuneState)super.getDialogState();
    }

    @Override
    public void tabSelected() {
        if (this.getDialogState().getProfitState().getProfitTableModel() == null) {
            return;
        }
        String string = this.getDialogState().getShareState().getSelectTestResult();
        if (string != null) {
            int n = 0;
            for (int i = 0; i < this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                Object object = this.getDialogState().getProfitState().getProfitTableModel().getValueAt(i, this.getDialogState().getProfitState().getRESULT_NAME());
                if (!string.equals(object)) continue;
                n = i;
                break;
            }
            this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
        }
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    @Override
    public void processInput() {
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jGraphSelection = new JPanel();
        this.jTargetLbl = new JLabel();
        this.jTargetComb = new JComboBox();
        this.jSettingsBtn = new JButton();
        this.jGraphPanel = new JPanel();
        this.jGraphControl = new JPanel();
        this.jQuantileSlider = new JSlider();
        this.jScrollPane1 = new JScrollPane();
        this.jCostMatrixPanel = new JPanel();
        this.jMatrixLbl = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.jMatrixTable = new BaseCostMatrixTable();
        this.jLabel1 = new JLabel();
        this.jClearButton = new JButton();
        this.jTuneBtn = new JButton();
        this.jTuneSettingsLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jTuneMethodLabel = new JLabel();
        this.jTuneMethodValue = new JLabel();
        this.jTuneTargetLabel = new JLabel();
        this.jTuneTargetValue = new JLabel();
        this.jTuneCriteriaLabel = new JLabel();
        this.jTuneCriteriaValue = new JLabel();
        this.jTuneThresholdLabel = new JLabel();
        this.jTuneThresholdValue = new JLabel();
        this.jMatrixLbl1 = new JLabel();
        this.jCostMatrixBtn = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jTuneMatrixTable = new BaseCostMatrixTable();
        this.jLabel7 = new JLabel();
        this.dataMinerTablePanel = new DataMinerTablePanel();
        this.setMinimumSize(new Dimension(750, 490));
        this.setPreferredSize(new Dimension(750, 490));
        this.jSplitPane1.setDividerLocation(360);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setName("jSplitPane1");
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane2.setDividerLocation(450);
        this.jSplitPane2.setName("jSplitPane2");
        this.jSplitPane2.setOneTouchExpandable(true);
        this.jPanel1.setName("jPanel1");
        this.jGraphSelection.setName("jGraphSelection");
        this.jTargetLbl.setText("Target Value:");
        this.jTargetLbl.setName("jTargetLbl");
        this.jTargetComb.setName("jTargetComb");
        this.jTargetComb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jTargetCombActionPerformed(actionEvent);
            }
        });
        this.jSettingsBtn.setText("Profit Settings...");
        this.jSettingsBtn.setName("jSettingsBtn");
        this.jSettingsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jSettingsBtnActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.jGraphSelection);
        this.jGraphSelection.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 449, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jTargetLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTargetComb, -2, 144, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 103, Short.MAX_VALUE).addComponent(this.jSettingsBtn).addContainerGap())));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTargetLbl).addComponent(this.jSettingsBtn).addComponent(this.jTargetComb, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE))));
        this.jGraphPanel.setName("jGraphPanel");
        this.jGraphPanel.setLayout(new BorderLayout());
        this.jGraphControl.setName("jGraphControl");
        this.jGraphControl.setLayout(new GridBagLayout());
        this.jQuantileSlider.setName("jQuantileSlider");
        this.jQuantileSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ProfitTabPanel.this.jQuantileSliderStateChanged(changeEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 50, 0, 0);
        this.jGraphControl.add((Component)this.jQuantileSlider, gridBagConstraints);
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jGraphControl, -1, 449, Short.MAX_VALUE).addComponent(this.jGraphSelection, -1, -1, Short.MAX_VALUE).addComponent(this.jGraphPanel, -1, 449, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jGraphSelection, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphPanel, -1, 285, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jGraphControl, -2, -1, -2)));
        this.jSplitPane2.setLeftComponent(this.jPanel1);
        this.jScrollPane1.setName("jScrollPane1");
        this.jCostMatrixPanel.setName("jCostMatrixPanel");
        this.jMatrixLbl.setText("Performance Matrix:");
        this.jMatrixLbl.setName("jMatrixLbl");
        this.jScrollPane.setName("jScrollPane");
        this.jScrollPane.setPreferredSize(new Dimension(450, 200));
        this.jMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jMatrixTable.setName("jMatrixTable");
        this.jMatrixTable.setPreferredSize(new Dimension(300, 73));
        this.jMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane.setViewportView((Component)this.jMatrixTable);
        this.jLabel1.setText("Rows: Actual; Columns: Predicted");
        this.jLabel1.setName("jLabel1");
        this.jClearButton.setText("Clear");
        this.jClearButton.setName("jClearButton");
        this.jClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jClearButtonActionPerformed(actionEvent);
            }
        });
        this.jTuneBtn.setText("Tune");
        this.jTuneBtn.setName("jTuneBtn");
        this.jTuneBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jTuneBtnActionPerformed(actionEvent);
            }
        });
        this.jTuneSettingsLabel.setText("Tune Settings");
        this.jTuneSettingsLabel.setName("jTuneSettingsLabel");
        this.jSeparator1.setName("jSeparator1");
        this.jTuneMethodLabel.setText("Method:");
        this.jTuneMethodLabel.setName("jTuneMethodLabel");
        this.jTuneMethodValue.setText("Profit");
        this.jTuneMethodValue.setName("jTuneMethodValue");
        this.jTuneTargetLabel.setText("Target Value:");
        this.jTuneTargetLabel.setName("jTuneTargetLabel");
        this.jTuneTargetValue.setText("1");
        this.jTuneTargetValue.setName("jTuneTargetValue");
        this.jTuneCriteriaLabel.setText("Criteria:");
        this.jTuneCriteriaLabel.setName("jTuneCriteriaLabel");
        this.jTuneCriteriaValue.setText("Average Accuracy");
        this.jTuneCriteriaValue.setName("jTuneCriteriaValue");
        this.jTuneThresholdLabel.setText("Threshold:");
        this.jTuneThresholdLabel.setName("jTuneThresholdLabel");
        this.jTuneThresholdValue.setText("0.56789");
        this.jTuneThresholdValue.setName("jTuneThresholdValue");
        this.jMatrixLbl1.setText("Derived Cost Matrix:");
        this.jMatrixLbl1.setName("jMatrixLbl1");
        this.jCostMatrixBtn.setText("View...");
        this.jCostMatrixBtn.setName("jCostMatrixBtn");
        this.jCostMatrixBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jCostMatrixBtnActionPerformed(actionEvent);
            }
        });
        this.jScrollPane2.setName("jScrollPane2");
        this.jTuneMatrixTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTuneMatrixTable.setName("jTuneMatrixTable");
        this.jTuneMatrixTable.setRowSelectionAllowed(false);
        this.jScrollPane2.setViewportView((Component)this.jTuneMatrixTable);
        this.jLabel7.setText("Rows: Actual; Columns: Predicted");
        this.jLabel7.setName("jLabel7");
        GroupLayout groupLayout3 = new GroupLayout(this.jCostMatrixPanel);
        this.jCostMatrixPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jClearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTuneBtn).addGap(18, 18, 18)).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jMatrixLbl, GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING).addComponent(this.jTuneSettingsLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGap(71, 71, 71).addComponent(this.jTuneMethodValue)).addComponent(this.jTuneMethodLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneCriteriaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTuneTargetValue).addComponent(this.jTuneCriteriaValue).addComponent(this.jTuneThresholdValue))).addComponent(this.jLabel7, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, groupLayout3.createSequentialGroup().addComponent(this.jMatrixLbl1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCostMatrixBtn))).addGap(0, 104, Short.MAX_VALUE)).addComponent(this.jSeparator1).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addComponent(this.jScrollPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jMatrixLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jTuneSettingsLabel)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneBtn).addComponent(this.jClearButton))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneMethodLabel).addComponent(this.jTuneMethodValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneTargetLabel).addComponent(this.jTuneTargetValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneCriteriaLabel).addComponent(this.jTuneCriteriaValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTuneThresholdLabel).addComponent(this.jTuneThresholdValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jMatrixLbl1).addComponent(this.jCostMatrixBtn)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 64, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addContainerGap(-1, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.jCostMatrixPanel);
        this.jSplitPane2.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.dataMinerTablePanel.setName("dataMinerTablePanel");
        this.jSplitPane1.setRightComponent(this.dataMinerTablePanel);
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 771, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 490, Short.MAX_VALUE));
    }

    private void jTargetCombActionPerformed(ActionEvent actionEvent) {
        if (this._loading) {
            return;
        }
        this.getDialogState().getProfitState().setSelectedTargetValue((String)this.jTargetComb.getSelectedItem());
        this._loading = true;
        this.jGraphPanel.removeAll();
        this.jGraphPanel.add((Component)new JTextArea("Loading..."), "Center");
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
        loadUI.execute();
    }

    private void jSettingsBtnActionPerformed(ActionEvent actionEvent) {
        ProfitInputPanel profitInputPanel = new ProfitInputPanel(this._context, this.getDialogState().getProfitState());
        if (profitInputPanel.showAsDialog(this)) {
            this._loading = true;
            this.enableControls(false);
            LoadUI loadUI = new LoadUI(UPDATE_GRAPH);
            loadUI.execute();
        }
    }

    private void jClearButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.getDialogState().getShareState().getSelectTestResult();
        this.getDialogState().setTuningNone(string);
        int n = this.dataMinerTablePanel.getTable().getSelectedRow();
        this.dataMinerTablePanel.getTable().tableChanged(new TableModelEvent(this.dataMinerTablePanel.getTable().getModel()));
        this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void jQuantileSliderStateChanged(ChangeEvent changeEvent) {
        if (this._loading) {
            return;
        }
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider.getValueIsAdjusting()) {
            return;
        }
        BoundedRangeModel boundedRangeModel = this.jQuantileSlider.getModel();
        Integer n = boundedRangeModel.getValue();
        n = Math.max(1, n);
        this.getDialogState().getProfitState().setSelectedQuantileValue(n);
        this._loading = true;
        this.enableControls(false);
        LoadUI loadUI = new LoadUI(UPDATE_THRESHOLD);
        loadUI.execute();
    }

    private void jCostMatrixBtnActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = this.getDialogState().getShareState().getSelectTestResult();
        boolean bl2 = this.getDialogState().getBenefitState().getTuneBenefitWeight(string) != null;
        boolean bl3 = bl = this.getDialogState().getCostState().getTuneCostMatrix(string) != null;
        if (bl2) {
            WeightsType weightsType = this.getDialogState().getBenefitState().getTuneBenefitWeight(string);
            CostBenefitDetailPanel costBenefitDetailPanel = new CostBenefitDetailPanel(weightsType);
            costBenefitDetailPanel.showAsDialog(this);
        } else if (bl) {
            CostMatrixInfo costMatrixInfo = this.getDialogState().getCostState().getTuneCostMatrixInfo(string);
            CostMatrixDetailPanel costMatrixDetailPanel = new CostMatrixDetailPanel(costMatrixInfo);
            costMatrixDetailPanel.showAsDialog(this);
        }
    }

    private void jTuneBtnActionPerformed(ActionEvent actionEvent) {
        int n = this.getDialogState().getProfitState().getSelectedQuantileValue();
        String string = this.getDialogState().getShareState().getSelectTestResult();
        ProfitInfo profitInfo = this.getDialogState().getProfitState().getProfitData().get(string).get(n);
        double d = profitInfo.getThreshold();
        this.getDialogState().getProfitState().setCustomThresholdValue(d);
        double d2 = 1.0E-6f;
        double d3 = d - d2 < 0.0 ? d : d - d2;
        double d4 = (1.0 - d3) / d3;
        String string2 = null;
        Object var14_10 = null;
        string2 = this.getDialogState().getProfitState().getSelectedTargetValue();
        List<ProfitInfo> list = this.getDialogState().getProfitState().getProfitData().get(string);
        int n2 = list.size();
        double d5 = list.get(n2 - 1).getTargetCum() + list.get(n2 - 1).getNonTargetCum();
        double d6 = list.get(n).getTargetCum();
        double d7 = list.get(n).getNonTargetCum();
        double d8 = this.getDialogState().getProfitState().getIncRevenue() * d6;
        double d9 = this.getDialogState().getProfitState().getIncCost() * (d6 + d7);
        double d10 = -1.0 * this.getDialogState().getProfitState().getStartupCost() + (d8 - d9) * this.getDialogState().getProfitState().getPopulation() / d5;
        d8 = this.getDialogState().getProfitState().getIncRevenue() * d6;
        d9 = this.getDialogState().getProfitState().getIncCost() * (d6 + d7);
        double d11 = (d8 - d9) / d9 * 100.0;
        CostMatrixType costMatrixType = new CostMatrixType();
        TuningType.Custom.Settings.Profit profit = new TuningType.Custom.Settings.Profit();
        profit.setPopulation(BigInteger.valueOf(n));
        profit.setProfit(d10);
        profit.setROI(d11);
        Vector<Object> vector = this.getDialogState().getModelTargetValues();
        for (Object e : vector) {
            for (Object e2 : vector) {
                CostMatrixType.Item item = new CostMatrixType.Item();
                item.setActual(e.toString());
                item.setPredict(e2.toString());
                if (e.toString().equals(e2.toString())) {
                    item.setCost(0.0);
                } else if (e.toString().equals(string2) && !e2.toString().equals(string2)) {
                    item.setCost(d4);
                } else {
                    item.setCost(1.0);
                }
                costMatrixType.getItem().add(item);
            }
        }
        this.getDialogState().setTuningCustom(string, string2, profit, costMatrixType);
        int n3 = this.dataMinerTablePanel.getTable().getSelectedRow();
        this.dataMinerTablePanel.getTable().tableChanged(new TableModelEvent(this.dataMinerTablePanel.getTable().getModel()));
        this.dataMinerTablePanel.getTable().setRowSelectionInterval(n3, n3);
        this.loadTuneMatrix();
        this.enableControls(true);
    }

    private void installProfitResultsActions() {
        this.dataMinerTablePanel.removeSearchField();
        this.jDetailBtn = new JButton(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.setDisabledIcon(OracleIcons.getIcon((String)"lov.png"));
        this.jDetailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProfitTabPanel.this.jDetailBtnActionPerformed();
            }
        });
        this.dataMinerTablePanel.addControlBarComponents(this.jDetailBtn);
    }

    private void jDetailBtnActionPerformed() {
        int[] nArray = this.dataMinerTablePanel.getTable().getSelectedRowsInModel();
        String string = (String)this.getDialogState().getProfitState().getProfitTableModel().getValueAt(nArray[0], this.getDialogState().getProfitState().getRESULT_NAME());
        ProfitDetailPanel profitDetailPanel = new ProfitDetailPanel(this._context, string, this.getDialogState().getProfitState(), this.getDialogState().getProfitState().getProfitData().get(string));
        profitDetailPanel.showAsDialog(this);
    }

    private void loadConfusionMatrix() {
        String string = this.getDialogState().getShareState().getSelectTestResult();
        ProfitInfo profitInfo = null;
        String string2 = null;
        String string3 = null;
        if (string != null) {
            profitInfo = this.getDialogState().getProfitState().getProfitData().get(string).get(this.getDialogState().getProfitState().getSelectedQuantileValue());
            string2 = this.getDialogState().getProfitState().getSelectedTargetValue();
            Vector<Object> vector = this.getDialogState().getModelTargetValues();
            string3 = vector.size() == 2 ? (string2.equals(vector.get(0).toString()) ? vector.get(vector.size() - 1).toString() : vector.get(0).toString()) : TestViewerLrb.get("OTHER_TARGETS");
        }
        ((BaseCostMatrixTable)this.jMatrixTable).setModel(new TuneState.MatrixModel(new PerformanceMatrixDataProvider(string2, string3, profitInfo, this._percentageFormat)));
    }

    private void loadTuneMatrix() {
        String string = this.getDialogState().getShareState().getSelectTestResult();
        if (this.getDialogState().isTuningNone(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_OPTION_NONE);
        } else if (this.getDialogState().isTuningBenefit(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_BENEFIT);
        } else if (this.getDialogState().isTuningCost(string)) {
            this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_COST);
        } else if (this.getDialogState().isTuningCustom(string)) {
            String string2 = null;
            TuneState.TuningCustomData tuningCustomData = this.getDialogState().getTuningCustomData(string);
            String string3 = tuningCustomData.getTargetValue();
            Vector<Object> vector = this.getDialogState().getModelTargetValues();
            this.jTuneTargetValue.setText(string3);
            Object object = tuningCustomData.getTuneType();
            CostMatrixType costMatrixType = tuningCustomData.getCostMatrix();
            if (object instanceof TuningType.Custom.Settings.ROC) {
                TuningType.Custom.Settings.ROC rOC = (TuningType.Custom.Settings.ROC)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_ROC);
                ROCAccuracyType rOCAccuracyType = rOC.getAccuracy();
                if (rOCAccuracyType == ROCAccuracyType.CUSTOM_ACCURACY) {
                    TuningType.Custom.Settings.ROC.CustomThreshold customThreshold = rOC.getCustomThreshold();
                    String string4 = customThreshold.getType().value();
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value() + ", " + string4 + ": " + this._percentageFormat.format(customThreshold.getValue()));
                } else {
                    this.jTuneCriteriaValue.setText(rOCAccuracyType.value());
                }
                this.jTuneThresholdValue.setText(this._percentageFormat.format(rOC.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Lift) {
                TuningType.Custom.Settings.Lift lift = (TuningType.Custom.Settings.Lift)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_LIFT);
                String string5 = lift.getType().value();
                this.jTuneCriteriaValue.setText("Quantile: " + lift.getQuantile() + " (" + string5 + ")");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(lift.getThreshold()));
            } else if (object instanceof TuningType.Custom.Settings.Profit) {
                TuningType.Custom.Settings.Profit profit = (TuningType.Custom.Settings.Profit)object;
                this.jTuneMethodValue.setText(TuneState.TUNE_METHOD_PROFIT);
                this.jTuneCriteriaValue.setText("Population: " + this._percentageFormat.format(profit.getPopulation()) + "%, ROI: " + this._percentageFormat.format(profit.getROI()) + "%");
                this.jTuneThresholdValue.setText(this._percentageFormat.format(profit.getProfit()));
            }
            string2 = vector.size() == 2 ? (string3.equals(vector.get(0).toString()) ? vector.get(vector.size() - 1).toString() : vector.get(0).toString()) : TestViewerLrb.get("OTHER_TARGETS");
            ((BaseCostMatrixTable)this.jTuneMatrixTable).setModel(new TuneState.MatrixModel(new TuneState.TuneMatrixDataProvider(string3, string2, costMatrixType, this._percentageFormat)));
        }
    }

    private class LoadUI
    extends ODMrSwingWorker<Void, Void> {
        private String _updatemode;

        public LoadUI(String string) {
            super(ProfitTabPanel.this, null, ProfitTabPanel.this.dataMinerTablePanel.getTable());
            this._updatemode = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            CompareMode compareMode;
            boolean bl = ProfitTabPanel.this.getDialogState().getProfitState().getParentTestViewerState().isEnabledPartitioning();
            CompareMode compareMode2 = compareMode = bl ? CompareMode.MODEL : CompareMode.NOT_PARTITIONED;
            if (ProfitTabPanel.UPDATE_THRESHOLD.equals(this._updatemode)) {
                ProfitTabPanel.this.getDialogState().getProfitState().refreshCustomThresholdData();
                ProfitTabPanel.this._graphPanel.refreshGraph();
            } else if (ProfitTabPanel.UPDATE_GRAPH.equals(this._updatemode)) {
                ProfitTabPanel.this.getDialogState().getProfitState().refreshProfitData(compareMode);
                ProfitTabPanel.this._graphPanel.initGraph(ProfitTabPanel.this.getDialogState().getProfitState().getProfitGraphModel());
            } else {
                ProfitTabPanel.this.getDialogState().getProfitState().load(compareMode);
                ProfitTabPanel.this._graphPanel.initGraph(ProfitTabPanel.this.getDialogState().getProfitState().getProfitGraphModel());
            }
            return null;
        }

        @Override
        protected void onSuccess(Void void_) throws Exception {
            Object object;
            ProfitTabPanel.this.jGraphPanel.removeAll();
            ProfitTabPanel.this.jGraphPanel.add((Component)ProfitTabPanel.this._graphPanel, "Center");
            ProfitTabPanel.this.jGraphPanel.updateUI();
            String string = ProfitTabPanel.this.getDialogState().getShareState().getSelectTestResult();
            ProfitTabPanel.this.dataMinerTablePanel.getTable().setFixedColumns(1, 175);
            ProfitTabPanel.this.dataMinerTablePanel.getTable().setModel((TableModel)((Object)ProfitTabPanel.this.getDialogState().getProfitState().getProfitTableModel()));
            ProfitTabPanel.this.dataMinerTablePanel.getTable().setColumnSelectorAvailable(true);
            ProfitTabPanel.this.dataMinerTablePanel.getTable().setSorted(true);
            TableColumnModel tableColumnModel = ProfitTabPanel.this.dataMinerTablePanel.getTable().getFullColumnModel();
            TableCellRenderer tableCellRenderer = FormatTableCellRenderer.getModelViewerPercentRenderer();
            TableCellRenderer tableCellRenderer2 = FormatTableCellRenderer.getModelViewerNumericRenderer();
            TableCellRenderer tableCellRenderer3 = FormatTableCellRenderer.getDateRenderer();
            ColorCellRenderer colorCellRenderer = new ColorCellRenderer(new ColorCellRenderer.ColorChooser(){

                @Override
                public Color getColorFor(Object object) {
                    String string = (String)object;
                    return ProfitTabPanel.this.getDialogState().getProfitState().getParentTestViewerState().getTestResultGraphColor(string);
                }
            });
            ProfitTabState profitTabState = ProfitTabPanel.this.getDialogState().getProfitState();
            tableColumnModel.getColumn(profitTabState.getRESULT_NAME()).setCellRenderer(colorCellRenderer);
            tableColumnModel.getColumn(profitTabState.getPROFIT()).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(profitTabState.getROI()).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(profitTabState.getPERCENTAGE_RECORDS_CUMULATIVE()).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(profitTabState.getTARGET_DENSITY_CUMULATIVE()).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(profitTabState.getMAX_PROFIT()).setCellRenderer(tableCellRenderer2);
            tableColumnModel.getColumn(profitTabState.getMAX_PROFIT_POPULATION()).setCellRenderer(tableCellRenderer);
            tableColumnModel.getColumn(profitTabState.getCREATION_DATE()).setCellRenderer(tableCellRenderer3);
            tableColumnModel.getColumn(profitTabState.getTUNE()).setPreferredWidth(90);
            tableColumnModel.getColumn(profitTabState.getPROFIT()).setPreferredWidth(100);
            tableColumnModel.getColumn(profitTabState.getROI()).setPreferredWidth(100);
            tableColumnModel.getColumn(profitTabState.getPERCENTAGE_RECORDS_CUMULATIVE()).setPreferredWidth(180);
            tableColumnModel.getColumn(profitTabState.getTARGET_DENSITY_CUMULATIVE()).setPreferredWidth(150);
            tableColumnModel.getColumn(profitTabState.getMAX_PROFIT()).setPreferredWidth(100);
            tableColumnModel.getColumn(profitTabState.getMAX_PROFIT_POPULATION()).setPreferredWidth(180);
            tableColumnModel.getColumn(profitTabState.getALGORITHM()).setPreferredWidth(150);
            tableColumnModel.getColumn(profitTabState.getCREATION_DATE()).setPreferredWidth(150);
            int n = -1;
            if (string == null) {
                double d = 0.0;
                double d2 = 0.0;
                for (int i = 0; i < ProfitTabPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                    d = (Double)ProfitTabPanel.this.getDialogState().getProfitState().getProfitTableModel().getValueAt(i, profitTabState.getMAX_PROFIT());
                    if (!(d2 < d)) continue;
                    d2 = d;
                    n = i;
                }
            } else {
                for (int i = 0; i < ProfitTabPanel.this.dataMinerTablePanel.getTable().getRowCount(); ++i) {
                    object = ProfitTabPanel.this.getDialogState().getProfitState().getProfitTableModel().getValueAt(i, profitTabState.getRESULT_NAME());
                    if (!string.equals(object)) continue;
                    n = i;
                }
            }
            if (n >= 0) {
                ProfitTabPanel.this.dataMinerTablePanel.getTable().setRowSelectionInterval(n, n);
            }
            if (this._updatemode.equals(ProfitTabPanel.UPDATE_ALL)) {
                String[] stringArray = new String[ProfitTabPanel.this.getDialogState().getProfitState().getTargetValues().size()];
                ProfitTabPanel.this.jTargetComb.setModel(new DefaultComboBoxModel<String>(ProfitTabPanel.this.getDialogState().getProfitState().getTargetValues().toArray(stringArray)));
                ProfitTabPanel.this.jTargetComb.setSelectedItem(ProfitTabPanel.this.getDialogState().getProfitState().getSelectedTargetValue());
                object = ProfitTabPanel.this.getDialogState().getProfitState().getSelectedQuantileValue();
                Integer n2 = 0;
                Integer n3 = ProfitTabPanel.this.getDialogState().getProfitState().getMaxQuantileCnt() - 1;
                ProfitTabPanel.this.jQuantileSlider.setMajorTickSpacing(10);
                ProfitTabPanel.this.jQuantileSlider.setMinorTickSpacing(1);
                ProfitTabPanel.this.jQuantileSlider.setPaintTicks(true);
                ProfitTabPanel.this.jQuantileSlider.setPaintLabels(true);
                ProfitTabPanel.this.jQuantileSlider.setSnapToTicks(true);
                ProfitTabPanel.this.jQuantileSlider.setModel(new DefaultBoundedRangeModel((Integer)object, 0, n2, n3));
            }
        }

        @Override
        protected void onFailure(Throwable throwable) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable, (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_TITLE"), (String)TestViewerLrb.get("TEST_VIEWER_FAILURE_MESG"), null);
        }

        @Override
        protected void onFinally() {
            ProfitTabPanel.this.loadConfusionMatrix();
            ProfitTabPanel.this.enableControls(true);
            ProfitTabPanel.this._loading = false;
        }
    }

    private class PerformanceMatrixDataProvider
    implements BaseCostMatrixDataProvider {
        private String _positiveTarget;
        private String _otherTarget;
        private ProfitInfo _data;
        private NumberFormat _percentageFormat;

        PerformanceMatrixDataProvider(String string, String string2, ProfitInfo profitInfo, NumberFormat numberFormat) {
            this._positiveTarget = string;
            this._otherTarget = string2;
            this._data = profitInfo;
            this._percentageFormat = numberFormat;
        }

        @Override
        public Object[] getTargetValues() {
            return new Object[]{this._positiveTarget, this._otherTarget};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this._data == null) {
                return null;
            }
            if (n == 0 && n2 == 0) {
                return this._percentageFormat.format(this._data.getTargetCum());
            }
            if (n == 0 && n2 == 1) {
                return this._percentageFormat.format(this._data.getNonTargetCum());
            }
            if (n == 1 && n2 == 0) {
                return this._percentageFormat.format(0.0);
            }
            if (n == 1 && n2 == 1) {
                return this._percentageFormat.format(0.0);
            }
            return "Undefined";
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

