/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.modeldetails;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dmt.dataminer.controls.DataMinerTable;
import oracle.dmt.dataminer.controls.DialogDisplayer;
import oracle.dmt.dataminer.controls.renderers.IconCellRenderer;
import oracle.dmt.dataminer.core.model.common.xmlschema.OutputAttributeType;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.server.model.MiningAlgorithmOptions;
import oracle.dmt.dataminer.server.model.MiningDetailsOutputType;
import oracle.dmt.dataminer.server.model.MiningFunctions;
import oracle.dmt.dataminer.workflow.OdmrSDMUndoFilter;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.AvailableRefModelType;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.EditModelDetailsPanel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelDetailsLrb;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelOutputColumnsListPanel;
import oracle.dmt.dataminer.workflow.dialog.modeldetails.ModelsTableModel;
import oracle.dmt.dataminer.workflow.inspect.PropertyLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.model.AbstractModelNode;
import oracle.dmt.dataminer.workflow.model.AbstractNode;
import oracle.dmt.dataminer.workflow.model.ExtractQueryFactory;
import oracle.dmt.dataminer.workflow.model.ModelDetailsDataNode;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.AutoSpecType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsDataNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelDetailsOutputType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.RefModelType;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.Version;

public class EditModelDetailsAutoPanel
extends DialogDisplayer<ModelDetailsDataNode> {
    private static final Logger theLogger = Logger.getLogger(EditModelDetailsAutoPanel.class.getName());
    private final String UNDEFINED = ModelDetailsLrb.get("UNDEFINED_SELECTION");
    private boolean _dirty;
    private JButton _addBtn;
    private String _ownerName;
    private JButton _removeBtn;
    private Version _dbVersion;
    private boolean _automaticSetting;
    private List<RefModelType> _models;
    private ModelDetailsDataNode _node;
    private boolean _ignoreAlgoComboEvent;
    private ModelDetailType _modelDetailType;
    private boolean _ignoreOutputTypeComboEvent;
    private MiningFunctions _currentMiningFunction;
    private ModelDetailsOutputType _modelOutputType;
    private ModelsTableModel _selectedModelsTableModel;
    private MiningAlgorithmOptions _currentAlgorithmOption;
    private List<OutputAttributeType> _currentOutputColumns;
    private MiningDetailsOutputType _currentMiningDetailOutputType;
    private GenericTable _selectedModelsGenericTable = new DataMinerTable();
    DefaultComboBoxModel<MiningAlgorithmOptions> algorithmComboModel;
    private JCheckBox _jAutoSpecificationCheckBox;
    private JButton _jDisplayColumnsButton;
    private JLabel _jMiningFunctionLabel;
    private JLabel _jMiningFunctionValue;
    private JLabel _jModelAlgorithmLabel;
    private JLabel _jOutputTypeLabel;
    private ComponentWithTitlebar<JComponent> _modelComponent;
    private JComboBox<MiningAlgorithmOptions> jModelAlgorithmCombo;
    private JComboBox<MiningDetailsOutputType> jOutputTypeCombo;

    public EditModelDetailsAutoPanel(Context context, ModelDetailsDataNode modelDetailsDataNode) {
        super(context, modelDetailsDataNode);
        assert (context != null) : "Context must not be null.";
        assert (modelDetailsDataNode != null) : "Model details data node must not be null.";
        this._context = context;
        this._node = modelDetailsDataNode;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this._jMiningFunctionLabel = new JLabel();
        this._jMiningFunctionValue = new JLabel();
        this._jModelAlgorithmLabel = new JLabel();
        this.jModelAlgorithmCombo = new JComboBox();
        this._jOutputTypeLabel = new JLabel();
        this.jOutputTypeCombo = new JComboBox();
        this._jDisplayColumnsButton = new JButton();
        this._jAutoSpecificationCheckBox = new JCheckBox();
        this._modelComponent = new ComponentWithTitlebar();
        this._jMiningFunctionLabel.setText("Model Function:");
        this._jMiningFunctionValue.setText("Classification");
        this._jModelAlgorithmLabel.setText("Model Type:");
        this._jOutputTypeLabel.setText("Output Type:");
        this._jDisplayColumnsButton.setText("Columns...");
        this._jAutoSpecificationCheckBox.setText("Automatic Specification");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this._modelComponent, -1, 495, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jAutoSpecificationCheckBox, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this._jMiningFunctionLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jOutputTypeLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this._jModelAlgorithmLabel, GroupLayout.Alignment.LEADING, -2, 81, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this._jMiningFunctionValue, -1, -1, Short.MAX_VALUE).addComponent(this.jModelAlgorithmCombo, 0, -1, Short.MAX_VALUE).addComponent(this.jOutputTypeCombo, -2, 279, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._jDisplayColumnsButton, -2, 101, -2))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this._jAutoSpecificationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jMiningFunctionLabel).addComponent(this._jMiningFunctionValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._jModelAlgorithmLabel).addComponent(this.jModelAlgorithmCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jOutputTypeCombo, -2, -1, -2).addComponent(this._jDisplayColumnsButton)).addComponent(this._jOutputTypeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this._modelComponent, -1, 259, Short.MAX_VALUE).addContainerGap()));
    }

    @Override
    public void initUI() {
        ModelDetailsDataNode modelDetailsDataNode = this._node;
        if (modelDetailsDataNode == null) {
            return;
        }
        HelpUtils.setHelpID((JComponent)this, (String)this.getHelpTopic());
        ResourceUtils.resButton((AbstractButton)this._jAutoSpecificationCheckBox, (String)PropertyLrb.get("PI_MODEL_DETAILS_AUTO_SETTING"));
        this._ownerName = ConnectionFolder.getUserAccountName(this._context);
        this._ownerName = StringUtils.isDoubleQuotedString(this._ownerName) ? StringUtils.trimDoubleQuotes(this._ownerName) : this._ownerName.toUpperCase();
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
        this._dbVersion = connectionFolder.getDbVersion();
        ModelDetailsDataNodeType modelDetailsDataNodeType = (ModelDetailsDataNodeType)modelDetailsDataNode.getData();
        this._modelOutputType = modelDetailsDataNodeType.getModelDetailsOutput();
        this.loadData();
        this.loadTables();
        JScrollPane jScrollPane = new JScrollPane((Component)this._selectedModelsGenericTable);
        this._modelComponent.setComponent((JComponent)jScrollPane);
        this._modelComponent.setLabel(new JLabel(ModelDetailsLrb.get("SELECTED_MODELS")));
        this._removeBtn = new JButton(OracleIcons.getIcon((String)"delete.png"));
        this._removeBtn.setEnabled(false);
        this._removeBtn.setToolTipText(ModelDetailsLrb.get("REMOVE_MODELS"));
        this._addBtn = new JButton(OracleIcons.getIcon((String)"add.png"));
        this._addBtn.setToolTipText(ModelDetailsLrb.get("ADD_MODELS"));
        ControlBar controlBar = new ControlBar();
        controlBar.add((Component)this._addBtn);
        controlBar.add((Component)this._removeBtn);
        this._modelComponent.setControlBar(controlBar);
        this.initComboBoxes();
        this.initOutputColumns();
        this.addListeners();
    }

    private void addListeners() {
        this._removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this._dirty = true;
                EditModelDetailsAutoPanel.this.removeButtonProcessing();
            }
        });
        this._addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelDetailsOutputType modelDetailsOutputType = EditModelDetailsAutoPanel.this.generateModelOutputType();
                EditModelDetailsPanel editModelDetailsPanel = new EditModelDetailsPanel(EditModelDetailsAutoPanel.this._context, EditModelDetailsAutoPanel.this._node, modelDetailsOutputType);
                if (editModelDetailsPanel.showAsDialog(EditModelDetailsAutoPanel.this) && editModelDetailsPanel.getUpdatedModelOutputType() != null) {
                    EditModelDetailsAutoPanel.this.reloadUI(editModelDetailsPanel.getUpdatedModelOutputType());
                }
            }
        });
        this._jDisplayColumnsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelOutputColumnsListPanel modelOutputColumnsListPanel = new ModelOutputColumnsListPanel(EditModelDetailsAutoPanel.this.getContext(), EditModelDetailsAutoPanel.this._currentOutputColumns, (ModelDetailsDataNode)EditModelDetailsAutoPanel.this.getData());
                modelOutputColumnsListPanel.showAsDialog(EditModelDetailsAutoPanel.this);
            }
        });
        this.jModelAlgorithmCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this._dirty = true;
                if (!EditModelDetailsAutoPanel.this._ignoreAlgoComboEvent) {
                    EditModelDetailsAutoPanel.this.processAlgorithmComboAction();
                }
            }
        });
        this.jOutputTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this._dirty = true;
                if (!EditModelDetailsAutoPanel.this._ignoreOutputTypeComboEvent) {
                    EditModelDetailsAutoPanel.this.processOutputTypeComboAction();
                }
            }
        });
        this._jAutoSpecificationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditModelDetailsAutoPanel.this.handleAutomaticSettingChange();
            }
        });
        this._selectedModelsGenericTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                EditModelDetailsAutoPanel.this._dirty = true;
                EditModelDetailsAutoPanel.this.handleModelSelectionChanged();
            }
        });
    }

    private void ignoreComboEvents(boolean bl) {
        this._ignoreAlgoComboEvent = bl;
        this._ignoreOutputTypeComboEvent = bl;
    }

    private void reloadUI(ModelDetailsOutputType modelDetailsOutputType) {
        try {
            this.ignoreComboEvents(true);
            this._modelOutputType = modelDetailsOutputType;
            this.loadData();
            this.updateComboBoxes();
            this.initOutputColumns();
            this._selectedModelsTableModel.reload(modelDetailsOutputType.getModels().getModel());
            this.validateModelsAreCompatible();
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY_CHECK_FAILED"), null);
        }
        finally {
            this.ignoreComboEvents(false);
        }
    }

    private void updateComboBoxes() throws Exception {
        this._jMiningFunctionValue.setText(this._currentMiningFunction.toString());
        this.algorithmComboModel.removeAllElements();
        MiningAlgorithmOptions.getMiningAlgorithmOptions(this._dbVersion, this._currentMiningFunction).forEach(miningAlgorithmOptions -> this.algorithmComboModel.addElement((MiningAlgorithmOptions)((Object)miningAlgorithmOptions)));
        this.jModelAlgorithmCombo.setEnabled(true);
        this.algorithmComboModel.setSelectedItem((Object)this._currentAlgorithmOption);
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._dbVersion, this._currentMiningFunction, this._currentAlgorithmOption)));
        this.jOutputTypeCombo.setEnabled(true);
        this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
    }

    private void handleAutomaticSettingChange() {
        boolean bl = this._jAutoSpecificationCheckBox.isSelected();
        if (bl) {
            if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)ModelDetailsLrb.get("MODEL_DETAILS_AUTO_SETTING_ON"), (String)ModelDetailsLrb.get("WARNING_TITLE"), null, (boolean)true)) {
                this._jAutoSpecificationCheckBox.setSelected(false);
                return;
            }
            this._dirty = true;
            try {
                ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
                this._selectedModelsTableModel.reload(this._node.getCompatibleModels(modelDetailsOutputType));
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY"), null);
            }
            this._automaticSetting = true;
        } else {
            this._dirty = true;
            this._automaticSetting = false;
        }
        this.enableControls(!this._automaticSetting);
    }

    private void loadCompatibleModels() throws Exception {
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        ModelDetailsOutputType modelDetailsOutputType2 = this._node.addCompatibleModels(modelDetailsOutputType);
        this._selectedModelsTableModel.reload(modelDetailsOutputType2.getModels().getModel());
    }

    private ModelDetailsOutputType generateModelOutputType() {
        ModelDetailsOutputType modelDetailsOutputType = new ModelDetailsOutputType();
        Attributes attributes = new Attributes();
        ModelDetailsOutputType.Models models = this._selectedModelsTableModel.getRowCount() == 0 ? new ModelDetailsOutputType.Models() : this._selectedModelsTableModel.generateModelsCollection();
        modelDetailsOutputType.setModels(models);
        modelDetailsOutputType.setAttributes(attributes);
        MiningDetailsOutputType miningDetailsOutputType = MiningDetailsOutputType.fromString(this._currentMiningDetailOutputType.toString());
        MiningAlgorithmOptions miningAlgorithmOptions = MiningAlgorithmOptions.fromString(this._currentAlgorithmOption.toString());
        MiningFunctions miningFunctions = MiningFunctions.fromString(this._currentMiningFunction.toString());
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningFunction(MiningFunctions.getMiningFunctionType(miningFunctions));
        modelDetailsOutputType.setMiningAlgorithm(MiningAlgorithmOptions.getMiningAlgorithmType(miningAlgorithmOptions));
        modelDetailsOutputType.setType(MiningDetailsOutputType.getMiningDetailType(miningDetailsOutputType, miningAlgorithmOptions, miningFunctions));
        modelDetailsOutputType.setAutoSpec(this._automaticSetting ? AutoSpecType.fromValue((String)"Yes") : AutoSpecType.fromValue((String)"No"));
        modelDetailsOutputType.setAttributes(OutputAttributeType.convertAttributes(this._currentOutputColumns));
        return modelDetailsOutputType;
    }

    private void handleModelSelectionChanged() {
        int n = this._selectedModelsGenericTable.getSelectedRowCount();
        this._removeBtn.setEnabled(n != 0 && !this._automaticSetting);
    }

    private void enableControls(boolean bl) {
        this._addBtn.setEnabled(bl);
        int n = this._selectedModelsGenericTable.getSelectedRowCount();
        this._removeBtn.setEnabled(bl && n > 0);
        this.jModelAlgorithmCombo.setEnabled(bl);
        this.jOutputTypeCombo.setEnabled(bl);
    }

    private void removeButtonProcessing() {
        int[] nArray = this._selectedModelsGenericTable.getSelectedRowsInModel();
        if (nArray.length == 0) {
            return;
        }
        ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)this._selectedModelsGenericTable.getModel());
        modelsTableModel.removeSelectedRows(nArray);
    }

    private void processOutputTypeComboAction() {
        MiningDetailsOutputType miningDetailsOutputType = (MiningDetailsOutputType)((Object)this.jOutputTypeCombo.getSelectedItem());
        if (this._currentMiningDetailOutputType != miningDetailsOutputType) {
            this._currentMiningDetailOutputType = miningDetailsOutputType;
            this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
            if (this._automaticSetting) {
                try {
                    this.loadCompatibleModels();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY"), null);
                }
            } else {
                try {
                    this.validateModelsAreCompatible();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY_CHECK_FAILED"), null);
                }
            }
            this.initOutputColumns();
        }
    }

    private void processAlgorithmComboAction() {
        MiningAlgorithmOptions miningAlgorithmOptions = (MiningAlgorithmOptions)((Object)this.jModelAlgorithmCombo.getSelectedItem());
        if (this._currentAlgorithmOption != miningAlgorithmOptions) {
            this._currentAlgorithmOption = miningAlgorithmOptions;
            this.setupOutputTypeCombo(this._currentMiningFunction, this._currentAlgorithmOption);
            if (this._automaticSetting) {
                try {
                    this.loadCompatibleModels();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY"), null);
                }
            } else {
                try {
                    this.validateModelsAreCompatible();
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_TITLE"), (String)ModelDetailsLrb.get("MODEL_DETAILS_ERROR_MODEL_COMPATIBILITY_CHECK_FAILED"), null);
                }
            }
        }
    }

    private void validateModelsAreCompatible() throws Exception {
        ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
        ModelDetailsOutputType modelDetailsOutputType2 = this._node.validateModelCompatibilityNotAuto(modelDetailsOutputType);
        this._selectedModelsTableModel.reload(modelDetailsOutputType2.getModels().getModel());
    }

    private void setupOutputTypeCombo(MiningFunctions miningFunctions, MiningAlgorithmOptions miningAlgorithmOptions) {
        this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._dbVersion, miningFunctions, miningAlgorithmOptions)));
        this._currentMiningDetailOutputType = MiningDetailsOutputType.getPreferredOutputTypeForModelDetailsNode(miningFunctions, miningAlgorithmOptions);
        this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        this.initOutputColumns();
    }

    @Override
    public void initRes() {
        ResourceUtils.resLabel((JLabel)this._jMiningFunctionLabel, (Component)this._jMiningFunctionValue, (String)PropertyLrb.get("PI_MODEL_DETAILS_MODEL_FUNCTION"));
        ResourceUtils.resLabel((JLabel)this._jModelAlgorithmLabel, this.jModelAlgorithmCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE"));
        this.jModelAlgorithmCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        this.jModelAlgorithmCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_MODEL_TYPE_ADA"));
        ResourceUtils.resLabel((JLabel)this._jOutputTypeLabel, this.jOutputTypeCombo, (String)PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE"));
        this.jOutputTypeCombo.getAccessibleContext().setAccessibleDescription(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        this.jOutputTypeCombo.setToolTipText(PropertyLrb.get("PI_MODEL_DETAILS_GROUP_OUTPUT_TYPE_ADA"));
        ResourceUtils.resButton((AbstractButton)this._jDisplayColumnsButton, (String)ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON"));
        this._jDisplayColumnsButton.getAccessibleContext().setAccessibleDescription(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
        this._jDisplayColumnsButton.setToolTipText(ModelDetailsLrb.get("COLUMNS_DISPLAY_BUTTON_ADA"));
    }

    private void loadData() {
        if (this._modelOutputType != null) {
            this._models = this._modelOutputType.getModels().getModel();
            this._modelDetailType = this._modelOutputType.getType();
            this._currentMiningDetailOutputType = MiningDetailsOutputType.getMiningDetailsOutputType(this._modelDetailType);
            this._currentMiningFunction = MiningFunctions.getMiningFunctionsFromType(this._modelOutputType.getMiningFunction());
            this._currentAlgorithmOption = MiningAlgorithmOptions.getMiningAlgorithmOption(this._modelOutputType.getMiningAlgorithm());
            this._currentOutputColumns = OutputAttributeType.convertAttributes((Attributes)this._modelOutputType.getAttributes());
            if (this._modelOutputType.getAutoSpec() != null) {
                this._automaticSetting = this._modelOutputType.getAutoSpec().value().compareTo("Yes") == 0;
            }
        } else {
            this._models = null;
            this._currentMiningDetailOutputType = null;
            this._currentMiningFunction = null;
            this._currentAlgorithmOption = null;
            this._currentOutputColumns = null;
            this._automaticSetting = false;
        }
    }

    private void loadTables() {
        try {
            this._selectedModelsTableModel = new ModelsTableModel(this._models, this._ownerName, this._node, true);
            this.setupModelsTable(this._selectedModelsGenericTable, this._selectedModelsTableModel);
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)ModelDetailsLrb.get("ERROR_TITLE"), (String)ModelDetailsLrb.get("ERROR_MODEL_LOADING_UNEXPECTED"), null);
            theLogger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private void setupModelsTable(GenericTable genericTable, ModelsTableModel modelsTableModel) {
        genericTable.setModel((TableModel)((Object)modelsTableModel));
        genericTable.setSorted(true);
        genericTable.setSortColumn(0, true);
        genericTable.setUpdateSelectionOnSort(true);
        genericTable.getTableHeader().setReorderingAllowed(false);
        IconCellRenderer iconCellRenderer = new IconCellRenderer(new IconCellRenderer.IconChooser(){

            @Override
            public Icon getIconFor(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                GenericTable genericTable = (GenericTable)jTable;
                int n3 = genericTable.convertRowIndexToModel(n);
                ModelsTableModel modelsTableModel = (ModelsTableModel)((Object)genericTable.getModel());
                AvailableRefModelType availableRefModelType = (AvailableRefModelType)((Object)modelsTableModel.getSrcData().get(n3));
                if (availableRefModelType.getStatus() == RefModelStatusType.VALID && modelsTableModel.isModelBuilt(n3)) {
                    return DataMinerIcons.get(Icons.PI_BUILD_GROUP_MODEL_BUILT);
                }
                if (availableRefModelType.getStatus() == RefModelStatusType.VALID && !modelsTableModel.isModelBuilt(n3)) {
                    return DataMinerIcons.getNullIcon();
                }
                return OracleIcons.getIcon((String)"database_error.png");
            }
        });
        TableColumn tableColumn = genericTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(iconCellRenderer);
    }

    private void initComboBoxes() {
        this._jAutoSpecificationCheckBox.setSelected(this._automaticSetting);
        List<AbstractNode> list = this._node.findParentNodes();
        this.algorithmComboModel = new DefaultComboBoxModel();
        if (list.isEmpty() && this._modelDetailType == null) {
            this._currentMiningFunction = MiningFunctions.CLASSIFICATION;
            this._jMiningFunctionValue.setText(this.UNDEFINED);
            this.jModelAlgorithmCombo.setEnabled(false);
            this.jOutputTypeCombo.setModel(new DefaultComboBoxModel());
            this.jOutputTypeCombo.setEnabled(false);
            this._jAutoSpecificationCheckBox.setEnabled(false);
        } else if (!list.isEmpty() && this._modelDetailType == null) {
            this._currentMiningFunction = this.getParentNodeMiningFunction(list);
            AbstractNode abstractNode = list.get(0);
            if (this._currentMiningFunction == null) {
                this._currentMiningFunction = MiningFunctions.CLASSIFICATION;
                this._jMiningFunctionValue.setText(this.UNDEFINED);
            } else {
                this._jMiningFunctionValue.setText(this._currentMiningFunction.toString());
            }
            this.jModelAlgorithmCombo.setEnabled(true);
            this.jOutputTypeCombo.setEnabled(true);
            MiningAlgorithmOptions.getMiningAlgorithmOptions(this._dbVersion, this._currentMiningFunction).forEach(miningAlgorithmOptions -> this.algorithmComboModel.addElement((MiningAlgorithmOptions)((Object)miningAlgorithmOptions)));
            this._currentAlgorithmOption = MiningAlgorithmOptions.getPreferredAlgorithmOptionForModelDetailsNode(abstractNode, this._currentMiningFunction);
            this.algorithmComboModel.setSelectedItem((Object)this._currentAlgorithmOption);
            this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._dbVersion, this._currentMiningFunction, this._currentAlgorithmOption)));
            this._currentMiningDetailOutputType = MiningDetailsOutputType.getPreferredOutputTypeForModelDetailsNode(this._currentMiningFunction, this._currentAlgorithmOption);
            this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        } else if (this._modelDetailType != null) {
            this._jMiningFunctionValue.setText(this._currentMiningFunction.toString());
            MiningAlgorithmOptions.getMiningAlgorithmOptions(this._dbVersion, this._currentMiningFunction).forEach(miningAlgorithmOptions -> this.algorithmComboModel.addElement((MiningAlgorithmOptions)((Object)miningAlgorithmOptions)));
            this.jModelAlgorithmCombo.setEnabled(true);
            this.algorithmComboModel.setSelectedItem((Object)this._currentAlgorithmOption);
            this.jOutputTypeCombo.setModel(new DefaultComboBoxModel<MiningDetailsOutputType>(MiningDetailsOutputType.getMiningDetailsOutputType(this._dbVersion, this._currentMiningFunction, this._currentAlgorithmOption)));
            this.jOutputTypeCombo.setEnabled(true);
            this.jOutputTypeCombo.setSelectedItem((Object)this._currentMiningDetailOutputType);
        }
        this.jModelAlgorithmCombo.setModel(this.algorithmComboModel);
        this.enableControls(!this._jAutoSpecificationCheckBox.isSelected());
    }

    private MiningFunctions getParentNodeMiningFunction(List<AbstractNode> list) {
        MiningFunctionType miningFunctionType = null;
        AbstractNode abstractNode = list.get(0);
        if (abstractNode instanceof AbstractBuildNode) {
            AbstractBuildNode abstractBuildNode = (AbstractBuildNode)abstractNode;
            miningFunctionType = abstractBuildNode.getMiningFunctionType();
        } else if (abstractNode instanceof AbstractModelNode) {
            AbstractModelNode abstractModelNode = (AbstractModelNode)abstractNode;
            miningFunctionType = abstractModelNode.getMiningFunctionTypeSupported();
        }
        return MiningFunctions.getMiningFunctionsFromType(miningFunctionType);
    }

    private void initOutputColumns() {
        this._currentAlgorithmOption = (MiningAlgorithmOptions)((Object)this.jModelAlgorithmCombo.getSelectedItem());
        if (this._currentMiningDetailOutputType != null && this._currentAlgorithmOption != null && this._currentMiningFunction != null) {
            this._currentOutputColumns = ExtractQueryFactory.getModelColumnList(this._node, MiningDetailsOutputType.getMiningDetailType(this._currentMiningDetailOutputType, this._currentAlgorithmOption, this._currentMiningFunction), this._dbVersion);
            this._jDisplayColumnsButton.setEnabled(true);
        } else {
            this._jDisplayColumnsButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doWork() {
        boolean bl;
        block8: {
            bl = true;
            if (!this._dirty) {
                return true;
            }
            try {
                ModelDetailsOutputType modelDetailsOutputType = this.generateModelOutputType();
                if (!bl) break block8;
                CommandProcessor.getInstance().beginTrans(ModelDetailsLrb.get("MODEL_NODE_EDIT_TRANSACTION_NAME"));
                try {
                    OdmrSDMUndoFilter odmrSDMUndoFilter = (OdmrSDMUndoFilter)((ModelDetailsDataNode)this.getData()).getUndoFilter();
                    odmrSDMUndoFilter.prepareUndo(this.getData(), this.getContext(), "modelDetailsModels", modelDetailsOutputType);
                    ((ModelDetailsDataNode)this.getData()).validate(true);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
                }
                finally {
                    CommandProcessor.getInstance().endTrans();
                }
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_TITLE"), (String)DialogsLrb.get("MODEL_NODE_EDIT_ERROR_MESG"), null);
            }
        }
        return bl;
    }

    @Override
    protected String getDialogTitle() {
        return ModelDetailsLrb.get("EDIT_DIALOG_TITLE");
    }

    @Override
    protected String getHelpTopic() {
        return "edit_model_details_auto";
    }
}

