/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.DataMinerTablePanel;
import oracle.dmt.dataminer.controls.dialog.DialogDisplayable;
import oracle.dmt.dataminer.controls.dialog.Dialogable;
import oracle.dmt.dataminer.controls.dialog.DialogableAdapter;
import oracle.dmt.dataminer.controls.models.SingleColumnTableModel;
import oracle.dmt.dataminer.core.utils.comparator.LetterNumberComparator;
import oracle.dmt.dataminer.core.utils.comparator.NumberComparator;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.xmlschema.TargetValues;
import oracle.ide.util.ResourceUtils;

public class TargetValuesPanel
extends JPanel
implements DialogDisplayable {
    private String targetName;
    private String targetDataType;
    private TargetValues targetValues;
    private DataMinerTablePanel tablePanel;
    private JLabel targetDataTypeLabel;
    private JLabel targetDataTypeValue;
    private JLabel targetNameLabel;
    private JLabel targetNameValue;

    public TargetValuesPanel(String string, String string2, TargetValues targetValues) {
        this.targetName = string;
        this.targetDataType = string2;
        this.targetValues = targetValues;
        this.initComponents();
        this.initRes();
        this.initUI();
    }

    private void initComponents() {
        this.targetNameLabel = new JLabel();
        this.targetNameValue = new JLabel();
        this.targetDataTypeLabel = new JLabel();
        this.targetDataTypeValue = new JLabel();
        this.tablePanel = new DataMinerTablePanel();
        this.targetNameLabel.setText("Target:");
        this.targetNameValue.setText("Churn");
        this.targetDataTypeLabel.setText("Data Type:");
        this.targetDataTypeValue.setText("VARCHAR2");
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tablePanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.targetNameLabel, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetNameValue, -2, 134, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.targetDataTypeLabel, -2, 74, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.targetDataTypeValue, -2, 80, -2).addGap(0, 26, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.targetNameLabel).addComponent(this.targetNameValue).addComponent(this.targetDataTypeLabel).addComponent(this.targetDataTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tablePanel, -1, 253, Short.MAX_VALUE).addContainerGap()));
    }

    private void initUI() {
        this.setupTable();
        this.targetNameValue.setText(this.targetName);
        this.targetDataTypeValue.setText(this.targetDataType);
        if (this.targetName.length() == 0) {
            this.targetNameValue.setVisible(false);
            this.targetNameLabel.setVisible(false);
            this.targetDataTypeLabel.setVisible(false);
            this.targetDataTypeValue.setVisible(false);
        }
    }

    private void initRes() {
        ResourceUtils.resLabel((JLabel)this.targetNameLabel, (Component)this.targetNameValue, (String)(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET") + ":"));
        ResourceUtils.resLabel((JLabel)this.targetDataTypeLabel, (Component)this.targetDataTypeValue, (String)(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_DATA_TYPE") + ":"));
    }

    private void setupTable() {
        TargetValueTableModel targetValueTableModel = null;
        if (!this.targetValues.getTargetValueNumber().isEmpty()) {
            targetValueTableModel = new TargetValueTableModel(this.targetValues.getTargetValueNumber(), false);
        } else if (!this.targetValues.getTargetValueString().isEmpty()) {
            targetValueTableModel = new TargetValueTableModel(this.targetValues.getTargetValueString(), true);
        } else assert (false) : "Invalid option";
        this.tablePanel.setup((TableModel)((Object)targetValueTableModel), "", 0);
        this.tablePanel.getTable().setSortColumn(0, true);
    }

    @Override
    public Dialogable asDialog() {
        return new DialogableAdapter(){

            @Override
            public String getTitle() {
                return DialogsLrb.get("TARGET_VALUES_DIALOG_TITLE");
            }

            @Override
            public String getHelpTopic() {
                return null;
            }

            @Override
            public int getButtonMask() {
                return 16;
            }

            @Override
            public JComponent getContent() {
                return TargetValuesPanel.this;
            }
        };
    }

    private static class TargetValueTableModel
    extends SingleColumnTableModel {
        private static final int VALUE = 0;
        private boolean isStringTargetValues;

        public TargetValueTableModel(List<?> list, boolean bl) {
            super(DialogsLrb.get("TARGET_VALUES_DIALOG_TARGET_VALUES"), list);
            this.isStringTargetValues = bl;
        }

        @Override
        public Comparator getColumnSortComparator(int n) {
            if (this.isStringTargetValues) {
                return LetterNumberComparator.getComparator();
            }
            return NumberComparator.getComparator();
        }
    }
}

