/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.model;

import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dmt.dataminer.ValidationException;
import oracle.dmt.dataminer.core.dal.ODMrDAOException;
import oracle.dmt.dataminer.core.model.clas.common.CostBenefitsInfo;
import oracle.dmt.dataminer.core.model.clas.common.CostMatrixInfo;
import oracle.dmt.dataminer.core.model.clas.common.PerformanceInfo;
import oracle.dmt.dataminer.core.model.clas.common.PriorsInfo;
import oracle.dmt.dataminer.core.model.common.NameValuePair;
import oracle.dmt.dataminer.core.model.common.ServerConstants;
import oracle.dmt.dataminer.core.model.common.build.ModelGeneralDescription;
import oracle.dmt.dataminer.core.utils.db.DbVersionHelper;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.server.model.Model;
import oracle.dmt.dataminer.utils.ConfigUtils;
import oracle.dmt.dataminer.utils.SQLHelper;
import oracle.dmt.dataminer.workflow.MetaDataHelper;
import oracle.dmt.dataminer.workflow.dialog.AbstractPropertiesDialogState;
import oracle.dmt.dataminer.workflow.dialog.model.DialogsLrb;
import oracle.dmt.dataminer.workflow.model.AbstractBuildNode;
import oracle.dmt.dataminer.workflow.xmlschema.AttributeType;
import oracle.dmt.dataminer.workflow.xmlschema.Attributes;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CGeneralizedLinearModelType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.CSupportVectorMachineModelType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.ClassificationModelType;
import oracle.dmt.dataminer.workflow.xmlschema.DataSourceNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.DecisionTreeModelType;
import oracle.dmt.dataminer.workflow.xmlschema.MiningFunctionType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelStatusType;
import oracle.dmt.dataminer.workflow.xmlschema.ModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesAlgoType;
import oracle.dmt.dataminer.workflow.xmlschema.NaiveBayesModelType;
import oracle.dmt.dataminer.workflow.xmlschema.NodeType;
import oracle.dmt.dataminer.workflow.xmlschema.PerformanceType;
import oracle.dmt.dataminer.workflow.xmlschema.PriorType;
import oracle.dmt.dataminer.workflow.xmlschema.SuperviseBuildNodeType;
import oracle.dmt.dataminer.workflow.xmlschema.WeightsType;
import oracle.ide.Context;
import oracle.javatools.util.Version;

public class ModelPropertiesState
implements AbstractPropertiesDialogState {
    private static final Logger theLogger = Logger.getLogger(ModelPropertiesState.class.getName());
    private ModelType _modelType;
    private Context _context;
    private Locale _locale;
    private Map<String, ModifiedObject> _data = new HashMap<String, ModifiedObject>();
    private Map<String, ModifiedObject> _copy = new HashMap<String, ModifiedObject>();
    private static String _VALIDATION_ERROR = "_VALIDATION_ERROR";
    private static String _NULL_VALUE = "_NULL_VALUE";
    private Map<String, Object> _allSetting;
    public static final Double DEFAULT_WEIGHT = 1.0;
    public static final Double DEFAULT_BENEFIT = 0.0;
    private Object _selectedTargetValue;
    private boolean _falsePositive = true;
    public static final String CLIENT_SVM_LINEAR = DialogsLrb.get("SVMS_LINEAR");
    public static final String CLIENT_SVM_GAUSSIAN = DialogsLrb.get("SVMS_GAUSSIAN");
    public static final String CLIENT_SVMS_SYSTEM_DEFAULT = DialogsLrb.get("SVMS_SYSTEM_DEFAULT");
    private ArrayList<String> _ignoredSettings = new ArrayList();
    private PerformanceInfo _pOriginalPerfInfo;
    private PerformanceInfo _pResultPerfInfo;
    private PriorsInfo _priorsOriginalInfo = PriorsInfo._NO_PRIOR;
    private PriorsInfo _priorsResultInfo = PriorsInfo._NO_PRIOR;
    private Model _odmModel;
    private DataSourceNodeType _dataSourceNode;
    private NodeType _nodeType;
    private List<String> _glmClassRefValues;
    private String _curClassRefValue;
    public static final int _ROUNDING_PRECISION = 4;
    protected static final String DEFAULT_CLASS_REF_NAME = DialogsLrb.get("GLM_REFERENCE_CLASS_NAME_DEFAULT");
    private OPTION _option = OPTION.PROPERTIES;
    private HashMap<String, Object> _modifiedSettings = new HashMap();

    public void setCostMatrixOption() {
        this._option = OPTION.COST_MATRIX;
    }

    public void setCostBenefitsOption() {
        this._option = OPTION.COST_BENEFIT;
    }

    public void setCurClassRefValue(String string) {
        this._curClassRefValue = string;
    }

    public String getCurClassRefValue() {
        return this._curClassRefValue;
    }

    public Model getOdmModel() {
        return this._odmModel;
    }

    public static boolean isNullValue(String string) {
        return string.endsWith(_NULL_VALUE);
    }

    public String getAlgorithm() {
        if (this._modelType == null) {
            return null;
        }
        return MetaDataHelper.getAlgorithmName(this._modelType);
    }

    public String getAlgorithmType() {
        if (this._modelType == null) {
            return null;
        }
        return MetaDataHelper.getAlgorithmType(this._modelType);
    }

    public MiningFunctionType getFunction() {
        if (this._nodeType instanceof ClassificationBuildNodeType) {
            return MiningFunctionType.CLASSIFICATION;
        }
        if (this._nodeType instanceof SuperviseBuildNodeType) {
            return MiningFunctionType.REGRESSION;
        }
        return null;
    }

    public ModelPropertiesState(Context context, ModelType modelType, AbstractBuildNode abstractBuildNode, DataSourceNodeType dataSourceNodeType, Locale locale) {
        this._nodeType = abstractBuildNode.getData();
        this._dataSourceNode = dataSourceNodeType;
        this._modelType = modelType;
        this._context = context;
        this._locale = locale;
    }

    public boolean isDataSourcePresent() {
        return this._dataSourceNode != null;
    }

    public boolean isTargetSelected() {
        AttributeType attributeType = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute();
        return attributeType != null;
    }

    public List<AttributeType> getAttributes() {
        if (this._dataSourceNode == null) {
            return new ArrayList<AttributeType>(0);
        }
        Attributes attributes = this._dataSourceNode.getAttributes();
        if (null == attributes) {
            return new ArrayList<AttributeType>(0);
        }
        return attributes.getAttribute();
    }

    private String getInputTableName() {
        if (this._dataSourceNode == null) {
            return null;
        }
        return this._dataSourceNode.getSourceTable().getName();
    }

    private String getInputSchemaName() {
        if (this._dataSourceNode == null) {
            return null;
        }
        return this._dataSourceNode.getSourceTable().getSchema();
    }

    public void setNullValue(String string) {
        this.setValue(string, _NULL_VALUE);
    }

    public void setValue(String string, Object object) {
        this._data.put(string, new ModifiedObject(object));
    }

    public void setBackupValue(String string, Object object) {
        this._copy.put(string, new ModifiedObject(object));
    }

    public Object getBackupValue(String string) {
        ModifiedObject modifiedObject = this._copy.get(string);
        return modifiedObject.getContent();
    }

    public void setBackupNullValue(String string) {
        this.setBackupValue(string, _NULL_VALUE);
    }

    public void setValidationError(String string) {
        if (!this._data.isEmpty()) {
            this._data.clear();
        }
        this._data.put(_VALIDATION_ERROR, new ModifiedObject(string));
    }

    @Override
    public boolean confirm(Component component) {
        return true;
    }

    @Override
    public boolean isModified() throws ValidationException {
        if (this._data.size() != this._copy.size()) {
            return true;
        }
        if (this.hasValidationError()) {
            return true;
        }
        boolean bl = false;
        for (Map.Entry<String, ModifiedObject> entry : this._data.entrySet()) {
            Object object;
            Object object2;
            ModifiedObject modifiedObject;
            String string = entry.getKey();
            if (this.isPerformanceSetting(string)) {
                if (this._pResultPerfInfo != null && this._pResultPerfInfo.equals(this._pOriginalPerfInfo)) {
                    modifiedObject = entry.getValue();
                    modifiedObject.clearModifiedFlag();
                    continue;
                }
                bl = true;
                continue;
            }
            if (this.isCostMatrixSetting(string)) {
                bl = true;
                continue;
            }
            if (this.isCostBenefitSetting(string)) {
                bl = true;
                continue;
            }
            modifiedObject = this._data.get(string);
            ModifiedObject modifiedObject2 = this._copy.get(string);
            if (modifiedObject.getContent() instanceof Number && modifiedObject2.getContent() instanceof Number) {
                object2 = (Number)modifiedObject.getContent();
                object = (Number)modifiedObject2.getContent();
                if (NameValuePair.areEqual((double)((Number)object2).doubleValue(), (double)((Number)object).doubleValue())) {
                    modifiedObject.clearModifiedFlag();
                    continue;
                }
                bl = true;
                continue;
            }
            object2 = modifiedObject.getContent().toString();
            if (0 == ((String)object2).compareTo((String)(object = modifiedObject2.getContent().toString()))) {
                modifiedObject.clearModifiedFlag();
                continue;
            }
            bl = true;
        }
        return bl;
    }

    private boolean isPerformanceSetting(String string) {
        return 0 == string.compareToIgnoreCase("BUILD_SETTING_PERFORM_OPTION");
    }

    private boolean isCostMatrixSetting(String string) {
        return 0 == string.compareToIgnoreCase("BUILD_SETTING_COST_MATRIX_OPTION");
    }

    private boolean isCostBenefitSetting(String string) {
        return 0 == string.compareToIgnoreCase("BUILD_SETTING_COST_BENEFITS_OPTION");
    }

    @Override
    public void clear() {
        this._data.clear();
    }

    private String getValidationError() {
        ModifiedObject modifiedObject = this._data.get(_VALIDATION_ERROR);
        return modifiedObject != null ? (String)modifiedObject.getContent() : null;
    }

    private boolean hasValidationError() {
        return null != this.getValidationError();
    }

    public Locale getLocale() {
        return this._locale;
    }

    @Override
    public void finish() throws Exception {
        for (Map.Entry<String, ModifiedObject> entry : this._data.entrySet()) {
            Object object;
            ModifiedObject modifiedObject;
            String string = entry.getKey();
            if (this._ignoredSettings.contains(string) || (modifiedObject = entry.getValue()) == null || !modifiedObject.isDirty()) continue;
            if (string.equals("BUILD_SETTING_PERFORM_OPTION")) {
                PerformanceType.Balanced balanced;
                Object object2;
                object = new PerformanceType();
                if (this._pResultPerfInfo.isCustom()) {
                    if (this._pResultPerfInfo.equals(this._pOriginalPerfInfo)) continue;
                    object2 = new PerformanceType.Custom();
                    balanced = new WeightsType();
                    List list = balanced.getItem();
                    List list2 = this._pResultPerfInfo.getValues();
                    for (int i = 0; i < list2.size(); ++i) {
                        NameValuePair nameValuePair = (NameValuePair)list2.get(i);
                        WeightsType.Item item = new WeightsType.Item();
                        item.setTargetValue(nameValuePair.getName());
                        BigDecimal bigDecimal = (BigDecimal)nameValuePair.getValue();
                        item.setWeight(bigDecimal.doubleValue());
                        list.add(item);
                    }
                    object2.setWeights((WeightsType)balanced);
                    object.setCustom((PerformanceType.Custom)object2);
                    this._modifiedSettings.put(string, object);
                    continue;
                }
                object2 = modifiedObject.getContent();
                if (object2.equals("BUILD_SETTING_PERFORM_OP_OVRL")) {
                    object.setNatural(new PerformanceType.Natural());
                } else {
                    balanced = new PerformanceType.Balanced();
                    object.setBalanced(balanced);
                }
                this._modifiedSettings.put(string, object);
                continue;
            }
            object = modifiedObject.getContent();
            this._modifiedSettings.put(string, object);
        }
    }

    private HashMap<String, Object> getAllModelSettings() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this._modelType != null && this._modelType instanceof ClassificationModelType) {
            CGeneralizedLinearAlgoType cGeneralizedLinearAlgoType;
            PerformanceType.Custom custom;
            PerformanceType.Natural natural;
            ClassificationModelType classificationModelType = (ClassificationModelType)this._modelType;
            PerformanceType performanceType = classificationModelType.getPerformance();
            PerformanceType.Balanced balanced = performanceType.getBalanced();
            if (balanced != null) {
                hashMap.put("BUILD_SETTING_PERFORM_OPTION", "BUILD_SETTING_PERFORM_OP_AVG");
            }
            if ((natural = performanceType.getNatural()) != null) {
                hashMap.put("BUILD_SETTING_PERFORM_OPTION", "BUILD_SETTING_PERFORM_OP_OVRL");
            }
            if ((custom = performanceType.getCustom()) != null) {
                hashMap.put("BUILD_SETTING_PERFORM_OPTION", "BUILD_SETTING_PERFORM_OP_CUST");
            }
            if (classificationModelType instanceof NaiveBayesModelType) {
                NaiveBayesAlgoType naiveBayesAlgoType = ((NaiveBayesModelType)classificationModelType).getNaiveBayesAlgo();
                hashMap.put("NABS_PAIRWISE_THRESHOLD", naiveBayesAlgoType.getNABSPAIRWISETHRESHOLD());
                this.setBackupValue("NABS_PAIRWISE_THRESHOLD", naiveBayesAlgoType.getNABSPAIRWISETHRESHOLD());
                hashMap.put("NABS_SINGLETON_THRESHOLD", naiveBayesAlgoType.getNABSSINGLETONTHRESHOLD());
                this.setBackupValue("NABS_SINGLETON_THRESHOLD", naiveBayesAlgoType.getNABSSINGLETONTHRESHOLD());
            } else if (classificationModelType instanceof CSupportVectorMachineModelType) {
                CSupportVectorMachineAlgoType cSupportVectorMachineAlgoType = ((CSupportVectorMachineModelType)classificationModelType).getCSupportVectorMachineAlgo();
                hashMap.put("SVMS_ACTIVE_LEARNING", cSupportVectorMachineAlgoType.getSVMSACTIVELEARNING());
                hashMap.put("SVMS_COMPLEXITY_FACTOR", cSupportVectorMachineAlgoType.getSVMSCOMPLEXITYFACTOR());
                hashMap.put("SVMS_CONV_TOLERANCE", cSupportVectorMachineAlgoType.getSVMSCONVTOLERANCE());
                hashMap.put("SVMS_KERNEL_FUNCTION", cSupportVectorMachineAlgoType.getSVMSKERNELFUNCTION());
                hashMap.put("SVMS_KERNEL_CACHE_SIZE", cSupportVectorMachineAlgoType.getSVMSKERNELCACHESIZE());
                hashMap.put("SVMS_STD_DEV", cSupportVectorMachineAlgoType.getSVMSSTDDEV());
                Version version = ConfigUtils.getDatabaseVersion(this._context);
                boolean bl = DbVersionHelper.isDB122Up((Version)version);
                if (bl) {
                    hashMap.put("SVMS_REGULARIZER", cSupportVectorMachineAlgoType.getSVMSREGULARIZER());
                    hashMap.put("SVMS_BATCH_ROWS", cSupportVectorMachineAlgoType.getSVMSBATCHROWS());
                    hashMap.put("SVMS_SOLVER", cSupportVectorMachineAlgoType.getSVMSSOLVER());
                    hashMap.put("SVMS_NUM_ITERATIONS", cSupportVectorMachineAlgoType.getSVMSNUMITERATIONS());
                    hashMap.put("SVMS_NUM_PIVOTS", cSupportVectorMachineAlgoType.getSVMSNUMPIVOTS());
                }
            } else if (classificationModelType instanceof DecisionTreeModelType) {
                DecisionTreeAlgoType decisionTreeAlgoType = ((DecisionTreeModelType)classificationModelType).getDecisionTreeAlgo();
                if (decisionTreeAlgoType != null) {
                    hashMap.put("TREE_IMPURITY_METRIC", null != decisionTreeAlgoType.getTREEIMPURITYMETRIC() ? decisionTreeAlgoType.getTREEIMPURITYMETRIC() : ServerConstants.DTSettings.TREE_IMPURITY.TREE_IMPURITY_GINI);
                    int n = decisionTreeAlgoType.getTREETERMMAXDEPTH();
                    if (n < 2 || n > 20) {
                        n = 7;
                    }
                    hashMap.put("TREE_TERM_MAX_DEPTH", n);
                    double d = decisionTreeAlgoType.getTREETERMMINPCTNODE();
                    if (d < 0.0 || d > 10.0) {
                        d = 0.05;
                    }
                    hashMap.put("TREE_TERM_MINPCT_NODE", d);
                    double d2 = decisionTreeAlgoType.getTREETERMMINPCTSPLIT();
                    if (d2 < 0.0 || d2 > 20.0) {
                        d2 = 0.1;
                    }
                    hashMap.put("TREE_TERM_MINPCT_SPLIT", d2);
                    hashMap.put("TREE_TERM_MINREC_NODE", null != decisionTreeAlgoType.getTREETERMMINRECNODE() ? decisionTreeAlgoType.getTREETERMMINRECNODE() : Integer.valueOf(10));
                    hashMap.put("TREE_TERM_MINREC_SPLIT", null != decisionTreeAlgoType.getTREETERMMINRECSPLIT() ? decisionTreeAlgoType.getTREETERMMINRECSPLIT() : Integer.valueOf(20));
                    Version version = ConfigUtils.getDatabaseVersion(this._context);
                    if (DbVersionHelper.isDB122Up((Version)version)) {
                        int n2 = decisionTreeAlgoType.getCLASMAXSUPBINS().intValue();
                        if (n2 < 1) {
                            n = 32;
                        }
                        hashMap.put("CLAS_MAX_SUP_BINS", n2);
                    }
                }
            } else if (classificationModelType instanceof CGeneralizedLinearModelType && (cGeneralizedLinearAlgoType = ((CGeneralizedLinearModelType)classificationModelType).getCGeneralizedLinearAlgo()) != null) {
                double d;
                if (cGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME() != null) {
                    hashMap.put("GLMS_DIAGNOSTICS_TABLE_NAME", cGeneralizedLinearAlgoType.getGLMSDIAGNOSTICSTABLENAME());
                }
                if ((d = cGeneralizedLinearAlgoType.getGLMSCONFLEVEL()) < 0.0 || d > 1.0) {
                    d = 0.95;
                }
                hashMap.put("GLMS_CONF_LEVEL", d);
                hashMap.put("GLMS_REFERENCE_CLASS_NAME", null != cGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME() ? cGeneralizedLinearAlgoType.getGLMSREFERENCECLASSNAME() : DEFAULT_CLASS_REF_NAME);
                hashMap.put("GLMS_RIDGE_REGRESSION", null != cGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION() ? cGeneralizedLinearAlgoType.getGLMSRIDGEREGRESSION() : "GLMS_RIDGE_REG_ENABLE");
                if (cGeneralizedLinearAlgoType.getGLMSRIDGEVALUE() != null) {
                    hashMap.put("GLMS_RIDGE_VALUE", cGeneralizedLinearAlgoType.getGLMSRIDGEVALUE());
                }
                hashMap.put("GLMS_VIF_FOR_RIDGE", null != cGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE() ? cGeneralizedLinearAlgoType.getGLMSVIFFORRIDGE() : "GLMS_VIF_RIDGE_DISABLE");
                hashMap.put("ODMS_MISSING_VALUE_TREATMENT", cGeneralizedLinearAlgoType.getODMSMISSINGVALUETREATMENT() != null ? cGeneralizedLinearAlgoType.getODMSMISSINGVALUETREATMENT() : "ODMS_MISSING_VALUE_MEAN_MODE");
                hashMap.put("ODMS_ROW_WEIGHT_COLUMN_NAME", cGeneralizedLinearAlgoType.getODMSROWWEIGHTCOLUMNNAME() != null ? cGeneralizedLinearAlgoType.getODMSROWWEIGHTCOLUMNNAME() : null);
                Version version = ConfigUtils.getDatabaseVersion(this._context);
                if (DbVersionHelper.isDB122Up((Version)version)) {
                    String string;
                    double d3;
                    double d4;
                    double d5 = cGeneralizedLinearAlgoType.getGLMSCONVTOLERANCE();
                    if (d5 > 0.0 && d5 < 1.0) {
                        hashMap.put("GLMS_CONV_TOLERANCE", d5);
                    }
                    if ((d4 = cGeneralizedLinearAlgoType.getGLMSNUMITERATIONS().doubleValue()) > 0.0) {
                        hashMap.put("GLMS_NUM_ITERATIONS", d4);
                    }
                    if ((d3 = cGeneralizedLinearAlgoType.getGLMSBATCHROWS().doubleValue()) > 0.0) {
                        hashMap.put("GLMS_BATCH_ROWS", d3);
                    }
                    if ((string = cGeneralizedLinearAlgoType.getGLMSROWDIAGNOSTICS()) != null) {
                        hashMap.put("GLMS_ROW_DIAGNOSTICS", string);
                    }
                }
            }
        }
        return hashMap;
    }

    @Override
    public void load() throws Exception {
        if (this._modelType == null) {
            return;
        }
        try {
            this._allSetting = this.getAllModelSettings();
            if (ServerConstants.Algorithm.isNB((String)this.getAlgorithm())) {
                this.loadPriorsInfo();
            }
            this.getOriginalPerformanceOption();
            this._curClassRefValue = this.getModelSettingStringValue("GLMS_REFERENCE_CLASS_NAME");
            if (this._curClassRefValue == null) {
                this._curClassRefValue = DEFAULT_CLASS_REF_NAME;
            } else {
                this.getGlmClassRefValues();
            }
            ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(this._context);
            this._odmModel = new Model(connectionFolder, null, this._modelType.getName());
            this._odmModel.load();
        }
        catch (ODMrDAOException oDMrDAOException) {
            this._allSetting = null;
            throw oDMrDAOException;
        }
    }

    public boolean isGlmClassRefValuesLoaded() {
        return this._glmClassRefValues != null;
    }

    public boolean isModelBuilt() {
        return this._modelType.getStatus() == ModelStatusType.COMPLETE;
    }

    public List<String> getGlmClassRefValues() {
        if (this._glmClassRefValues != null) {
            return this._glmClassRefValues;
        }
        if (this.isDataSourcePresent() && this.isTargetSelected()) {
            this._glmClassRefValues = this.getDistinctTargetValues();
        }
        return this._glmClassRefValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDistinctTargetValues() {
        String string = this.getInputTableName();
        String string2 = this.getInputSchemaName();
        String string3 = "\"" + string2 + "\"" + "." + "\"" + string + "\"";
        AttributeType attributeType = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute();
        if (attributeType == null) {
            return new ArrayList<String>(0);
        }
        String string4 = attributeType.getName();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select distinct \"" + string4 + "\" from " + string3 + " where \"" + string4 + "\" is not null");
        ArrayList<String> arrayList = new ArrayList<String>();
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(this._context);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuilder.toString());
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString(1);
                arrayList.add(string5);
            }
        }
        return arrayList;
    }

    public boolean isODmModelBuilt() {
        assert (this._odmModel != null);
        ModelGeneralDescription modelGeneralDescription = this._odmModel.getModelGeneralDescription();
        return modelGeneralDescription.getCreationDate() != null;
    }

    public String getModelSettingStringValue(String string) {
        Object object = null;
        if (this._allSetting != null) {
            object = this._allSetting.get(string);
            assert (!(object instanceof String));
            if (object != null) {
                return object.toString();
            }
        }
        return "";
    }

    public BigDecimal getModelSettingNumValue(String string) {
        BigDecimal bigDecimal = null;
        if (this._allSetting != null) {
            Object object = this._allSetting.get(string);
            assert (!(object instanceof Number));
            if (object != null) {
                return new BigDecimal(object.toString());
            }
        }
        return bigDecimal;
    }

    public ArrayList<String> getIgnoredSettings() {
        return this._ignoredSettings;
    }

    public boolean loadPriorsInfo() {
        boolean bl = false;
        this._priorsOriginalInfo = this.loadPriors();
        this._priorsResultInfo = new PriorsInfo(this._priorsOriginalInfo);
        return !bl ? null != this._priorsOriginalInfo.getOptionName() : false;
    }

    private PriorsInfo loadPriors() {
        NaiveBayesModelType naiveBayesModelType;
        PriorType priorType;
        PriorsInfo priorsInfo = null;
        if (this._modelType == null) {
            return priorsInfo;
        }
        if (this._modelType instanceof NaiveBayesModelType && (priorType = (naiveBayesModelType = (NaiveBayesModelType)this._modelType).getPrior()) != null) {
            priorsInfo = new PriorsInfo("Y");
            List list = priorType.getItem();
            if (list != null && list.size() > 0) {
                for (PriorType.Item item : list) {
                    String string = item.getTargetValue();
                    double d = item.getProb();
                    priorsInfo.put(string, BigDecimal.valueOf(d));
                }
            }
        }
        if (priorsInfo == null) {
            return PriorsInfo._NO_PRIOR;
        }
        return priorsInfo;
    }

    public void createCustomPriorsInfo() {
        StringBuffer stringBuffer = null;
        String string = this.getInputTableName();
        String string2 = this.getInputSchemaName();
        this._priorsResultInfo = this.createDefaultPriors(this.getContext(), string2, string, stringBuffer);
    }

    public CostBenefitsInfo createDefaultCostBenefit() {
        String string = this.getInputTableName();
        String string2 = this.getInputSchemaName();
        return this.createDefaultCostBenefit(this.getContext(), string2, string, null);
    }

    public CostMatrixInfo createDefaultCostMatrix() {
        String string = this.getInputTableName();
        String string2 = this.getInputSchemaName();
        return this.createDefaultCostMatrix(this.getContext(), string2, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostMatrixInfo createDefaultCostMatrix(Context context, String string, String string2, StringBuffer stringBuffer) {
        Object object;
        CostMatrixInfo costMatrixInfo = new CostMatrixInfo("BUILD_SETTING_CSTBNF_OP_TRUE");
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = "\"" + string + "\"" + "." + "\"" + string2 + "\"";
        String string4 = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (stringBuffer != null) {
            object = "SELECT * FROM " + string2;
            int n = stringBuffer.lastIndexOf((String)object);
            stringBuffer3.append(stringBuffer.substring(0, n));
            stringBuffer3.append("select distinct \"" + string4 + "\" from " + string3 + " where \"" + string4 + "\" is not null");
        } else {
            stringBuffer3.append("select distinct \"" + string4 + "\" from " + string3 + " where \"" + string4 + "\" is not null");
        }
        object = new Vector();
        stringBuffer2.append(stringBuffer3);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer2.toString());
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString(1);
                ((Vector)object).add(string5);
            }
        }
        if (costMatrixInfo == null) {
            return null;
        }
        if (((Vector)object).isEmpty()) {
            return null;
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                costMatrixInfo.put(((Vector)object).get(i), ((Vector)object).get(j), j != i ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L));
            }
        }
        return costMatrixInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CostBenefitsInfo createDefaultCostBenefit(Context context, String string, String string2, StringBuffer stringBuffer) {
        Object object;
        CostBenefitsInfo costBenefitsInfo = new CostBenefitsInfo("BUILD_SETTING_COST_BENEFITS_OPTION");
        StringBuffer stringBuffer2 = new StringBuffer();
        String string3 = "\"" + string + "\"" + "." + "\"" + string2 + "\"";
        String string4 = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (stringBuffer != null) {
            object = "SELECT * FROM " + string2;
            int n = stringBuffer.lastIndexOf((String)object);
            stringBuffer3.append(stringBuffer.substring(0, n));
            stringBuffer3.append("select distinct \"" + string4 + "\" from " + string3 + " where \"" + string4 + "\" is not null");
        } else {
            stringBuffer3.append("select distinct \"" + string4 + "\" from " + string3 + " where \"" + string4 + "\" is not null");
        }
        object = new Vector();
        stringBuffer2.append(stringBuffer3);
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer2.toString());
            while (sQLHelper.rs.next()) {
                String string5 = sQLHelper.rs.getString(1);
                ((Vector)object).add(string5);
            }
        }
        if (costBenefitsInfo == null) {
            return null;
        }
        if (((Vector)object).isEmpty()) {
            return null;
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            costBenefitsInfo.put((String)((Vector)object).get(i), BigDecimal.valueOf(0L));
        }
        return costBenefitsInfo;
    }

    public boolean hasPriors() {
        return null != this._priorsResultInfo && null != this._priorsResultInfo.getValues();
    }

    public void clearPriors() {
        if (null != this._priorsResultInfo) {
            this._priorsResultInfo.clearPriors();
        }
        this._priorsResultInfo.setNoPriorsOption();
    }

    public PriorsInfo getResultPriorsInfo() {
        return this._priorsResultInfo;
    }

    public PriorsInfo getOriginalPriorsInfo() {
        return this._priorsOriginalInfo;
    }

    public void setResultPriorsInfo(PriorsInfo priorsInfo) {
        this._priorsResultInfo = new PriorsInfo(priorsInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PriorsInfo createDefaultPriors(Context context, String string, String string2, StringBuffer stringBuffer) {
        String string3;
        PriorsInfo priorsInfo = new PriorsInfo("Y");
        StringBuffer stringBuffer2 = new StringBuffer();
        String string4 = null;
        String string5 = null;
        if (stringBuffer != null) {
            string4 = "\"" + string2 + "\"";
            string3 = "SELECT * FROM " + string2;
            int n = stringBuffer.lastIndexOf(string3);
            string5 = stringBuffer.substring(0, n);
        } else {
            string4 = "\"" + string + "\"" + "." + "\"" + string2 + "\"";
        }
        string3 = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName();
        String string6 = "select \"" + string3 + "\" as VALUE, COUNT(*) as VALUE_COUNT \n from " + string4 + " group by \"" + string3 + "\" having \"" + string3 + "\" is not null";
        String string7 = "SELECT COUNT(*) AS total FROM " + string4 + " WHERE \"" + string3 + "\" IS NOT NULL";
        String string8 = "select  COUNT(*) as ROWCOUNT from " + string4;
        String string9 = "select  e.VALUE,  ROUND((e.value_count / total), 4) as current_distribution from \n(" + string6 + ") e, \n(" + string7 + ") f, \n(" + string8 + ") g ";
        if (string5 != null) {
            stringBuffer2.append(string5);
        }
        stringBuffer2.append(string9);
        SQLHelper sQLHelper = new SQLHelper();
        Double d = null;
        double d2 = 0.0;
        String string10 = null;
        try {
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer2.toString());
            while (sQLHelper.rs.next()) {
                String string11 = sQLHelper.rs.getString(1);
                double d3 = sQLHelper.rs.getDouble(2);
                priorsInfo.put(string11, new BigDecimal(String.valueOf(d3)));
                if (d == null) {
                    d = d3;
                } else if (d3 > d) {
                    d = d3;
                    string10 = string11;
                }
                d2 += d3;
            }
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, sQLException.getMessage(), sQLException);
            priorsInfo = null;
        }
        finally {
            sQLHelper.close();
        }
        double d4 = 1.0 - d2;
        if (d4 > 0.0 || d4 < 0.0) {
            double d5 = d + d4;
            priorsInfo.put(string10, new BigDecimal(String.valueOf(d5)));
        }
        return priorsInfo;
    }

    public String getOriginalPerformanceOption() {
        if (this._pOriginalPerfInfo != null) {
            return this._pOriginalPerfInfo.getPerformanceOption();
        }
        if (this._pOriginalPerfInfo != null) {
            return this._pOriginalPerfInfo.getPerformanceOption();
        }
        boolean bl = false;
        this._pOriginalPerfInfo = this.getPerformanceOption();
        if (this._pOriginalPerfInfo != null) {
            this._pResultPerfInfo = new PerformanceInfo(this._pOriginalPerfInfo);
        }
        return !bl ? this._pOriginalPerfInfo.getPerformanceOption() : null;
    }

    private PerformanceInfo getPerformanceOption() {
        PerformanceInfo performanceInfo = null;
        if (this._modelType == null) {
            return performanceInfo;
        }
        if (this._modelType instanceof ClassificationModelType) {
            ClassificationModelType classificationModelType = (ClassificationModelType)this._modelType;
            PerformanceType performanceType = classificationModelType.getPerformance();
            PerformanceType.Custom custom = null;
            if (performanceType != null) {
                if (null != performanceType.getBalanced()) {
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_AVG");
                } else if (null != performanceType.getNatural()) {
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_OVRL");
                } else if (null != performanceType.getCustom()) {
                    custom = performanceType.getCustom();
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
                    WeightsType weightsType = custom.getWeights();
                    List list = weightsType.getItem();
                    if (list != null && list.size() > 0) {
                        for (WeightsType.Item item : list) {
                            String string = item.getTargetValue();
                            double d = item.getWeight();
                            performanceInfo.put(string, BigDecimal.valueOf(d));
                        }
                    }
                } else {
                    performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_AVG");
                }
            }
        }
        return performanceInfo;
    }

    public PerformanceInfo getResultPerformanceInfo() {
        return this._pResultPerfInfo;
    }

    public PerformanceInfo getOriginalPerformanceInfo() {
        return this._pOriginalPerfInfo;
    }

    public boolean hasWeights() {
        return null != this._pResultPerfInfo && null != this._pResultPerfInfo.getValues();
    }

    public void setResultPerformanceInfo(PerformanceInfo performanceInfo) {
        this._pResultPerfInfo = new PerformanceInfo(performanceInfo);
    }

    public void setBalancedPerformanceInfo() {
        this.setPerformanceOption(this._pResultPerfInfo, true);
    }

    public void setNaturalPerformanceInfo() {
        this.setPerformanceOption(this._pResultPerfInfo, false);
    }

    private void setPerformanceOption(PerformanceInfo performanceInfo, boolean bl) {
        performanceInfo.setPerformanceOption(bl ? "BUILD_SETTING_PERFORM_OP_AVG" : "BUILD_SETTING_PERFORM_OP_OVRL");
    }

    public void setPerformanceInfo(boolean bl) {
        this._pResultPerfInfo.setPerformanceOption(bl ? "BUILD_SETTING_PERFORM_OP_AVG" : "BUILD_SETTING_PERFORM_OP_OVRL");
    }

    public void setCustomPerformanceInfo() {
        this._pResultPerfInfo.setPerformanceOption("BUILD_SETTING_PERFORM_OP_CUST");
    }

    public boolean isCaseIdSelected() {
        List list = ((SuperviseBuildNodeType)this._nodeType).getCaseAttributes().getAttribute();
        return list != null && !list.isEmpty();
    }

    public void createCustomPerformanceInfo(boolean bl) {
        if (!(this._nodeType instanceof SuperviseBuildNodeType)) {
            return;
        }
        String string = ((SuperviseBuildNodeType)this._nodeType).getTargetAttribute().getName();
        if (bl) {
            this.createBalanceWeights(string);
        } else {
            this.createNaturalWeights(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerformanceInfo createNaturalWeights(Context context, String string, String string2, String string3, StringBuffer stringBuffer) {
        String string4;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string5 = null;
        String string6 = null;
        if (stringBuffer != null) {
            string5 = "\"" + string3 + "\"";
            string4 = "SELECT * FROM " + string3;
            int n = stringBuffer.lastIndexOf(string4);
            string6 = stringBuffer.substring(0, n);
        } else {
            string5 = "\"" + string2 + "\"" + "." + "\"" + string3 + "\"";
        }
        string4 = "select  \"" + string + "\" as VALUE, COUNT(*) as VALUE_COUNT from " + string5 + " group by \"" + string + "\" having \"" + string + "\" is not null ";
        String string7 = "select  COUNT(*) as total from " + string5 + " where \"" + string + "\" is not null";
        String string8 = "select  e.VALUE,  ROUND((e.value_count / total), 4) as target_distribution from \n(" + string4 + ") e, \n(" + string7 + ") f ";
        if (string6 != null) {
            stringBuffer2.append(string6);
        }
        stringBuffer2.append(string8);
        PerformanceInfo performanceInfo = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer2.toString());
            while (sQLHelper.rs.next()) {
                String string9 = sQLHelper.rs.getString(1);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(2);
                performanceInfo.put(string9, bigDecimal);
            }
        }
        performanceInfo.setCustomGeneratedNatural();
        return performanceInfo;
    }

    private void createBalanceWeights(String string) {
        String string2 = this.getInputTableName();
        String string3 = this.getInputSchemaName();
        this._pResultPerfInfo = this.createBalanceWeights(this.getContext(), string, string3, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerformanceInfo createBalanceWeights(Context context, String string, String string2, String string3, StringBuffer stringBuffer) {
        String string4;
        if (this._modelType == null) {
            return null;
        }
        String string5 = MetaDataHelper.getAlgorithmType(this._modelType);
        StringBuffer stringBuffer2 = new StringBuffer();
        String string6 = null;
        String string7 = null;
        if (stringBuffer != null) {
            string6 = "\"" + string3 + "\"";
            string4 = "SELECT * FROM " + string3;
            int n = stringBuffer.lastIndexOf(string4);
            string7 = stringBuffer.substring(0, n);
        } else {
            string6 = "\"" + string2 + "\"" + "." + "\"" + string3 + "\"";
        }
        if (ServerConstants.Algorithm.isDT((String)string5)) {
            if (string7 != null) {
                stringBuffer2.append(string7);
            }
            stringBuffer2.append("select " + string + ", 1 / (count(*) / (select count(*) from " + string6 + " where " + string + " is not null))  from " + string6 + " group by " + string + " having " + string + " is not null");
        } else if (ServerConstants.Algorithm.isSVM((String)string5) || ServerConstants.Algorithm.isGLM((String)string5)) {
            if (string7 != null) {
                stringBuffer2.append(string7);
            }
            stringBuffer2.append("select " + string + ", 1/count(*) / (select sum(1/count(*)) from " + string6 + " group by " + string + " having " + string + " is not null)  from " + string6 + " group by " + string + " having " + string + " is not null");
        } else if (ServerConstants.Algorithm.isNB((String)string5)) {
            if (string7 != null) {
                stringBuffer2.append(string7);
            }
            stringBuffer2.append("select distinct " + string + ", 1 / (select count(distinct cust_gender) from " + string6 + " where " + string + " is not null)  from " + string6 + " where " + string + " is not null");
        }
        if (stringBuffer2 == null) {
            return null;
        }
        string4 = new PerformanceInfo("BUILD_SETTING_PERFORM_OP_CUST");
        try (SQLHelper sQLHelper = new SQLHelper();){
            sQLHelper.conn = ConnectionFolder.getConnection(context);
            sQLHelper.stmt = sQLHelper.conn.createStatement();
            sQLHelper.rs = sQLHelper.stmt.executeQuery(stringBuffer2.toString());
            while (sQLHelper.rs.next()) {
                String string8 = sQLHelper.rs.getString(1);
                BigDecimal bigDecimal = sQLHelper.rs.getBigDecimal(2);
                string4.put(string8, bigDecimal);
            }
        }
        string4.setCustomGeneratedBalanced();
        return string4;
    }

    private void createNaturalWeights(String string) {
        String string2 = this.getInputTableName();
        String string3 = this.getInputSchemaName();
        this._pResultPerfInfo = this.createNaturalWeights(this.getContext(), string, string3, string2, null);
    }

    public void setSelectedTargetValue(Object object) {
        this._selectedTargetValue = object;
    }

    public Object getSelectedTargetValue() {
        return this._selectedTargetValue;
    }

    public void setFalsePositive(boolean bl) {
        this._falsePositive = bl;
    }

    public boolean isFalsePositive() {
        return this._falsePositive;
    }

    @Override
    public Context getContext() {
        return this._context;
    }

    @Override
    public void validate() throws ValidationException {
        String string = this.getValidationError();
        if (string != null) {
            throw new ValidationException(string);
        }
    }

    @Override
    public Object getUserObject() {
        return this._modifiedSettings;
    }

    private static class ModifiedObject {
        private Object _content;
        private boolean _modified = true;

        ModifiedObject(Object object) {
            this._content = object;
        }

        Object getContent() {
            return this._content;
        }

        void clearModifiedFlag() {
            this._modified = false;
        }

        boolean isDirty() {
            return this._modified;
        }
    }

    public static enum OPTION {
        PROPERTIES,
        COST_MATRIX,
        COST_BENEFIT;

    }
}

