/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.workflow.dialog.jsonQuery;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dmt.dataminer.controls.JSONAggregationFunctionCellEditor;
import oracle.dmt.dataminer.controls.JSONAggregationFunctionProvider;
import oracle.dmt.dataminer.controls.JSONAggregationOutputNameCellEditor;
import oracle.dmt.dataminer.controls.JSONHelper;
import oracle.dmt.dataminer.controls.JSONSubGroupByEditorProvider;
import oracle.dmt.dataminer.controls.JSONSubGroupByTableCellEditor;
import oracle.dmt.dataminer.controls.JSONSubGroupByTableCellRenderer;
import oracle.dmt.dataminer.controls.models.SimpleBaseTableModel;
import oracle.dmt.dataminer.repository.StringUtils;
import oracle.dmt.dataminer.utils.AttributeTypeHelper;
import oracle.dmt.dataminer.utils.SimpleSearchListener;
import oracle.dmt.dataminer.workflow.dialog.data.DataDialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.AddAggregationColumnPanel;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.DialogsLrb;
import oracle.dmt.dataminer.workflow.dialog.jsonQuery.JSONDataMinerTablePanel;
import oracle.dmt.dataminer.workflow.model.JSONQueryNode;
import oracle.dmt.dataminer.workflow.xmlschema.AggregationElementsExType;
import oracle.dmt.dataminer.workflow.xmlschema.JSONAttributeType;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;
import oracle.javatools.ui.table.GenericTable;

public class AggregationAttributesTablePanel
extends JSONDataMinerTablePanel
implements JSONSubGroupByEditorProvider,
JSONAggregationFunctionProvider {
    private static String title = DialogsLrb.get("JSON_QUERY_AGGREGATION_AGGREG_ATTR_TITLE");
    protected static final String _EMPTY_ELEMENT = DialogsLrb.get("JSON_ADD_AGGREGATION_DLG_EMPTY_COLUMN");
    protected static final String DUPLICATE_AGGREGATION_ELEMENTS = "DUPLICATE_AGGREGATION_ELEMENTS";
    protected static final String WARNING_DUPLICATE_AGGREGATION_ELEMENTS = DialogsLrb.get("JSON_WARNING_DUPLICATE_AGGREGATION_ELEMENTS");
    protected static final String EMPTY_AGGREGATION_ELEMENTS = "EMPTY_AGGREGATION_ELEMENTS";
    protected static final String JSON_WARNING_NO_AGGREGATION_ELEMENTS = DialogsLrb.get("JSON_WARNING_NO_AGGREGATION_ELEMENTS");
    private static final int SOURCE = 0;
    private static final int OUTPUT = 1;
    private static final int FUNCTION = 2;
    private static final int SUB_GROUP_BY = 3;
    protected static String[] _colNames = new String[]{DialogsLrb.get("JSON_QUERY_AGGREGATION_ELEMENTS_COLUMN_SOURCE"), DialogsLrb.get("JSON_QUERY_AGGREGATION_ELEMENTS_COLUMN_OUTPUT"), DialogsLrb.get("JSON_QUERY_AGGREGATION_ELEMENTS_COLUMN_FUNCTION"), DialogsLrb.get("JSON_QUERY_AGGREGATION_ELEMENTS_COLUMN_SUB_GROUP_BY")};

    @Override
    protected Icon getEditIcon() {
        return OracleIcons.getIcon((String)"add.png");
    }

    @Override
    protected void setToolTip(JButton jButton) {
        jButton.setToolTipText(DialogsLrb.get("JSON_QUERY_AGGREGATION_ADD_ELEMENT"));
    }

    @Override
    public void initUI() {
        super.initUI();
        AggregationElementsExType aggregationElementsExType = this._parent.getAggregationElements();
        this.addControlBarComponents(new Component[0]);
        this.getTable().setFillsViewportHeight(true);
        this.getTable().setSelectionMode(2);
        this.getTable().setShowGrid(true);
        this.getTable().setShowHorizontalLines(true);
        this.getTable().setShowVerticalLines(true);
        this.getTable().setFixedColumns(0, new int[0]);
        AggregationAttributesTableModel aggregationAttributesTableModel = new AggregationAttributesTableModel(aggregationElementsExType);
        this.getTable().setModel((TableModel)((Object)aggregationAttributesTableModel));
        this.getTable().setSorted(true);
        this.getTable().setColumnSelectorAvailable(true);
        this.getTable().setAutoResizeMode(4);
        TableColumnModel tableColumnModel = this.getTable().getFullColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(60);
        tableColumnModel.getColumn(2).setPreferredWidth(10);
        tableColumnModel.getColumn(3).setPreferredWidth(60);
        tableColumnModel.getColumn(0).setCellRenderer(new JSONDataMinerTablePanel.CustomCellRenderer(this, 0));
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = AggregationAttributesTablePanel.this.getTable().getSelectedRowsInModel();
                if (nArray != null && nArray.length > 0) {
                    AggregationAttributesTablePanel.this.enableRemoveButton(true);
                } else {
                    AggregationAttributesTablePanel.this.enableRemoveButton(false);
                }
            }
        });
        if (this._parent.getJSONSourceColumn() != null) {
            this.enableEditBtn(true);
        }
        this.configureSearchField();
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(3);
        tableColumn.setCellEditor(new JSONSubGroupByTableCellEditor(this._context, this, this._parent));
        tableColumn.setCellRenderer(new JSONSubGroupByTableCellRenderer(this));
        tableColumn = this.getTable().getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new JSONAggregationFunctionCellEditor(new JComboBox<String>(), this));
        tableColumn = this.getTable().getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new JSONAggregationOutputNameCellEditor(this._context, this));
        this._enclosingPanel.updateStatus(aggregationElementsExType);
    }

    @Override
    protected boolean isValidElement(int n) {
        AggregationAttributesTableModel aggregationAttributesTableModel = (AggregationAttributesTableModel)((Object)this.getTable().getModel());
        AggregationElementsExType.AggregationElement aggregationElement = aggregationAttributesTableModel.getRow(n);
        if (!(aggregationElement instanceof AggregationElementsExType.AggregationElement)) {
            return false;
        }
        AggregationElementsExType.AggregationElement aggregationElement2 = aggregationElement;
        JSONAttributeType jSONAttributeType = aggregationElement2.getJSONAttribute();
        return this.isValidJSONAttributeType(jSONAttributeType);
    }

    @Override
    protected void configureSearchField() {
        this.getSearchField().setPrompt(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_PROMPT"));
        SearchCategory searchCategory = new SearchCategory(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_PATH"));
        this.getSearchField().addCategory(searchCategory);
        this.getSearchField().addCategory(new SearchCategory(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_TYPE_OUTPUT")));
        this.getSearchField().addCategory(new SearchCategory(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_TYPE_FUNCTION")));
        this.getSearchField().addCategory(new SearchCategory(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_TYPE_SUBGROUPBY")));
        this.getSearchField().setSelectedCategory(searchCategory);
        RowFilter<AggregationAttributesTableModel, Integer> rowFilter = new RowFilter<AggregationAttributesTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends AggregationAttributesTableModel, ? extends Integer> entry) {
                int n = -1;
                String string = AggregationAttributesTablePanel.this.getSearchField().getSelectedCategory().getLabel();
                if (string.equals(DataDialogsLrb.get("JSON_DATA_GUDE_SEARCH_CATEGORY_PATH"))) {
                    n = 0;
                } else if (string.equals(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_TYPE_OUTPUT"))) {
                    n = 1;
                } else if (string.equals(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_TYPE_FUNCTION"))) {
                    n = 2;
                } else if (string.equals(DialogsLrb.get("JSON_DATA_AGGREGATION_SEARCH_CATEGORY_TYPE_SUBGROUPBY"))) {
                    n = 3;
                }
                String string2 = AggregationAttributesTablePanel.this.getSearchField().getText();
                SearchMatcher searchMatcher = SearchMatcher.getSubstringMatcher((CharSequence)string2, (boolean)true);
                boolean bl = false;
                boolean bl2 = false;
                Integer n2 = entry.getIdentifier();
                AggregationAttributesTableModel aggregationAttributesTableModel = entry.getModel();
                AggregationElementsExType.AggregationElement aggregationElement = aggregationAttributesTableModel.getRow(n2);
                String string3 = "";
                if (n == 0) {
                    String string4 = aggregationElement.getJSONAttribute().getPath();
                    if (AggregationAttributesTablePanel.this.isShowPath()) {
                        string3 = string4;
                    } else {
                        int n3 = string4.lastIndexOf(".");
                        string3 = string4.substring(n3 + 1, string4.length());
                    }
                } else if (n == 1) {
                    string3 = aggregationElement.getOutput() != null ? aggregationElement.getOutput().getName() : null;
                } else if (n == 2) {
                    string3 = aggregationElement.getAggregationFunction();
                } else if (n == 3 && null != aggregationElement.getSubGroupBy() && null != aggregationElement.getSubGroupBy().getAttributes()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (JSONAttributeType jSONAttributeType : aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute()) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(jSONAttributeType.getDBName());
                    }
                    string3 = stringBuilder.toString();
                }
                bl2 = searchMatcher.matches((CharSequence)string3);
                bl = bl2;
                return bl;
            }
        };
        this.getSearchField().addSearchListener((SearchListener)new SimpleSearchListener((GenericTable)this.getTable(), rowFilter, 0));
    }

    public void reload() {
        AggregationAttributesTableModel aggregationAttributesTableModel = (AggregationAttributesTableModel)((Object)this.getTable().getModel());
        AggregationElementsExType aggregationElementsExType = this._parent.getAggregationElements();
        aggregationAttributesTableModel.reload(aggregationElementsExType);
        if (this._parent.getJSONSourceColumn() != null) {
            this.enableEditBtn(true);
        }
    }

    @Override
    public String getTableTitle() {
        return title;
    }

    @Override
    protected void showJSONPaths() {
        AggregationAttributesTableModel aggregationAttributesTableModel = (AggregationAttributesTableModel)((Object)this.getTable().getModel());
        aggregationAttributesTableModel.showFullPath();
    }

    @Override
    protected void editAction(ActionEvent actionEvent) {
        AggregationElementsExType aggregationElementsExType;
        AggregationElementsExType aggregationElementsExType2;
        JSONQueryNode jSONQueryNode = (JSONQueryNode)this._parent.getData();
        AddAggregationColumnPanel addAggregationColumnPanel = new AddAggregationColumnPanel(this._context, jSONQueryNode, this._parent, this, aggregationElementsExType2 = new AggregationElementsExType(), aggregationElementsExType = this._parent.getAggregationElements());
        if (addAggregationColumnPanel.showAsDialog(this)) {
            StringBuilder stringBuilder;
            Object object;
            Object object2;
            Object object32;
            Object object42;
            AggregationAttributesTableModel aggregationAttributesTableModel = (AggregationAttributesTableModel)((Object)this.getTable().getModel());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            for (Object object42 : aggregationElementsExType.getAggregationElement()) {
                hashMap.put(object42.getJSONAttribute().getPath(), object42.getAggregationFunction());
                object32 = object42.getSubGroupBy().getAttributes().getJSONAttribute();
                object2 = new StringBuilder();
                object = object32.iterator();
                while (object.hasNext()) {
                    stringBuilder = (JSONAttributeType)object.next();
                    ((StringBuilder)object2).append(stringBuilder.getPath());
                }
                hashMap2.put(((StringBuilder)object2).toString(), object42);
                hashMap3.put(object42.getJSONAttribute().getPath(), object42);
            }
            ArrayList arrayList = new ArrayList();
            for (Object object32 : aggregationElementsExType2.getAggregationElement()) {
                Object object5;
                object2 = object32.getSubGroupBy();
                object = object2.getAttributes().getJSONAttribute();
                stringBuilder = new StringBuilder();
                Object object6 = object.iterator();
                while (object6.hasNext()) {
                    object5 = (JSONAttributeType)object6.next();
                    stringBuilder.append(object5.getPath());
                }
                if (null == hashMap2.get(stringBuilder.toString()) || null == ((AggregationElementsExType.AggregationElement)hashMap2.get(stringBuilder.toString())).getSubGroupBy() || null == ((AggregationElementsExType.AggregationElement)hashMap2.get(stringBuilder.toString())).getSubGroupBy().getAttributes()) {
                    arrayList.add(object32);
                    continue;
                }
                if (!JSONHelper.areEqual(((AggregationElementsExType.AggregationElement)hashMap2.get(stringBuilder.toString())).getSubGroupBy().getAttributes().getJSONAttribute(), (List<JSONAttributeType>)object)) {
                    arrayList.add(object32);
                    continue;
                }
                if (null == hashMap3.get(object32.getJSONAttribute().getPath())) {
                    arrayList.add(object32);
                    continue;
                }
                object6 = ((AggregationElementsExType.AggregationElement)hashMap3.get(object32.getJSONAttribute().getPath())).getJSONAttribute();
                if (!JSONHelper.areEqual(object6, object32.getJSONAttribute())) {
                    arrayList.add(object32);
                    continue;
                }
                object6 = (String)hashMap.get(object32.getJSONAttribute().getPath());
                if (null == object6) {
                    arrayList.add(object32);
                    continue;
                }
                object5 = object32.getAggregationFunction();
                if (((String)object5).equals(object6)) continue;
                arrayList.add(object32);
            }
            if (aggregationElementsExType2.getAggregationElement().isEmpty()) {
                MessageDialog.optionalInformation((String)EMPTY_AGGREGATION_ELEMENTS, (Component)Ide.getMainWindow(), (Object)JSON_WARNING_NO_AGGREGATION_ELEMENTS, (String)DialogsLrb.get("WARNING_TITLE"), null);
            } else if (arrayList.isEmpty()) {
                MessageDialog.optionalInformation((String)DUPLICATE_AGGREGATION_ELEMENTS, (Component)Ide.getMainWindow(), (Object)WARNING_DUPLICATE_AGGREGATION_ELEMENTS, (String)DialogsLrb.get("WARNING_TITLE"), null);
                return;
            }
            object42 = arrayList.iterator();
            while (object42.hasNext()) {
                object32 = (AggregationElementsExType.AggregationElement)object42.next();
                aggregationElementsExType.getAggregationElement().add(object32);
            }
            this._enclosingPanel.updateStatus(aggregationElementsExType);
            aggregationAttributesTableModel.reload(aggregationElementsExType);
            this._parent.setAggregDirty(true);
        }
    }

    @Override
    protected void removeAction(ActionEvent actionEvent) {
        ArrayList<AggregationElementsExType.AggregationElement> arrayList = new ArrayList<AggregationElementsExType.AggregationElement>();
        AggregationElementsExType aggregationElementsExType = this._parent.getAggregationElements();
        AggregationAttributesTableModel aggregationAttributesTableModel = (AggregationAttributesTableModel)((Object)this.getTable().getModel());
        int[] nArray = this.getTable().getSelectedRowsInModel();
        for (int i = 0; i < nArray.length; ++i) {
            AggregationElementsExType.AggregationElement aggregationElement = aggregationAttributesTableModel.getRow(nArray[i]);
            arrayList.add(aggregationElement);
        }
        if (!arrayList.isEmpty()) {
            aggregationElementsExType.getAggregationElement().removeAll(arrayList);
            aggregationAttributesTableModel.reload(aggregationElementsExType);
            this._parent.setAggregDirty(true);
            this._enclosingPanel.updateStatus(aggregationElementsExType);
        }
    }

    @Override
    protected boolean showAddButton() {
        return false;
    }

    @Override
    protected boolean showEditButton() {
        return true;
    }

    @Override
    public void addNewAggregationElement(AggregationElementsExType.AggregationElement aggregationElement) {
        AggregationElementsExType aggregationElementsExType = this._parent.getAggregationElements();
        int n = aggregationElementsExType.getAggregationElement().indexOf(aggregationElement);
        if (-1 != n) {
            AggregationElementsExType.AggregationElement aggregationElement2 = (AggregationElementsExType.AggregationElement)aggregationElementsExType.getAggregationElement().get(n);
            aggregationElement2 = aggregationElement;
            this._parent.setAggregDirty(true);
            this._enclosingPanel.updateStatus(aggregationElementsExType);
            return;
        }
        aggregationElementsExType.getAggregationElement().add(aggregationElement);
        this._parent.setAggregDirty(true);
        this._enclosingPanel.updateStatus(aggregationElementsExType);
    }

    @Override
    public List<JSONAttributeType> getSubGroupByJSONAttributes(int n) {
        List list = null;
        AggregationElementsExType.AggregationElement aggregationElement = this.getAggregationElement(n);
        if (null != aggregationElement && null != aggregationElement.getSubGroupBy() && null != aggregationElement.getSubGroupBy().getAttributes()) {
            list = aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute();
        }
        return list;
    }

    @Override
    public AggregationElementsExType.AggregationElement getAggregationElement(int n) {
        AggregationAttributesTableModel aggregationAttributesTableModel = (AggregationAttributesTableModel)((Object)this.getTable().getModel());
        AggregationElementsExType.AggregationElement aggregationElement = aggregationAttributesTableModel.getRow(n);
        return aggregationElement;
    }

    @Override
    public AggregationElementsExType.AggregationElement getAggregationElement() {
        int[] nArray = this.getTable().getSelectedRowsInModel();
        if (nArray != null && nArray.length == 1) {
            return this.getAggregationElement(nArray[0]);
        }
        return null;
    }

    @Override
    public JPanel getParentPanel() {
        return this;
    }

    @Override
    public void setOutputName(String string, int n) {
        AggregationElementsExType.AggregationElement aggregationElement = this.getAggregationElement(n);
        if (string.trim().isEmpty()) {
            aggregationElement.setOutput(null);
        } else {
            aggregationElement.getOutput().setName(string);
        }
        this._parent.setAggregDirty(true);
        this.updateUI();
    }

    @Override
    public boolean isOutputNameUnique(String string) {
        boolean bl = true;
        if (this._parent.getAggregationElements() != null && !this._parent.getAggregationElements().getAggregationElement().isEmpty()) {
            for (AggregationElementsExType.AggregationElement aggregationElement : this._parent.getAggregationElements().getAggregationElement()) {
                if (null == aggregationElement.getOutput() || !aggregationElement.getOutput().getName().equals(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    @Override
    public void setAggregationFunction(String string, int n) {
        AggregationElementsExType.AggregationElement aggregationElement = this.getAggregationElement(n);
        if (_EMPTY_ELEMENT.equals(string)) {
            aggregationElement.setAggregationFunction(null);
            aggregationElement.setOutput(null);
        } else {
            aggregationElement.setAggregationFunction(string);
            String string2 = aggregationElement.getJSONAttribute().getPath();
            int n2 = string2.lastIndexOf(".");
            String string3 = string2.substring(n2 + 1, string2.length());
            String string4 = StringUtils.trimDoubleQuotes(string3);
            string4 = string4.toUpperCase();
            string4 = string4.replaceAll("\\s+", "");
            String string5 = this._parent.getNameGenerator().GenerateName(string4, string2, string);
            AttributeTypeHelper.setJSONOutputAttributeType(this._context, string5, aggregationElement);
        }
        this._parent.setAggregDirty(true);
        this.updateUI();
    }

    class AggregationAttributesTableModel
    extends SimpleBaseTableModel {
        AggregationElementsExType _aggregationElements;

        AggregationAttributesTableModel(AggregationElementsExType aggregationElementsExType) {
            this._aggregationElements = aggregationElementsExType;
            this.setColumnIdentifiers(_colNames);
            int n = 0;
            if (null != this._aggregationElements) {
                n = this._aggregationElements.getAggregationElement().size();
            }
            this.setRowCount(n);
            AggregationAttributesTablePanel.this.numberOfAttributes = n;
            AggregationAttributesTablePanel.this.setTitle(AggregationAttributesTablePanel.this.getTableHeaderText());
        }

        public void reload(AggregationElementsExType aggregationElementsExType) {
            this._aggregationElements = aggregationElementsExType;
            int n = 0;
            if (null != this._aggregationElements) {
                n = this._aggregationElements.getAggregationElement().size();
            }
            this.setRowCount(n);
            this.fireTableDataChanged();
            AggregationAttributesTablePanel.this.numberOfAttributes = n;
            AggregationAttributesTablePanel.this.setTitle(AggregationAttributesTablePanel.this.getTableHeaderText());
        }

        public AggregationElementsExType.AggregationElement getRow(int n) {
            return (AggregationElementsExType.AggregationElement)this._aggregationElements.getAggregationElement().get(n);
        }

        public String getColumnName(int n) {
            return _colNames[n];
        }

        public boolean isCellEditable(int n, int n2) {
            int[] nArray;
            if ((n2 == 3 || n2 == 2 || n2 == 1) && (nArray = AggregationAttributesTablePanel.this.getTable().getSelectedRowsInModel()) != null && nArray.length == 1) {
                if (n2 == 1) {
                    AggregationElementsExType.AggregationElement aggregationElement = (AggregationElementsExType.AggregationElement)this._aggregationElements.getAggregationElement().get(n);
                    if (aggregationElement.getAggregationFunction() != null) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Class getColumnClass(int n) {
            if (n == 3 || n == 2 || n == 1) {
                return Object.class;
            }
            return String.class;
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            AggregationElementsExType.AggregationElement aggregationElement = (AggregationElementsExType.AggregationElement)this._aggregationElements.getAggregationElement().get(n);
            if (n2 == 0) {
                String string2 = aggregationElement.getJSONAttribute().getPath();
                if (AggregationAttributesTablePanel.this.isShowPath()) {
                    string = string2;
                } else {
                    int n3 = string2.lastIndexOf(".");
                    string = string2.substring(n3 + 1, string2.length());
                }
            } else if (n2 == 1) {
                string = aggregationElement.getOutput() != null ? aggregationElement.getOutput().getName() : null;
            } else if (n2 == 2) {
                string = aggregationElement.getAggregationFunction();
            } else if (n2 == 3 && null != aggregationElement.getSubGroupBy() && null != aggregationElement.getSubGroupBy().getAttributes()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (JSONAttributeType jSONAttributeType : aggregationElement.getSubGroupBy().getAttributes().getJSONAttribute()) {
                    String string3 = jSONAttributeType.getPath();
                    String string4 = null;
                    if (AggregationAttributesTablePanel.this.isShowPath()) {
                        string4 = string3;
                    } else {
                        int n4 = string3.lastIndexOf(".");
                        string4 = string3.substring(n4 + 1, string3.length());
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string4);
                }
                string = stringBuilder.toString();
            }
            return string != null ? string : "";
        }

        public void showFullPath() {
            this.fireTableDataChanged();
        }
    }
}

